;;; -*- Package: MKRP; Syntax: Common-lisp; Mode: LISP -*-
#| Copyright (C) 1991 AG Siekmann, 
                      Fachbereich Informatik, Universitaet des Saarlandes, 
                      Saarbruecken, Germany

This file is part of Markgraf Karl Refutation Procedure (MKRP).

MKRP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  

Everyone is granted permission to copy, modify and redistribute
MKRP, but only if the it is not used for military purposes or any
military research. It is also forbidden to use MKRP in nuclear plants
or nuclear research, and for verifying programs in military 
and nuclear research.  A copy of this license is
supposed to have been given to you along with MKRP so you
can know your rights and responsibilities.  
Among other things, the copyright notice
must be preserved on all copies.  |#

(IN-PACKAGE "MARKGRAF-KARL" :use '("CL") :nicknames '("MKRP"))

(DEFUN PDS-RESET NIL
						; EDITED: 18-OCT-84 15:15:07          BY CL
						; EFFECT: SETS ALL THOSE COMMON VARIABLES TO NIL,
						;         THAT ARE USED BY ADDING ELEMENTS TO THEM.
  ;;(DT-RESET)
  (SETQ PDS*AXIOMS.GRAPH NIL)
  (SETQ PDS*FINAL.AXIOM.CLAUSES NIL)
  (SETQ PDS*AX.OPERATIONS NIL)
  (SETQ PDS*PROOF.PARTS NIL)
  (SETQ PDS*SPLITPARTS NIL))

(DEFUN PDS-CLAUSE.PROPERTY (CLAUSE INDICATOR) (MEM-GETPROP CLAUSE INDICATOR))

(DEFUN PDS-CLAUSE.ADD.PROPERTY (CLAUSE INDICATOR VALUE) (PROG1 VALUE (MEM-PUTPROP CLAUSE INDICATOR VALUE)))

(DEFUN PDS-ALLOCATE.MEMORY.ADDRESS (TYPE)
						; EDITED: 28-SEP-84 16:23:35           BY CL
						; INPUT : TYPE OF DATASTRUCTURE
						; EFFECT: CREATES AN EMPTY MEMORY OBJECT OF SIZE
						;         ACCORDING TO TYPE
						; VALUE : ADDRESS OF NEWLY CREATED MEMORY OBJECT
  (APPLY (INTERN (CONCATENATE 'STRING "PDS=" (princ-to-string TYPE) ".STORAGE")
		 (find-package "MKRP")) NIL))

(DEFUN PDS-PNAME (OBJECT)
						; EDITED:  6-JUL-84 11:27:30          BY CL
						; INPUT :  ANY LISP OBJECT
						; EFFECT:  REPLACES ALL CLAUSE ADDRESSES BY THEIR
						;          RESPECTIVE PNAMES.
						; VALUE :  THE SAME OBJECT WITH PNAMES INSERTED
  (COND ((CONSP OBJECT) (MAPCAR (FUNCTION PDS-PNAME) OBJECT))
	((PDS-CLAUSE.IS OBJECT) (PDS-CLAUSE.PNAME OBJECT))
	(T OBJECT)))

(DEFUN PDS-PUT.PROTOCOL.TYPE (PROTOCOL.TYPE) (SETQ PDS*PROTOCOL.TYPE PROTOCOL.TYPE))

(DEFUN PDS-PUT.COMMENT (COMMENT) (SETQ PDS*COMMENT COMMENT))

(DEFUN PDS-PUT.PROOF.VERSION (VERSION) (SETQ PDS*PROOF.VERSION VERSION))

(DEFUN PDS-PUT.RUN.DATE (date)
  (SETQ PDS*RUN.DATE (LIST (subseq date 0 11) (subseq date 12))))

(DEFUN PDS-PUT.OPTIONS (OPTIONS) (SETQ PDS*OPTIONS OPTIONS))

(DEFUN PDS-PUT.INDICES (INDICES) (SETQ PDS*INDICES INDICES))

(DEFVAR PDS*PROTOCOL.TYPE NIL)

(DEFVAR PDS*COMMENT NIL)

(DEFVAR PDS*PROOF.VERSION NIL)

(DEFVAR PDS*RUN.DATE NIL)

(DEFVAR PDS*OPTIONS NIL)

(DEFVAR PDS*indices NIL)

(DEFUN PDS-GET.PROTOCOL.TYPE NIL (SYMBOL-VALUE 'PDS*PROTOCOL.TYPE))

(DEFUN PDS-GET.COMMENT NIL PDS*COMMENT)

(DEFUN PDS-GET.PROOF.VERSION NIL PDS*PROOF.VERSION)

(DEFUN PDS-GET.RUN.DATE NIL PDS*RUN.DATE)

(DEFUN PDS-GET.OPTIONS NIL PDS*OPTIONS)

(DEFUN PDS-GET.INDICES NIL PDS*INDICES)

(DEFUN PDS-PUT.AXIOMS.INFIX (AXIOMS) (SETQ PDS*AX.INFIX AXIOMS))

(DEFUN PDS-PUT.THEOREMS.INFIX (THEOREMS) (SETQ PDS*TH.INFIX THEOREMS))

(DEFUN PDS-PUT.AXIOMS.PREFIX (AXIOMS) (SETQ PDS*AX.PREFIX AXIOMS))

(DEFUN PDS-PUT.THEOREMS.PREFIX (THEOREMS) (SETQ PDS*TH.PREFIX THEOREMS))

(DEFUN PDS-ADD.AXIOMS (AXIOMS)
						; EDITED:  1-SEP-83 14:39:56           BY CL
						; INPUT :  A LIST (OF INTEGERS)
						; EFFECT:  THE ELEMENTS OF THE INPUT LIST ARE ADDED
						;          TO PDS*AXIOMS.GRAPH
						; VALUE :  THE RESULTING VALUE OF PDS*AXIOMS.GRAPH
  (SETQ PDS*AXIOMS.GRAPH (NCONC PDS*AXIOMS.GRAPH AXIOMS)))

(DEFUN PDS-ADD.AX.OPERATION (OPERATIONS) (SETQ PDS*AX.OPERATIONS (NCONC PDS*AX.OPERATIONS OPERATIONS)))

(DEFUN PDS-ADD.AX.STATISTICS (STATISTICS) (SETQ PDS*AX.STATISTICS (NCONC1 PDS*AX.STATISTICS STATISTICS)))

(DEFUN PDS-PUT.FINAL.AXIOM.CLAUSES (CLAUSES) (SETQ PDS*FINAL.AXIOM.CLAUSES CLAUSES))

(DEFUN PDS-PUT.AXIOMS.TIME (TIME) (SETQ PDS*AXIOMS.TIME TIME))

(DEFUN PDS-PUT.AX.SYMBOLS (SYMBOLS) (SETQ PDS*AX.SYMBOLS SYMBOLS))

(DEFVAR PDS*AX.INFIX NIL)

(DEFVAR PDS*TH.INFIX NIL)

(DEFVAR PDS*AX.PREFIX NIL)

(DEFVAR PDS*TH.PREFIX NIL)

(DEFVAR PDS*AXIOMS.GRAPH NIL)

(DEFVAR PDS*AX.OPERATIONS NIL)

(DEFVAR PDS*AX.STATISTICS NIL)

(DEFVAR PDS*FINAL.AXIOM.CLAUSES NIL)

(DEFVAR PDS*AXIOMS.TIME NIL)

(DEFVAR PDS*AX.SYMBOLS NIL)

(DEFUN PDS-GET.AXIOMS.INFIX NIL PDS*AX.INFIX)

(DEFUN PDS-GET.THEOREMS.INFIX NIL PDS*TH.INFIX)

(DEFUN PDS-GET.AXIOMS.PREFIX NIL PDS*AX.PREFIX)

(DEFUN PDS-GET.THEOREMS.PREFIX NIL PDS*TH.PREFIX)

(DEFUN PDS-GET.AXIOMS NIL PDS*AXIOMS.GRAPH)

(DEFUN PDS-GET.AX.OPERATIONS NIL PDS*AX.OPERATIONS)

(DEFUN PDS-GET.AX.STATISTICS NIL PDS*AX.STATISTICS)

(DEFUN PDS-GET.FINAL.AXIOM.CLAUSES NIL PDS*FINAL.AXIOM.CLAUSES)

(DEFUN PDS-GET.AXIOMS.TIME NIL PDS*AXIOMS.TIME)

(DEFUN PDS-GET.AX.SYMBOLS NIL (SYMBOL-VALUE 'PDS*AX.SYMBOLS))

(DEFUN PDS-ADD.PROOF.PART (PROOF.PART) (SETQ PDS*PROOF.PARTS (NCONC1 PDS*PROOF.PARTS PROOF.PART)))

(DEFVAR PDS*PROOF.PARTS NIL)

(DEFUN PDS-ALL.PROOF.PARTS NIL (SYMBOL-VALUE 'PDS*PROOF.PARTS))

(DEFUN PDS-PROOF.PART.CREATE
       (IDENTIFIER CHANGED.OPTIONS INITIAL.CLAUSES OPERATIONS STATISTICS.BLOCKS TOTAL.STATISTICS FINAL.CLAUSES
	RESULT REASON TIME USED.CLAUSES PROOF.TREE SYMBOLS OLD.NEW.CLAUSE.ADDRESSES PROOF.PART)
						; EDITED:  2-OCT-84 08:23:20          BY CL
						; INPUT : CF. COMMENT OF PDS=PROOF.PART.STORAGE
						;         LAST ARGUMENT IS EITHER THE ADDRESS OF PROOF
						;         PART IN MEMORY OR NIL; IN THE LATTER CASE
						;         THE MEMORY OBJECT HAS TO BE DEFINED FIRST
						; EFFECT: STORES THE INFO OF THE PROOF PART
						; VALUE : NEW ADDRESS
  (SETQ PROOF.PART (OR PROOF.PART (PDS=PROOF.PART.STORAGE))) (PDS=PROOF.PART.PUT.IDENTIFIER PROOF.PART IDENTIFIER)
  (PDS=PROOF.PART.PUT.CHANGED.OPTIONS PROOF.PART CHANGED.OPTIONS)
  (PDS=PROOF.PART.PUT.INITIAL.CLAUSES PROOF.PART INITIAL.CLAUSES)
  (PDS=PROOF.PART.PUT.OPERATIONS PROOF.PART OPERATIONS)
  (PDS=PROOF.PART.PUT.STATISTICS.BLOCKS PROOF.PART STATISTICS.BLOCKS)
  (PDS=PROOF.PART.PUT.TOTAL.STATISTICS PROOF.PART TOTAL.STATISTICS)
  (PDS=PROOF.PART.PUT.FINAL.CLAUSES PROOF.PART FINAL.CLAUSES) (PDS=PROOF.PART.PUT.RESULT PROOF.PART RESULT)
  (PDS=PROOF.PART.PUT.REASON PROOF.PART REASON) (PDS=PROOF.PART.PUT.TIME PROOF.PART TIME)
  (PDS=PROOF.PART.PUT.USED.CLAUSES PROOF.PART USED.CLAUSES) (PDS=PROOF.PART.PUT.PROOF.TREE PROOF.PART PROOF.TREE)
  (PDS=PROOF.PART.PUT.SYMBOLS PROOF.PART SYMBOLS)
  (PDS=PROOF.PART.PUT.O.N.C.ADDRESSES PROOF.PART OLD.NEW.CLAUSE.ADDRESSES) PROOF.PART)

(DEFUN PDS=PROOF.PART.STORAGE NIL
						; EDITED: 18-OCT-84 15:19:30          BY CL
						; INPUT : NONE
						; EFFECT: RESERVES THE NECESSARY CELLS IN MEMORY
						;
						;   CELL  COMPONENT              EXAMPLE
						;
						;    1   IDENTIFIER             ( 1 2 )
						;    2   CHANGED.OPTIONS   <(PR:PROOF.FILE . PR.NEW)>
						;    3   INITIAL.CLAUSES        ( 5 9 12 13 )
						;    4   OPERATIONS             ( 10 11 14 17 )
						;    5   STATISTICS.BLOCKS      ( 15 18 )
						;    6   TOTAL.STATISTICS           -
						;    7   FINAL.CLAUSES          ( 9 13 20 )
						;    8   RESULT                   SUCCESS
						;    9   REASON                     20
						;   10   TIME                     3753  (IN MSEC)
						;   11   USED.CLAUSES           ( 5 9 19 20 )
						;   12   PROOF.TREE                 -
						;   13   SYMBOLS           < CODE OF ST >
						;   14   O.N.C.ADDRS           < (34 . 4) (40 . 9) >
						; VALUE: NEW ADDRESS
  (MEM-NEW 'PROOF.PART 14))

(DEFUN PDS=PROOF.PART.PUT.IDENTIFIER (PROOF.PART IDENTIFIER) (MEM-PUT PROOF.PART 1 IDENTIFIER))

(DEFUN PDS=PROOF.PART.PUT.CHANGED.OPTIONS (PROOF.PART CHANGED.OPTIONS) (MEM-PUT PROOF.PART 2 CHANGED.OPTIONS))

(DEFUN PDS=PROOF.PART.PUT.INITIAL.CLAUSES (PROOF.PART INITIAL.CLAUSES) (MEM-PUT PROOF.PART 3 INITIAL.CLAUSES))

(DEFUN PDS=PROOF.PART.PUT.OPERATIONS (PROOF.PART OPERATIONS) (MEM-PUT PROOF.PART 4 OPERATIONS))

(DEFUN PDS=PROOF.PART.PUT.STATISTICS.BLOCKS (PROOF.PART STATISTICS.BLOCKS)
  (MEM-PUT PROOF.PART 5 STATISTICS.BLOCKS))

(DEFUN PDS=PROOF.PART.PUT.TOTAL.STATISTICS (PROOF.PART TOTAL.STATISTICS) (MEM-PUT PROOF.PART 6 TOTAL.STATISTICS))

(DEFUN PDS=PROOF.PART.PUT.FINAL.CLAUSES (PROOF.PART FINAL.CLAUSES) (MEM-PUT PROOF.PART 7 FINAL.CLAUSES))

(DEFUN PDS=PROOF.PART.PUT.RESULT (PROOF.PART RESULT) (MEM-PUT PROOF.PART 8 RESULT))

(DEFUN PDS=PROOF.PART.PUT.REASON (PROOF.PART REASON) (MEM-PUT PROOF.PART 9 REASON))

(DEFUN PDS=PROOF.PART.PUT.TIME (PROOF.PART TIME) (MEM-PUT PROOF.PART 10 TIME))

(DEFUN PDS=PROOF.PART.PUT.USED.CLAUSES (PROOF.PART USED.CLAUSES) (MEM-PUT PROOF.PART 11 USED.CLAUSES))

(DEFUN PDS=PROOF.PART.PUT.PROOF.TREE (PROOF.PART PROOF.TREE) (MEM-PUT PROOF.PART 12 PROOF.TREE))

(DEFUN PDS=PROOF.PART.PUT.SYMBOLS (PROOF.PART SYMBOLS) (MEM-PUT PROOF.PART 13 SYMBOLS))

(DEFUN PDS=PROOF.PART.PUT.O.N.C.ADDRESSES (PROOF.PART OLD.NEW.CLAUSE.ADDRESSES)
  (MEM-PUT PROOF.PART 14 OLD.NEW.CLAUSE.ADDRESSES))

(DEFUN PDS-PROOF.PART.IDENTIFIER (PROOF.PART) (MEM-GET PROOF.PART 1))

(DEFUN PDS-PROOF.PART.CHANGED.OPTIONS (PROOF.PART) (MEM-GET PROOF.PART 2))

(DEFUN PDS-PROOF.PART.INITIAL.CLAUSES (PROOF.PART) (MEM-GET PROOF.PART 3))

(DEFUN PDS-PROOF.PART.OPERATIONS (PROOF.PART) (MEM-GET PROOF.PART 4))

(DEFUN PDS-PROOF.PART.STATISTICS.BLOCKS (PROOF.PART) (MEM-GET PROOF.PART 5))

(DEFUN PDS-PROOF.PART.TOTAL.STATISTICS (PROOF.PART) (MEM-GET PROOF.PART 6))

(DEFUN PDS-PROOF.PART.FINAL.CLAUSES (PROOF.PART) (MEM-GET PROOF.PART 7))

(DEFUN PDS-PROOF.PART.RESULT (PROOF.PART) (MEM-GET PROOF.PART 8))

(DEFUN PDS-PROOF.PART.REASON (PROOF.PART) (MEM-GET PROOF.PART 9))

(DEFUN PDS-PROOF.PART.TIME (PROOF.PART) (MEM-GET PROOF.PART 10))

; (DEFUN PDS-PROOF.PART.USED.CLAUSES (PROOF.PART) (MEM-GET PROOF.PART 11)) Not used

(DEFUN PDS-PROOF.PART.PROOF.TREE (PROOF.PART) (MEM-GET PROOF.PART 12))

(DEFUN PDS-PROOF.PART.SYMBOLS (PROOF.PART) (MEM-GET PROOF.PART 13))

(DEFUN PDS-PROOF.PART.O.N.C.ADDRESSES (PROOF.PART) (MEM-GET PROOF.PART 14))

(DEFUN PDS-ADD.SPLITPART (SPLITPART)
						; EDITED: 14-SEP-83 10:38:45          BY CL
						; INPUT : AN INTEGER (ADDRESS OF SPLITPART)
						; EFFECT: ADDS THE SPLITPART TO PDS*SPLITPARTS
						; VALUE : THE NEW VALUE OF PDS*SPLIPPARTS
  (SETQ PDS*SPLITPARTS (NCONC1 PDS*SPLITPARTS SPLITPART)))

(DEFVAR PDS*SPLITPARTS NIL)

(DEFUN PDS-ALL.SPLITPARTS NIL
						; EDITED: 14-SEP-83 10:37:35          BY CL
						; INPUT : NONE
						; VALUE : A LIST OF INTEGERS (ALL SPLITPART ADDRESSES)
  PDS*SPLITPARTS)

(DEFUN PDS-SPLITPART.CREATE
       (AXIOMS THEOREMS INITIAL.GRAPH CHANGED.OPTIONS OPERATIONS RESULT REASON USED.CLAUSES PROOF.TREE STATISTICS
	TOTAL.STATISTICS SYMBOLS IDENTIFIER SPLITPART)
						; EDITED:  4-OCT-84 13:28:10
						; INPUT : 3 LISTS OF INTEGERS, A LIST OF DOTTED PAIRS,
						;         ANOTHER LIST OF INTEGERS, 2 ATOMS, STILL
						;         ANOTHER LIST OF INTEGERS,A LIST REPRESENTING
						;         THE PROOF TREE, AND A LIST CONTAINING STA-
						;         TISTICAL VALUES
						;         SPLITPART = ADDRESS OF NEW SPLITPART OR NIL
						; EFFECT: STORES THE SPLITPART
						; VALUE : THE NEW ADDRESS
  (SETQ SPLITPART (OR SPLITPART (PDS=SPLITPART.STORAGE))) (PDS=SPLITPART.PUT.AXIOMS SPLITPART AXIOMS)
  (PDS=SPLITPART.PUT.THEOREMS SPLITPART THEOREMS) (PDS=SPLITPART.PUT.INITIAL.GRAPH SPLITPART INITIAL.GRAPH)
  (PDS=SPLITPART.PUT.CHANGED.OPTIONS SPLITPART CHANGED.OPTIONS)
  (PDS=SPLITPART.PUT.OPERATIONS SPLITPART OPERATIONS) (PDS=SPLITPART.PUT.RESULT SPLITPART RESULT)
  (PDS=SPLITPART.PUT.REASON SPLITPART REASON) (PDS=SPLITPART.PUT.USED.CLAUSE.LIST SPLITPART USED.CLAUSES)
  (PDS=SPLITPART.PUT.PROOF.TREE SPLITPART PROOF.TREE) (PDS=SPLITPART.PUT.STATISTICS SPLITPART STATISTICS)
  (PDS=SPLITPART.PUT.TOTAL.STATISTICS SPLITPART TOTAL.STATISTICS) (PDS=SPLITPART.PUT.SYMBOLS SPLITPART SYMBOLS)
  (PDS=SPLITPART.PUT.IDENTIFIER SPLITPART IDENTIFIER) SPLITPART)

(DEFUN PDS=SPLITPART.STORAGE NIL
						; EDITED: 30-JUN-84 09:54:13        BY CL
						; INPUT : NONE
						; EFFECT: RESERVES THE NECESSARY CELLS IN MEMORY
						;          CELL COMPONENT          EXAMPLE
						;           1    AXIOMS         ( 1 4 6 9 12 )
						;           2   THEOREMS          ( 13 15 )
						;           3  INITIAL.GRAPH    ( 1 4 6 9 12 13 16)
						;           4  CHANGED.OPTIONS  < (TERM:DEPTH . 3) >
						;           5   OPERATIONS        ( 23 26 31 45)
						;           6    RESULT              FAILURE
						;           7    REASON           GRAPH.COLLAPSED
						;           8  USED.CLAUSES     ( 1 4 6 9 12 ... )
						;           9  PROOF.TREE         LIST STRUCTURE
						;          10  STATISTICS          ( 23 25 28 )
						;          11  TOTAL STATISTICS         ??
						;          12   SYMBOLS          < CODE OF ST >
						;          13  IDENTIFIER             ( 1 3 )
						; VALUE : THE NEW ADDRESS
  (MEM-NEW 'SPLITPART 13))

(DEFUN PDS=SPLITPART.PUT.AXIOMS (SPLITPART AXIOMS)
						; EDITED: 15-SEP-83 14:11:15            BY CL
						; INPUT : A LIST OF INTEGERS
						; EFFECT: PUTS AXIOMS INTO APPROPRIATE CELL OF
						;         SPLITPART
						; VALUE : AXIOMS
  (MEM-PUT SPLITPART 1 AXIOMS))

(DEFUN PDS=SPLITPART.PUT.THEOREMS (SPLITPART THEOREMS)
						; EDITED: 15-SEP-83 14:12:08            BY CL
						; INPUT : A LIST OF INTEGERS
						; EFFECT: PUTS THEOREMS INTO APPROPRIATE CELL OF
						;         SPLITPART
						; VALUE : THEOREMS
  (MEM-PUT SPLITPART 2 THEOREMS))

(DEFUN PDS=SPLITPART.PUT.INITIAL.GRAPH (SPLITPART INITIAL.GRAPH)
						; EDITED: 15-SEP-83 14:13:53            BY CL
						; INPUT : A LIST OF INTEGERS
						; EFFECT: PUTS INITIAL.GRAPH INTO APPROPRIATE CELL OF
						;         SPLITPART
						; VALUE : INITIAL.GRAPH
  (MEM-PUT SPLITPART 3 INITIAL.GRAPH))

(DEFUN PDS=SPLITPART.PUT.CHANGED.OPTIONS (SPLITPART CHANGED.OPTIONS)
						; EDITED: 15-SEP-83 14:16:12            BY CL
						; INPUT : A LIST OF DOTTED PAIRS OR NIL
						; EFFECT: PUTS CHANGED.OPTIONS INTO APPROPRIATE CELL
						;         OF SPLITPART
						; VALUE : CHANGED.OPTIONS
  (MEM-PUT SPLITPART 4 CHANGED.OPTIONS))

(DEFUN PDS=SPLITPART.PUT.OPERATIONS (SPLITPART OPERATIONS)
						; EDITED: 15-SEP-83 14:18:21            BY CL
						; INPUT : A LIST OF INTEGERS
						; EFFECT: PUTS OPERATIONS INTO APPROPRIATE CELL
						;         OF SPLITPART
						; VALUE : OPERATIONS
  (MEM-PUT SPLITPART 5 OPERATIONS))

(DEFUN PDS=SPLITPART.PUT.RESULT (SPLITPART RESULT)
						; EDITED: 15-SEP-83 14:19:01            BY CL
						; INPUT : AN ATOM, EITHER 'FAILURE OR 'SUCCESS
						; EFFECT: PUTS ESULT INTO APPROPRIATE CELL OF
						;         OF SPLITPART
						; VALUE : RESULT
  (MEM-PUT SPLITPART 6 RESULT))

(DEFUN PDS=SPLITPART.PUT.REASON (SPLITPART REASON)
						; EDITED: 15-SEP-83 14:19:54            BY CL
						; INPUT : AN ADDRESS (SMALLP) OR A LITATOM
						; EFFECT: PUTS REASON INTO APPROPRIATE CELL OF
						;         OF SPLITPART
						; VALUE : REASON
  (MEM-PUT SPLITPART 7 REASON))

(DEFUN PDS=SPLITPART.PUT.USED.CLAUSE.LIST (SPLITPART USED.CLAUSES)
						; EDITED: 15-SEP-83 14:20:43            BY CL
						; INPUT : A LIST OF INTEGERS
						; EFFECT: PUTS USED.CLAUSES INTO APPROPRIATE CELL OF
						;         OF SPLITPART
						; VALUE : USED.CLAUSES
  (MEM-PUT SPLITPART 8 USED.CLAUSES))

(DEFUN PDS=SPLITPART.PUT.PROOF.TREE (SPLITPART PROOF.TREE)
						; EDITED: 15-SEP-83 14:21:21            BY CL
						; INPUT : A LIST REPRESENTING A TREE STRUCTURE
						; EFFECT: PUTS PROOF.TREE INTO APPROPRIATE CELL
						;         OF SPLITPART
						; VALUE : PROOF.TREE
  (MEM-PUT SPLITPART 9 PROOF.TREE))

(DEFUN PDS=SPLITPART.PUT.STATISTICS (SPLITPART STATISTICS) (MEM-PUT SPLITPART 10 STATISTICS))

(DEFUN PDS=SPLITPART.PUT.TOTAL.STATISTICS (SPLITPART STATISTICS) (MEM-PUT SPLITPART 11 STATISTICS))

(DEFUN PDS=SPLITPART.PUT.SYMBOLS (SPLITPART SYMBOLS) (MEM-PUT SPLITPART 12 SYMBOLS))

(DEFUN PDS=SPLITPART.PUT.IDENTIFIER (SPLITPART IDENTIFIER) (MEM-PUT SPLITPART 13 IDENTIFIER))

(DEFUN PDS-SPLITPART.INSERT.TOTAL.STATISTICS (SPLITPART STATISTICS)
  (PDS=SPLITPART.PUT.TOTAL.STATISTICS SPLITPART STATISTICS))

(DEFUN PDS-SPLITPART.AXIOMS (SPLITPART)
						; EDITED: 15-SEP-83 14:24:22            BY CL
						; INPUT : AN INTEGER (ADDRESS OF A SPLITPART)
						; VALUE : LIST OF AXIOMS
  (MEM-GET SPLITPART 1))

(DEFUN PDS-SPLITPART.THEOREMS (SPLITPART)
						; EDITED: 15-SEP-83 14:25:31            BY CL
						; INPUT : AN INTEGER (ADDRESS OF A SPLITPART)
						; VALUE : LIST OF THEOREMS
  (MEM-GET SPLITPART 2))

(DEFUN PDS-SPLITPART.INITIAL.GRAPH (SPLITPART)
						; EDITED: 15-SEP-83 14:26:19            BY CL
						; INPUT : AN INTEGER (ADDRESS OF A SPLITPART)
						; VALUE : LIST OF CLAUSES IN INITIAL.GRAPH
  (MEM-GET SPLITPART 3))

(DEFUN PDS-SPLITPART.CHANGED.OPTIONS (SPLITPART)
						; EDITED: 15-SEP-83 14:27:00            BY CL
						; INPUT : AN INTEGER (ADDRESS OF A SPLITPART)
						; VALUE : LIST OF CHANGED.OPTIONS AS DOTTED PAIRS
  (MEM-GET SPLITPART 4))

(DEFUN PDS-SPLITPART.OPERATIONS (SPLITPART)
						; EDITED: 15-SEP-83 14:27:47            BY CL
						; INPUT : AN INTEGER (ADDRESS OF A SPLITPART)
						; VALUE : LIST OF OPERATIONS
  (MEM-GET SPLITPART 5))

(DEFUN PDS-SPLITPART.RESULT (SPLITPART)
						; EDITED: 15-SEP-83 14:28:33            BY CL
						; INPUT : AN INTEGER (ADDRESS OF A SPLITPART)
						; VALUE : EITHER 'SUCCESS OR 'FAILURE
  (MEM-GET SPLITPART 6))

(DEFUN PDS-SPLITPART.REASON (SPLITPART)
						; EDITED: 15-SEP-83 14:29:11            BY CL
						; INPUT : AN INTEGER (ADDRESS OF A SPLITPART)
						; VALUE : AN ADDRESS (SMALLP) OR A LITATOM
  (MEM-GET SPLITPART 7))

(DEFUN PDS-SPLITPART.USED.CLAUSE.LIST (SPLITPART)
						; EDITED: 15-SEP-83 14:29:58            BY CL
						; INPUT : AN INTEGER (ADDRESS OF A SPLITPART)
						; VALUE : A LIST OF INTEGERS
  (MEM-GET SPLITPART 8))

#| Not used
(DEFUN PDS-SPLITPART.PROOF.TREE (SPLITPART)
						; EDITED: 15-SEP-83 14:30:30            BY CL
						; INPUT : AN INTEGER (ADDRESS OF A SPLITPART)
						; VALUE : A LIST REPRESENTING THE PROOF.TREE STRUCTURE
  (MEM-GET SPLITPART 9))|#

(DEFUN PDS-SPLITPART.STATISTICS (SPLITPART) (MEM-GET SPLITPART 10))

(DEFUN PDS-SPLITPART.TOTAL.STATISTICS (SPLITPART) (MEM-GET SPLITPART 11))

(DEFUN PDS-SPLITPART.SYMBOLS (SPLITPART)
  (MEM-GET SPLITPART 12))

(DEFUN PDS-SPLITPART.IDENTIFIER (SPLITPART)
  (MEM-GET SPLITPART 13))

(DEFUN PDS-OPERATION.CREATE (CLAUSES TYPE PARENTS USE DESCRIPTORS)
						; EDITED:  3-JUL-84 10:18:45            BY CL
						; INPUT :  CLAUSES = LIST OF ADDRESSES ; TYPE = ATOM ;
						;          PARENTS = LIST  ; USE = LIST  ;
						;          AND DESCRIPTORS ARE LISTS.
						; EFFECT:  STORES THE OPERATION
						; VALUE :  THE NEW ADDRESS
  (PROG ((OPERATION (PDS=OPERATION.STORAGE (LIST-LENGTH DESCRIPTORS)))) (PDS=OPERATION.PUT.CLAUSES OPERATION CLAUSES)
	(PDS=OPERATION.PUT.TYPE OPERATION TYPE) (PDS=OPERATION.PUT.PARENTS OPERATION PARENTS)
	(PDS=OPERATION.PUT.USE OPERATION USE) (PDS=OPERATION.PUT.DESCRIPTORS OPERATION DESCRIPTORS) (RETURN OPERATION)))

(DEFUN PDS=OPERATION.STORAGE (DESCRIPTORS.LENGTH)
						; EDITED:  3-JUL-84 10:20:00                 BY CL
						; INPUT :  THE NUMBER OF DESCRIPTORS (INTEGER)
						; EFFECT:  RESERVES THE NECESSARY CELLS IN MEMORY
						;            CELL COMPONENT        EXAMPLE
						;             1    CLAUSES       ( 3 5 6 23 24 )
						;             2     TYPE         PARAMODULATION
						;             3    PARENTS       ( 1 2  17 13 )
						;             4     USE                 T
						;            5-12 DESCRIPTORS     E.G. POSPAR ETC.
						; VALUE :  THE NEW ADDRESS
  (MEM-NEW 'OPERATION (+ 4 DESCRIPTORS.LENGTH)))

(DEFUN PDS=OPERATION.PUT.CLAUSES (OPERATION CLAUSES) (MEM-PUT OPERATION 1 CLAUSES))

(DEFUN PDS=OPERATION.PUT.TYPE (OPERATION TYPE) (MEM-PUT OPERATION 2 TYPE))

(DEFUN PDS=OPERATION.PUT.PARENTS (OPERATION PARENTS) (MEM-PUT OPERATION 3 PARENTS))

(DEFUN PDS=OPERATION.PUT.USE (OPERATION USE) (MEM-PUT OPERATION 4 USE))

(DEFUN PDS=OPERATION.PUT.DESCRIPTORS (OPERATION DESCRIPTORS)
						; EDITED:  3-JUL-84 10:50:02            BY CL
						; INPUT :  AN ADDRESS AND A LIST
						; EFFECT:  STORES THE DESCRIPTORS
						;       5     6    7     8     9     10      11    12
						;  RES RULE  UNI  POSP. POSLIT  -    NEGP. NEGLIT  -
						;  PAR RULE  UNI  EQP.  EQLIT  EQFCT PAR   LITNO  FCT
						;  FAC RULE  UNI  PAR     -     -     -      -     -
						;  INST  -   UNI    -     -     -     -      -     -
						;  DBL RULE LIT#1 LIT#2   -     -     -      -     -
						;  RW  RULE LIT#    -     -     -     -      -     -
						;  RWS   -    -     -     -     -     -      -     -
						; VALUE :  UNDEFINED
  (PROG ((N 5))
	(MAPC (FUNCTION (LAMBDA (DESCRIPTOR) (MEM-PUT OPERATION N DESCRIPTOR) (SETQ N (1+ N)))) DESCRIPTORS)))

(DEFUN PDS-OPERATION.INSERT.USE (OPERATION USE) (PDS=OPERATION.PUT.USE OPERATION USE))

(DEFUN PDS-OPERATION.CLAUSES (OPERATION) (MEM-GET OPERATION 1))

(DEFUN PDS-OPERATION.TYPE (OPERATION) (MEM-GET OPERATION 2))

(DEFUN PDS-OPERATION.PARENTS (OPERATION) (MEM-GET OPERATION 3))

(DEFUN PDS-OPERATION.USE (OPERATION) (MEM-GET OPERATION 4))

(DEFUN PDS-OPERATION.UNIFIER (OPERATION) (MEM-GET OPERATION 6))

(DEFUN PDS-OPERATION.RULE (OPERATION) (MEM-GET OPERATION 5))

(DEFUN PDS-OPERATION.POS.EQ.PAR (OPERATION) (MEM-GET OPERATION 7))

(DEFUN PDS-OPERATION.LITNO.1 (OPERATION) (MEM-GET OPERATION 6))

(DEFUN PDS-OPERATION.POS.EQ.LITNO (OPERATION) (MEM-GET OPERATION 8))

(DEFUN PDS-OPERATION.LITNO.2 (OPERATION) (MEM-GET OPERATION 7))

; (DEFUN PDS-OPERATION.EQFCT (OPERATION) (MEM-GET OPERATION 9)) Not used

(DEFUN PDS-OPERATION.NEG.PAR (OPERATION) (MEM-GET OPERATION 10))

(DEFUN PDS-OPERATION.NEG.LITNO (OPERATION) (MEM-GET OPERATION 11))

(DEFUN PDS-OPERATION.FCT (OPERATION) (MEM-GET OPERATION 12))

(DEFUN PDS-CLAUSE.CREATE (PNAME PARENTS SORTS.VARIABLES LITERALS USED CLAUSE)
						; EDITED: 28-SEP-84 18:07:55          BY CL
						; INPUT : PNAME = ATOM ; PARENTS = LIST OF INTEGERS ;
						;         SORTS.VARIABLES ; LITERALS = LIST .
						;         USED = T OR NIL, CLAUSE IS EITHER THE MEMO-
						;         RY ADDRESS OF THE NEW CLAUSE OR NIL; IN THE
						;         LATTER CASE MEMORY SPACE MUST FIRST BE ALLO-
						;         CATED.
						; EFFECT: STORES THE CLAUSE
						; VALUE : THE NEW ADDRESS
  (SETQ CLAUSE (OR CLAUSE (PDS=CLAUSE.STORAGE)))
  (PDS=CLAUSE.PUT.PNAME CLAUSE PNAME) (PDS=CLAUSE.PUT.PARENTS CLAUSE PARENTS)
  (PDS=CLAUSE.PUT.SORTS.VARIABLES CLAUSE SORTS.VARIABLES)
  (PDS=CLAUSE.PUT.LITERALS CLAUSE LITERALS)
  (PDS=CLAUSE.PUT.USE CLAUSE USED)
  CLAUSE)

(DEFUN PDS=CLAUSE.STORAGE NIL
						; EDITED: 28-SEP-84 17:22:15           BY CL
						; INPUT : NONE
						; EFFECT: RESERVES THE NECESSARY CELLS IN MEMORY
						;          CELL  COMPONENT         EXAMPLE
						;           1     PNAME              RES2
						;           2     PARENTS          ( 34   12 )
						;           3     SORTS.VARIABLES <(ANY 14)(INT 1 23 >
						;           4     LITERALS        <(+ 44 (14 (7 14)))
						;                                  (- 43 ((7 (7 23   >
						;           5     USED                 T
						; VALUE : THE NEW ADDRESS
  (MEM-NEW 'CLAUSE 5))

(DEFUN PDS=CLAUSE.PUT.PNAME (CLAUSE PNAME)	; edited: 29-jul-83 14:34:32  by cl
						; input : an integer and an atom or string
						; effect: puts pname into appropriate cell of clause, always as a string
  (MEM-PUT CLAUSE 1 (string PNAME)))		; value : pname

(DEFUN PDS=CLAUSE.PUT.PARENTS (CLAUSE PARENTS)
						; EDITED: 29-JUL-83 14:37:57           BY CL
						; INPUT : AN INTEGER AND A LIST
						; EFFECT: PUTS PARENTS INTO APPROPRIATE CELL OF CLAUSE
						; VALUE : PARENTS
  (MEM-PUT CLAUSE 2 PARENTS))

(DEFUN PDS=CLAUSE.PUT.SORTS.VARIABLES (CLAUSE SORTS.VARIABLES)
						; EDITED: 29-JUL-83 14:40:03           BY CL
						; INPUT : AN INTEGER AND A LIST
						; EFFECT: PUTS SORTS.VARIABLES INTO APPROPRIATE CELL
						;         OF CLAUSE
						; VALUE : SORTS.VARIABLES
  (MEM-PUT CLAUSE 3 SORTS.VARIABLES))

(DEFUN PDS=CLAUSE.PUT.LITERALS (CLAUSE LITERALS)
						; EDITED: 29-JUL-83 14:45:24           BY CL
						; INPUT : AN INTEGER AND A LIST
						; EFFECT: PUTS LITERALS INTO APPROPRIATE CELL
						;         OF CLAUSE
						; VALUE : LITERALS
  (MEM-PUT CLAUSE 4 LITERALS))

(DEFUN PDS=CLAUSE.PUT.USE (CLAUSE USE)
						; EDITED: 29-JUL-83 14:47:12           BY CL
						; INPUT : AN INTEGER AND A BOOLEAN VALUE
						; EFFECT: PUTS USE INTO APPROPRIATE CELL OF CLAUSE
						; VALUE : USE
  (MEM-PUT CLAUSE 5 USE))

(DEFUN PDS-CLAUSE.ADD.PARENT (CLAUSE PARENT)
  (PROG ((PARENTS.SO.FAR (PDS-CLAUSE.PARENTS CLAUSE))) (PDS=CLAUSE.PUT.PARENTS CLAUSE (NCONC1 PARENTS.SO.FAR PARENT))))

(DEFUN PDS-CLAUSE.ADD.USE (CLAUSE SPLITPART)
						; EDITED: 16-SEP-83 14:06:44            BY CL
						; INPUT : TWO ADDRESSES
						; EFFECT: ADDS THE SPLITPART TO THE LIST
						;          'USE  OF CLAUSE IN MEMORY
						; VALUE : RESULTING LIST
  (PDS=CLAUSE.PUT.USE CLAUSE (NCONC1 (PDS-CLAUSE.USE CLAUSE) SPLITPART)))

(DEFUN PDS-CLAUSE.IS (ADR) (AND (INTEGERP ADR) (EQL (MEM-TYPE ADR) 'CLAUSE)))

(DEFUN PDS-CLAUSE.PNAME (CLAUSE)
						; EDITED: 29-JUL-83 14:46:09           BY CL
						; INPUT : AN INTEGER
						; VALUE : THE PNAME OF CLAUSE
  (MEM-GET CLAUSE 1))

(DEFUN PDS-CLAUSE.PARENTS (CLAUSE)
						; EDITED: 29-JUL-83 14:52:45           BY CL
						; INPUT : AN INTEGER
						; VALUE : THE PARENTS OF CLAUSE
  (MEM-GET CLAUSE 2))

(DEFUN PDS-CLAUSE.SORTS.VARIABLES (CLAUSE)
						; EDITED: 29-JUL-83 14:53:20           BY CL
						; INPUT : AN INTEGER
						; VALUE : THE SORTS.VARIABLES OF CLAUSE
  (MEM-GET CLAUSE 3))

(DEFUN PDS-CLAUSE.LITERALS (CLAUSE)
						; EDITED: 29-JUL-83 14:54:33           BY CL
						; INPUT : AN INTEGER
						; VALUE : THE LITERALS OF CLAUSE
  (MEM-GET CLAUSE 4))

(DEFUN PDS-CLAUSE.USE (CLAUSE)
						; EDITED: 29-JUL-83 14:55:54           BY CL
						; INPUT : AN INTEGER
						; VALUE : T , IF CLAUSE WAS USED IN PROOF, NIL ELSE
  (MEM-GET CLAUSE 5))

