 ;;; -*- Package: MKRP; Syntax: Common-lisp; Mode: LISP -*-

(IN-PACKAGE "MKRP" :use '("CL"))


(defmacro op=inherit1 ()
  `(progn ,@(MAPCar #'(LAMBDA (COLOUR)
			`(DODOWN (RPTN 2)
			   (MAPC #'(LAMBDA (LINK)
				     (SETQ OTHERCLAUSE (DS-LINK.OTHERPAR LINK CLAUSE))
				     (SETQ OTHERLITNO (DS-LINK.OTHERLITNO LINK CLAUSE (1+ RPTN)))
				     (COND ((SETQ UNIFIERS
						  (UNI-UNIFY.ATOMS PREDICATE (DS-CLAUSE.TERMLIST OTHERCLAUSE OTHERLITNO)
								   PREDICATE (DS-CLAUSE.TERMLIST RESOLVENT (1+ RPTN))))
					    (CG-INSERT.LINK
					      (COND ((EQL CLAUSE (DS-LINK.POSPAR LINK))
						     (DS-LINK.CREATE ',COLOUR UNIFIERS RESOLVENT (1+ RPTN)
								     OTHERCLAUSE OTHERLITNO NIL NIL NIL))
						    (T (DS-LINK.CREATE ',COLOUR UNIFIERS OTHERCLAUSE OTHERLITNO RESOLVENT
								       (1+ RPTN) NIL NIL NIL)))
					      (LIST LINK) 'INHERITED (LIST LINK)))))
				 (DS-CLAUSE.LINKS ',COLOUR CLAUSE (1+ RPTN)))))
		    '(R S))))

(DEFUN OP=INHERIT.LINKS (CLAUSE CREATOR UNIFIER POSRHO NEGRHO RHO &optional LITNOS)
						; EDITED: 19-OCT-83                              AP
						; INPUT:  CLAUSE IS A NEWLY CREATED CLAUSE BY AN
						;         OPERATION WITH UNIFIER.
						;         POSRHO IS THE RENAMING SUBSTITUTION APPLIED
						;         TO CREATOR'S POSITIVE PARENT, NEGRHO IS THE
						;         RENAMING APPLIED TO THE NEGATIVE PARENT AND
						;         RHO IS (APPEND POSRHO NEGRHO).
						;         LITNOS IS A LIST OF LITERALS TO WHICH NO
						;         literal LINK SHOULD BE INHERITED.
						; EFFECT: TRIES TO INHERIT ALL LINKS, EXCEPTED SOME
						;         OF KIND P OF ALL ANCESTOR LITERALS EXCEPT
						;         LITNOS.
						; VALUE:  NIL.
  (PROG
    ((NOAUTOLINK (MEMBER (DS-LINK.COLOUR CREATOR) (DS-LINK.COLOURS.FOR 'NOAUTOLINKS)))
     (VARIABLES (COPY-list (DS-CLAUSE.VARIABLES CLAUSE)))
     PARENTCLAUSE PARENTLITNO LASTVAR POSPAR NEGPAR)
    (SETQ LASTVAR (LAST VARIABLES))
    (when NOAUTOLINK
      (SETQ POSPAR (DS-LINK.POSPAR CREATOR))
      (SETQ NEGPAR (DS-LINK.NEGPAR CREATOR))
      (DT-PUTPROP POSPAR 'OP*RENAMING POSRHO)
      (DT-PUTPROP NEGPAR 'OP*RENAMING NEGRHO))
    (DODOWN (RPTN (DS-CLAUSE.NOLIT CLAUSE))
      (unless (MEMBER (1+ RPTN) LITNOS)
	(cond ((cg-clause.changed.p clause (1+ rptn))
	       (cons-reconstruct.links nil (list (list clause (1+ rptn))))
	       (mapc #'(lambda (colour)
			 (mapc #'(lambda (link) (dt-putprop link 'inherited t))
			       (ds-clause.links colour clause (1+ rptn))))
		     '(R RD RIW RIWD S SIW SI SID T TIW)))
	      (t (SETQ PARENTCLAUSE (CG-CLAUSE_ANCESTOR.LITERALS CLAUSE (1+ RPTN)))
		 (SETQ PARENTLITNO (CADAR PARENTCLAUSE))
		 (SETQ PARENTCLAUSE (CAAR PARENTCLAUSE))
		 (OP=INHERIT.R CLAUSE (1+ RPTN) PARENTCLAUSE PARENTLITNO UNIFIER RHO VARIABLES LASTVAR LITNOS)
		 (OP=INHERIT.S CLAUSE (1+ RPTN) PARENTCLAUSE PARENTLITNO UNIFIER RHO VARIABLES LASTVAR LITNOS)
		 (OP=INHERIT.T CLAUSE (1+ RPTN) PARENTCLAUSE PARENTLITNO UNIFIER RHO VARIABLES LASTVAR LITNOS)))))
    (DODOWN (RPTN (DS-CLAUSE.NOLIT CLAUSE))
      (unless (MEMBER (1+ RPTN) LITNOS)
	(OP=REMOVE.PROPERTY '(R RD RIW RIWD S SIW SI SID T TIW) CLAUSE (1+ RPTN))
	(SETQ PARENTCLAUSE (CG-CLAUSE_ANCESTOR.LITERALS CLAUSE (1+ RPTN))) (SETQ PARENTLITNO (CADAR PARENTCLAUSE))
	(SETQ PARENTCLAUSE (CAAR PARENTCLAUSE))
	(OP=REMOVE.PROPERTY '(R RD RIW RIWD S SIW SI SID T TIW) PARENTCLAUSE PARENTLITNO)))
    (COND (NOAUTOLINK (DT-REMPROP POSPAR 'OP*RENAMING) (DT-REMPROP NEGPAR 'OP*RENAMING)))))

(DEFUN OP=INHERIT.R (CLAUSE LITNO PARENTCLAUSE PARENTLITNO SIGMA RHO VARIABLES LASTVAR LITNOS)
						; EDITED: 12. 2. 1984
						; INPUT:  THE NEW CLAUSE AND LITERAL NUMBER,
						;         THE PARENTCLAUSE AND LITERAL NUMBER, OF
						;         WHICH THE NEW CLAUSE IS AN INSTANCE,
						;         RHO AND SIGMA ARE SUBSTITUTIONS SUCH THAT
						;         RHO(SIGMA(PARENTCLAUSE)) -> CLAUSE
						;         VARIABLES IS A COPY OF (DS-CLAUSE.VARIABLES
						;         CLAUSE) AND LASTVAR IS A POINTER TO THE
						;         LAST CONS CELL OF VARIABLES.
						;         LITNOS IS A LIST OF LITERALS TO WHICH NO
						;         LINK SHOULD BE INHERITED.
						; EFFECT: THE R-LINK FAMILY IS INHERITED TO THE
						;         SPECIFIED LITERAL IN CLAUSE.
						;         INTERNAL LITERALS ARE GENERATED BETWEEN
						;         LITNO AND LITERALS WITH SMALLER NUMBERS.
						; VALUE:  UNDEFINED.
  (PROG ((PARENTS (DS-CLAUSE.PARENTS CLAUSE)) OTHERCLAUSE OTHERLITNO LITNO2 X.LINKS XD.LINKS)
	(MAPC
	  #'(LAMBDA (COLOUR)
	      (MAPC
		#'(LAMBDA (LINK)
		    (COND
		      ((and (NOT (DT-GETPROP LINK 'INHERITED)) (not (nar-narrow.info link)))
		       (SETQ OTHERCLAUSE (DS-LINK.OTHERPAR LINK PARENTCLAUSE))
		       (SETQ OTHERLITNO  (DS-LINK.OTHERLITNO LINK PARENTCLAUSE PARENTLITNO))
		       (SETQ LITNO2
			     (first (rest (ASSOC CLAUSE (CG-CLAUSE_DESCENDANT.LITERALS OTHERCLAUSE OTHERLITNO)))))
		       (SETQ X.LINKS (OP=PARALLEL.LINKS 'R PARENTCLAUSE PARENTLITNO OTHERCLAUSE OTHERLITNO))
		       (SETQ XD.LINKS (OP=PARALLEL.LINKS 'RD PARENTCLAUSE PARENTLITNO OTHERCLAUSE OTHERLITNO))
		       (COND
			 ((MEMBER OTHERCLAUSE PARENTS)
			  (OP=INHERIT.X.TO.X.XI.XIW CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERCLAUSE
						    OTHERLITNO SIGMA RHO X.LINKS XD.LINKS VARIABLES LITNOS))
			 (T
			  (OP=INHERIT.X.TO.X CLAUSE LITNO OTHERCLAUSE OTHERLITNO SIGMA RHO X.LINKS XD.LINKS
					     VARIABLES)))
		       (COND (LASTVAR (RPLACD LASTVAR NIL))))))
		(DS-CLAUSE.LINKS COLOUR PARENTCLAUSE PARENTLITNO)))
	  '(R RD))
	(MAPC
	  #'(LAMBDA (COLOUR)
	      (MAPC
		#'(LAMBDA (LINK)
		    (COND
		      ((and (NOT (DT-GETPROP LINK 'INHERITED)) (not (nar-narrow.info link)))
		       (SETQ OTHERLITNO (DS-LINK.OTHERLITNO LINK PARENTCLAUSE PARENTLITNO))
		       (SETQ LITNO2
			     (CAR (rest (ASSOC CLAUSE (CG-CLAUSE_DESCENDANT.LITERALS PARENTCLAUSE OTHERLITNO)))))
		       (COND ((AND LITNO2 (> LITNO2 LITNO))
						; THESE LINKS ARE ALREADY INHERITED
			      )
			     (T
			      (SETQ X.LINKS
				    (OP=PARALLEL.LINKS 'RIW PARENTCLAUSE PARENTLITNO PARENTCLAUSE OTHERLITNO))
			      (SETQ XD.LINKS
				    (OP=PARALLEL.LINKS 'RIWD PARENTCLAUSE PARENTLITNO PARENTCLAUSE OTHERLITNO))
			      (OP=INHERIT.XIW.TO.X.XI.XIW CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERLITNO
							  SIGMA RHO X.LINKS XD.LINKS VARIABLES LITNOS T)
			      (COND (LASTVAR (RPLACD LASTVAR NIL))))))))
		(DS-CLAUSE.LINKS COLOUR PARENTCLAUSE PARENTLITNO)))
	  '(RIW RIWD))))

(DEFUN OP=INHERIT.S (CLAUSE LITNO PARENTCLAUSE PARENTLITNO SIGMA RHO VARIABLES LASTVAR LITNOS)
						; EDITED: 12. 2. 1984
						; INPUT:  THE NEW CLAUSE AND LITERAL NUMBER,
						;         THE PARENTCLAUSE AND LITERAL NUMBER, OF
						;         WHICH THE NEW CLAUSE IS AN INSTANCE,
						;         RHO AND SIGMA ARE SUBSTITUTIONS SUCH THAT
						;         RHO(SIGMA(PARENTCLAUSE)) -> CLAUSE
						;         VARIABLES IS A COPY OF (DS-CLAUSE.VARIABLES
						;         CLAUSE) AND LASTVAR IS A POINTER TO THE
						;         LAST CONS CELL OF VARIABLES.
						;         LITNOS IS A LIST OF LITERALS TO WHICH NO
						;         LINK SHOULD BE INHERITED.
						; EFFECT: THE S-LINK FAMILY IS INHERITED TO THE
						;         SPECIFIED LITERAL IN CLAUSE.
						;         INTERNAL LITERALS ARE GENERATED BETWEEN
						;         LITNO AND LITERALS WITH SMALLER NUMBERS.
						; VALUE:  UNDEFINED.
  (PROG ((PARENTS (DS-CLAUSE.PARENTS CLAUSE)) OTHERCLAUSE OTHERLITNO LITNO2 X.LINKS XD.LINKS)
	(MAPC
	  #'(LAMBDA (LINK)
	      (COND
		((and (NOT (DT-GETPROP LINK 'INHERITED)) (not (nar-narrow.info link)))
		 (SETQ OTHERCLAUSE (DS-LINK.OTHERPAR LINK PARENTCLAUSE))
		 (SETQ OTHERLITNO (DS-LINK.OTHERLITNO LINK PARENTCLAUSE PARENTLITNO))
		 (SETQ LITNO2 (CAR (rest (ASSOC CLAUSE (CG-CLAUSE_DESCENDANT.LITERALS OTHERCLAUSE OTHERLITNO)))))
		 (COND
		   ((SETQ X.LINKS (OP=PARALLEL.LINKS.1 'S T PARENTCLAUSE PARENTLITNO OTHERCLAUSE OTHERLITNO))
						; ORIENTATION IS FREE
		    (COND
		      ((MEMBER OTHERCLAUSE PARENTS)
		       (OP=INHERIT.X.TO.X.XI.XIW CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERCLAUSE
						 OTHERLITNO SIGMA RHO X.LINKS NIL VARIABLES LITNOS))
		      (T (OP=INHERIT.X.TO.X CLAUSE LITNO OTHERCLAUSE OTHERLITNO SIGMA RHO X.LINKS NIL VARIABLES)))))
		 (COND (LASTVAR (RPLACD LASTVAR NIL)))
		 (COND
		   ((SETQ X.LINKS (OP=PARALLEL.LINKS.1 'S NIL OTHERCLAUSE OTHERLITNO PARENTCLAUSE PARENTLITNO))
						; ORIENTATION IS FIXED
		    (COND
		      (LITNO2
		       (OP=INHERIT.X.TO.X.XI.XIW CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERCLAUSE
						 OTHERLITNO SIGMA RHO X.LINKS NIL VARIABLES LITNOS)
		       (COND (LASTVAR (RPLACD LASTVAR NIL))))
		      (T (OP=INHERIT.X.TO.X CLAUSE LITNO OTHERCLAUSE OTHERLITNO SIGMA RHO X.LINKS NIL VARIABLES)))
		    (COND (LASTVAR (RPLACD LASTVAR NIL))))))))
	  (DS-CLAUSE.LINKS 'S PARENTCLAUSE PARENTLITNO))
	(MAPC
	  #'(LAMBDA (LINK)
	      (COND
		((and (NOT (DT-GETPROP LINK 'INHERITED)) (not (nar-narrow.info link)))
		 (SETQ OTHERLITNO (DS-LINK.OTHERLITNO LINK PARENTCLAUSE PARENTLITNO))
		 (SETQ LITNO2
		       (CAR (rest (ASSOC CLAUSE (CG-CLAUSE_DESCENDANT.LITERALS PARENTCLAUSE OTHERLITNO)))))
		 (COND ((AND LITNO2 (> LITNO2 LITNO))
						; THESE LINKS ARE ALREADY INHERITED
			)
		       (T
			(COND
			  ((SETQ X.LINKS
				 (OP=PARALLEL.LINKS.1 'SIW T PARENTCLAUSE PARENTLITNO PARENTCLAUSE OTHERLITNO))
			   (OP=INHERIT.XIW.TO.X.XI.XIW CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERLITNO
						       SIGMA RHO X.LINKS NIL VARIABLES LITNOS NIL)
			   (COND (LASTVAR (RPLACD LASTVAR NIL)))))
			(COND
			  ((SETQ X.LINKS
				 (OP=PARALLEL.LINKS.1 'SIW NIL PARENTCLAUSE OTHERLITNO PARENTCLAUSE PARENTLITNO))
			   (OP=INHERIT.XIW.TO.X.XI.XIW CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERLITNO
						       SIGMA RHO X.LINKS NIL VARIABLES LITNOS NIL)
			   (COND (LASTVAR (RPLACD LASTVAR NIL))))))))))
	  (DS-CLAUSE.LINKS 'SIW PARENTCLAUSE PARENTLITNO))
	(MAPC
	  #'(LAMBDA (COLOUR)
	      (MAPC
		#'(LAMBDA (LINK)
		    (COND
		      ((and (NOT (DT-GETPROP LINK 'INHERITED)) (not (nar-narrow.info link)))
		       (SETQ OTHERLITNO (DS-LINK.OTHERLITNO LINK PARENTCLAUSE PARENTLITNO))
		       (SETQ LITNO2
			     (CAR (rest (ASSOC CLAUSE (CG-CLAUSE_DESCENDANT.LITERALS PARENTCLAUSE OTHERLITNO)))))
		       (COND
			 (LITNO2
			  (COND
			    ((OR (> LITNO2 LITNO) (MEMBER LITNO2 LITNOS))
						; THESE LINKS ARE ALREADY INHERITED
			     )
			    (T
			     (SETQ X.LINKS
				   (OP=PARALLEL.LINKS.1 'SI T PARENTCLAUSE PARENTLITNO PARENTCLAUSE OTHERLITNO))
			     (SETQ XD.LINKS
				   (OP=PARALLEL.LINKS.1 'SID T PARENTCLAUSE PARENTLITNO PARENTCLAUSE OTHERLITNO))
			     (COND
			       ((OR X.LINKS XD.LINKS)
                                (OP=INHERIT.XI.TO.XI CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERLITNO
						     SIGMA RHO X.LINKS XD.LINKS VARIABLES)
                                (COND (LASTVAR (RPLACD LASTVAR NIL)))))
			     (SETQ X.LINKS
				   (OP=PARALLEL.LINKS.1 'SI NIL PARENTCLAUSE OTHERLITNO PARENTCLAUSE PARENTLITNO))
			     (SETQ XD.LINKS
				   (OP=PARALLEL.LINKS.1 'SID NIL PARENTCLAUSE OTHERLITNO PARENTCLAUSE PARENTLITNO))
			     (COND
			       ((OR X.LINKS XD.LINKS)
                                (OP=INHERIT.XI.TO.XI CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERLITNO
						     SIGMA RHO X.LINKS XD.LINKS VARIABLES)
                                (COND (LASTVAR (RPLACD LASTVAR NIL))))))))))))
		(DS-CLAUSE.LINKS COLOUR PARENTCLAUSE PARENTLITNO)))
	  '(SI SID))))

(DEFUN OP=INHERIT.T (CLAUSE LITNO PARENTCLAUSE PARENTLITNO SIGMA RHO VARIABLES LASTVAR LITNOS)
						; EDITED: 12. 2. 1984
						; INPUT:  THE NEW CLAUSE AND LITERAL NUMBER,
						;         THE PARENTCLAUSE AND LITERAL NUMBER, OF
						;         WHICH THE NEW CLAUSE IS AN INSTANCE,
						;         RHO AND SIGMA ARE SUBSTITUTIONS SUCH THAT
						;         RHO(SIGMA(PARENTCLAUSE)) -> CLAUSE
						;         VARIABLES IS A COPY OF (DS-CLAUSE.VARIABLES
						;         CLAUSE) AND LASTVAR IS A POINTER TO THE
						;         LAST CONS CELL OF VARIABLES.
						;         LITNOS IS A LIST OF LITERALS TO WHICH NO
						;         LINK SHOULD BE INHERITED.
						; EFFECT: THE T-LINK FAMILY IS INHERITED TO THE
						;         SPECIFIED LITERAL IN CLAUSE.
						;         INTERNAL LITERALS ARE GENERATED BETWEEN
						;         LITNO AND LITERALS WITH SMALLER NUMBERS.
						; VALUE:  UNDEFINED.
  (PROG ((PARENTS (DS-CLAUSE.PARENTS CLAUSE)) OTHERCLAUSE OTHERLITNO LITNO2 X.LINKS)
	(MAPC
	  #'(LAMBDA (LINK)
	      (COND
		((and (NOT (DT-GETPROP LINK 'INHERITED)) (not (nar-narrow.info link)))
		 (SETQ OTHERCLAUSE (DS-LINK.OTHERPAR LINK PARENTCLAUSE))
		 (SETQ OTHERLITNO (DS-LINK.OTHERLITNO LINK PARENTCLAUSE PARENTLITNO))
		 (SETQ LITNO2 (CAR (CdR (ASSOC CLAUSE (CG-CLAUSE_DESCENDANT.LITERALS OTHERCLAUSE OTHERLITNO)))))
		 (SETQ X.LINKS (OP=PARALLEL.LINKS 'T PARENTCLAUSE PARENTLITNO OTHERCLAUSE OTHERLITNO))
		 (COND
		   ((MEMBER OTHERCLAUSE PARENTS)
		    (OP=INHERIT.X.TO.X.XI.XIW CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERCLAUSE
					      OTHERLITNO SIGMA RHO X.LINKS NIL VARIABLES LITNOS))
		   (T (OP=INHERIT.X.TO.X CLAUSE LITNO OTHERCLAUSE OTHERLITNO SIGMA RHO X.LINKS NIL VARIABLES)))
		 (COND (LASTVAR (RPLACD LASTVAR NIL))))))
	  (DS-CLAUSE.LINKS 'T PARENTCLAUSE PARENTLITNO))
	(MAPC
	  #'(LAMBDA (LINK)
	      (COND
		((and (NOT (DT-GETPROP LINK 'INHERITED)) (not (nar-narrow.info link)))
		 (SETQ OTHERLITNO (DS-LINK.OTHERLITNO LINK PARENTCLAUSE PARENTLITNO))
		 (SETQ LITNO2
		       (CAR (rest (ASSOC CLAUSE (CG-CLAUSE_DESCENDANT.LITERALS PARENTCLAUSE OTHERLITNO)))))
		 (COND ((AND LITNO2 (> LITNO2 LITNO))
						; THESE LINKS ARE ALREADY INHERITED
			)
		       ((SETQ X.LINKS (OP=PARALLEL.LINKS 'TIW PARENTCLAUSE PARENTLITNO PARENTCLAUSE OTHERLITNO))
			(OP=INHERIT.XIW.TO.X.XI.XIW CLAUSE LITNO LITNO2 PARENTCLAUSE PARENTLITNO OTHERLITNO SIGMA
						    RHO X.LINKS NIL VARIABLES LITNOS T)
			(COND (LASTVAR (RPLACD LASTVAR NIL))))))))
	  (DS-CLAUSE.LINKS 'TIW PARENTCLAUSE PARENTLITNO))))

(DEFUN OP=INHERIT.X.TO.X (NEWCLAUSE NEWLITNO OTHERCLAUSE OTHERLITNO SIGMA RHO X.LINKS XD.LINKS VARIABLES)
						; EDITED: 12. 2. 1984
						; INPUT:  THE NEW LITERAL ADDRESS (NEWCLAUSE NEWLITNO)
						;         A LITERAL ADDRESS (OTHERCLAUSE OTHERLITNO)
						;         TO WHICH LINKS SHALL BE GENERATED. SIGMA AND RHO
						;         ARE SUBSTITUTIONS WHITH NEWLITERAL
						;         WHERE OLDLITERAL IS THE ANCESTOR OF NEWLITERAL.
						;         X.LINKS AND XD.LINKS ARE THE LINKS (NOT DELETED
						;         AND DELETED) BETWEEN OLDLITERAL AND OTHERLITERAL
						;         WHICH SHALL BE INHERITED.
						;         VARIABLES ARE THE VARIABLES OCCURRING IN NEWCLAUSE.
						;
						;             OLD                       OTHER
						;    SIGMA  .-----. X.LINKS  XD.LINKS  .-----.
						;  ---------I  I  I--------------------I  I  I
						;           '-----'                    '-----'
						;                !                      !
						;             RHO!        .-------------'
						;                !        !  NEW LINKS
						;           NEW  V        !
						;       ----------.       !
						;           I  I  I ------'
						;       ----------'
						;
						; EFFECT: X.LINKS AND XD.LINKS ARE INHERITED IF
						;         POSSIBLE. INHERITED UNIFIERS FROM X.LINKS
						;         WHICH ARE INSTANCES OF INHERITED UNIFIERS
						;         FROM XD.LINKS ARE REMOVED.
						; VALUE:  UNDEFINED.
  (PROG (UNIFIERS X.UNIFIERS XD.UNIFIERS LINK)
	(SETQ VARIABLES (NCONC VARIABLES (DS-CLAUSE.LIT.VARIABLES OTHERCLAUSE OTHERLITNO)))
	(UNI-SET.BINDINGS.OF.SUBSTITUTION SIGMA)
	(MAPC #'(LAMBDA (LINK)
		  (when (SETQ UNIFIERS
			      (MAPCAN #'(LAMBDA (TAU) (OP=REMOVE.COMPONENTS (OP=RENAME RHO (UNI-UNIFY.MIXED.TERMLIST TAU))
									    VARIABLES))
				      (DS-LINK.UNIFIERS LINK)))
		    (SETQ XD.UNIFIERS (CONS (CONS LINK UNIFIERS) XD.UNIFIERS))))
	      XD.LINKS)
	(MAPC
	  #'(LAMBDA (LINK)
	      (COND
		((SETQ UNIFIERS
		       (MAPCAN
			 #'(LAMBDA (TAU) (OP=REMOVE.COMPONENTS (OP=RENAME RHO (UNI-UNIFY.MIXED.TERMLIST TAU)) VARIABLES))
			 (DS-LINK.UNIFIERS LINK)))
		 (SETQ X.UNIFIERS (CONS (CONS LINK UNIFIERS) X.UNIFIERS)))))
	  X.LINKS)
	(UNI-RESET.BINDINGS.OF.SUBSTITUTION SIGMA)
	(COND
	  ((OR XD.UNIFIERS X.UNIFIERS)
	   (MAPC #'(LAMBDA (LINK.UNIFIERS)
		     (SETQ LINK (CAR LINK.UNIFIERS))
		     (COND
		       ((EQL OTHERCLAUSE (DS-LINK.POSPAR LINK))
			(CG-INSERT.LINK
			  (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) OTHERCLAUSE OTHERLITNO NEWCLAUSE
					  NEWLITNO NIL NIL (DS-LINK.RULE LINK))
			  (LIST LINK) 'INHERITED (LIST LINK)))
		       (T
			(CG-INSERT.LINK
			  (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO OTHERCLAUSE
					  OTHERLITNO NIL NIL (DS-LINK.RULE LINK))
			  (LIST LINK) 'INHERITED (LIST LINK)))))
		 (OP=REMOVE.INSTANCES XD.UNIFIERS X.UNIFIERS VARIABLES))))))

(DEFUN OP=INHERIT.X.TO.X.XI.XIW
       (NEWCLAUSE NEWLITNO1 NEWLITNO2 OLDCLAUSE OLDLITNO OTHERCLAUSE OTHERLITNO SIGMA RHO X.LINKS XD.LINKS
	VARIABLES LITNOS)
						; EDITED: 12. 2. 1984
						; INPUT:  FOUR LITERAL ADDRESSES (CLAUSE LITNO).
						;         SIGMA AND RHO ARE THE SUBSTITUTIONS SUCH
						;  THAT RHO (SIGMA (OLD)) = NEW.
						;  X.LINKS AND XD.LINKS ARE THE LINKS (NOT DELETED
						;  AND DELETED) TO BE INHERITED TO NEWLITERAL.
						;  VARIABLES ARE THE VARIABLES OCCURRING IN NEWCLAUSE.
						;         LITNOS IS A LIST OF LITERALS TO WHICH NO
						;         LINK SHOULD BE INHERITED.
						;
						;                 X.LINKS  XD.LINKS
						;   OLD .-------------------------------------. OTHER
						;  .-----------.       SIGMA           .-----------.
						;  I   I 1 I   I-----------------------I   I 2 I   I
						;  '-----------'                       '-----------'
						;        !                                   !
						;        !            .----------------------'
						;        '------------+-------. NEW X-LINKS
						;                     !       !
						;                   .-----------.
						;     RHO ->        I 1 I   I 2 I NEW
						;                   '-----------'
						;                     '-------'  NEW XI-, XIW-LINKS
						;
						; EFFECT: X.LINKS AND XD.LINKS ARE INHERITED TO
						;         EXTERNAL AND INTERNAL LITERAL LINKS IF
						;  POSSIBLE. D-LINKS (DELETED) ARE INHERITED TO
						;  D-LINKS. INHERITED UNIFIERS WHICH ARE INSTANCES OF
						;  UNIFIERS OF D-LINKS ARE REMOVED.
						; VALUE: UNDEFINED.
  (PROG
    ((RHO1 (DS-CLAUSE.RENAMING NEWCLAUSE))
     (RHO.SIGMA (UNI-APPLY.SUBSTITUTION RHO SIGMA T))
     (VARS1 (COND (NEWLITNO1 (APPEND (DS-CLAUSE.LIT.VARIABLES NEWCLAUSE NEWLITNO1)
				     (copy-list (DS-CLAUSE.LIT.VARIABLES OTHERCLAUSE OTHERLITNO))))))
     (VARS2 (COND (NEWLITNO2 (APPEND (DS-CLAUSE.LIT.VARIABLES NEWCLAUSE NEWLITNO2)
				     (copy-list (DS-CLAUSE.LIT.VARIABLES OLDCLAUSE OLDLITNO))))))
     (RHOOLD (DT-GETPROP OLDCLAUSE 'OP*RENAMING))
     (RHOOTHER (DT-GETPROP OTHERCLAUSE 'OP*RENAMING))
     XIWD.UNIFIERS XIW.UNIFIERS XID.UNIFIERS XI.UNIFIERS X1D.UNIFIERS
     X2D.UNIFIERS X1.UNIFIERS X2.UNIFIERS UNIFIERS1
     UNIFIERS2 THETA PHI VAR.T1 LINK NEWLINK)
    (UNI-SET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
    (MAPC #'(LAMBDA (LINK)
	      (SETQ THETA (DS-LINK.UNIFIERS LINK))
	      (COND ((AND NEWLITNO1
			  (NOT (MEMBER NEWLITNO1 LITNOS))
			  (SETQ UNIFIERS1 (MAPCAN #'(LAMBDA (TAU) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST TAU) VARS1))
						  (UNI-APPLY.SUBSTITUTION RHOOLD THETA T))))
		     (SETQ X1D.UNIFIERS (CONS (CONS LINK UNIFIERS1) X1D.UNIFIERS)))
		    (T (SETQ UNIFIERS1 NIL)))
	      (COND ((AND NEWLITNO2
			  (NOT (MEMBER NEWLITNO2 LITNOS))
			  (SETQ UNIFIERS2 (MAPCAN #'(LAMBDA (TAU) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST TAU) VARS2))
						  (UNI-APPLY.SUBSTITUTION RHOOTHER THETA T))))
		     (SETQ X2D.UNIFIERS (CONS (CONS LINK UNIFIERS2) X2D.UNIFIERS)))
		    (T (SETQ UNIFIERS2 NIL)))
	      (COND
		((AND UNIFIERS1 UNIFIERS2)
		 (UNI-RESET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
		 (UNI-SET.BINDINGS.OF.SUBSTITUTION SIGMA)
		 (COND
		   ((EQL OLDCLAUSE (DS-LINK.POSPAR LINK)) (SETQ VAR.T1 (DS-CLAUSE.LIT.VARIABLES OLDCLAUSE OLDLITNO)))
		   (T (SETQ VAR.T1 (DS-CLAUSE.LIT.VARIABLES OTHERCLAUSE OTHERLITNO)))) 
		 (SETQ PHI (OP=RENAME RHO1 (OP=RENAME RHO (UNI-APPLY.SUBSTITUTION SIGMA VAR.T1 T))))
		 (AND
		   (SETQ UNIFIERS1
			 (MAPCAN
			   #'(LAMBDA (TAU)
			       (OP=REMOVE.COMPONENTS
				 (OP=RENAME RHO (UNI-UNIFY.MIXED.TERMLIST (SUBPAIR PHI VAR.T1 TAU))) RHO1))
			   THETA))
		   (SETQ XIWD.UNIFIERS (CONS (CONS LINK UNIFIERS1) XIWD.UNIFIERS))
		   (SETQ UNIFIERS1
			 (MAPCAN
			   #'(LAMBDA (TAU)
			       (OP=REMOVE.COMPONENTS (OP=RENAME RHO (UNI-UNIFY.MIXED.TERMLIST TAU)) VARIABLES))
			   THETA))
		   (SETQ XID.UNIFIERS (CONS (CONS LINK UNIFIERS1) XID.UNIFIERS)))
		 (UNI-RESET.BINDINGS.OF.SUBSTITUTION SIGMA) (UNI-SET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA))))
	  XD.LINKS)
    (MAPC
      #'(LAMBDA (LINK) (SETQ THETA (DS-LINK.UNIFIERS LINK))
		(COND
		  ((AND NEWLITNO1 (NOT (MEMBER NEWLITNO1 LITNOS))
			(SETQ UNIFIERS1
			      (MAPCAN #'(LAMBDA (TAU) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST TAU) VARS1))
				      (UNI-APPLY.SUBSTITUTION RHOOLD THETA T))))
		   (SETQ X1.UNIFIERS (CONS (CONS LINK UNIFIERS1) X1.UNIFIERS)))
		  (T (SETQ UNIFIERS1 NIL)))
		(COND
		  ((AND NEWLITNO2 (NOT (MEMBER NEWLITNO2 LITNOS))
			(SETQ UNIFIERS2
			      (MAPCAN #'(LAMBDA (TAU) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST TAU) VARS2))
				      (UNI-APPLY.SUBSTITUTION RHOOTHER THETA T))))
		   (SETQ X2.UNIFIERS (CONS (CONS LINK UNIFIERS2) X2.UNIFIERS)))
		  (T (SETQ UNIFIERS2 NIL)))
		(COND
		  ((AND UNIFIERS1 UNIFIERS2) (UNI-RESET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
		   (UNI-SET.BINDINGS.OF.SUBSTITUTION SIGMA)
		   (COND
		     ((EQL OLDCLAUSE (DS-LINK.POSPAR LINK)) (SETQ VAR.T1 (DS-CLAUSE.LIT.VARIABLES OLDCLAUSE OLDLITNO)))
		     (T (SETQ VAR.T1 (DS-CLAUSE.LIT.VARIABLES OTHERCLAUSE OTHERLITNO))))
		   (SETQ PHI (OP=RENAME RHO1 (OP=RENAME RHO (UNI-APPLY.SUBSTITUTION SIGMA VAR.T1 T))))
		   (AND
		     (SETQ UNIFIERS1
			   (MAPCAN
			     #'(LAMBDA (TAU)
				 (OP=REMOVE.COMPONENTS
				   (OP=RENAME RHO (UNI-UNIFY.MIXED.TERMLIST (SUBPAIR PHI VAR.T1 TAU))) RHO1))
			     THETA))
		     (SETQ XIW.UNIFIERS (CONS (CONS LINK UNIFIERS1) XIW.UNIFIERS))
		     (SETQ UNIFIERS1
			   (MAPCAN
			     #'(LAMBDA (TAU)
				 (OP=REMOVE.COMPONENTS (OP=RENAME RHO (UNI-UNIFY.MIXED.TERMLIST TAU)) VARIABLES))
			     THETA))
		     (SETQ XI.UNIFIERS (CONS (CONS LINK UNIFIERS1) XI.UNIFIERS)))
		   (UNI-RESET.BINDINGS.OF.SUBSTITUTION SIGMA) (UNI-SET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA))))
      X.LINKS)
    (UNI-RESET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
    (COND
      ((OR X1D.UNIFIERS X1.UNIFIERS)
       (MAPC
	 #'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS))
		   (COND
		     ((EQL OLDCLAUSE (DS-LINK.POSPAR LINK))
		      (SETQ NEWLINK
			    (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO1 OTHERCLAUSE
					    OTHERLITNO NIL NIL (DS-LINK.RULE LINK))))
		     (T
		      (SETQ NEWLINK
			    (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) OTHERCLAUSE OTHERLITNO NEWCLAUSE
					    NEWLITNO1 NIL NIL (DS-LINK.RULE LINK)))))
		   (CG-INSERT.LINK NEWLINK (LIST LINK) 'INHERITED (LIST LINK)) (DT-PUTPROP NEWLINK 'INHERITED T))
	 (OP=REMOVE.INSTANCES X1D.UNIFIERS X1.UNIFIERS VARS1))))
    (COND
      ((OR X2D.UNIFIERS X2.UNIFIERS)
       (MAPC
	 #'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS))
		   (COND
		     ((EQL OLDCLAUSE (DS-LINK.POSPAR LINK))
		      (SETQ NEWLINK
			    (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) OLDCLAUSE OLDLITNO NEWCLAUSE NEWLITNO2
					    NIL NIL (DS-LINK.RULE LINK))))
		     (T
		      (SETQ NEWLINK
			    (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO2 OLDCLAUSE OLDLITNO
					    NIL NIL (DS-LINK.RULE LINK)))))
		   (CG-INSERT.LINK NEWLINK (LIST LINK) 'INHERITED (LIST LINK)) (DT-PUTPROP NEWLINK 'INHERITED T))
	 (OP=REMOVE.INSTANCES X2D.UNIFIERS X2.UNIFIERS VARS2))))
    (COND
      ((OR XIWD.UNIFIERS XIW.UNIFIERS)
       (MAPC
	 #'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS))
		   (COND
		     ((EQL OLDCLAUSE (DS-LINK.POSPAR LINK))
		      (CG-INSERT.LINK
			(DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'IW) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO1
					NEWCLAUSE NEWLITNO2 NIL NIL (DS-LINK.RULE LINK))
			(LIST LINK) 'INHERITED (LIST LINK)))
		     (T
		      (CG-INSERT.LINK
			(DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'IW) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO2
					NEWCLAUSE NEWLITNO1 NIL NIL (DS-LINK.RULE LINK))
			(LIST LINK) 'INHERITED (LIST LINK)))))
	 (OP=REMOVE.INSTANCES XIWD.UNIFIERS XIW.UNIFIERS RHO1))))
    (COND
      ((OR XID.UNIFIERS XI.UNIFIERS)
       (MAPC
	 #'(LAMBDA (LINK.UNIFIERS)
	     (SETQ LINK (CAR LINK.UNIFIERS))
	     (COND
	       ((EQL OLDCLAUSE (DS-LINK.POSPAR LINK))
		(CG-INSERT.LINK
		  (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'I) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO1
				  NEWCLAUSE NEWLITNO2 NIL NIL (DS-LINK.RULE LINK))
		  (LIST LINK) 'INHERITED (LIST LINK)))
	       (T
		(CG-INSERT.LINK
		  (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'I) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO2
				  NEWCLAUSE NEWLITNO1 NIL NIL (DS-LINK.RULE LINK))
		  (LIST LINK) 'INHERITED (LIST LINK)))))
	 (OP=REMOVE.INSTANCES XID.UNIFIERS XI.UNIFIERS VARIABLES))))))

(DEFUN OP=INHERIT.XIW.TO.X.XI.XIW
       (NEWCLAUSE NEWLITNO1 NEWLITNO2 OLDCLAUSE OLDLITNO1 OLDLITNO2 SIGMA RHO XIW.LINKS XIWD.LINKS VARIABLES LITNOS
	XIFLAG)
						; EDITED: 12. 2. 1984
						; INPUT:  TWO PAIRS OF LITERALS (CLAUSE LIT1 LIT2).
						;         SIGMA AND RHO ARE SUBSTITUTIONS SUCH THAT
						;         RHO (SIGMA (OLD)) = NEW.
						;  VARIABLES ARE THE VARIABLES OCCURING IN NEWCLAUSE.
						;  LITNOS IS A LIST OF LITERALS TO WHICH NO LINKS
						;  SHALL BE INHERITED.
						;
						;                 OLD XIW.LINKS XIWD.LINKS
						;                      .---------------.
						;     SIGMA      .-----------------------. OLD
						;   -------------I   I 1 I   I   I   I 2 I
						;      RHO       '-----------------------'
						;                      !       .-------'
						;       INHERITED      '-------+-------.
						;       LINKS          X-LINKS !       !
						;                      .-------'       !
						;                      !               !
						;                    .-------------------. NEW
						;                    I 1 I   I   I   I 2 I
						;                    '-------------------'
						;                      ! XI, XIW-LINKS !
						;                      '---------------'
						;
						; EFFECT: INTERNAL LINKS ARE INHERITED TO EXTERNAL
						;         AND INTERNAL LINKS IF POSSIBLE.
						;         IF XIFLAG = NIL, NO XI-LINKS ARE GENERATED
						; VALUE:  UNDEFINED.
  (COND
    ((EQL OLDLITNO1 OLDLITNO2)
     (OP=INHERIT.CIRCLE.LINKS NEWCLAUSE NEWLITNO1 OLDCLAUSE OLDLITNO1 SIGMA RHO XIW.LINKS XIWD.LINKS
			      VARIABLES LITNOS))
    (T
     
     (PROG
       ((RHO1 (DS-CLAUSE.RENAMING OLDCLAUSE)) (RHO3 (DS-CLAUSE.RENAMING NEWCLAUSE))
	(RHO.SIGMA (UNI-APPLY.SUBSTITUTION RHO SIGMA T)) X.UNIFIERS1 X.UNIFIERS2 XD.UNIFIERS1 XD.UNIFIERS2 RHO2
	RHO2.TAU POSLITNO NEGLITNO NEGUNIFIERS POSUNIFIERS XIWD.UNIFIERS XID.UNIFIERS XIW.UNIFIERS
	XI.UNIFIERS W.UNIFIERS S.UNIFIERS LINK NEWLINK)
       (DECLARE (SPECIAL X.UNIFIERS1 X.UNIFIERS2 XD.UNIFIERS1 XD.UNIFIERS2))
       (SETQ VARIABLES (NCONC VARIABLES (DS-CLAUSE.VARIABLES OLDCLAUSE)))
       (SETQ RHO2
	     (SMAPCON #'(LAMBDA (TAIL) (LIST (SECOND TAIL) (SECOND (MEMBER (CAR TAIL) RHO)))) #'CDDR RHO1))
       (UNI-SET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
       (MAPC
	 #'(LAMBDA (LINK) (SETQ POSUNIFIERS NIL) (SETQ NEGUNIFIERS NIL)
		   (COND
		     ((EQL OLDLITNO1 (DS-LINK.POSLITNO LINK))
		      (SETQ POSLITNO
			    (COND ((OR (NULL NEWLITNO1) (MEMBER NEWLITNO1 LITNOS)) NIL) (T 'XD.UNIFIERS1)))
		      (SETQ NEGLITNO
			    (COND ((OR (NULL NEWLITNO2) (MEMBER NEWLITNO2 LITNOS)) NIL) (T 'XD.UNIFIERS2))))
		     (T
		      (SETQ POSLITNO
			    (COND ((OR (NULL NEWLITNO2) (MEMBER NEWLITNO2 LITNOS)) NIL) (T 'XD.UNIFIERS2)))
		      (SETQ NEGLITNO
			    (COND ((OR (NULL NEWLITNO1) (MEMBER NEWLITNO1 LITNOS)) NIL) (T 'XD.UNIFIERS1)))))
		   (SETQ RHO2.TAU (UNI-APPLY.SUBSTITUTION RHO2 (DS-LINK.UNIFIERS LINK) T))
		   (COND
		     (POSLITNO
		      (SETQ POSUNIFIERS
			    (MAPCAN
			      #'(LAMBDA (UNIFIER) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST UNIFIER) VARIABLES))
			      RHO2.TAU))))
		   (UNI-SET.BINDINGS.OF.SUBSTITUTION SIGMA)
		   (COND
		     (NEGLITNO (UNI-RESET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
			       (SETQ NEGUNIFIERS
				     (MAPCAN
				       #'(LAMBDA (UNIFIER)
					   (OP=REMOVE.COMPONENTS (UNI-SWITCH RHO (UNI-UNIFY.MIXED.TERMLIST UNIFIER)) VARIABLES))
				       RHO2.TAU))
			       (UNI-SET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)))
		   (COND
		     ((AND POSUNIFIERS NEGUNIFIERS
			   (SETQ W.UNIFIERS
				 (MAPCAN
				   #'(LAMBDA (UNIFIER)
				       (OP=REMOVE.COMPONENTS
					 (OP=RENAME RHO (OP=RENAME RHO3 (UNI-UNIFY.MIXED.TERMLIST UNIFIER))) RHO3))
				   RHO2.TAU)))
		      (SETQ XIWD.UNIFIERS (CONS (CONS LINK W.UNIFIERS) XIWD.UNIFIERS)))
		     (T (SETQ W.UNIFIERS NIL)))
		   (UNI-RESET.BINDINGS.OF.SUBSTITUTION SIGMA)
		   (COND
		     ((AND XIFLAG W.UNIFIERS
			   (OR (NEQ (DS-LINK.COLOUR LINK) 'RIWD) (DS-RULE.R.IFF.T (DS-LINK.RULE LINK)))
			   (SETQ S.UNIFIERS
				 (MAPCAN
				   #'(LAMBDA (UNIFIER) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST UNIFIER) VARIABLES))
				   (OP=RENAME RHO RHO2.TAU))))
		      (SETQ XID.UNIFIERS (CONS (CONS LINK S.UNIFIERS) XID.UNIFIERS))))
		   (COND (POSUNIFIERS (SET POSLITNO (CONS (CONS LINK POSUNIFIERS) (EVAL POSLITNO)))))
		   (COND (NEGUNIFIERS (SET NEGLITNO (CONS (CONS LINK NEGUNIFIERS) (EVAL NEGLITNO))))))
	 XIWD.LINKS)
       (MAPC
	 #'(LAMBDA (LINK) (SETQ POSUNIFIERS NIL) (SETQ NEGUNIFIERS NIL)
		   (COND
		     ((EQL OLDLITNO1 (DS-LINK.POSLITNO LINK))
		      (SETQ POSLITNO
			    (COND ((OR (NULL NEWLITNO1) (MEMBER NEWLITNO1 LITNOS)) NIL) (T 'X.UNIFIERS1)))
		      (SETQ NEGLITNO
			    (COND ((OR (NULL NEWLITNO2) (MEMBER NEWLITNO2 LITNOS)) NIL) (T 'X.UNIFIERS2))))
		     (T
		      (SETQ POSLITNO
			    (COND ((OR (NULL NEWLITNO2) (MEMBER NEWLITNO2 LITNOS)) NIL) (T 'X.UNIFIERS2)))
		      (SETQ NEGLITNO
			    (COND ((OR (NULL NEWLITNO1) (MEMBER NEWLITNO1 LITNOS)) NIL) (T 'X.UNIFIERS1)))))
		   (SETQ RHO2.TAU (UNI-APPLY.SUBSTITUTION RHO2 (DS-LINK.UNIFIERS LINK) T))
		   (COND
		     (POSLITNO
		      (SETQ POSUNIFIERS
			    (MAPCAN
			      #'(LAMBDA (UNIFIER) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST UNIFIER) VARIABLES))
			      RHO2.TAU))))
		   (UNI-SET.BINDINGS.OF.SUBSTITUTION SIGMA)
		   (COND
		     (NEGLITNO (UNI-RESET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
			       (SETQ NEGUNIFIERS
				     (MAPCAN
				       #'(LAMBDA (UNIFIER)
					   (OP=REMOVE.COMPONENTS (UNI-SWITCH RHO (UNI-UNIFY.MIXED.TERMLIST UNIFIER)) VARIABLES))
				       RHO2.TAU))
			       (UNI-SET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)))
		   (COND
		     ((AND POSUNIFIERS NEGUNIFIERS
			   (SETQ W.UNIFIERS
				 (MAPCAN
				   #'(LAMBDA (UNIFIER)
				       (OP=REMOVE.COMPONENTS
					 (OP=RENAME RHO (OP=RENAME RHO3 (UNI-UNIFY.MIXED.TERMLIST UNIFIER))) RHO3))
				   RHO2.TAU)))
		      (SETQ XIW.UNIFIERS (CONS (CONS LINK W.UNIFIERS) XIW.UNIFIERS)))
		     (T (SETQ W.UNIFIERS NIL)))
		   (UNI-RESET.BINDINGS.OF.SUBSTITUTION SIGMA)
		   (COND
		     ((AND XIFLAG W.UNIFIERS
			   (OR (NEQ (DS-LINK.COLOUR LINK) 'RIW) (DS-RULE.R.IFF.T (DS-LINK.RULE LINK)))
			   (SETQ S.UNIFIERS
				 (MAPCAN
				   #'(LAMBDA (UNIFIER) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST UNIFIER) VARIABLES))
				   (OP=RENAME RHO RHO2.TAU))))
		      (SETQ XI.UNIFIERS (CONS (CONS LINK S.UNIFIERS) XI.UNIFIERS))))
		   (COND (POSUNIFIERS (SET POSLITNO (CONS (CONS LINK POSUNIFIERS) (EVAL POSLITNO)))))
		   (COND (NEGUNIFIERS (SET NEGLITNO (CONS (CONS LINK NEGUNIFIERS) (EVAL NEGLITNO))))))
	 XIW.LINKS)
       (UNI-RESET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
       (COND
	 ((OR XD.UNIFIERS1 X.UNIFIERS1)
	  (MAPC
	    #'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS))
		      (COND
			((EQL OLDLITNO1 (DS-LINK.POSLITNO LINK))
			 (SETQ NEWLINK
			       (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'E) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO1
					       OLDCLAUSE OLDLITNO2 NIL NIL (DS-LINK.RULE LINK))))
			(T
			 (SETQ NEWLINK
			       (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'E) (CDR LINK.UNIFIERS) OLDCLAUSE OLDLITNO2
					       NEWCLAUSE NEWLITNO1 NIL NIL (DS-LINK.RULE LINK)))))
		      (CG-INSERT.LINK NEWLINK (LIST LINK) 'INHERITED (LIST LINK)) (DT-PUTPROP NEWLINK 'INHERITED T))
	    (OP=REMOVE.INSTANCES XD.UNIFIERS1 X.UNIFIERS1 VARIABLES))))
       (COND
	 ((OR XD.UNIFIERS2 X.UNIFIERS2)
	  (MAPC
	    #'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS))
		      (COND
			((EQL OLDLITNO1 (DS-LINK.POSLITNO LINK))
			 (SETQ NEWLINK
			       (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'E) (CDR LINK.UNIFIERS) OLDCLAUSE OLDLITNO1
					       NEWCLAUSE NEWLITNO2 NIL NIL (DS-LINK.RULE LINK))))
			(T
			 (SETQ NEWLINK
			       (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'E) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO2
					       OLDCLAUSE OLDLITNO1 NIL NIL (DS-LINK.RULE LINK)))))
		      (CG-INSERT.LINK NEWLINK (LIST LINK) 'INHERITED (LIST LINK)) (DT-PUTPROP NEWLINK 'INHERITED T))
	    (OP=REMOVE.INSTANCES XD.UNIFIERS2 X.UNIFIERS2 VARIABLES))))
       (COND
	 ((OR XIWD.UNIFIERS XIW.UNIFIERS)
	  (MAPC
	    #'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS))
		      (COND
			((EQL OLDLITNO1 (DS-LINK.POSLITNO LINK))
			 (CG-INSERT.LINK
			   (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO1 NEWCLAUSE
					   NEWLITNO2 NIL NIL (DS-LINK.RULE LINK))
			   (LIST LINK) 'INHERITED (LIST LINK)))
			(T
			 (CG-INSERT.LINK
			   (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO2 NEWCLAUSE
					   NEWLITNO1 NIL NIL (DS-LINK.RULE LINK))
			   (LIST LINK) 'INHERITED (LIST LINK)))))
	    (OP=REMOVE.INSTANCES XIWD.UNIFIERS XIW.UNIFIERS RHO3))))
       (COND
	 ((OR XID.UNIFIERS XI.UNIFIERS)
	  (MAPC
	    #'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS))
		      (COND
			((EQL OLDLITNO1 (DS-LINK.POSLITNO LINK))
			 (CG-INSERT.LINK
			   (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'I) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO1
					   NEWCLAUSE NEWLITNO2 NIL NIL (DS-LINK.RULE LINK))
			   (LIST LINK) 'INHERITED (LIST LINK)))
			(T
			 (CG-INSERT.LINK
			   (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'I) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO2
					   NEWCLAUSE NEWLITNO1 NIL NIL (DS-LINK.RULE LINK))
			   (LIST LINK) 'INHERITED (LIST LINK)))))
	    (OP=REMOVE.INSTANCES XID.UNIFIERS XI.UNIFIERS VARIABLES))))))))

(DEFUN OP=INHERIT.CIRCLE.LINKS
       (NEWCLAUSE NEWLITNO OLDCLAUSE OLDLITNO SIGMA RHO XIW.LINKS XIWD.LINKS VARIABLES LITNOS)
						; EDITED: 6. 4. 1984
						; INPUT:  THE OLD LITERAL AND THE INHERITED LITERAL
						;         WITH RHO(SIGMA(OLDLITERAL)) = NEWLITERAL;
						;         TWO GROUPS OF CIRCLE LINKS CONNECTED TO
						;         OLDLITNO, THE VARIABLES OF NEWCLAUSE AND
						;         A LIST OF LITERALS TO WHICH NO LINK SHALL
						;         BE INHERITED.
						;                       .---.
						;            OLD LINKS   d //
						;                         V
						;         SIGMA     .---------------
						;    ---------------!   !   !    OLD CLAUSE
						;          RHO      '---------------
						;                         !
						;                         !      NEW LINKS
						;                   .---------------
						;                   !   !   !    NEW CLAUSE
						;                   '---------------
						;                         //d     NEW LINKS
						;                        '--'
						; EFFECT: THE EXTERNAL LINKS BETWEEN OLDLITERAL AND
						;         NEWLITERAL AS WELL AS THE NEW CIRCLE LINKS
						;         ARE INHERITED.
						; VALUE:  UNDEFINED.
  (COND ((MEMBER NEWLITNO LITNOS))
	(T
	 (PROG
	   ((RHO3 (DS-CLAUSE.RENAMING NEWCLAUSE)) (RHO.SIGMA (UNI-APPLY.SUBSTITUTION RHO SIGMA T))
	    (RHO2
	      (SMAPCON #'(LAMBDA (TAIL) (LIST (SECOND TAIL) (SECOND (MEMBER (CAR TAIL) RHO)))) #'CDDR
		       (DS-CLAUSE.RENAMING OLDCLAUSE)))
	    RHO2.TAU UNIFIERS W.UNIFIERS LINK RULE NEWLINK X.UNIFIERS XD.UNIFIERS XIW.UNIFIERS XIWD.UNIFIERS)
	   (SETQ VARIABLES (NCONC VARIABLES (DS-CLAUSE.LIT.VARIABLES OLDCLAUSE OLDLITNO)))
	   (UNI-SET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
	   (MAPC
	     #'(LAMBDA (LINK) (SETQ RHO2.TAU (UNI-APPLY.SUBSTITUTION RHO2 (DS-LINK.UNIFIERS LINK) T))
		       (COND
			 ((SETQ UNIFIERS
				(MAPCAN
				  #'(LAMBDA (UNIFIER) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST UNIFIER) VARIABLES))
				  RHO2.TAU))
			  (SETQ XD.UNIFIERS (CONS (CONS LINK UNIFIERS) XD.UNIFIERS)) (UNI-SET.BINDINGS.OF.SUBSTITUTION SIGMA)
			  (COND
			    ((SETQ W.UNIFIERS
				   (MAPCAN
				     #'(LAMBDA (UNIFIER)
					 (COND
					   ((SETQ UNIFIERS (UNI-UNIFY.MIXED.TERMLIST UNIFIER))
					    (OP=REMOVE.COMPONENTS (OP=RENAME RHO (OP=RENAME RHO3 UNIFIERS)) RHO3))))
				     RHO2.TAU))
			     (SETQ XIWD.UNIFIERS (CONS (CONS LINK W.UNIFIERS) XIWD.UNIFIERS))))
			  (UNI-RESET.BINDINGS.OF.SUBSTITUTION SIGMA))))
	     XIWD.LINKS)
	   (MAPC
	     #'(LAMBDA (LINK) (SETQ RHO2.TAU (UNI-APPLY.SUBSTITUTION RHO2 (DS-LINK.UNIFIERS LINK) T))
		       (COND
			 ((SETQ UNIFIERS
				(MAPCAN
				  #'(LAMBDA (UNIFIER) (OP=REMOVE.COMPONENTS (UNI-UNIFY.MIXED.TERMLIST UNIFIER) VARIABLES))
				  RHO2.TAU))
			  (SETQ X.UNIFIERS (CONS (CONS LINK UNIFIERS) X.UNIFIERS)) (UNI-SET.BINDINGS.OF.SUBSTITUTION SIGMA)
			  (COND
			    ((SETQ W.UNIFIERS
				   (MAPCAN
				     #'(LAMBDA (UNIFIER)
					 (COND
					   ((SETQ UNIFIERS (UNI-UNIFY.MIXED.TERMLIST UNIFIER))
					    (OP=REMOVE.COMPONENTS (OP=RENAME RHO (OP=RENAME RHO3 UNIFIERS)) RHO3))))
				     RHO2.TAU))
			     (SETQ XIW.UNIFIERS (CONS (CONS LINK W.UNIFIERS) XIW.UNIFIERS))))
			  (UNI-RESET.BINDINGS.OF.SUBSTITUTION SIGMA))))
	     XIW.LINKS)
	   (UNI-RESET.BINDINGS.OF.SUBSTITUTION RHO.SIGMA)
	   (COND
	     ((OR XD.UNIFIERS X.UNIFIERS)
	      (MAPC
		#'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS)) (SETQ RULE (DS-LINK.RULE LINK))
			  (SETQ NEWLINK
				(COND
				  ((AND (CONSP RULE) (EQL 1 (SECOND RULE)))
				   (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'E) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO
						   OLDCLAUSE OLDLITNO NIL NIL RULE))
				  (T
				   (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'E) (CDR LINK.UNIFIERS) OLDCLAUSE OLDLITNO
						   NEWCLAUSE NEWLITNO NIL NIL RULE))))
						; THE ORIENTATION OF THE NEW LINK IS DERIVED FROM THE STRUCTURE OF THE OLD LINKS RULE:
						;  RULE = (C 1 2) YIELDS POSPAR = NEWCLAUSE, RULE = (C 2 1) YIELDS POSPAR = OLDCLAUSE
			  (CG-INSERT.LINK NEWLINK (LIST LINK) 'INHERITED (LIST LINK)) (DT-PUTPROP NEWLINK 'INHERITED T))
		(OP=REMOVE.INSTANCES XD.UNIFIERS X.UNIFIERS VARIABLES))))
	   (COND
	     ((OR XIWD.UNIFIERS XIW.UNIFIERS)
	      (MAPC
		#'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS))
			  (CG-INSERT.LINK
			    (DS-LINK.CREATE (OP=COLOUR (DS-LINK.COLOUR LINK) 'IW) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO
					    NEWCLAUSE NEWLITNO NIL NIL (DS-LINK.RULE LINK))
			    (LIST LINK) 'INHERITED (LIST LINK)))
		(OP=REMOVE.INSTANCES XIWD.UNIFIERS XIW.UNIFIERS RHO3))))))))

(DEFUN OP=INHERIT.XI.TO.XI
       (NEWCLAUSE NEWLITNO1 NEWLITNO2 OLDCLAUSE OLDLITNO1 OLDLITNO2 SIGMA RHO XI.LINKS XID.LINKS VARIABLES)
  (declare (ignore oldlitno2 oldclause))
						; EDITED: 12. 2. 1984
						; INPUT:  TWO PAIRS OF LITERALS (CLAUSE LIT1 LIT2).
						;         SIGMA AND RHO ARE SUBSTITUTIONS SUCH THAT
						;         RHO (SIGMA (OLD)) = NEW.
						;  VARIABLES ARE THE VARIABLES OCCURING IN NEWCLAUSE.
						;
						;                 OLD  XI.LINKS  XID.LINKS
						;                      .---------------.
						;     SIGMA      .-----------------------. OLD
						;   -------------    1 |   |   |   | 2 |
						;      RHO       '-----------------------'
						;                      !               !
						;                      !               !
						;                      V               V
						;                    .-------------------. NEW
						;                    | 1 |   |   |   | 2 |
						;                    '-------------------'
						;                      |   XI-LINKS    |
						;                      '---------------'
						;
						; EFFECT: INTERNAL STRONG LINKS ARE INHERITED TO
						;         INTERNAL STRONG LINKS.
						; VALUE:  UNDEFINED.
  (PROG (XID.UNIFIERS XI.UNIFIERS LINK UNIFIERS) (UNI-SET.BINDINGS.OF.SUBSTITUTION SIGMA)
	(MAPC
	  #'(LAMBDA (LINK)
	      (COND
		((SETQ UNIFIERS
		       (MAPCAN
			 #'(LAMBDA (TAU) (OP=REMOVE.COMPONENTS (OP=RENAME RHO (UNI-UNIFY.MIXED.TERMLIST TAU)) VARIABLES))
			 (DS-LINK.UNIFIERS LINK)))
		 (SETQ XID.UNIFIERS (CONS (CONS LINK UNIFIERS) XID.UNIFIERS)))))
	  XID.LINKS)
	(MAPC
	  #'(LAMBDA (LINK)
	      (COND
		((SETQ UNIFIERS
		       (MAPCAN
			 #'(LAMBDA (TAU) (OP=REMOVE.COMPONENTS (OP=RENAME RHO (UNI-UNIFY.MIXED.TERMLIST TAU)) VARIABLES))
			 (DS-LINK.UNIFIERS LINK)))
		 (SETQ XI.UNIFIERS (CONS (CONS LINK UNIFIERS) XI.UNIFIERS)))))
	  XI.LINKS)
	(UNI-RESET.BINDINGS.OF.SUBSTITUTION SIGMA)
	(COND
	  ((OR XID.UNIFIERS XI.UNIFIERS)
	   (MAPC
	     #'(LAMBDA (LINK.UNIFIERS) (SETQ LINK (CAR LINK.UNIFIERS))
		       (COND
			 ((EQL OLDLITNO1 (DS-LINK.POSLITNO LINK))
			  (CG-INSERT.LINK
			    (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO1 NEWCLAUSE
					    NEWLITNO2 NIL NIL (DS-LINK.RULE LINK))
			    (LIST LINK) 'INHERITED (LIST LINK)))
			 (T
			  (CG-INSERT.LINK
			    (DS-LINK.CREATE (DS-LINK.COLOUR LINK) (CDR LINK.UNIFIERS) NEWCLAUSE NEWLITNO2 NEWCLAUSE
					    NEWLITNO1 NIL NIL (DS-LINK.RULE LINK))
			    (LIST LINK) 'INHERITED (LIST LINK)))))
	     (OP=REMOVE.INSTANCES XID.UNIFIERS XI.UNIFIERS VARIABLES))))))

(DEFUN OP=INHERIT_POT.TRUE.AND.FALSE.LITNOS (CLAUSE)
						; EDITED: 20-SEP-83                             AP
						; INPUT:  A NEWLY CREATED CLAUSE.
						; EFFECT: INHERITS THE CLAUSE COMPONENT POTENTIALLY
						;         TRUE AND FALSE LITERAL NUMBERS.
						; VALUE:  UNDEFINED.
  (PROG ((PARENTS (DS-CLAUSE.PARENTS CLAUSE)) (POT.TRUE.LITNOS NIL) (POT.FALSE.LITNOS NIL) LITNO DESCENDANT)
	(MAPC
	  #'(LAMBDA (PARENT)
	      (MAPC
		#'(LAMBDA (POT.LITNO)
		    (COND
		      ((SETQ DESCENDANT (CG-CLAUSE_DESCENDANT.LITERALS PARENT POT.LITNO))
		       (SETQ LITNO (CADAR DESCENDANT)) (SETQ POT.TRUE.LITNOS (CONS LITNO POT.TRUE.LITNOS)))))
		(DS-CLAUSE.POTENTIALLY.TRUE.LITNOS PARENT))
	      (MAPC
		#'(LAMBDA (POT.LITNO)
		    (COND
		      ((SETQ DESCENDANT (CG-CLAUSE_DESCENDANT.LITERALS PARENT POT.LITNO))
		       (SETQ LITNO (CADAR DESCENDANT)) (SETQ POT.FALSE.LITNOS (CONS LITNO POT.FALSE.LITNOS)))))
		(DS-CLAUSE.POTENTIALLY.FALSE.LITNOS PARENT)))
	  PARENTS)
	(DS-CLAUSE.PUT.POTENTIALLY.TRUE.LITNOS CLAUSE POT.TRUE.LITNOS)
	(DS-CLAUSE.PUT.POTENTIALLY.FALSE.LITNOS CLAUSE POT.FALSE.LITNOS)))

(DEFUN OP=INHERIT_ERPATHS (&REST IGNORE)
  (declare (ignore ignore)))

(DEFUN OP=INHERIT_RELINKS (&REST IGNORE)
  (declare (ignore ignore)))

