;;; -*- Package: MKRP; Syntax: Common-lisp; Mode: lisp -*-

(IN-PACKAGE "MKRP" :use '("CL"))


(defvar norm*commons.to.save
	'(NORM*FUNCTION.COUNTER NORM*CONSTANT.COUNTER 
                                NORM*MAX.SPLIT.DEPTH 
				NORM*EXPRESSION
				NORM*EXPRESSION.LENGTH
				NORM*EXPRESSION.LENGTH.ORIGINAL 
				NORM*FILE.VERSION))

(DEFUN NORM-SAVE (FILE)
  ;; EDITED: 24-APR-83 17:22:34        MW
  ;; INPUT:  NIL OR NAME OF FILE THAT IS OPEN FOR OUTPUT.
  ;; EFFECT: COMPUTES AN S-EXPRESSION WHICH, WHEN EVALU-
  ;;         ATED, RESTORES THE SAVE TIME STATE OF THIS
  ;;         MODULE. IF FILE =//= NIL, THIS EXPRESSION IS
  ;;         WRITTEN ON FILE, OTHERWISE IT IS RETURNED
  ;;         AS VALUE.
  ;; VALUE:  IF FILE =//= NIL THEN THE COMPUTED EXPRESSION
  ;;         DESCRIBED ABOVE ELSE NIL.
  (PROG (RESULT VAR.VAL)
	(SETQ VAR.VAL
	      (CONS 'PROGN
		    (MAPCAR (FUNCTION (LAMBDA (VAR) (LIST 'setq  VAR `',(SYMBOL-VALUE VAR))))
			    norm*commons.to.save)))
	(COND
	  ((EQL NORM*EXPRESSION 'FILE)
	   (SETQ RESULT
		 (NCONC1 VAR.VAL
			 '(COND
			    ((> NORM*EXPRESSION.LENGTH 0)
			     (COND ((NOT (OPENP NORM*FILE.VERSION 'INPUT)) (INPUT (INFILE NORM*FILE.VERSION))))
			     (DODOWN (RPTN (- NORM*EXPRESSION.LENGTH.ORIGINAL NORM*EXPRESSION.LENGTH)) (READ NORM*FILE.VERSION)))))))
	  (T (SETQ RESULT VAR.VAL)))
	(COND (FILE (PROGN (PRINC RESULT FILE) (TERPRI FILE)) (RETURN NIL)) ((NOT FILE) (RETURN RESULT)))))

(defun NORM=TRACE_IS.TOP.INCARNATION (FUNCTION)
  (symbol-value (intern (format nil "NORM*TRACE_TOP.~A" function)
			(find-package "MKRP"))))

(defun NORM=TRACE_TOP.INCARNATION.FLAG (function set.flag)
  (setf (symbol-value (intern (format nil "NORM*TRACE_TOP.~A" function)
			      (find-package "MKRP"))) set.flag))

(DEFmacro NORM-TRACE (SWITCH)
  ;; INPUT:  EITHER OF THE ATOMS ON, OFF, T.
  ;; VALUE:  MESSAGE ABOUT KIND OF SWITCH PERFORMED
  ;; EFFECT: WHEN SWITCHED ON CAUSES ALL FUNCTIONS IN-
  ;;         VOKED BY NORM-NORMALIZATION TO PRETTYPRINT
  ;;         THEIR RESULT ON THE PROTOCOL FILE OR ON T,
  ;;         THUS PROVIDING A MEANS FOR KEEPING TRACK OF
  ;;         THE INTERMEDIATE RESULTS.
  ;;         FOR DEBUGGING AND TEST PURPOSES.
  (CASE SWITCH
    ((ON T) (let* ((FUNCTIONS '(NORM=REPLACE.EQV NORM=REPLACE.IMPL NORM=MOVE.NEGATIONS.TO.LITERALS NORM=MOVE.QUANTIFIERS.INSIDE
						 NORM=MOVE.QUANTIFIERS.OUTSIDE NORM=SKOLEMIZE NORM=MARK.SPLIT NORM=PREPARE.SPLIT
						 NORM=SPLIT NORM=REMOVE.QUANTIFIERS NORM=TRANSFORM.TO.PSEUDO.CNF
						 NORM=FLATTEN.CLAUSELIST))
		   (STRINGS   '("EQV REPLACED:" "IMPL REPLACED:" "NEGATIONS MOVED INSIDE:" "QUANTIFIERS MOVED INSIDE:"
				"QUANTIFIERS MOVED OUTSIDE:" "SKOLEMIZED:" "PARTS TO BE SPLIT MARKED BY ']':"
				"SPLITMARKS REMOVED, TRANSFORMED TO PSEUDO DNF:" "SPLIT:" "QUANITIFIERS REMOVED:"
				"TRANSFORMED TO PSEUDO CNF:" "CLAUSAL FORM:"))
		   (=TERMINALFLAG (EQL SWITCH T))
		   (message (APPEND '(NORM-TRACE SWITCHED ON. OUTPUT WILL GO TO) (if =TERMINALFLAG '(TERMINAL.) '(PROTOCOL FILE.)))))
	      `(progn (GLOBAL:ADVISE NORM-NORMALIZATION :around NORM 0
			(let ((NORM*TRACE_TOP.NORM=TRACE_PROTOCOL (if (boundp 'NORM*TRACE_TOP.NORM=TRACE_PROTOCOL)
								      nil
								      t)))
			  (declare (special NORM*TRACE_TOP.NORM=TRACE_PROTOCOL))
			  (NORM=TRACE_PROTOCOL "Normalizing the following expression:" (first arglist) ,=TERMINALFLAG)
			  :do-it
			  (when (and (boundp 'NORM*TRACE_TOP.NORM=TRACE_PROTOCOL)
				     NORM*TRACE_TOP.NORM=TRACE_PROTOCOL)
			    (NORM=TRACE_PROTOCOL "RESULT OF NORMALIZATION:"  (first VALUEs) ,=TERMINALFLAG))))
		      (GLOBAL:ADVISE NORM-next.splitpart :around NORM 0
			(let ((NORM*TRACE_TOP.NORM=TRACE_PROTOCOL (if (boundp 'NORM*TRACE_TOP.NORM=TRACE_PROTOCOL)
								      nil
								      t)))
			  (declare (special NORM*TRACE_TOP.NORM=TRACE_PROTOCOL))
			  (NORM=TRACE_PROTOCOL "Normalizing next split part of the following formula:"
					       NORM*EXPRESSION ,=TERMINALFLAG)
			  :do-it
			  (when (and (boundp 'NORM*TRACE_TOP.NORM=TRACE_PROTOCOL)
				     NORM*TRACE_TOP.NORM=TRACE_PROTOCOL)
			    (NORM=TRACE_PROTOCOL "Remaining formula:" NORM*EXPRESSION ,=TERMINALFLAG)
			    (NORM=TRACE_PROTOCOL "RETURNED SPLIT PART:"  (first VALUEs) ,=TERMINALFLAG))))
		      (GLOBAL:ADVISE NORM-NEW.FORMULA :BEFORE NORM 0
			(NORM=TRACE_PROTOCOL "Entering the following new formula for normalization:"
					     (first arglist) ,=TERMINALFLAG))
		      ,@(mapcar #'(LAMBDA (=FUNCTION =STRING)
				    `(GLOBAL:ADVISE ,=FUNCTION :around norm 0 
				       (let ((,(intern (format nil "NORM*TRACE_TOP.~A" =function) (find-package "MKRP"))
					      (if (boundp ',(intern (format nil "NORM*TRACE_TOP.~A" =function)
								    (find-package "MKRP")))
						  nil
						  t)))
					 (declare (special ,(intern (format nil "NORM*TRACE_TOP.~A" =function)
								    (find-package "MKRP"))))
					 :do-it
					 (when (and (boundp ',(intern (format nil "NORM*TRACE_TOP.~A" =function)
								      (find-package "MKRP")))
						    NORM*TRACE_TOP.NORM=TRACE_PROTOCOL)
					   (NORM=TRACE_PROTOCOL ,=string (first VALUEs) ,=TERMINALFLAG)))))
				FUNCTIONS STRINGS)
		      ',message)))		; (NORM-TRACE T) (NORM-TRACE ON)
    (OFF `(progn ,@(mapcar #'(lambda (function) `(global:unadvise ,function))
			   '(NORM=REPLACE.IMPL NORM=REPLACE.EQV NORM=MOVE.NEGATIONS.TO.LITERALS
					       NORM=MOVE.QUANTIFIERS.INSIDE NORM=SKOLEMIZE NORM=MARK.SPLIT
					       NORM=PREPARE.SPLIT NORM=SPLIT
					       NORM=REMOVE.QUANTIFIERS NORM=TRANSFORM.TO.PSEUDO.CNF
					       NORM=FLATTEN.CLAUSELIST NORM-NORMALIZATION
					       NORM-NEW.FORMULA NORM-NEXT.SPLITPART))
		 '(NORM-TRACE SWITCHED OFF)))	; (NORM-TRACE OFF)
    (OTHERWISE '(INVALID ARGUMENT - TRY (NORM-TRACE ON) (NORM-TRACE T) OR (NORM-TRACE OFF)))))

(DEFUN NORM=TRACE_PROTOCOL (STRING EXPRESSION TERMINALFLG)
  ;; EFFECT: PRETTYPRINTS STRING AND EXPRESSION ON
  ;;         TERMINAL OR PROTOCOL FILE DEPENDING ON
  ;;         TERMINALFLG.
  ;; REMARK: USED BY ADVISE IN NORM-TRACE ONLY.
  (let ((FILE (COND (TERMINALFLG *terminal-io*) (T (OPT-GET.OPTION TR_TRACE.FILE)))))
    (PRINC STRING file)
    (TERPRI file)
    (pprint EXPRESSION file)))

