(defstruct iterm
  (typ nil :type symbol)
  ; Typen lit fnterm bins leftunaer leftunaerk rightunaer rightunaerk
  (predecessor nil :type (or nil iterm))
  (actual-length nil :type (or nil number))
  (local-length nil :type (or nil number)) 
  (end-length nil :type (or nil number)) 
  (next-step-length nil :type (or nil number))
  (format-nr 0 :type number)
  ;;(fn-parts nil :type list)
  ;(use-kl nil :type (or t nil))
  (splits nil :type list)
  (ops nil :type list) 
  (fn nil :type (or symbol string))
  (args nil :type list)
  (quant-lists nil :type list)
  (quantifier nil :type symbol)
)

(defun pr-int-term (iterm &optional (tab 0) (stream t))
  (case (iterm-typ iterm)
    (lit (pr-lit-term iterm tab stream))
    (fnterm (pr-fn-term iterm tab stream))
    (bins (pr-bins-term iterm tab stream))
    (leftunaer (pr-leftunaer-term iterm tab stream))
    (quant (pr-quant-term iterm tab stream))
    ; inserted 26.2.1992
    (kl (pr-kl-term iterm tab stream))
    ; inserted 10.3.1992 
    ;(leftunaerk (pr-leftunaerk-term iterm tab stream))
    (rightunaer (pr-rightunaer-term iterm tab stream))
    ;(rightunaerk (pr-rightunaerk-term iterm tab stream))
  )
) 

(defvar *latex-mode nil)
; inserted 9.4.92

(defvar *allowed-quantifiers-a-list (if *latex-mode '((all . 2) (some . 2)) '((all . 4) (some . 5))))
                                    ; changed 9.4.92 

(defun quantifier-length (quantifier)
  (let ((hv (cdr (assoc quantifier *allowed-quantifiers-a-list))))
    (if hv hv (error "parse-term>> unknown quantifier ~a" quantifier))
  ) 
)
; new 26.2.1992

(defun print-quantifier (quantifier tab stream)
  (case quantifier
    (all (tab-step tab stream) (princ "all " stream))
    (some (tab-step tab stream) (princ "some " stream))
    ; inserted 9.4.92
    (t (error "print-quantifier>> unknown quantifier ~a" quantifier))
  ) 
) 
; new 26.2.1992

(defun length-in () (if *latex-mode 1 2))
; new 26.2.1992     ; changed 9.4.92

(defun tab-step (tab &optional (stream t))
  (format stream (format nil "~~~a,0T" tab))
)

(defmacro princ-local-str ()
  ";;i"
  '(progn (tab-step tab stream) (princ (setq str (iterm-fn iterm)) stream))
) 

; Rueckgabe jeweils Ansatztab, Laenge lokal laengster Zeile  

(defun pr-lit-term (iterm &optional (tab 0) (stream t) &aux str (orig-tab tab))
  (princ-local-str) (incf tab (length str))
  (unless nil 
    (setf (iterm-actual-length iterm) tab) 
    (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab)) 
    (setf (iterm-end-length iterm) (- tab orig-tab))
  )
  (values tab tab)
)

(defun pr-quant-term (iterm &optional (tab 0) (stream t) &aux (maxtab tab) str (newtab tab) (orig-tab tab))
  (case (iterm-format-nr iterm)
    (0 (print-quantifier (iterm-quantifier iterm) tab stream) 
       (incf tab (quantifier-length (iterm-quantifier iterm)))
       (setq first-time1 t)
       (dolist (ai (iterm-quant-lists iterm))
         (unless first-time1 (princ " " stream) (incf tab)) 
         (setq first-time1 nil)
         (setq first-time t)
         (dolist (aj (cdr ai))
           (unless first-time
             (tab-step tab stream) (princ ", " stream) (incf tab 2) 
           )
           (setq first-time nil)
           (princ (symbol-name aj) stream)
           (incf tab (length (symbol-name aj)))
         )
         (princ " in " stream) (princ (symbol-name (car ai)) stream) 
         (incf tab (+ (length-in) 2 (length (symbol-name (car ai)))))
       )
       (princ ": " stream) 
       (incf tab 2)
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream)                         
         (unless nil 
           (setf (iterm-actual-length iterm) ltab)
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (- atab orig-tab))
         )
         (values atab ltab)
       )
    )
    (1 (print-quantifier (iterm-quantifier iterm) tab stream) 
       (incf tab (quantifier-length (iterm-quantifier iterm)))
       (setq first-time1 t)
       (dolist (ai (iterm-quant-lists iterm))
         (unless first-time1 (princ " " stream) (incf tab)) 
         (setq first-time1 nil)
         (setq first-time t)
         (dolist (aj (cdr ai))
           (unless first-time
             (tab-step tab stream) (princ ", " stream) (incf tab 2) 
           ) 
           (setq first-time nil)
           (princ (symbol-name aj) stream)
           (incf tab (length (symbol-name aj)))
         )
         (princ " in " stream) (princ (symbol-name (car ai)) stream) 
         (incf tab (+ (length-in) 2 (length (symbol-name (car ai)))))
       )
       (princ ":" stream) 
       (setq maxtab (1+ tab)) (terpri stream)
       (setq tab orig-tab) (tab-step tab stream)
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream)                         
         (unless nil 
           (setf (iterm-actual-length iterm) (max ltab maxtab))
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (- atab orig-tab))
         )
         (values atab (max ltab maxtab))
       )
    ) 
    (2 (print-quantifier (iterm-quantifier iterm) tab stream)
       (setq first-time1 t)
       (dolist (ai (iterm-quant-lists iterm))
         (unless first-time1 (terpri stream))
         (setq first-time1 nil)
         (setq tab (+ orig-tab (quantifier-length (iterm-quantifier iterm))))
         (tab-step tab stream)
         (setq first-time t)
         (dolist (aj (cdr ai))
           (unless first-time
             (tab-step tab stream) (princ ", " stream) (incf tab 2) 
           ) 
           (setq first-time nil)
           (princ (symbol-name aj) stream)
           (incf tab (length (symbol-name aj)))
         )
         (princ " in " stream) (princ (symbol-name (car ai)) stream) 
         (incf tab (+ (length-in) 2 (length (symbol-name (car ai)))))
         (setq maxtab (max tab maxtab))
       )
       (princ ":" stream) 
       (setq maxtab (max (1+ tab) maxtab)) (terpri stream)
       (setq tab orig-tab) (tab-step tab stream)
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream)                         
         (unless nil 
           (setf (iterm-actual-length iterm) (max ltab maxtab))
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (- atab orig-tab))
         )
         (values atab (max ltab maxtab))
       )
    )
    (3 (print-quantifier (iterm-quantifier iterm) tab stream)
       (setq first-time1 t)
       (dolist (ai (iterm-quant-lists iterm))
         (unless first-time1 (terpri stream))
         (setq first-time1 nil)
         (setq tab (+ orig-tab (quantifier-length (iterm-quantifier iterm))))
         (tab-step tab stream)
         (setq first-time t)
         (dolist (aj (cdr ai))
           (unless first-time
             (tab-step tab stream) (princ ", " stream) (incf tab 2)  
           )
           (setq first-time nil)
           (princ (symbol-name aj) stream)
           (incf tab (length (symbol-name aj)))
         )
         (setq maxtab (max maxtab tab)) (terpri stream)
         (setq tab (+ orig-tab (quantifier-length (iterm-quantifier iterm))))
         (tab-step tab stream)
         (princ "in " stream) (princ (symbol-name (car ai)) stream) 
         (incf tab (+ (length-in) 1 (length (symbol-name (car ai)))))
         (setq maxtab (max tab maxtab))
       )
       (princ ":" stream) 
       (setq maxtab (max (1+ tab) maxtab)) (terpri stream)
       (setq tab orig-tab) (tab-step tab stream)
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream)                         
         (unless nil 
           (setf (iterm-actual-length iterm) (max ltab maxtab))
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (- atab orig-tab))
         )
         (values atab (max ltab maxtab))
       )
    )
    (4 (print-quantifier (iterm-quantifier iterm) tab stream) (terpri stream)
       (setq maxtab (+ orig-tab (quantifier-length (iterm-quantifier iterm))))
       (setq tab orig-tab) (tab-step tab stream)
       (dolist (ai (iterm-quant-lists iterm))
         (setq first-time t)
         (dolist (aj (cdr ai))
           (unless first-time
             (princ "," stream) (incf tab) (terpri stream)
             (setq maxtab (max maxtab tab))
             (setq tab orig-tab) (tab-step tab stream)
           )
           (setq first-time nil)
           (princ (symbol-name aj) stream)
           (incf tab (length (symbol-name aj)))
         )
         (setq maxtab (max maxtab tab)) (terpri stream)
         (setq tab orig-tab) (tab-step tab stream)
         (princ "in " stream)
         (setq maxtab (max (+ 2 tab) maxtab)) (terpri stream)
         (setq tab orig-tab) (tab-step tab stream)
         (princ (symbol-name (car ai)) stream) 
         (incf tab (length (symbol-name (car ai))))
         (terpri stream) (setq maxtab (max tab maxtab))
         (setq tab orig-tab) (tab-step tab stream)
       )
       (princ ":" stream) 
       (setq maxtab (max (+ 1 tab) maxtab)) 
       (setq tab orig-tab) (terpri stream) (tab-step tab stream)
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream)                         
         (unless nil 
           (setf (iterm-actual-length iterm) (max ltab maxtab))
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (- atab orig-tab))
         )
         (values atab (max ltab maxtab))
       )
    )
  ) 
)
; new 26.2.1992

(defun pr-leftunaer-term (iterm &optional (tab 0) (stream t)
                                &aux first-time first-time1 (maxtab tab) str (newtab tab) (orig-tab tab))
  (case (iterm-format-nr iterm)      ; inserted 9.4.92
    (0 (princ-local-str) (incf tab (length str)) 
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream)                         
         (unless nil (setf (iterm-actual-length iterm) ltab)
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (- atab orig-tab))
         )
         (values atab ltab)
       )
    )
    (1 (princ-local-str) (incf maxtab (length str)) (terpri stream) 
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream) 
         (unless nil (setf (iterm-actual-length iterm) (max ltab maxtab))
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (- atab orig-tab))
         )
         (values atab (max ltab maxtab))
       )
    )
  ) 
)

(defun pr-kl-term (iterm &optional (tab 0) (stream t) &aux (maxtab tab) str (newtab tab) (orig-tab tab))
  (case (iterm-format-nr iterm)
    (0 (tab-step tab stream) (princ "(" stream) (incf tab)
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream)                         
         (unless nil 
           (setf (iterm-actual-length iterm) (max (1+ atab) ltab))
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (1+ (- atab orig-tab)))
         )
         (princ ")" stream)
         (values (1+ atab) (max (1+ atab) ltab))
       )
    )
    (1 (tab-step tab stream) (princ "(" stream) (incf tab) 
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream) 
         (unless nil 
           (setf (iterm-actual-length iterm) (1+ ltab))
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) 1)
         )
         (terpri stream) (decf tab) (tab-step tab stream) (princ ")" stream)
         (values 1 (1+ ltab))
       )
    )
    (2 (tab-step tab stream) (princ "(" stream) (terpri stream) 
       (multiple-value-bind (atab ltab)
         (pr-int-term (car (iterm-args iterm)) tab stream) 
         (unless nil 
           (setf (iterm-actual-length iterm) (max 1 ltab))
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) 1)
         )
         (terpri stream) (decf tab) (tab-step tab stream) (princ ")" stream)
         (values 1 (max 1 ltab))
       )
    )
  ) 
)
; new 10.3.1992

(defun pr-rightunaer-term (iterm &optional (tab 0) (stream t) &aux (maxtab tab) str dummy (orig-tab tab))
  (case (iterm-format-nr iterm)
    (0 (multiple-value-setq (tab maxtab) (pr-int-term (car (iterm-args iterm)) tab stream)))
    (1 (multiple-value-setq (dummy maxtab) (pr-int-term (car (iterm-args iterm)) tab stream))
       (terpri stream) (tab-step tab stream) 
    )
  ) 
  (setq str (iterm-fn iterm))
  (princ str stream) (incf tab (length str))
  (unless nil (setf (iterm-actual-length iterm) (max tab maxtab))
    (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
    (setf (iterm-end-length iterm) (- tab orig-tab))
  )
  (values tab (max maxtab tab))
)

(defun pr-fn-term (iterm &optional (tab 0) (stream t) &aux (maxtab tab) str dummy mtab (orig-tab tab))
  (case (iterm-format-nr iterm)
    (0  (princ-local-str) (princ "(" stream) (incf tab (1+ (length str))) (setq maxtab tab) 
        (when (iterm-args iterm) 
          (multiple-value-setq (tab maxtab) 
            (pr-int-term (car (iterm-args iterm)) tab stream)
          )
          (dolist (ai (cdr (iterm-args iterm)))
             (princ "," stream) (incf tab) 
             (multiple-value-bind (atab ltab)
               (pr-int-term ai tab stream)
               (setq tab atab maxtab (max maxtab ltab))
             )
          )
        )
        (princ ")" stream) (incf tab)
        (unless nil (setf (iterm-actual-length iterm) (max tab maxtab))
          (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab)) 
          (setf (iterm-end-length iterm) (- tab orig-tab))
        )
        (values tab (max tab maxtab))
    )
    (1  (princ-local-str) (princ "(" stream) (incf tab (1+ (length str))) (setq maxtab tab) 
        (when (iterm-args iterm) 
          (multiple-value-setq (dummy maxtab) 
            (pr-int-term (car (iterm-args iterm)) tab stream)
          ) 
          (dolist (ai (cdr (iterm-args iterm)))
             (princ "," stream) (setq maxtab (max (1+ dummy) maxtab))
             (terpri stream)
             (multiple-value-setq (dummy mtab) 
               (pr-int-term ai tab stream)
             )
             (setq maxtab (max mtab maxtab))
           )
        )
        (terpri stream) (tab-step (1- tab)) (princ ")" stream)
        (unless nil (setf (iterm-actual-length iterm) maxtab)
          (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
          (setf (iterm-end-length iterm) (- tab orig-tab))
        )
        (values tab maxtab)
    )
    (2  (princ-local-str) (setq maxtab (+ tab (length str))) (incf tab)
        (terpri stream) (tab-step tab) (princ "(" stream) (incf tab) 
        (when (iterm-args iterm) 
          (multiple-value-setq (dummy mtab) 
            (pr-int-term (car (iterm-args iterm)) tab stream) 
          )
          (setq maxtab (max mtab maxtab))
          (dolist (ai (cdr (iterm-args iterm)))
             (princ "," stream) (setq maxtab (max (1+ dummy) maxtab))
             (terpri stream)
             (multiple-value-setq (dummy mtab) 
               (pr-int-term ai tab stream)
             )
             (setq maxtab (max mtab maxtab))
           )
        )
        (terpri stream) (tab-step (1- tab)) (princ ")" stream)
        (unless nil (setf (iterm-actual-length iterm) maxtab)
          (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
          (setf (iterm-end-length iterm) (- tab orig-tab))
        )
        (values tab maxtab)
    )
    (3  (princ-local-str) (princ "(" stream) (setq maxtab (+ 1 tab (length str)))
        (terpri stream) 
        (when (iterm-args iterm) 
          (multiple-value-setq (dummy mtab) 
            (pr-int-term (car (iterm-args iterm)) tab stream)
          )
          (setq maxtab (max mtab maxtab))
          (dolist (ai (cdr (iterm-args iterm)))
             (princ "," stream) (setq maxtab (max (1+ dummy) maxtab))
             (terpri stream)
             (multiple-value-setq (dummy mtab) 
               (pr-int-term ai tab stream)
             )
             (setq maxtab (max mtab maxtab))
           )
        )
        (terpri stream) (tab-step tab) (princ ")" stream) (incf tab)
                                                   ;
        (unless nil (setf (iterm-actual-length iterm) maxtab)
          (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
          (setf (iterm-end-length iterm) (- tab orig-tab))
        )
        (values tab maxtab)
    )
  )
)

(defun op-length (op)
  (+ 2 (length op))
)  

(defun pr-bins-term (iterm &optional (tab 0) (stream t) &aux (maxtab tab) str dummy mtab (orig-tab tab))
  (case (iterm-format-nr iterm)
    (0 (when (iterm-args iterm) 
        (let ((args (iterm-args iterm))
              (ops  (iterm-ops iterm))
             ) 
         (loop
          (multiple-value-setq (tab maxtab) 
            (pr-int-term (pop args) tab stream)
          )
          (unless args (return))
          (format stream " ~a " (car ops)) 
          (incf tab (op-length (pop ops)))
          (setq maxtab (max maxtab tab))
         )
        )
       )
       (unless nil (setf (iterm-actual-length iterm) maxtab)
         (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
         (setf (iterm-end-length iterm) (- tab orig-tab))
       )
       (values tab maxtab)
    )
    (1 (let ((ltab tab) (mtab tab) (splits (iterm-splits iterm))
             (args (iterm-args iterm)) (ops (iterm-ops iterm))
            )
         (when splits (incf ltab (apply #'max (mapcar #'(lambda (ai) (op-length (car ai))) splits))))
         (when args 
          (loop
           (multiple-value-setq (ltab mtab) 
             (pr-int-term (pop args) ltab stream)
           )
           (setq maxtab (max mtab maxtab)) 
           (unless args (return))
           (when (eq (car splits) ops)
             (pop splits) (setq ltab tab)
             (terpri stream) (tab-step ltab stream)
           )                 ; inserted 26.2.1992
           (format stream " ~a " (car ops)) 
           (incf ltab (op-length (pop ops)))
          )
         )  
         (unless nil (setf (iterm-actual-length iterm) maxtab)
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (- ltab orig-tab))
         )
         (values ltab maxtab)
       )
    )
    (2 (let ((ltab tab) (mtab tab) dummy
             (args (iterm-args iterm)) (ops (iterm-ops iterm))
            )
         (when args 
          (loop
           (multiple-value-setq (dummy mtab) 
             (pr-int-term (pop args) tab stream)
           )
           (setq maxtab (max mtab maxtab)) 
           (unless args (return))
           (terpri stream) (tab-step ltab stream)
                           ; inserted 26.2.1992
           (format stream " ~a " (car ops)) 
           (setq dummy (+ tab (op-length (pop ops))))
           (setq maxtab (max dummy maxtab))
           (terpri stream)
          )
         ) 
         (unless nil (setf (iterm-actual-length iterm) maxtab)
           (setf (iterm-local-length iterm) (- (iterm-actual-length iterm) orig-tab))
           (setf (iterm-end-length iterm) (- dummy orig-tab))
         )
         (values dummy maxtab)
       )
    )
  )
)


