(defun silent-optimize-iterm (iterm aim-length &aux zielterm)
  (loop 
    (pr-int-term iterm 0 nil)
    (when (<= (iterm-local-length iterm) aim-length) (return iterm))
    (setq zielterm (get-zielterm (find-longest-term-path iterm))) 
    (when (int-term-at-max? zielterm) 
      (warn "Could'nt reach aim") (return iterm)
    )
    (step-int-term zielterm)
  ) 
)

(defun silent-optimize-iterm (iterm aim-length &aux zielterm)
  (loop 
    (pr-int-term iterm) (terpri) (terpri)
    (when (<= (iterm-local-length iterm) aim-length) (return iterm))
    (setq zielterm (get-zielterm (find-longest-term-path iterm))) 
    (terpri)
    (when (int-term-at-max? zielterm) 
      (warn "Could'nt reach aim") (return iterm)
    )
    (step-int-term zielterm)
  ) 
)  
; vorlaeufig  

(defun top-latex-out-int-term (iterm &optional (tab 0) (stream t))
  (princ "\\begin{tabbing}" stream) (terpri stream)
  (latex-out-int-term iterm tab stream)
  (terpri stream) (princ "\\end{tabbing}" stream) (terpri stream)
)
; corrected 23.5.92

(defun latex-out-int-term (iterm &optional (tab 0) (stream t))
  (case (iterm-typ iterm)
    (lit (latex-out-lit-term iterm tab stream))
    (fnterm (latex-out-fn-term iterm tab stream))
    (bins (latex-out-bins-term iterm tab stream))
    (leftunaer (latex-out-leftunaer-term iterm tab stream))
    (quant (latex-out-quant-term iterm tab stream))
    ; inserted 26.2.1992
    (kl (latex-out-kl-term iterm tab stream))
    ; inserted 10.3.1992 
    ;(leftunaerk (latex-out-leftunaerk-term iterm tab stream))
    (rightunaer (latex-out-rightunaer-term iterm tab stream))
    ;(rightunaerk (latex-out-rightunaerk-term iterm tab stream))
  )
)

(defun latex-tab-step (tab stream)
  (dotimes (ai (length stream)) (princ "\\>" stream)) 
)                                          ; changed 9.4.92

;(defmacro latex-out-local-str ()
;  ";;i"
;  '(princ (iterm-fn iterm) stream)
;)

(defmacro latex-out-fn-str ()
  ";;i"
  '(princ (iterm-fn iterm) stream)
)
; new 23.5.1992

(defmacro latex-out-local-str ()
  ";;i"
  '(format stream "$~a$" (iterm-fn iterm))
)
; vorlaeufig geaendert 23.5.1992

(defun latex-terpri (tab stream)
  (princ "\\\\" stream) (terpri stream)
  (dotimes (ai tab) (princ "\\> " stream)) 
)

(defmacro push-latex-tabstep ()
  ";;i"
  '(progn (princ "\\=" stream) (incf tab))
)

(defmacro pop-latex-tabstep ()
  ";;i"
  '(decf tab)
)

(defun latex-out-quantifier
  (quantifier tab stream)
  (case quantifier
    (all (princ "$\\forall\\,$" stream))
    (some (princ "$\\exists\\,$" stream))
    (t (error "print-quantifier>> unknown quantifier ~a" quantifier))
  ) 
)
; new 9.4.92 

(defun latex-out-lit-term (iterm &optional (tab 0) (stream t))
  (latex-out-local-str)
)

(defun latex-out-leftunaer-term (iterm &optional (tab 0) (stream t))
  (latex-out-operator (iterm-fn iterm) stream t)
  ; changed 9.4.92 war (latex-out-local-str)
  (case (iterm-format-nr iterm)
    (0 (push-latex-tabstep) 
       (latex-out-int-term (car (iterm-args iterm)) tab stream)
    )
    (1 (latex-terpri tab stream)
       (latex-out-int-term (car (iterm-args iterm)) tab stream)
    ) 
  ) 
)
; new version 9.4.1992
; corrected 23.5.1992

(defun latex-out-rightunaer-term (iterm &optional (tab 0) (stream t))
  (latex-out-int-term (car (iterm-args iterm)) tab stream)
  (when (= (iterm-format-nr iterm) 1) (latex-terpri tab stream))
  (latex-out-operator (iterm-fn iterm) stream t)
  ; changed 9.4.92 war (latex-out-local-str)
)

(defun latex-out-kl-term (iterm &optional (tab 0) (stream t))
  (princ "(" stream)
  (case (iterm-format-nr iterm)
    (0 (push-latex-tabstep) 
       (latex-out-int-term (car (iterm-args iterm)) tab stream)
       (pop-latex-tabstep)                                              
    )
    (1 (push-latex-tabstep)
       (latex-out-int-term (car (iterm-args iterm)) tab stream)
       (pop-latex-tabstep)                                              
       (latex-terpri tab stream)
    )
    (2 (latex-terpri tab stream)
       (latex-out-int-term (car (iterm-args iterm)) tab stream)
       (latex-terpri tab stream)
    )
  )
  (princ ")" stream)
)

(defun latex-out-fn-term (iterm &optional (tab 0) (stream t))
  (latex-out-fn-str)
   ; changed 23.5.1992 war latex-out-local-str
  (case (iterm-format-nr iterm)
    (0  (princ "(" stream)
        (when (iterm-args iterm)
         (push-latex-tabstep)
         ; inserted for correction 23.5.1992
         (latex-out-int-term (car (iterm-args iterm)) tab stream) 
         (dolist (ai (cdr (iterm-args iterm)))
           (princ "," stream) 
           (latex-out-int-term ai tab stream)
         )
         (pop-latex-tabstep)
         ; inserted for correction 23.5.1992
        )
    )
    (1  (princ "(" stream) 
        (when (iterm-args iterm)
          (push-latex-tabstep)
          (latex-out-int-term (car (iterm-args iterm)) tab stream)
          (dolist (ai (cdr (iterm-args iterm)))
            (princ "," stream) 
            (latex-terpri tab stream)
            (latex-out-int-term ai tab stream)
          )
          (pop-latex-tabstep)
        )
        (latex-terpri tab stream)                                             
    )
    (2  (latex-terpri tab stream)
        (princ "\\ (" stream)
        (when (iterm-args iterm) 
          (push-latex-tabstep)
          (latex-out-int-term (car (iterm-args iterm)) tab stream)
          (dolist (ai (cdr (iterm-args iterm)))
            (princ "," stream)
            (latex-terpri tab stream)
            (latex-out-int-term ai tab stream)
          ) 
          (pop-latex-tabstep)
        )
        (latex-terpri tab stream)                                             
        (princ "\\ " stream)
    )
    (3  (latex-terpri tab stream)
        (princ "(" stream)
        (latex-terpri tab stream)
        (when (iterm-args iterm)
          (latex-out-int-term (car (iterm-args iterm)) tab stream) 
          (dolist (ai (cdr (iterm-args iterm)))
            (princ "," stream) 
            (latex-terpri tab stream) 
            (latex-out-int-term ai tab stream)
          )
          (latex-terpri tab stream)
        )
    )
  )
  (princ ")" stream)
) 

(defvar *allowed-operators-a-list
  '((+ . "+")(- . "-")(* . "\\cdot")(\ . "\\div")(or . "\\vee")(and . "\\wedge")
    (< . "<")(> . ">")(<= . "\\leq")(>= . "\\geq")(= . "=")(xor . "\\oplus")
    (equiv . "\\equiv")(impl . "\\Rightarrow")(! . "!")(not . "\\neg")(in . "\\in")
   )
)
; new 9.4.92

(defun latex-out-operator (op &optional (stream t) (unaer nil))
  (let ((hv (cdr (assoc (if (stringp op) (intern op) op) *allowed-operators-a-list))))
    (unless hv
      (warn "latex-out-operator>> unknown operator ~a~%" op)
      (setq hv (if (stringp op) op (symbol-name op)))
    ) 
    (princ "$" stream) 
    (unless unaer (princ "\\," stream)) 
    (princ hv stream) 
    (unless unaer (princ "\\," stream))
    (princ "$" stream) 
  ) 
)
; new 9.4.92

(defun latex-out-bins-term (iterm &optional (tab 0) (stream t) &aux (maxtab tab) str dummy mtab (orig-tab tab))
  (case (iterm-format-nr iterm)
    (0 (when (iterm-args iterm) 
        (let ((args (iterm-args iterm)) (ops  (iterm-ops iterm))) 
         (loop 
          (latex-out-int-term (pop args) tab stream)
          (unless args (return))
          (latex-out-operator (car ops) stream)
         )
        )
       )
    )
    (1 (error "not available yet")
       (let ((ltab tab) (mtab tab) (splits (iterm-splits iterm))
             (args (iterm-args iterm)) (ops (iterm-ops iterm))
            )
         (when args 
          (loop
           (latex-out-int-term (pop args) tab stream)
           (unless args (return))
           (when (eq (car splits) ops)
             (pop splits) (setq ltab tab)
             (terpri stream) (tab-step ltab stream)
           )                 ; inserted 26.2.1992
           (format stream " ~a " (car ops)) 
           (incf ltab (op-length (pop ops)))
          )
         )  
       )
    )
    (2 (let ((ltab tab) (mtab tab) dummy
             (args (iterm-args iterm)) (ops (iterm-ops iterm))
            )
         (when args 
          (loop
           (latex-out-int-term (pop args) tab stream)
           (unless args (return))
           (latex-terpri tab stream)
           (latex-out-operator (car ops) stream)
           (latex-terpri tab stream)
          )
         ) 
       )
    )
  )
)
; new 9.4.92

;(defmacro latex-out-quantifier-var (var)
;  ";;i"
;  `(format stream "$~a$" (symbol-name ,var))
;)
; new 23.5.1992
; wird aktuell nicht benutzt

(defun latex-out-quant-term (iterm &optional (tab 0) (stream t) &aux first-time1)
  (case (iterm-format-nr iterm)
    (0 (latex-out-quantifier (iterm-quantifier iterm) tab stream) 
       (setq first-time1 t)
       (dolist (ai (iterm-quant-lists iterm))
         (unless first-time1 (princ "\\ " stream))
         (setq first-time1 nil)
         (princ "$" stream)
         ; uncommented 23.5.92
         (princ (symbol-name (cadr ai)) stream)
         (dolist (aj (cddr ai))
           (princ "," stream) (princ (symbol-name aj) stream)
         )
         (princ "$" stream)
         ; uncommented 23.5.92
         (princ "$\\,\\in\\,$" stream) (princ (symbol-name (car ai)) stream) 
       )
       (princ ": " stream) 
       (latex-out-int-term (car (iterm-args iterm)) tab stream)                         
    )
    (1 (latex-out-quantifier (iterm-quantifier iterm) tab stream) 
       (setq first-time1 t)
       (dolist (ai (iterm-quant-lists iterm))
         (unless first-time1 (princ "\\ " stream))
         (setq first-time1 nil)
         (princ "$" stream)
         ; uncommented 23.5.92
         (princ (symbol-name (cadr ai)) stream)
         (dolist (aj (cddr ai))
           (princ "," stream) (princ (symbol-name aj) stream)
         )
         (princ "$" stream)
         ; uncommented 23.5.92
         (princ "$\\,\\in\\,$" stream) (princ (symbol-name (car ai)) stream) 
       )
       (princ ": " stream) (latex-terpri tab stream)
       (latex-out-int-term (car (iterm-args iterm)) tab stream)                         
    )
    (2 (latex-out-quantifier (iterm-quantifier iterm) tab stream)
       (push-latex-tabstep)
       (setq first-time1 t)
       (dolist (ai (iterm-quant-lists iterm))
         (unless first-time1 (latex-terpri tab stream))
         (setq first-time1 nil)
         (princ "$" stream)
         ; uncommented 23.5.92
         (princ (symbol-name (cadr ai)) stream)
         (dolist (aj (cddr ai))
           (princ "," stream) (princ (symbol-name aj) stream)
         )
         (princ "$" stream)
         ; uncommented 23.5.92
         (princ "$\\,\\in\\,$" stream) (princ (symbol-name (car ai)) stream) 
       )
       (princ ": " stream) (pop-latex-tabstep)
       (latex-terpri tab stream)
       (latex-out-int-term (car (iterm-args iterm)) tab stream)                         
    )
    (3 (latex-out-quantifier (iterm-quantifier iterm) tab stream)
       (push-latex-tabstep)
       (setq first-time1 t)
       (dolist (ai (iterm-quant-lists iterm))
         (unless first-time1 (latex-terpri tab stream))
         (setq first-time1 nil)
         (princ "$" stream)
         ; uncommented 23.5.92
         (princ (symbol-name (cadr ai)) stream)
         (dolist (aj (cddr ai))
           (princ "," stream) (princ (symbol-name aj) stream)
         )
         (princ "$" stream)
         ; uncommented 23.5.92
         (latex-terpri tab stream)
         (princ "$\\,\\in\\,$" stream) (princ (symbol-name (car ai)) stream) 
       )
       (princ ": " stream) (pop-latex-tabstep)
       (latex-terpri tab stream)
       (latex-out-int-term (car (iterm-args iterm)) tab stream)                         
    )
    (4 (latex-out-quantifier (iterm-quantifier iterm) tab stream)
       (latex-terpri tab stream)
       (setq first-time1 t)
       (dolist (ai (iterm-quant-lists iterm))
         (unless first-time1 (latex-terpri tab stream))
         (setq first-time1 nil)
         (princ "$" stream)
         ; uncommented 23.5.92
         (princ (symbol-name (cadr ai)) stream)
         (dolist (aj (cddr ai))
           (princ "," stream) (latex-terpri tab stream) (princ (symbol-name aj) stream)
         )
         (princ "$" stream)
         ; uncommented 23.5.92
         (latex-terpri tab stream)
         (princ "$\\,\\in\\,$" stream) (latex-terpri tab stream) (princ (symbol-name (car ai)) stream) 
       )
       (latex-terpri tab stream)
       (princ ": " stream)
       (latex-terpri tab stream)
       (latex-out-int-term (car (iterm-args iterm)) tab stream)                         
    )
  )
)
; new 9.4.92

(setq *latex-mode t)
; new 9.4.92

(setq *allowed-quantifiers-a-list '((all . 2) (some . 2)))
; new 9.4.92    
