;;; -*- Package: MKRP; Syntax: Common-lisp; Mode: LISP -*-

#| Copyright (C) 1991 AG Siekmann, 
                      Fachbereich Informatik, Universitaet des Saarlandes, 
                      Saarbruecken, Germany

This file is part of Markgraf Karl Refutation Procedure (MKRP).

MKRP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  

Everyone is granted permission to copy, modify and redistribute
MKRP, but only if the it is not used for military purposes or any
military research. It is also forbidden to use MKRP in nuclear plants
or nuclear research, and for verifying programs in military 
and nuclear research.  A copy of this license is
supposed to have been given to you along with MKRP so you
can know your rights and responsibilities.  
Among other things, the copyright notice
must be preserved on all copies.  |#

(IN-PACKAGE "MARKGRAF-KARL" :use '("CL") :nicknames '("MKRP"))

(DEFparameter COM*KEYWORDS.PLL
	'(ALL EX EQV |:EQV| |EQV:| |:EQV:| IMPL |:IMPL| |IMPL:| |:IMPL:| OR |:OR| |OR:| |:OR:| AND |:AND| |AND:| |:AND:| NOT
	      TYPE SORT |:| |,| ASSOCIATIVE ac ac1 ag commutative SYMMETRIC REFLEXIVE IRREFLEXIVE = |:=| |=:| |:=:| 
	      ANY NIL QUOTE))

(defparameter com*keywords.colon '(eqv impl or and =))

(DEFPARAMETER COM*KEYWORDS.IND '(MATCH |:MATCH| |MATCH:| |:MATCH:| STRUCTURE FUNCTION PREDICATE IF THEN))

(defparameter COM*LETTERS '(A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ ]))

(DEFPARAMETER COM*DIGITS '(\1 \2 \3 \4 \5 \6 \7 \8 \9 \0))

(DEFPARAMETER COM*SPECIAL.SIGNS '(! |#| $ & * = - \@ + |;| ? // |.|))

(DEFparameter COM*EXPRESSION.PREFIX.PLL '(ALL EX NOT TYPE SORT ASSOCIATIVE ac ac1 commutative ag
					      SYMMETRIC REFLEXIVE IRREFLEXIVE * |(|))

(DEFPARAMETER COM*EXPRESSION.PREFIX.IND '(STRUCTURE FUNCTION PREDICATE IF |(|))

(DEFPARAMETER COM*CHANGED.SYMBOLS NIL)

(DEFPARAMETER COM*USED.SYMBOLS NIL)

; (DEFPARAMETER COM*ERROR.STOP NIL) Not used

(DEFPARAMETER COM*EQUIVALENCES NIL)

(DEFPARAMETER COM*IMPLICATIONS NIL)

(DEFPARAMETER COM*ERROR NIL)

(DEFPARAMETER COM*VSTACK NIL)


(DEFUN COM-RESET NIL
						; EDITED: 10-FEB-82 14:56:50
						; INPUT:  INDUCTION.FLAG   -  T//NIL
						; EFFECT: INITIALIZES COM*SYMBOLTABLE AND ALL OTHER STATE VARIABLES
						;        IF INDUCTION.FLAG IS T THE COMPILER  IS USED IN THE INDUCTION-MODE.
						; VALUE:  UNDEFINED
  (PROG (SYMBOL.LIST)
	(declare (special symbol.list))
	(setq com*error nil)
	(COM=3=ENTER.SORT 'ANY NIL)
	(MAPC #'(LAMBDA (X)
		  (COM=3=ENTER.SYMBOL X 'PREDICATE 0 NIL NIL (CONS 'DEFINED nil)))
	      '(TRUE FALSE))
	(COM=3=ENTER.SYMBOL '= 'PREDICATE 2 NIL NIL (LIST 'DEFINED 'SYMMETRIC 'REFLEXIVE) (CONS 'EQUALITY nil))
	(when (opt-get.option sort_literals)
	  (COM=3=ENTER.SYMBOL 'omega 'constant 0 nil NIL (CONS 'DEFINED nil))
	  (COM=3=ENTER.SYMBOL 'e 'PREDICATE 2 '(any any) NIL (CONS 'DEFINED nil)))
	(SETQ COM*CHANGED.SYMBOLS NIL)
	(SETQ COM*USED.SYMBOLS NIL) (SETQ COM*ERROR NIL)))
#|(DEFUN COM-RESET NIL
						; EDITED: 10-FEB-82 14:56:50
						; INPUT:  INDUCTION.FLAG   -  T//NIL
						; EFFECT: INITIALIZES COM*SYMBOLTABLE AND ALL OTHER STATE VARIABLES
						;        IF INDUCTION.FLAG IS T THE COMPILER  IS USED IN THE INDUCTION-MODE.
						; VALUE:  UNDEFINED
  (PROG (SYMBOL.LIST)
	(declare (special symbol.list))
	(setq com*error nil)
	(COM=3=ENTER.SORT 'ANY NIL)
	(MAPC #'(LAMBDA (X)
		  (COM=3=ENTER.SYMBOL X 'PREDICATE 0 NIL NIL (CONS 'DEFINED nil)))
	      '(TRUE FALSE))
	(COM=3=ENTER.SYMBOL '= 'PREDICATE 2 NIL NIL (LIST 'DEFINED 'SYMMETRIC 'REFLEXIVE) (CONS 'EQUALITY nil))
	(SETQ COM*CHANGED.SYMBOLS NIL)
	(SETQ COM*USED.SYMBOLS NIL) (SETQ COM*ERROR NIL)))|#

(DEFUN COM-KEYWORD (SYMBOL)
						; EDITED: "17-MAY-81 16:35:36
						; INPUT:  SYMBOL - A SYMBOL OF A SENTENCE
						; EFFECT: NONE.
						; VALUE:  SEXPRESSION <> NIL, IF SYMBOL IS A
						;        KEYWORD OF TFOL - LANGUAGE ELSE NIL.
  (OR (MEMBER SYMBOL COM*KEYWORDS.PLL)))

(DEFUN COM-CHANGED.SYMBOLS NIL
						;EDITED: 10-MAR-81 18:50:32
						;input:  NONE
						;EFFECT: RETURNS VALUE
						;VALUE:  A LIST OF SYMBOLNAMES , WHICH DENOTE
						;        SYMBOLS , WHICH ARE NEW ENTERED IN THE SYMBOLTABLE OR WHOSE CLASSIFI -
						;        CATION IN THE SYMBOLTABLE WHERE UPDATED DURING THE LAST CALL OF
						;        COM-COMPILE , COM-ENTER.SYMBOL OR COM-REMOVE.SYMBOL
  COM*CHANGED.SYMBOLS)

(DEFUN COM-USED.SYMBOLS NIL
						;EDITED: 10-MAR-81 18:53:00
						;input:  NONE
						;EFFECT: RETURNS VALUE
						;VALUE:  A LIST OF SYMBOLNAMES , WHICH DENOTE
						;        SYMBOLS , WHICH WHERE USED DURING THE LAST CALL OF COM-COMPILE ,
						;        COM-ENTER.SYMBOL OR COM-REMOVE.SYMBOL
  COM*USED.SYMBOLS)

(DEFUN COM-EXPRESSION.PREFIX (SEXPR)
						;EDITED:  6-OCT-81 18:01:07
						;input:  A SEXPRESSION
						;EFFECT: RETURNS VALUE
						;VALUE:  T IF 'SEXPR' IS A POTENTIAL PREFIX OF
						;        A EXPRESSION ACCEPTED BY THE COMPILER, ELSE NIL
  (COND
    ((OR (MEMBER SEXPR COM*EXPRESSION.PREFIX.PLL))
     T)
    ((CONSP SEXPR) T)))

(defun com=colonize (sentence)
  (cond ((consp sentence)
	 (cond ((eq (first sentence) '\:)
		(cond ((consp (rest sentence))
		       (cond ((member (second sentence) com*keywords.colon)
			      (cond ((and (consp (rest (rest sentence)))
					  (eq (third sentence) '\:))
				     (cons (intern (format nil ":~A:" (second sentence))
						   (find-package "MKRP"))
					   (rest (rest (rest sentence)))))
				    (t (cons (intern (format nil ":~A" (second sentence))
						     (find-package "MKRP"))
					     (rest (rest sentence))))))
			     (t (cons `\: (com=colonize (rest sentence))))))
		      (t (cons '\: (rest sentence)))))
	       ((member (first sentence) com*keywords.colon)
		(cond ((and (consp (rest sentence))
			    (eq (second sentence) '\:))
		       (cons (intern (format nil "~A:" (first sentence))
				     (find-package "MKRP"))
			     (rest (rest sentence))))
		      (t (cons (first sentence)
			       (com=colonize (rest sentence))))))
	       (t (cons (com=colonize (first sentence))
			(com=colonize (rest sentence))))))
	(t sentence)))

(DEFUN COM-COMPILE (SENTENCE)
						;EDITED: "30-SEP-81 14:05:36
						;INPUT:  SENTENCE - A SEXPRESSION
						;EFFECT: TESTS WHETHER 'SENTENCE' IS A WORD MEMBER OF THE TFOL-LANGUAGE . IF SO,
						;        UPDATES THE SYMBOLTABLE DUE TO THE INPUT
						;VALUE:  NIL , IF 'SENTENCE' IS NOT MEMBER OF THE
						;        TFOL - LANGUAGE , ELSE
						;        IF SENTENCE IS GENERATED BY:
						;        COMMENT
						;          <COMMENT>    -> ...
						;        TYPEDECLARATION
						;          <TYPE DECLARATION> -> ...
						;          <SUBSORT DECLARATION> -> ...
						;        PROPERTYDECLARATION
						;          <PROPERTY DECLARATION> -> ...
						;        ELSE (I.E. 'SENTENCE' IS GENERATED BY
						;          <QUANTIFICATION>       -> ...
						;        AND IF THE COMPILER IS CALLED BY THE
						;        INDUCTION-PROVER:
						;          <STRUCTURE DECLARATION> ->
						;          <FUNCTION DEFINITION>   ->
						;          <PREDICATE DEFINITION>  ->
						;        THE CODE GENERATED BY THIS
						;        PRODUCTION , I.E. A FORMULA OBTAINED FROM 'SENTENCE' ,
						;        WHERE QUANTIFICATIONS,
						;        CONNECTIVES, NEGATIONS, PREDICATES, RELATIONS,
						;        TERMS AND VARIABLE DECLARA-
						;        TIONS ARE WRITTEN IN LIST NOTATION AND
						;        VARIABLES ARE CONSISTENTLY RENAMED.
						;        IF SENTENCE IS A STRUCTURE ANNOUNCMENT THE VALUE IS THE LITATOM
						;        STRUCTURE.ANNOUNCEMENT
  (setq sentence (com=colonize sentence))
  (COND ((atom SENTENCE) NIL)
	((EQL '* (CAR SENTENCE)) (CONS 'COMMENT 'COMMENT))
	(T (let (SYMBOL SYMBOL.LIST RESULT #| (VARIABLE.COUNTER 0)|#)
	     (declare (SPECIAL SYMBOL SYMBOL.LIST))
	     (SETQ COM*VSTACK NIL
		   COM*EQUIVALENCES 0
		   COM*IMPLICATIONS 0
		   COM*ERROR NIL
		   COM*USED.SYMBOLS NIL
		   COM*CHANGED.SYMBOLS NIL
		   SYMBOL.LIST (COM=1=SYMBOL.ANALYSYS SENTENCE)
		   SYMBOL (CAR SYMBOL.LIST))
	     (unless COM*ERROR (SETQ RESULT (COM=2=STATEMENT)))
	     (when (AND (NULL COM*ERROR) (CONSP (CDR RESULT)))
	       (COM=4=TYPE.CHECK (CDR RESULT) NIL nil nil))
	     (if COM*ERROR
		 (SETQ COM*CHANGED.SYMBOLS NIL
		       COM*USED.SYMBOLS NIL
		       RESULT NIL)
		 (SETQ COM*CHANGED.SYMBOLS (DELETE '= COM*CHANGED.SYMBOLS)))
	     RESULT))))

(DEFUN COM=1=SYMBOL.ANALYSYS (INPUT)
						; EDITED: 10-FEB-82 16:48:26
						; INPUT:  'INPUT' - A LIST OF SEXPRESSIONS
						; EFFECT: PERFORMS SYMBOL ANALYSYS OF 'INPUT' DUE
						;         TO SYMBOL-GRAMMAR OF THE TFOL-LANGUAGE
						; VALUE:  A COPY OF THE GIVEN 'INPUT' - LIST , WHERE
						;         - (XXX) IS REPLACED BY (LIST ( (SYMBOLANALYSYS XXX) ) )
						;         - " XXX " IS REPLACED BY (SYMBOLANALYSYS(LIST /" (UNPACK XXX) / "))
						;         - A NUMBER XXX IS REPLACED BY (CONS 'NUMBER XXX)                  
						;         - A IDENTIFIER XXX IS REPLACED BY (CONS 'IDENTIFIER XXX)
						;         - A NAME XXX IS REPLACED BY (CONS 'NAME XXX)                     
						;         - A KEYWORD REMAINS UNCHANGED
  (SMAPCAN #'(LAMBDA (SEXPR)
	       (COND ((CONSP SEXPR)       (NCONC1 (CONS '|(| (COM=1=SYMBOL.ANALYSYS SEXPR)) '|)|))
		     ((STRINGP SEXPR)     (COM=1=SYMBOL.ANALYSYS (LIST '|"| (COERCE SEXPR 'LIST) '|"|)))
		     ((COM-KEYWORD SEXPR) (LIST SEXPR))
		     ((INTEGERP SEXPR)    (LIST (CONS 'NUMBER SEXPR)))
						; sexpr is now a symbol, hopefully
		     (T (let (SYM1 sYM2 (symbols (symbol-name SEXPR)))
			  (COND ((find #\: SYMBOLS :test #'char=)
				 (SETQ SYM1 (subseq symbols 0 (position #\: symbols)))
				 (when (string= "" sym1) (setq sym1 nil))
				 (SETQ SYM2 (subseq symbols (1+ (position #\: symbols))))
				 (when (string= "" sym2) (setq sym2 nil))
				 (COND ((AND SYM1 SYM2)
					(NCONC (COM=1=SYMBOL.ANALYSYS (list (intern SYM1 (find-package "MKRP"))))
					       (LIST '|:|)
					       (COM=1=SYMBOL.ANALYSYS (LIST (intern SYM2 (find-package "MKRP"))))))
				       
				       ((and sym1 (null sym2))
					(NCONC (COM=1=SYMBOL.ANALYSYS (LIST (intern SYM1 (find-package "MKRP")))) (LIST '|:|)))
				       ((AND (NULL SYM1) SYM2)
					(NCONC (LIST '|:|) (COM=1=SYMBOL.ANALYSYS (LIST (intern SYM2 (find-package "MKRP"))))))
				       (T (LIST '|:|))))
				((find #\, SYMBOLS :test #'char=)
				 (SETQ SYM1 (subseq symbols 0 (position #\, symbols)))
				 (SETQ SYM2 (subseq symbols (1+ (position #\, symbols))))
				 (COND  ((AND SYM1 SYM2)
					 (NCONC (COM=1=SYMBOL.ANALYSYS (LIST (intern SYM1 (find-package "MKRP"))))
						(LIST '|,|) (COM=1=SYMBOL.ANALYSYS (LIST (intern SYM2 (find-package "MKRP"))))))
					((AND SYM1 (NULL SYM2))
					 (NCONC (COM=1=SYMBOL.ANALYSYS (LIST (intern SYM1 (find-package "MKRP"))))
						(LIST '|,|)))
					((AND (NULL SYM1) SYM2)
					 (NCONC (LIST '|,|) (COM=1=SYMBOL.ANALYSYS (LIST (intern SYM2 (find-package "MKRP"))))))
					(T (LIST '|,|))))
				((COM=1=IS.IDENTIFIER (map 'list #'(lambda (char) (intern (format nil "~c" char)
											  (find-package "MKRP"))) symbols))
				 (LIST (CONS 'IDENTIFIER SEXPR)))
				((COM=1=IS.NAME (map 'list #'(lambda (char) (intern (format nil "~c" char)
										    (find-package "MKRP"))) symbols))
				 (LIST (CONS 'NAME SEXPR)))
				(T (COM=ERROR T 1 SEXPR)))))))
	   #'(LAMBDA (POINTER) (COND ((NULL COM*ERROR) (SETQ POINTER (CDR POINTER)))
				     (T (SETQ POINTER NIL))))
	   INPUT))

(DEFUN COM=1=IS.IDENTIFIER (SYMBOL.LIST)
  (DECLARE (special symbol.list))
						; EDITED: 10-FEB-82 16:54:12
						; INPUT:  SYMBOL.LIST - A LIST OF ATOMS
						; EFFECT: RETURNS VALUE
						; VALUE:  T IF (PACK SYMBOL.LIST) IS AN IDENTIFIER, ELSE NIL
  (COND
    ((AND (MEMBER (CAR SYMBOL.LIST) COM*LETTERS)
	  (EVERY #'(LAMBDA (CHAR) (OR (MEMBER CHAR COM*LETTERS) (MEMBER CHAR COM*DIGITS) (MEMBER CHAR COM*SPECIAL.SIGNS)))
		 (CDR SYMBOL.LIST)))
     T)))

(DEFUN COM=1=IS.NAME (SYMBOL.LIST)
  (DECLARE (special symbol.list))
						; EDITED: 10-FEB-82 16:55:13
						; INPUT:  SYMBOL.LIST - A LIST OF ATOMS
						; EFFECT: RETURNS VALUE
						; VALUE:  T IF (PACK SYMBOL.LIST) IS A NAME, ELSE NIL
  (COND
    ((AND (MEMBER (CAR SYMBOL.LIST) COM*SPECIAL.SIGNS)
	  (EVERY
	    #'(LAMBDA (CHAR) (OR (MEMBER CHAR COM*LETTERS) (MEMBER CHAR COM*DIGITS) (MEMBER CHAR COM*SPECIAL.SIGNS)))
	    (CDR SYMBOL.LIST)))
     T)))

(DEFmacro COM=1=SYMBOL.ACCEPTED (X)
						;EDITED: 24-FEB-81 12:50:00
						;input:  A LIST OF ATOMS MEMBER OF COM*KEYWORDS +
						;        (IDENTIFIER NAME NUMBER)
						;EFFECT: REPLACES THE ACTUAL SYMBOL
						;        BY THE NEXT SYMBOL,IF THIS FUNCTION RETURNS T
						;VALUE:  T,IF THE ACTUAL SYMBOL IS IN X, ELSE NIL
  `(COND ((MEMBER (COND ((CONSP SYMBOL) (CAR SYMBOL))
			(T SYMBOL))
		  ',X)
	  (COM=1=NEXT.SYMBOL)
	  T)))

(DEFmacro COM=1=SYMBOL.IS (X)
						;EDITED: "24-FEB-81 16:08:11
						;INPUT:  A LIST OF VALID SYMBOLS,I.E. SYMBOLS MEMBER"
						;        OF COM*KEYWORDS + (IDENTIFIER NAME NUMBER)
						;EFFECT: RETURNS VALUE                              "
						;VALUE:  T,IF THE ACTUALSYMBOL IS IN X
  `(MEMBER (COND ((CONSP SYMBOL) (CAR SYMBOL)) (T SYMBOL)) ',X))

(DEFUN COM=1=NEXT.SYMBOL NIL
  (DECLARE (special symbol symbol.list))
						;EDITED: 11-MAR-81 09:48:32
						;input:  NONE
						;EFFECT: REPLACES THE ACTUAL SYMBOL BY THE NEXT SYMBOL IN SYMBOL LIST
						;VALUE:  UNDEFINED
  (SETQ SYMBOL.LIST (CDR SYMBOL.LIST)
	SYMBOL      (CAR SYMBOL.LIST)))

(DEFUN COM=2=STATEMENT NIL
  (DECLARE (special symbol symbol.list))
						; EDITED: 22-FEB-82 13:18:00
						; INPUT:  NONE
						; EFFECT: IMPLEMENTS -
						;         <STATEMENT> ->
						;                    <QUANTIFICATION>        |  <TYPE DECLARATION>      |
						;                    <SUBSORT DECLARATION>   |  <STRUCTURE DECLARATION> |
						;                    <FUNCTION DEFINITION>   |  <PREDICATE DEFINITION>  |
						;                    <PROPERTY DECLARATION>
						; VALUE: THE CODE GENERATED BY THE RESP. RULES
  (unless COM*ERROR
    (let ((RESULT (COND ((COM=1=SYMBOL.IS (TYPE))                        (CONS 'TYPE (COM=2=TYPE.DECLARATION)))
			((COM=1=SYMBOL.IS (SORT))                        (CONS 'TYPE (COM=2=SUBSORT.DECLARATION)))
			((COM=1=SYMBOL.IS (ASSOCIATIVE ac ac1 commutative ag SYMMETRIC REFLEXIVE IRREFLEXIVE))
			 (CONS 'PROPERTY       (COM=2=PROPERTY.DECLARATION)))
			(T                                               (CONS 'QUANTIFICATION (COM=2=QUANTIFICATION))))))
      (COND ((AND (NULL COM*ERROR) SYMBOL.LIST)
	     (COM=ERROR T 0)))
      (unless COM*ERRor RESULT))))

(DEFUN COM=2=TYPE.DECLARATION NIL
  (DECLARE (special symbol))
						; EDITED: 24-FEB-82 12:54:09
						; INPUT:  NONE
						; EFFECT: IMPLEMENTS -  <TYPE DECLARATION> -> TYPE
						;                       <TYPE DEFINITION> : <SORT SYMBOL>
						; VALUE:  NIL OR 'TYPEDECLARATION
  (unless COM*ERROR
    (let (TYPE.DEFINITION IDENTIFIER)
      (COND ((COM=1=SYMBOL.ACCEPTED (TYPE))
	     (SETQ TYPE.DEFINITION (COM=2=TYPE.DEFINITION))
	     (COND ((COM=1=SYMBOL.ACCEPTED (|:|))
		    (SETQ IDENTIFIER (COM=2=SORT.SYMBOL)) (COM=3=ENTER.SORT IDENTIFIER NIL)
		    (COND
		      ((CONSP (CAR TYPE.DEFINITION))	; TYPE A1, ... ,AN:S
		       (MAPC #'(LAMBDA (CONSTANTSYMBOL) (COM=3=ENTER.SYMBOL CONSTANTSYMBOL 'CONSTANT 0 NIL IDENTIFIER NIL))
			     (CAR TYPE.DEFINITION)))
		      (T			; TYPE F(S1 ... SN):S
		       (MAPC #'(LAMBDA (TYPESYMBOL) (COM=3=ENTER.SORT TYPESYMBOL NIL)) (CDR TYPE.DEFINITION))
		       (COM=3=ENTER.SYMBOL (CAR TYPE.DEFINITION) 'FUNCTION (LENGTH (CDR TYPE.DEFINITION)) (CDR TYPE.DEFINITION)
					   IDENTIFIER NIL)))
		    (LIST '+ (DT-PREDICATE.TRUE) NIL nil))
		   ((ATOM (CAR TYPE.DEFINITION))
		    (MAPC #'(LAMBDA (TYPESYMBOL) (COM=3=ENTER.SORT TYPESYMBOL NIL)) (CDR TYPE.DEFINITION))
		    (COM=3=ENTER.SYMBOL (CAR TYPE.DEFINITION) 'PREDICATE (LENGTH (CDR TYPE.DEFINITION))
					(CDR TYPE.DEFINITION) NIL NIL)
		    (LIST '+ (DT-PREDICATE.TRUE) NIL nil))
		   (T (COM=ERROR T 0))))
	    (T (COM=ERROR T 0))))))

(DEFUN COM=2=TYPE.DEFINITION NIL
  (DECLARE (special symbol))
						; EDITED: 30-SEP-81 15:31:23
						; INPUT:  NONE
						; EFFECT: IMPLEMENTS -
						;            <TYPE DEFINITION> -> <CONSTANT LIST>|
						;            <IDENTIFIER> <TYPETAIL>
						; VALUE:  THE CODE GENERATED BY THIS RULE, I.E
						;         A DOTTED PAIR X.Y, WHERE Y IS NIL AND  X IS THE CODE RETURNED BY THE
						;         <CONSTANT LIST> RULE FOR THE 1.ST ALTERNATIVE, X IS NIL AND Y IS THE
						;         CODE RETURNED BY THE <IDENTIFIER LIST> RULE FOR THE 2.ND ALTERNATIVE
						;         OR X IS THE CODE RETURNED BY THE <IDENTIFIER RULE> AND Y IS THE CODE
						;         RETURNED BY THE <TYPETAIL> RULE FOR THE 3.RD ALTERNATIVE
  (unless COM*ERROR
    (let (IDENTIFIER TYPETAIL #|IDENTIFIER.LIST|#)
      (COND ((COM=1=SYMBOL.IS (NUMBER))
	     (LIST (COM=2=CONSTANT.LIST)))
	    (T (SETQ IDENTIFIER (COM=2=IDENTIFIER.OR.NAME))
	       (SETQ TYPETAIL (COM=2=TYPETAIL))
	       (if TYPETAIL
		   (if (CONSP (CAR TYPETAIL))	; TYPE A,B,...,C:D
		       (LIST (CONS IDENTIFIER (CAR TYPETAIL)))
						; TYPE F(A ... B):C
		       (CONS IDENTIFIER TYPETAIL))
						; TYPE A:B
		   (LIST (LIST IDENTIFIER))))))))

(DEFUN COM=2=TYPETAIL NIL
  (DECLARE (special symbol))
						;EDITED: 30-SEP-81 16:02:01
						;INPUT:  NONE
						;EFFECT: IMPLEMENTS -
						;         <TYPETAIL> -> <> |
						;                       (<IDENTIFIER> <TYPELIST>) |
						;                       , <CONSTANT LIST>
						;VALUE: NIL OR A LIST X ,WHERE (CAR X) IS THE VALUE OF THE 'IDENTIFIER' RULE AND
						;       (CDR X) IS THE VALUE OF THE 'TYPELIST RULE. IF
						;        THE 3.RD ALTERNATIVE APPLIES
						;       THE VALUE IS A LIST , THE CAR OF WHICH IS THE CODE RETURNED BY THE
						;       <CONSTANT LIST> RULE .
  (unless COM*ERROR
    (let (IDENTIFIER TYPELIST)
      (COND ((COM=1=SYMBOL.ACCEPTED (|(|))
	     (SETQ IDENTIFIER (COM=2=IDENTIFIER)
		   TYPELIST   (COM=2=TYPELIST))
	     (if (COM=1=SYMBOL.ACCEPTED (|)|))
		 (CONS IDENTIFIER TYPELIST)
		 (COM=ERROR T 0)))
	    ((COM=1=SYMBOL.ACCEPTED (\,))
	     (LIST (COM=2=CONSTANT.LIST)))
	    (T NIL)))))

(DEFUN COM=2=TYPELIST NIL
  (DECLARE (special symbol))
						; EDITED: 8-SEP-81 12:44:25
						; INPUT:  NONE
						; EFFECT: IMPLEMENTS -
						;            <TYPELIST> -> <> |
						;                          <IDENTIFIER><TYPELIST>
						; VALUE:  NIL OR A LIST X ,WHERE (CAR X) IS THE
						;         VALUE OF THE 'IDENTIFIER' RULE AND (CDR X) IS
						;        THE VALUE OF THE 'TYPELIST'
						;         RULE
  (unless COM*ERROR
    (let (IDENTIFIER TYPELIST)
      (COND ((COM=1=SYMBOL.IS (any identifier))
	     (SETQ IDENTIFIER (COM=2=sort.symbol)
		   TYPELIST   (COM=2=TYPELIST))
	     (CONS IDENTIFIER TYPELIST))
	    (T NIL)))))

(DEFUN COM=2=SUBSORT.DECLARATION NIL
  (DECLARE (special symbol))
						; EDITED: 24-FEB-82 12:54:09
						; INPUT:  NONE
						; EFFECT: IMPLEMENTS -  <SUBSORT DECLARATION> ->
						;         SORT <SORT SYMBOLSEQUENCE> : <SORT SYMBOLSEQUENCE>
						; VALUE:  NIL OR 'TYPEDECLARATION.
  (unless COM*ERROR
    (let (SUBSORT.IDENTIFIERS SUPERSORT.IDENTIFIERS)
      (COND ((COM=1=SYMBOL.ACCEPTED (SORT))
	     (SETQ SUBSORT.IDENTIFIERS (COM=2=SORT.SYMBOL.SEQUENCE))
	     (COND ((COM=1=SYMBOL.ACCEPTED (|:|))
		    (SETQ SUPERSORT.IDENTIFIERS (COM=2=SORT.SYMBOL.SEQUENCE))
		    (MAPC #'(LAMBDA (SUBSORT) (COM=3=ENTER.SORT SUBSORT SUPERSORT.IDENTIFIERS))
			  SUBSORT.IDENTIFIERS)
		    (LIST '+ (DT-PREDICATE.TRUE) NIL nil))
		   (T (COM=ERROR T 0))))
	    (T (COM=ERROR T 0))))))

(defun com=2=ac1 ()
  (declare (special symbol))
  (let* ((IDENTIFIER1 (COM=2=IDENTIFIER.OR.NAME))
	 (RANGE1 (ST-GET.SYMBOL.CLASSIFICATION IDENTIFIER1 'RANGE)))
    (unless RANGE1 (SETQ RANGE1 'ANY))
    (unless com*error
      (let* ((IDENTIFIER2 (COM=2=CONSTANT.AND.CONSTRUCT))
	     (RANGE2 (ST-GET.SYMBOL.CLASSIFICATION IDENTIFIER2 'RANGE)))
	(unless RANGE2 (SETQ RANGE2 'ANY))
	(COM=3=ENTER.SYMBOL IDENTIFIER1 'FUNCTION 2 (LIST RANGE1 RANGE1) RANGE1 (CONS 'AC1 nil))
	(COM=3=ENTER.SYMBOL IDENTIFIER2 'CONSTANT 0 nil RANGE2 (CONS 'AC1 nil))
	(dt-putprop (ST-GET.SYMBOL.CLASSIFICATION identifier1 'address)
		    'dt*null (ST-GET.SYMBOL.CLASSIFICATION identifier2 'address))
	(if (COM=1=SYMBOL.ACCEPTED (|)|))
	    (LIST '+ (DT-PREDICATE.TRUE) NIL nil)
	    (COM=ERROR T 0 "Wrong ac1"))))))

(defun com=2=ag ()
  (declare (special symbol))
  (let* ((IDENTIFIER1 (COM=2=IDENTIFIER.OR.NAME))
	 (RANGE1 (ST-GET.SYMBOL.CLASSIFICATION IDENTIFIER1 'RANGE)))
    (unless RANGE1 (SETQ RANGE1 'ANY))
    (unless com*error
      (let* ((IDENTIFIER2 (COM=2=IDENTIFIER.OR.NAME))
	     (RANGE2 (ST-GET.SYMBOL.CLASSIFICATION IDENTIFIER2 'RANGE)))
	(unless range2 (setq range2 'any))
	(unless com*error
	  (let* ((IDENTIFIER3 (COM=2=CONSTANT.AND.CONSTRUCT))
		 (RANGE3 (ST-GET.SYMBOL.CLASSIFICATION IDENTIFIER3 'RANGE)))
	    (unless RANGE3 (SETQ RANGE3 'ANY))
	    (COM=3=ENTER.SYMBOL IDENTIFIER1 'FUNCTION 2 (LIST RANGE1 RANGE1) RANGE1 (CONS 'Ag nil))
	    (COM=3=ENTER.SYMBOL IDENTIFIER2 'FUNCTION 1 (LIST RANGE2) RANGE2 (CONS 'Ag nil))
	    (COM=3=ENTER.SYMBOL IDENTIFIER3 'CONSTANT 0 nil RANGE3 (CONS 'Ag nil))
	    (dt-putprop (ST-GET.SYMBOL.CLASSIFICATION identifier1 'address)
			'dt*null (ST-GET.SYMBOL.CLASSIFICATION identifier3 'address))
	    (dt-putprop (ST-GET.SYMBOL.CLASSIFICATION identifier1 'address)
			'dt*minus (ST-GET.SYMBOL.CLASSIFICATION identifier2 'address))
	    (if (COM=1=SYMBOL.ACCEPTED (|)|))
		(LIST '+ (DT-PREDICATE.TRUE) NIL nil)
		(COM=ERROR T 0 "Wrong abelian group"))))))))

(DEFUN COM=2=PROPERTY.DECLARATION NIL
  (DECLARE (special symbol))
						;EDITED: 11-MAR-82 15:09:02
						;INPUT:  NONE"
						;EFFECT: IMPLEMENTS -
						;            <PROPERTY DECLARATION> ->
						;                 ASSOCIATIVE ( <IDENTIFIER> ) |
						;                 REFLEXIVE   ( <IDENTIFIER> ) |
						;                 IRREFLEXIVE ( <IDENTIFIER> ) |
						;                 commutative ( <IDENTIFIER> ) |
						;                 ac          ( <IDENTIFIER> ) |
						;                 ac1         ( <IDENTIFIER> <IDENTIFIER> ) |
						;                 ag          ( <IDENTIFIER> <IDENTIFIER> <IDENTIFIER> ) |
						;                 SYMMETRIC   ( <IDENTIFIER> )
						;VALUE:  NIL OR PROPERTYDECLARATION
  (unless COM*ERROR
    (let (IDENTIFIER RANGE DOMAIN ARITY (PROPERTY SYMBOL))
      (COND ((AND (COM=1=SYMBOL.ACCEPTED (ASSOCIATIVE ac commutative SYMMETRIC REFLEXIVE IRREFLEXIVE))
		  (COM=1=SYMBOL.ACCEPTED (|(|)))
	     (SETQ IDENTIFIER (COM=2=IDENTIFIER.OR.NAME)
		   RANGE (ST-GET.SYMBOL.CLASSIFICATION IDENTIFIER 'RANGE)
		   DOMAIN (ST-GET.SYMBOL.CLASSIFICATION IDENTIFIER 'DOMAIN)
		   ARITY (ST-GET.SYMBOL.CLASSIFICATION IDENTIFIER 'ARITY))
	     (COND ((EQL PROPERTY 'ASSOCIATIVE)
		    (COND ((NULL RANGE) (SETQ RANGE 'ANY)))
		    (COM=3=ENTER.SYMBOL IDENTIFIER 'FUNCTION 2 (LIST RANGE RANGE) RANGE (CONS 'ASSOCIATIVE nil)))
		   ((EQL PROPERTY 'COMMUTATIVE)
		    (COND ((NULL RANGE) (SETQ RANGE 'ANY)))
		    (COM=3=ENTER.SYMBOL IDENTIFIER 'FUNCTION 2 (LIST RANGE RANGE) RANGE (CONS 'COMMUTATIVE nil)))
		   ((EQL PROPERTY 'AC)
		    (COND ((NULL RANGE) (SETQ RANGE 'ANY)))
		    (COM=3=ENTER.SYMBOL IDENTIFIER 'FUNCTION 2 (LIST RANGE RANGE) RANGE (CONS 'AC nil)))
		   (T
		    (COND ((NULL DOMAIN)
			   (SETQ ARITY 2
				 DOMAIN (LIST 'ANY 'ANY)))
			  ((EQL ARITY 1) (SETQ ARITY 2))
			  (T (SETQ DOMAIN (NCONC (CONS (SECOND DOMAIN) nil) (CONS (CAR DOMAIN) nil) (CDDR DOMAIN)))))
		    (COM=3=ENTER.SYMBOL IDENTIFIER 'PREDICATE ARITY DOMAIN NIL (CONS PROPERTY nil))))
	     (if (COM=1=SYMBOL.ACCEPTED (|)|))
		 (LIST '+ (DT-PREDICATE.TRUE) NIL nil)
		 (COM=ERROR T 0)))
	    ((AND (COM=1=SYMBOL.ACCEPTED (ac1)) (COM=1=SYMBOL.ACCEPTED (|(|)))
	     (com=2=ac1))
	    ((AND (COM=1=SYMBOL.ACCEPTED (ag))  (COM=1=SYMBOL.ACCEPTED (|(|)))
	     (com=2=ag))
	    (T (COM=ERROR T 0 "Wrong property declaration"))))))

(DEFUN COM=2=QUANTIFICATION (&optional ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED:  3-SEP-81 14:18:30
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS -
						;        <QUANTIFICATION> -> <EQUIVALENCE 1>|
						;                            ALL <VARIABLE DECLARATION> <QUANTIFICATION> |
						;                            EX <VARIABLE DECLARATION> <QUANTIFICATION>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E. THE CODE GENERATED BY THE
						;        'EQUIVALENCE1' RULE OR A LIST X , WHERE (CAR X) IS ONE OF THE ATOMS
						;        ALL AND EX ,(CADR X) IS THE CODE GENERATED BY THE 'VARIABLE DECLARA-
						;        TION' RULE AND (CADDR X) IS THE CODE GENERATED BY THE 'QUANTIFICA-
						;        TION' RULE
  (unless COM*ERROr
    (PROG ((ALLEX SYMBOL)
	   VARIABLE.DECLARATION QUANTIFICATION)
	  (COND
	    ((COM=1=SYMBOL.ACCEPTED (ALL EX))
	     (SETQ VARIABLE.DECLARATION (COM=2=VARIABLE.DECLARATION (MEMBER 'PREDICATE.BODY ATTRIBUTES) ATTRIBUTES))
	     (COM=3=VSTACK.PUSH VARIABLE.DECLARATION)
	     (unless com*error (SETQ QUANTIFICATION (COM=2=QUANTIFICATION ATTRIBUTES)))
	     (COM=3=VSTACK.POP)
	     (unless com*error
	       (RETURN (COM=QUANTIFICATION.CLOSURE ALLEX (MAPCAR #'CADR VARIABLE.DECLARATION) QUANTIFICATION))))
	    (T (RETURN (COM=2=EQUIVALENCE.1 ATTRIBUTES)))))))

(DEFUN COM=2=EQUIVALENCE.1 (ATTRIBUTES)
						;EDITED: 26-FEB-81 16:12:20
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS -
						;        <EQUIVALENCE 1> -> <IMPLICATION 1>
						;                           <EQUIVALENCE 2>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        THE CODE GENERATED BY THE 'IMPLICATION 1' RULE IF Y , WHICH IS THE
						;        CODE GENERATED BY THE 'EQUIVALENCE2' RULE IS NIL,ELSE A LIST X ,WHERE
						;        (CAR X) IS (CAR Y),(CADR X) IS THE CODE GENERATED BY THE 'IMPLICATION1'
						;        RULE AND (CADDR X) IS (CADR Y)
  (unless COM*ERROR
    (let (IMPLICATION.1 EQUIVALENCE.2 COUNTER SIDE)
      (SETQ IMPLICATION.1 (COM=2=IMPLICATION.1 ATTRIBUTES))
      (unless com*error (SETQ EQUIVALENCE.2 (COM=2=EQUIVALENCE.2 ATTRIBUTES)))
      (unless com*error
	(COND (EQUIVALENCE.2
	       (CASE (CAR EQUIVALENCE.2)
		 (|:EQV| (SETQ SIDE 'LEFT))
		 (|EQV:| (SETQ SIDE 'RIGHT))
		 ((EQV |:EQV:|))
		 (OTHERWISE (ERROR "ILLEGAL EQUIVALENCE-SYMBOL IN COM=2=EQUIVALENCE.1~A" NIL)))
	       (SETQ COUNTER (INTERN (with-output-to-string (stream)
				       (princ (1+ (ST-STACK.LENGTH)) stream)
				       (princ COM*EQUIVALENCES stream))
				     (find-package "MKRP")))
	       (COM=3=INSERT.PROPERTY IMPLICATION.1
				      (LIST 'KIND (LIST 'EQV (COND ((OR (NULL SIDE) (EQL SIDE 'LEFT)) T)) COUNTER)))
	       (unless com*error
		 (COM=3=INSERT.PROPERTY (CDR EQUIVALENCE.2) (LIST 'KIND (LIST 'EQV (COND ((EQL SIDE 'RIGHT) T)) COUNTER)))
		 (SETQ COM*EQUIVALENCES (1+ COM*EQUIVALENCES))
		 (LIST 'EQV IMPLICATION.1 (CDR EQUIVALENCE.2))))
	      (T IMPLICATION.1))))))

(DEFUN COM=2=EQUIVALENCE.2 (ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED: 11-MAR-82 15:13:42
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS - <EQUIVALENCE 2> -> <> |
						;                                        EQV <EQUIVALENCE 1> |
						;                                        :EQV <EQUIVALENCE 1> |
						;                                        EQV: <EQUIVALENCE 1> |
						;                                        :EQV: <EQUIVALENCE 1>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E. NIL OR A LIST X , WHERE (CAR X) IS
						;        ONE OF THE ATOMS EQV, :EQV, EQV: OR :EQV:  AND  (CADR X) IS THE CODE
						;        GENERATED BY THE <EQUIVALENCE 1> RULE.
  (unless COM*ERROR
    (let ((JUNCTOR SYMBOL))
      (COND
	((COM=1=SYMBOL.ACCEPTED (EQV |:EQV| |EQV:| |:EQV:|)) (CONS JUNCTOR (COM=2=EQUIVALENCE.1 ATTRIBUTES)))
	(T NIL)))))

(DEFUN COM=2=IMPLICATION.1 (ATTRIBUTES)
						;EDITED: 26-FEB-81 14:44:25
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS -
						;         <IMPLICATION 1> -> <DISJUNCTION 1>
						;                            <IMPLICATION 2>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        THE CODE GENERATED BY THE 'DISJUNCTION 1' RULE IF Y , WHICH IS THE
						;        CODE GENERATED BY THE 'IMPLICATION2' RULE IS NIL,ELSE A LIST X ,WHERE
						;        (CAR X) IS (CAR Y),(CADR X) IS THE CODE GENERATED BY THE 'DISJUNCTION1'
						;        RULE AND (CADDR X) IS (CADR Y)
  (unless COM*ERROR
    (let ((DISJUNCTION.1 (COM=2=DISJUNCTION.1 ATTRIBUTES))
	  IMPLICATION.2)
      (unless com*error
	(SETQ IMPLICATION.2 (COM=2=IMPLICATION.2 ATTRIBUTES)))
      (unless com*error
	(if IMPLICATION.2
	    (LIST 'IMPL DISJUNCTION.1 (CDR IMPLICATION.2))
	    DISJUNCTION.1)))))

(DEFUN COM=2=IMPLICATION.2 (ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED: 11-MAR-82 15:16:35
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS -
						;        <IMPLICATION 2> -> <> |
						;                           IMPL <IMPLICATION 1> |
						;                           :IMPL <IMPLICATION 1> |
						;                           IMPL: <IMPLICATION 1> |
						;                           :IMPL: <IMPLICATION 1>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E. NIL OR A LIST X , WHERE (CAR X) IS
						;        ONE OF THE ATOMS IMPL, :IMPL IMPL: OR :IMPL: AND (CADR X) IS THE CODE
						;        GENERATED BY THE <IMPLICATION 1> RULE.
  (unless COM*ERROR
    (let ((JUNCTOR SYMBOL))
      (COND ((COM=1=SYMBOL.ACCEPTED (IMPL |:IMPL| |IMPL:| |:IMPL:|)) (CONS JUNCTOR (COM=2=IMPLICATION.1 ATTRIBUTES)))
	    (T NIL)))))

(DEFUN COM=2=DISJUNCTION.1 (ATTRIBUTES)
						;EDITED: 26-FEB-81 14:46:20
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS -
						;       <DISJUNCTION 1> -> <CONJUNCTION 1> <DISJUNCTION 2>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        THE CODE GENERATED BY THE 'CONJUNCTION 1' RULE IF Y , WHICH IS THE
						;        CODE GENERATED BY THE 'DISJUNCTION2' RULE IS NIL,ELSE A LIST X ,WHERE
						;        (CAR X) IS (CAR Y),(CADR X) IS THE CODE GENERATED BY THE 'CONJUNCTION1'
						;        RULE AND (CADDR X) IS (CADR Y)
  (unless COM*ERROR
    (let ((CONJUNCTION.1 (COM=2=CONJUNCTION.1 ATTRIBUTES))
	  DISJUNCTION.2)
      (unless com*error
	(SETQ DISJUNCTION.2 (COM=2=DISJUNCTION.2 ATTRIBUTES))
	(unless com*error
	  (if DISJUNCTION.2
	      (LIST 'OR CONJUNCTION.1 (CDR DISJUNCTION.2))
	      CONJUNCTION.1))))))

(DEFUN COM=2=DISJUNCTION.2 (ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED:  5-APR-82 11:37:37
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS -  <DISJUNCTION 2> -> <> |
						;                          OR <DISJUNCTION 1> | :OR <DISJUNCTION 1>
						;                          OR: <DISJUNCTION 1> | :OR: <DISJUNCTION 1>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E. NIL OR A LIST X , WHERE (CAR X) IS
						;        THE ATOM OR AND (CADR X) IS THE CODE GENERATED BY THE 'DISJUNCTION 1'
						;        RULE
  (COND
    ((NULL COM*ERROR)
     (PROG ((JUNCTOR SYMBOL))
	   (COND ((COM=1=SYMBOL.ACCEPTED (OR |:OR| |OR:| |:OR:|))
		  (RETURN (CONS JUNCTOR (COM=2=DISJUNCTION.1 ATTRIBUTES)))) (T (RETURN NIL)))))))

(DEFUN COM=2=CONJUNCTION.1 (ATTRIBUTES)
						;EDITED: 26-FEB-81 14:48:47
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS -
						;         <CONJUNCTION 1> -> <NEGATION> <CONJUNCTION 2>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        THE CODE GENERATED BY THE 'NEGATION' RULE IF Y , WHICH IS THE
						;        CODE GENERATED BY THE 'CONJUNCTION2' RULE IS NIL,ELSE A LIST X ,WHERE
						;        (CAR X) IS (CAR Y),(CADR X) IS THE CODE GENERATED BY THE 'NEGATION'
						;        RULE AND (CADDR X) IS (CADR Y)
  (unless COM*ERROR
    (let (NEGATION CONJUNCTION.2)
      (SETQ NEGATION (COM=2=NEGATION ATTRIBUTES))
      (unless com*error
	(SETQ CONJUNCTION.2 (COM=2=CONJUNCTION.2 ATTRIBUTES)))
      (unless com*error
	(if CONJUNCTION.2
	    (LIST 'AND NEGATION (CDR CONJUNCTION.2))
	    NEGATION)))))

(DEFUN COM=2=CONJUNCTION.2 (ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED: 22-FEB-82 12:35:10
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS -
						;             <CONJUNCTION 2> -> <> | AND <CONJUNCTION 1> | :AND <CONJUNCTION 1> |
						;                                AND: <CONJUNCTION 1> | :AND: <CONJUNCTION 1>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E. NIL OR A LIST X , WHERE (CAR X) IS
						;        THE ATOM AND AND (CADR X) IS THE CODE GENERATED BY THE 'CONJUNCTION 1'
						;        RULE
  (COND
    ((NULL COM*ERROR)
     (PROG ((JUNCTOR SYMBOL))
	   (COND
	     ((COM=1=SYMBOL.ACCEPTED (AND |:AND| |AND:| |:AND:|))
	      (RETURN (CONS JUNCTOR (COM=2=CONJUNCTION.1 ATTRIBUTES))))
	     (T (RETURN NIL)))))))

(DEFUN COM=2=NEGATION (ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED: 26-FEB-81 16:38:07
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS -  <NEGATION> -> <ATOMAR FORMULA> | NOT <ATOMAR FORMULA>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        THE CODE GENERATED BY THE 'ATOMAR - FORMULA' RULE OR A LIST X ,WHERE
						;        (CAR X) IS THE ATOM NOT AND (CADR X) IS THE CODE GENERATED BY THE
						;        'ATOMAR FORMULA' RULE
  (unless COM*ERROR
    (if (COM=1=SYMBOL.ACCEPTED (NOT))
	(LIST 'NOT (COM=2=ATOMAR.FORMULA ATTRIBUTES))
	(COM=2=ATOMAR.FORMULA ATTRIBUTES))))

(DEFUN COM=2=ATOMAR.FORMULA (ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED:  5-MAR-81 12:07:56
						;input:  ATTRIBUTES - A LIST OF ATOMS.
						;EFFECT: IMPLEMENTS - <ATOMAR FORMULA> -> <PROPOSITION> | ( <QUANTIFICATION> )
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        THE CODE GENERATED BY THE 'PROPOSITION'  RULE OR
						;        THE CODE GENERATED BY THE 'QUANTIFICATION' RULE
  (unless COM*ERROR 
    (if (COM=1=SYMBOL.ACCEPTED (|(|))
	(PROG1 (COM=2=QUANTIFICATION ATTRIBUTES)
	       (unless com*error (unless (COM=1=SYMBOL.ACCEPTED (|)|)) (COM=ERROR T 0))))
        (if (COM=1=SYMBOL.is (all ex))
	    (PROG1 (COM=2=QUANTIFICATION ATTRIBUTES))
	    (COM=2=PROPOSITION ATTRIBUTES)))))

(DEFUN COM=2=STRUCTURE.DECLARATION NIL
  (DECLARE (special symbol))
						;EDITED: 14-JUL-81 17:59:45
						;input:  NONE
						;EFFECT: IMPLEMents - <STRUCTURE DECLARATION> -> STRUCTURE
						;                       <STRUCTURE ANNOUNCEMENT>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E.
						;        THE CODE GENERATED BY THE <STRUCTURE ANNOUNCEMENT> RULE
  (COND
    ((NULL COM*ERROR) (COND ((COM=1=SYMBOL.ACCEPTED (STRUCTURE)) (COM=2=STRUCTURE.ANNOUNCEMENT)) (T (COM=ERROR T 0))))))

(DEFUN COM=2=STRUCTURE.ANNOUNCEMENT NIL
  (DECLARE (special symbol))
						;Edited: 15-JUL-81 15:20:30
						;input:  NONE
						;EFFECT: IMPLEMENTS -
						;        <STRUCTURE ANNOUNCEMENT> -> ? : <SORT SYMBOL> | <STRUCTURE DEFINITION>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E. THE CODE GENERATED BY THE <STRUCTURE
						;        DEFINITION> RULE OR THE LITATOM STRUCTURE.ANNOUNCEMENT
  (COND
    ((NULL COM*ERROR)
     (PROG (SORTSYMBOL)
	   (COND
	     ((COM=1=SYMBOL.ACCEPTED (?))
	      (COND
		((COM=1=SYMBOL.ACCEPTED (|:|)) (SETQ SORTSYMBOL (COM=2=SORT.SYMBOL))
		 (COM=3=ENTER.SORT SORTSYMBOL NIL (CONS '?STRUCTURE nil)) (RETURN 'STRUCTURE.ANNOUNCEMENT))
		(T (RETURN (COM=ERROR T 0)))))
	     (T (RETURN (COM=2=STRUCTURE.DEFINITION))))))))

(DEFUN COM=2=STRUCTURE.DEFINITION NIL
  (DECLARE (special symbol))
						;EDITED: 19-APR-82 14:01:59
						;input:  NONE
						;EFFECT: IMPLEMENTS - <STRUCTURE DEFINITION> ->
						;                         ( <IDENTIFIER.LIST> ) <STRUCTURE.TAIL>  |
						;                         <CONSTANT.AND.CONSTRUCT> : <IDENTIFIER>
						;VALUE:  THE CODE GENERATED BY THIS RULE ,I.E. A PREDICATE-LOGIC FORMULA WRITTEN IN
						;        PREFIX NOTATION WITH RENAMED VARIABLES REPRESENTING
						;         - THE DEFINITION OF THE CANONICAL ORDERING
						;         - THE DEFINITION OF THE TRANSITIVE CLOSURE OF THE CANONICAL ORDERING
						;         - A FORMULA EXPRESSING THAT EVEry  OBJECT IS  A  BASE CONSTANT, IS OF
						;           THE BASE SORT OR IS IN THE RANGE OF THE CONSTRUCTOR FUNCTION
						;         - A FORMULA EXPRESSING THAT A BASE CONSTANT
						;         AND EVERY OBJECT OF THE BASE
						;           SORT IS NOT IN THE RANGE OF THE CONSTRUCTOR FUNCTION AND THAT BASE
						;           CONSTANTS ARE DISTINCT AND NO OBJECT OF THE BASE SORTS.
						;         - THE INJECTIVITY OF THE CONSTRUCTOR FUNCTION
  (COND
    ((NULL COM*ERROR)
     (PROG
       ((EQUALITY (COM=3=ENTER.SYMBOL '= 'PREDICATE 2 '(ANY ANY) 'ANY '(DEFINED REFLEXIVE) NIL)) STRUCTURE.TAIL
	#|CONSTANT.AND.CONSTRUCT|#
	CONSTRUCTION.DEFINITIONS BASE.SORTS BASE.CONSTANTS STRUCTURE.SORT RANGE.VARIABLE STRUCTURE.SCHEME
	STRUCTURE.SCHEME2 BASESORT.VARIABLE COMPL.CODE UNIQUE.CODE INJECT.CODE #|DOMAIN.VARS2|#)
       (COND
	 ((COM=1=SYMBOL.ACCEPTED (|(|)) (SETQ BASE.SORTS (COM=2=IDENTIFIER.LIST))
	  (COND ((NOT (COM=1=SYMBOL.ACCEPTED (|)|))) (COM=ERROR T 0)))))
       (COND
	 ((NULL COM*ERROR) (SETQ STRUCTURE.TAIL (COM=2=STRUCTURE.TAIL)) (SETQ BASE.CONSTANTS (CAR (CAR STRUCTURE.TAIL)))
	  (SETQ CONSTRUCTION.DEFINITIONS (CDR (CAR STRUCTURE.TAIL))) (SETQ STRUCTURE.SORT (CDR STRUCTURE.TAIL))))
       (COM=3=ENTER.SORT STRUCTURE.SORT NIL (CONS 'STRUCTURE nil))
       (MAPC #'(LAMBDA (BASE.SORT) (COM=3=ENTER.SORT BASE.SORT (CONS STRUCTURE.SORT nil))) BASE.SORTS)
       (SETQ BASE.CONSTANTS
	     (MAPCAR
	       #'(LAMBDA (BASE.CONSTANTS)
		   (COM=3=ENTER.SYMBOL BASE.CONSTANTS 'CONSTANT 0 NIL STRUCTURE.SORT (CONS 'STRUCTURE nil)))
	       BASE.CONSTANTS))
       (MAPC
	 #'(LAMBDA (CONSTRUCTION.DEFINITION)
	     (MAPC #'(LAMBDA (SORT) (COM=3=ENTER.SORT SORT NIL (CONS 'ANNOUNCED.STRUCTURE nil))) (CDR CONSTRUCTION.DEFINITION))
	     (COM=3=ENTER.SYMBOL (CAR CONSTRUCTION.DEFINITION) 'FUNCTION (LIST-LENGTH (CDR CONSTRUCTION.DEFINITION))
				 (CDR CONSTRUCTION.DEFINITION) STRUCTURE.SORT (CONS 'STRUCTURE nil)))
	 CONSTRUCTION.DEFINITIONS)
       (ST-ENTER.SYMBOL.CLASSIFICATION
	 STRUCTURE.SORT 'DATA
	 (LIST BASE.SORTS BASE.CONSTANTS (MAPCAR #'CAR CONSTRUCTION.DEFINITIONS)))	
       (SETQ RANGE.VARIABLE (ST-CREATE.VARIABLE STRUCTURE.SORT))	; GENERATION OF CODE1 = ALL |X:S| X = ? OR ... OR X = ?
       (SETQ COMPL.CODE
	     (NCONC
	       (MAPCAR #'(LAMBDA (CONSTANT) (LIST '+ EQUALITY (LIST RANGE.VARIABLE CONSTANT) NIL)) BASE.CONSTANTS)
	       (MAPCAR
		 #'(LAMBDA (SORT) (SETQ BASESORT.VARIABLE (ST-CREATE.VARIABLE SORT))
			   (LIST 'EX BASESORT.VARIABLE (LIST '+ EQUALITY (LIST RANGE.VARIABLE BASESORT.VARIABLE) NIL)))
		 BASE.SORTS)
	       (MAPCAR
		 #'(LAMBDA (CONSTRUCTION.DEFINITION)
		     (SETQ STRUCTURE.SCHEME (COM=CREATE.STRUCTURE.SCHEME CONSTRUCTION.DEFINITION))
		     (COM=QUANTIFICATION.CLOSURE 'EX (CDR STRUCTURE.SCHEME)
						 (LIST '+ EQUALITY (LIST RANGE.VARIABLE (CAR STRUCTURE.SCHEME)) NIL)))
		 CONSTRUCTION.DEFINITIONS)))
       (SETQ COMPL.CODE (COM=QUANTIFICATION.CLOSURE 'ALL RANGE.VARIABLE (COM=JUNCTION.CLOSURE 'OR COMPL.CODE)))
       ;; GENERATION OF CODE2 = (1) ALL BASE CONSTANTS ARE DISTINCT
       ;; (2) NO BASE CONSTANT IS IN THE RANGE OF THE CONSTRUCTOR FUNCTION
       ;; (3) NO OBJECT OF A BASE SORT IS IN THE RANGE OF THE CONSTRUCTOR FUNCTION
       (MAPL
	 #'(LAMBDA (BASE.CONSTS)
	     (SETQ UNIQUE.CODE
		   (NCONC
		     (MAPCAR
		       #'(LAMBDA (CONSTR.DEFS) (SETQ STRUCTURE.SCHEME (COM=CREATE.STRUCTURE.SCHEME CONSTR.DEFS))
				 (COM=QUANTIFICATION.CLOSURE 'ALL (CDR STRUCTURE.SCHEME)
							     (LIST '- EQUALITY (LIST (CAR BASE.CONSTS) (CAR STRUCTURE.SCHEME)) NIL)))
		       CONSTRUCTION.DEFINITIONS)
		     (MAPCAR
		       #'(LAMBDA (BASE.SORT) (SETQ BASESORT.VARIABLE (ST-CREATE.VARIABLE BASE.SORT))
				 (LIST 'ALL BASESORT.VARIABLE (LIST '- EQUALITY (LIST BASESORT.VARIABLE BASE.CONSTANTS) NIL)))
		       BASE.SORTS)
		     (MAPCAR #'(LAMBDA (BASE.CONST) (LIST '- EQUALITY (LIST BASE.CONST (CAR BASE.CONSTS)) NIL)) (CDR BASE.CONSTS)))))
	 BASE.CONSTANTS)
       (MAPL
	 #'(LAMBDA (BASE.SORTS)
	     (SETQ UNIQUE.CODE
		   (NCONC
		     (MAPCAR
		       #'(LAMBDA (CONSTR.DEF) (SETQ STRUCTURE.SCHEME (COM=CREATE.STRUCTURE.SCHEME CONSTR.DEF))
				 (SETQ BASESORT.VARIABLE (ST-CREATE.VARIABLE (CAR BASE.SORTS)))
				 (COM=QUANTIFICATION.CLOSURE 'ALL (CONS BASESORT.VARIABLE (CDR STRUCTURE.SCHEME))
							     (LIST '- EQUALITY (LIST BASESORT.VARIABLE (CAR STRUCTURE.SCHEME)) NIL)))
		       CONSTRUCTION.DEFINITIONS)
		     (MAPCAR
		       #'(LAMBDA (BASE.SORT)
			   (SETQ BASESORT.VARIABLE
				 (LIST (ST-CREATE.VARIABLE (CAR BASE.SORTS)) (ST-CREATE.VARIABLE BASE.SORT)))
			   (COM=QUANTIFICATION.CLOSURE 'ALL BASESORT.VARIABLE (LIST '- EQUALITY BASESORT.VARIABLE NIL)))
		       (CDR BASE.SORTS))
		     UNIQUE.CODE)))
	 BASE.SORTS)
       (MAPL
	 #'(LAMBDA (CONST.DEFS)
	     (SETQ UNIQUE.CODE
		   (NCONC
		     (MAPCAR
		       #'(LAMBDA (CONST.DEF) (SETQ STRUCTURE.SCHEME (COM=CREATE.STRUCTURE.SCHEME CONST.DEF))
				 (SETQ STRUCTURE.SCHEME2 (COM=CREATE.STRUCTURE.SCHEME (CAR CONST.DEFS)))
				 (COM=QUANTIFICATION.CLOSURE
				   'ALL (APPEND (CDR STRUCTURE.SCHEME) (CDR STRUCTURE.SCHEME2))
				   (LIST '- EQUALITY (LIST (CAR STRUCTURE.SCHEME) (CAR STRUCTURE.SCHEME2)) NIL)))
		       (CDR CONST.DEFS))
		     UNIQUE.CODE))
	     (SETQ STRUCTURE.SCHEME (COM=CREATE.STRUCTURE.SCHEME (CAR CONST.DEFS)))
	     (SETQ STRUCTURE.SCHEME2 (COM=CREATE.STRUCTURE.SCHEME (CAR CONST.DEFS)))
	     (SETQ INJECT.CODE
		   (CONS
		     (COM=QUANTIFICATION.CLOSURE
		       'ALL (APPEND (CDR STRUCTURE.SCHEME) (CDR STRUCTURE.SCHEME2))
		       (LIST 'IMPL (LIST '+ EQUALITY (LIST (CAR STRUCTURE.SCHEME) (CAR STRUCTURE.SCHEME2)) NIL)
			     (COM=JUNCTION.CLOSURE 'AND
						   (MAPCAR #'(LAMBDA (VAR1 VAR2)
							       (LIST '+ EQUALITY (LIST VAR1 VAR2) NIL)) (CDR STRUCTURE.SCHEME)
							   (CDR STRUCTURE.SCHEME2)))))
		     INJECT.CODE)))
	 CONSTRUCTION.DEFINITIONS)
       (RETURN (COM=JUNCTION.CLOSURE 'AND (CONS COMPL.CODE (NCONC UNIQUE.CODE INJECT.CODE))))))))

(DEFUN COM=2=STRUCTURE.TAIL NIL
  (DECLARE (special symbol))
						;Edited: 19-APR-82 12:45:08
						;input:  NONE
						;EFFECT: IMPLEMENTS -                                <STRUCTURE.TAIL> ->
						;                   <CONSTANT.AND.CONSTRUCT>                      : <SORT.SYMBOL>    |
						;                   : <SORT.SYMBOL>          VALUE:  THE CODE GENERATED BY THIS RULE.
						;        I.E. A DOTTED-PAIR X WHERE (CAR X)          IS THE CODE GENERATED BY THE
						;        <CONSTANT.AND.CONSTRUCT> RULE AND           (CDR X) IS THE CODE GENERATED BY
						;        <IDENTIFIER> .
  (COND
    ((NULL COM*ERROR)
     (PROG (CONSTANT.AND.CONSTRUCT SORT.SYMBOL)
	   (COND ((COM=1=SYMBOL.ACCEPTED (|:|)) (SETQ SORT.SYMBOL (COM=2=SORT.SYMBOL)) (RETURN (CONS NIL SORT.SYMBOL)))
		 (T (SETQ CONSTANT.AND.CONSTRUCT (COM=2=CONSTANT.AND.CONSTRUCT))
		    (COND
		      ((COM=1=SYMBOL.ACCEPTED (|:|)) (SETQ SORT.SYMBOL (COM=2=SORT.SYMBOL))
		       (RETURN (CONS CONSTANT.AND.CONSTRUCT SORT.SYMBOL)))
		      (T (COM=ERROR T 0)))))))))

(DEFUN COM=2=CONSTANT.AND.CONSTRUCT NIL
  (DECLARE (special symbol))
						;EDITED: 16-APR-82 13:00:30
						;input:  NONE
						;EFFECT: IMPLEMENTS - <CONSTANT.AND.CONSTRUCT> ->
						;            <IDENTIFIER> <CONSTANT.AND.CONSTRUCT.TAIL2>|
						;            <NAME> <CONSTANT.AND.CONSTRUCT.TAIL2>|
						;            <NUMBER> <CONSTANT.AND.CONSTRUCT.TAIL1>.
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E. A DOTTED PAIR X WHERE (CAR X)
						;        IS A LIST OF BASE.CONSTANTS AND (CDR X) IS THE CODE GENERATED BY THE
						;        <CONSTRUCTION.DEFINITION>.
  (COND
    ((NULL COM*ERROR)
     (PROG (IDENTIFIER TAIL #|NAME|# NUMBER CONSTANT.AND.CONSTRUCT.TAIL)
	   (COND
	     ((COM=1=SYMBOL.IS (IDENTIFIER NAME)) (SETQ IDENTIFIER (COM=2=IDENTIFIER.OR.NAME))
	      (SETQ TAIL (COM=2=CONSTANT.AND.CONSTRUCT.TAIL2))
	      (RETURN
		(COND
		  ((CAR TAIL)			; TAIL IS PART OF A CONSTRUCTOR-DEFINITION AND THERE ARE NO BASE.CONSTANTS
		   (CONS NIL (CONS (CONS IDENTIFIER (CAR TAIL)) (THIRD TAIL))))
		  ((SECOND TAIL)		; THERE ARE SOME BASE.CONSTANTS ANDIDENTIFIER IS ONE OF THESE
		   (CONS (CONS IDENTIFIER (SECOND TAIL)) (THIRD TAIL)))
		  ((THIRD TAIL)			; IDENTIFIER IS THE ONLY BASE.CONSTANT AND TAIL IS A CONSTRUCTON-DEFINITION
		   (CONS (LIST IDENTIFIER) (THIRD TAIL)))
		  ((CONSP TAIL) (CONS (CONS IDENTIFIER nil) nil))
		  (T				; A SYNTAXERROR IS DISCOVERED IN (CONSTANT.AND.CONSTRUCT.TAIL2)
		   NIL))))
	     ((COM=1=SYMBOL.IS (NUMBER)) (SETQ NUMBER (COM=2=NUMBER))
	      (SETQ CONSTANT.AND.CONSTRUCT.TAIL (COM=2=CONSTANT.AND.CONSTRUCT.TAIL1))
	      (RETURN (CONS (CONS NUMBER (CAR CONSTANT.AND.CONSTRUCT.TAIL)) (CDR CONSTANT.AND.CONSTRUCT.TAIL))))
	     (T (COM=ERROR T 0)))))))

(DEFUN COM=2=CONSTANT.AND.CONSTRUCT.TAIL1 NIL
  (DECLARE (special symbol))
						;EDITED: 16-APR-82 12:40:08
						;input:  NONE
						;EFFECT: IMPLEMENTS - <CONSTANT.AND.CONSTRUCT.TAIL1> ->
						;               <CONSTRUCTION.DEFINITION>  | , <CONSTANT.LIST>
						;               <CONSTRUCTION.DEFINITION>  |
						;VALUE:  THE CODE GENERATED BY THIS RULE,
						;        I.E. A DOTTED PAIR X, WHERE (CAR X) IS THE CODE GENERATED BY
						;        <CONSTANT.LIST> AND (CDR X) IS THE CODE GENERATED BY <CONSTRUCTOR.
						;        DEFINITION>.
  (COND
    ((NULL COM*ERROR)
     (PROG (CONSTANT.LIST CONSTRUCTION.DEFINITION)
	   (COND
	     ((COM=1=SYMBOL.ACCEPTED (UNQUOTE)) (SETQ CONSTANT.LIST (COM=2=CONSTANT.LIST))
	      (SETQ CONSTRUCTION.DEFINITION (COM=2=CONSTRUCTION.DEFINITION)))
	     (T (SETQ CONSTRUCTION.DEFINITION (COM=2=CONSTRUCTION.DEFINITION))))
	   (RETURN (CONS CONSTANT.LIST CONSTRUCTION.DEFINITION))))))

(DEFUN COM=2=CONSTANT.AND.CONSTRUCT.TAIL2 NIL
  (DECLARE (special symbol))
						;EDITED: 14-APR-82 15:29:32
						;input:  NONE
						;EFFECT: IMPLEMENTS - <CONSTANT.AND.CONSTRUCT.TAIL2> ->
						;               <SORT.SYMBOLLIST> <CONSTRUCTION.DEFINITION.TAIL> |
						;               <COSTRUCTION.DEFINITION.TAIL>  | , <CONSTANT.LIST>
						;               <CONSTRUCTION.DEFINITION>  | <CONSTRUCTION.DEFINITION>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E. A LIST OF THREE S-EXPRESSIONS
						;        WHERE THE FIRST IS A LIST OF (<IDENTIFIER> <TYPELIST>) ,
						;        THE SECOND IS THE CODE GENERATED  BY THE <CONSTANT.LIST> AND THE THIRD
						;        IS THE CODE GENERATED BY THE <CONSTRUCTION.DEFINITION> .
  (COND
    ((NULL COM*ERROR)
     (PROG (SORT.SYMBOLLIST #|TYPELIST|# CONSTANT.LIST CONSTRUCTION.DEFINITION)
	   (COND
	     ((COM=1=SYMBOL.ACCEPTED (|(|))	; THE TAIL OF THE CONSTRUCTION.DEFINITION.
	      (SETQ SORT.SYMBOLLIST (COM=2=SORT.SYMBOLLIST))
	      (COND
		((COM=1=SYMBOL.ACCEPTED (|)|)) (RETURN (LIST SORT.SYMBOLLIST NIL (COM=2=CONSTRUCTION.DEFINITION.TAIL))))
		(T (RETURN (COM=ERROR T 0)))))
	     ((COM=1=SYMBOL.ACCEPTED (\,))	; THE TAIL OF THE BASE.CONSTANTS PLUS THE CONSTRUCTION.DEFINITION
	      (SETQ CONSTANT.LIST (COM=2=CONSTANT.LIST)) (SETQ CONSTRUCTION.DEFINITION (COM=2=CONSTRUCTION.DEFINITION))
	      (RETURN (LIST NIL CONSTANT.LIST CONSTRUCTION.DEFINITION NIL)))
	     (T					; A COMPLETE CONSTRUCTION.DEFINITION
	      (SETQ CONSTRUCTION.DEFINITION (COM=2=CONSTRUCTION.DEFINITION))
	      (RETURN (LIST NIL NIL CONSTRUCTION.DEFINITION))))))))

(DEFUN COM=2=CONSTRUCTION.DEFINITION NIL
  (DECLARE (special symbol))
						;Edited: 30-SEP-81 17:27:40
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <CONSTRUCTION DEFINITION> -> <> |
						;           <IDENTIFIER> (<SORT.SYMBOLLIST>)  <CONSTRUCTION DEFINITION TAIL>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E. NIL IF THE FIRST ALTERNATIVE APPLIES OR
						;        A LIST OF FORMS ((F1 S11 S12 .. S1N) (F2 S21 S22 .. S2N)..) WHERE FN ARE THE
						;        CODES RETURNED BY THE <IDENTIFIER> RULE , S1 IS THE CODE GENERATED BY THE
						;        <IDENTIFIER> RULE AND S2...SN IS THE CODE GENERATED BY THE <TYPELIST> RULE.
  (COND
    ((NULL COM*ERROR)
     (COND
       ((COM=1=SYMBOL.IS (IDENTIFIER NAME))
	(PROG (FSYMBOL SORT.SYMBOLLIST) (SETQ FSYMBOL (COM=2=IDENTIFIER.OR.NAME))
	      (COND
		((COM=1=SYMBOL.ACCEPTED (|(|)) (SETQ SORT.SYMBOLLIST (COM=2=SORT.SYMBOLLIST))
		 (COND
		   ((COM=1=SYMBOL.ACCEPTED (|)|))
                    (RETURN (CONS (CONS FSYMBOL SORT.SYMBOLLIST) (COM=2=CONSTRUCTION.DEFINITION.TAIL)))))))
	      (RETURN (COM=ERROR T 0))))
       (T NIL)))))

(DEFUN COM=2=CONSTRUCTION.DEFINITION.TAIL NIL
  (DECLARE (special symbol))
						;INPUT:  NONE
						;EFFECT: IMPLEMENTS -
						;        <CONSTRUCTION DEFINITION TAIL> -> <> | <CONSTRUCTION DEFINITION>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E. NIL OR THE LIST GENERATED BY
						;        <CONSTRUCTION DEFINITION>.
  (COND ((NULL COM*ERROR) (COND ((COM=1=SYMBOL.ACCEPTED (\,)) (COM=2=CONSTRUCTION.DEFINITION)) (T NIL)))))

(DEFUN COM=2=FUNCTION.DEFINITION NIL
  (DECLARE (special symbol))
						;EDITED: 16-FEB-82 16:53:30
						;input:  NONE
						;EFFECT: IMPLEMENTS - <FUNCTION DEFINITION> ->
						;          FUNCTION <IDENTIFIER> ( <PARAMETER LIST> ) : <IDENTIFIER>
						;           = <FUNCTION BODY>
						;VALUE:  THE CODE GENERATED BY THIS RULE , I.E.
						;        THE PREDICATE-LOGIC EQUIVALENT OF THIS FUNCTION DEFINITION
  (COND
    ((NULL COM*ERROR)
     (PROG
       ((EQUALITY (COM=3=ENTER.SYMBOL '= 'PREDICATE 2 '(ANY ANY) 'ANY '(DEFINED REFLEXIVE) '(EQUALITY)))
	F.SYMBOL FUNCTION.SYMBOL PARAMETER.LIST
	RANGE.SORT FUNCTION.BODY FUNCTION.HEAD)
       (COM=1=SYMBOL.ACCEPTED  (FUNCTION FN)) (SETQ FUNCTION.SYMBOL (COM=2=IDENTIFIER.OR.NAME))
       (COND
	 ((COM=1=SYMBOL.ACCEPTED (|(|)) (SETQ PARAMETER.LIST (COM=2=PARAMETER.LIST)) (COM=3=VSTACK.PUSH PARAMETER.LIST)
	  (SETQ PARAMETER.LIST (MAPCAR #'CADR PARAMETER.LIST))
	  (COND
	    ((AND (COM=1=SYMBOL.ACCEPTED (|)|)) (COM=1=SYMBOL.ACCEPTED (|:|))) (SETQ RANGE.SORT (COM=2=IDENTIFIER))
	     (COM=3=ENTER.SORT RANGE.SORT NIL NIL '(KNOWN.SYMBOL CONSTRUCTIVE.SYMBOL))
	     (SETQ F.SYMBOL
		   (COM=3=ENTER.SYMBOL FUNCTION.SYMBOL 'FUNCTION (LIST-LENGTH PARAMETER.LIST)
				       (MAPCAR #'(LAMBDA (ENTRY) (ST-GET.SYMBOL.CLASSIFICATION ENTRY 'RANGE)) PARAMETER.LIST)
				       RANGE.SORT
				       (CONS 'DEFINED nil)))
	     (COND
	       ((COM=1=SYMBOL.ACCEPTED (=)) (SETQ FUNCTION.BODY (COM=2=FUNCTION.BODY FUNCTION.SYMBOL))
		(SETQ FUNCTION.HEAD (CONS F.SYMBOL (COPY-TREE PARAMETER.LIST))) (COM=3=VSTACK.POP)
		(RETURN
		  (COM=QUANTIFICATION.CLOSURE
		    'ALL PARAMETER.LIST
		    (COM=JUNCTION.CLOSURE
		      'AND			; FUNCTION.BODY = (CONDITION.TERM ... )
		      (COND ((AND (CONSP FUNCTION.BODY) (CONSP (CAR FUNCTION.BODY))) 
			     (MAPCAR
			       #'(LAMBDA (CONDITION.TERM)
				   (COM=QUANTIFICATION.CLOSURE 'ALL (CAAR CONDITION.TERM)
							       (LIST 'IMPL (CDAR CONDITION.TERM)
								     (LIST '+ EQUALITY (LIST (COPY-TREE FUNCTION.HEAD)
											     (CDR CONDITION.TERM))
									   (LIST 'KIND (LIST 'DEF NIL FUNCTION.SYMBOL))))))
			       FUNCTION.BODY))
			    (T			; FUNCTION.BODY = TERM
			     (CONS
			       (LIST '+ '|:=| (LIST FUNCTION.HEAD FUNCTION.BODY) (LIST 'KIND (LIST 'DEF NIL FUNCTION.SYMBOL)))
			       nil))))))))))))
       (COM=ERROR T 0) F.SYMBOL))))

(DEFUN COM=2=PARAMETER.LIST NIL
						;EDITED: 27-JUL-81 15:21:50
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <PARAMETER LIST> ->
						;           <VARIABLE DECLARATION><PARAMETER TAIL>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E.
						;        A LIST,WHERE EACH TOPLEVEL ELEMENT IS THE CODE RETURNED BY THE
						;        <VARIABLE DECLARATION> RULE
  (COND ((NULL COM*ERROR) (NCONC (COM=2=VARIABLE.DECLARATION T '(KNOWN.SYMBOL)) (COM=2=PARAMETER.TAIL)))))

(DEFUN COM=2=PARAMETER.TAIL NIL
  (DECLARE (special symbol))
						;EDITED:  8-JUL-81 11:08:20
						;input:  NONE
						;EFFECT: IMPLEMENTS - <PARAMETER TAIL> -> <> | <PARAMETER LIST>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E. NIL OR THE CODE GENERATED BY THE
						;        <PARAMETER LIST> RULE
  (COND ((NULL COM*ERROR) (COND ((COM=1=SYMBOL.IS (|)|)) NIL) (T (COM=2=PARAMETER.LIST))))))

(DEFUN COM=2=FUNCTION.BODY (function.SYMBOL)
  (DECLARE (special symbol))
						;EDITED:  2-MAR-82 11:05:20
						;input:  FUNCTION.SYMBOL - A NAME OF A FUNCTION .
						;        PARAMETER.LIST  - A LIST OF FORMAL PARAM.
						;EFFECT: IMPLEMENTS -
						;        <FUNCTION BODY> -> <TERM> |  <FUNCTION IF CLAUSE LIST>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E. THE CODE GENERATED BY THE <TERM> OR BY
						;        THE <FUNCTION IF CLAUSE LIST> RULE
  (unless COM*ERROR
    (if (COM=1=SYMBOL.IS (IF))
	(COM=2=FUNCTION.IF.CLAUSE.LIST)
	(COM=2=TERM (CONS 'REC (CONS FUNCTION.SYMBOL '(KNOWN.SYMBOL CONSTRUCTIVE.SYMBOL)))))))

(DEFUN COM=2=FUNCTION.IF.CLAUSE.LIST NIL
  (DECLARE (special symbol))
						;EDITED:  2-MAR-82 11:03:52
						;input:  PARAMETER.LIST  - A LIST OF FORMAL PARAM.
						;EFFECT: IMPLEMENTS -  <FUNCTION IF CLAUSE LIST> ->
						;                      IF <CONDITION> THEN <TERM> <FUNCTION IF CLAUSE TAIL>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E. A LIST WHERE EACH TOPLEVEL ELEMENT IS A
						;        DOTTED PAIR OF FORM (CONDITION.TERM),
						;        WHERE CONDITION IS THE CODE GENERATED BY
						;        THE <CONDITION> RULE AND TERM IS THE CODE RETURNED BY THE <TERM> RULE
  (COND
    ((NULL COM*ERROR)
     (PROG (CONDITION TERM)
	   (COND
	     ((COM=1=SYMBOL.ACCEPTED (IF)) (SETQ CONDITION (COM=2=CONDITION))
	      (COND
		((COM=1=SYMBOL.ACCEPTED (THEN)) (SETQ TERM (COM=2=TERM '(CONSTRUCTIVE.SYMBOL KNOWN.SYMBOL))) (COM=3=VSTACK.POP)
		 (RETURN (NCONC (LIST (CONS CONDITION TERM)) (COM=2=FUNCTION.IF.CLAUSE.TAIL)))))))
	   (COM=ERROR T 0)))))

(DEFUN COM=2=FUNCTION.IF.CLAUSE.TAIL NIL
  (DECLARE (special symbol))
						;EDITED:  8-SEP-81 15:07:20
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <FUNCTION IF CLAUSE TAIL> -> <> |
						;                       <FUNCTION IF CLAUSE LIST>
						;VALUE:  THE CODE GENERATED BY THIS RULE , I.E.
						;        NIL OR THE CODE GENERATED BY THE  <FUNCTION IF CLAUSE LIST> RULE
  (COND ((NULL COM*ERROR) (COND ((COM=1=SYMBOL.IS (IF)) (COM=2=FUNCTION.IF.CLAUSE.LIST))))))

(DEFUN COM=2=CONDITION NIL
  (DECLARE (special symbol))
						;EDITED:  3-SEP-81 14:44:17
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <CONDITION> -> EX <VARIABLE DECLARATION>
						;                <CONDITION> | <IF CONJUNCTION.1>
						;VALUE:  THE CODE GENERATED BY THIS RULE , I.E.
						;        A DOTTED PAIR VD.CON , WHERE VD IS A LIST OF
						;        VARIABLE DECLARATIONS EACH OF WHICH IS
						;        RETURNED BY THE <VARIABLE DECLARATION> RULE AND
						;        CON IS THE CODE GENERATED BY THE
						;        <IF CONJUNCTION.1> RULE
  (COND
    ((NULL COM*ERROR)
     (PROG (VARIABLE.DECLARATION CONDITION)
	   (COND
	     ((COM=1=SYMBOL.ACCEPTED (EX)) (SETQ VARIABLE.DECLARATION (COM=2=VARIABLE.DECLARATION NIL '(KNOWN.SYMBOL)))
	      (COM=3=VSTACK.PUSH VARIABLE.DECLARATION) (SETQ CONDITION (COM=2=CONDITION))
	      (RETURN (CONS (SMAPCAR #'CADR (CAR CONDITION) VARIABLE.DECLARATION) (CDR CONDITION))))
	     (T (COM=3=VSTACK.PUSH NIL) (RETURN (CONS NIL (COM=2=IF.CONJUNCTION.1)))))))))

(DEFUN COM=2=IF.CONJUNCTION.1 NIL
						;EDITED:  9-JUL-81 11:03:29
						;input:  NONE
						;EFFECT: IMPLEMENTS - <IF CONJUNCTION 1> -> <LITERAL>
						;                              <IF CONJUNCTION.2>
						;VALUE:  THE CODE GENERATED BY THIS RULE , I.E.
						;        THE CODE GENERATED BY THE <LITERAL> RULE IF THE CODE
						;        RETURNED BY THE <IF CONJUNC-
						;        TION.2> RULE IS NIL , ELSE A LIST (AND LIT CON) WHERE LIT IS THE CODE
						;        GENERATED BY THE <LITERAL> RULE AND CON
						;        IS THE CODE RETURNED BY THE <IF CONJUNC-
						;        TION.2> RULE
  (COND
    ((NULL COM*ERROR)
     (PROG (LITERAL IF.CONJUNCTION.2) (SETQ LITERAL (COM=2=LITERAL)) (SETQ IF.CONJUNCTION.2 (COM=2=IF.CONJUNCTION.2))
	   (RETURN (COND (IF.CONJUNCTION.2 (LIST 'AND LITERAL IF.CONJUNCTION.2)) (T LITERAL)))))))

(DEFUN COM=2=IF.CONJUNCTION.2 NIL
  (DECLARE (special symbol))
						;EDITED:  9-JUL-81 11:04:27
						;input:  NONE
						;EFFECT: IMPLEMENTS - <IF CONJUNCTION.2> -> <> |
						;                          AND <IF CONJUNCTION.1>
						;VALUE:  THE CODE GENERATED BY THIS RULE , I.E.
						;        NIL OR THE CODE GENERATED BY THE <IF CONJUNCTION.1> RULE
  (COND ((NULL COM*ERROR) (COND ((COM=1=SYMBOL.ACCEPTED (AND)) (COM=2=IF.CONJUNCTION.1)) (T NIL)))))

(DEFUN COM=2=LITERAL NIL
  (DECLARE (special symbol))
						; EDITED:  1-MAR-82 12:44:48
						; INPUT:  NONE
						; EFFECT: IMPLEMENTS - <LITERAL> -> NOT <PROPOSITION> |
						;                                   <PROPOSITION>
						; VALUE:  THE CODE GENERATED BY THIS RULE , I.E.
						;         A LIST OF FORM (NOT PROPOSITION) OR PROPOSITION , WHERE PROPOSITION IS THE
						;         CODE GENERATED BY THE <PROPOSITION> RULE
  (COND
    ((NULL COM*ERROR)
     (PROG (ATOMAR.FORMULA PARAMETER.UNBOUND.VARIABLE)
	   (COND
	     ((COM=1=SYMBOL.ACCEPTED (NOT)) (SETQ ATOMAR.FORMULA (COM=2=PROPOSITION (CONS 'KNOWN.SYMBOL nil)))
	      (COM=3=INSERT.PROPERTY ATOMAR.FORMULA (LIST 'KIND (LIST 'CONDITION 'NOT.NEEDED)))
	      (COND
		((AND (NULL COM*ERROR)
		      (NOT (SETQ PARAMETER.UNBOUND.VARIABLE (COM=3=IS.PARAMETER.UNBOUND.ATOM ATOMAR.FORMULA))))
		 (RETURN (LIST 'NOT ATOMAR.FORMULA)))))
	     (T (SETQ ATOMAR.FORMULA (COM=2=PROPOSITION))
		(COND
		  ((NULL COM*ERROR)
		   (COND
		     ((AND (DT-PREDICATE.IS.EQUALITY (SECOND ATOMAR.FORMULA))
			   (OR (COM=3=IS.PARAMETER.BINDING (CAR (THIRD ATOMAR.FORMULA)) (SECOND (THIRD ATOMAR.FORMULA)))
			       (COND
				 ((COM=3=IS.PARAMETER.BINDING (SECOND (THIRD ATOMAR.FORMULA)) (CAR (THIRD ATOMAR.FORMULA)))
				  (RPLACA (CDDR ATOMAR.FORMULA) (NREVERSE (THIRD ATOMAR.FORMULA)))))))
		      (COM=3=INSERT.PROPERTY ATOMAR.FORMULA (LIST 'KIND (CONS 'MATCH nil))) (RETURN ATOMAR.FORMULA))
		     ((NOT (SETQ PARAMETER.UNBOUND.VARIABLE (COM=3=IS.PARAMETER.UNBOUND.ATOM ATOMAR.FORMULA)))
		      (COM=3=INSERT.PROPERTY ATOMAR.FORMULA (LIST 'KIND (LIST 'CONDITION 'NOT.NEEDED))) (RETURN ATOMAR.FORMULA))))
		  (T (RETURN NIL)))))
	   (COM=ERROR T 70 (COM=3=VSTACK.OLDNAME PARAMETER.UNBOUND.VARIABLE))))))

(DEFUN COM=2=PREDICATE.DEFINITION NIL
  (DECLARE (special symbol))
						;EDITED: 16-APR-82 12:27:32
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <PREDICATE DEFINITION> ->
						;          PREDICATE <IDENTIFIER>  ( <PARAMETER LIST> ) |
						;                             = <PREDICATE BODY>
						;VALUE:  THE CODE GENERATED BY THIS RULE , I.E.
						;        THE PREDICATE-LOGIC EQUIVALENT OF THIS PREDICATE DEFINITION
  (COND
    ((NULL COM*ERROR)
     (PROG (PREDICATE.SYMBOL PARAMETER.LIST PREDICATE.BODY #|PREDICATE.TERMLIST|# (PARTNUMBER 0) P.SYMBOL)
	   (COM=1=SYMBOL.ACCEPTED (PREDICATE)) (SETQ PREDICATE.SYMBOL (COM=2=IDENTIFIER.OR.NAME))
	   (COND
	     ((COM=1=SYMBOL.ACCEPTED (|(|)) (SETQ PARAMETER.LIST (COM=2=PARAMETER.LIST)) (COM=3=VSTACK.PUSH PARAMETER.LIST)
	      (SETQ PARAMETER.LIST (MAPCAR #'CADR PARAMETER.LIST))
	      (COND
		((COM=1=SYMBOL.ACCEPTED (|)|))
		 (SETQ P.SYMBOL
		       (COM=3=ENTER.SYMBOL PREDICATE.SYMBOL 'PREDICATE (LENGTH PARAMETER.LIST) PARAMETER.LIST NIL
					   (CONS 'DEFINED nil)))
		 (COND
		   ((COM=1=SYMBOL.ACCEPTED (=))
                    (SETQ PREDICATE.BODY
			  (COM=2=PREDICATE.BODY (CONS 'REC (CONS PREDICATE.SYMBOL '(CONSTRUCTIVE.SYMBOL KNOWN.SYMBOL)))))
                    (RETURN
                      (COM=QUANTIFICATION.CLOSURE
			'ALL PARAMETER.LIST
			(COM=JUNCTION.CLOSURE
			  'AND
			  (COND
			    ((AND (CONSP PREDICATE.BODY) (CONSP (CAR PREDICATE.BODY)))
						; PREDICATE.BODY = ( CONDITION.TERM ... )
			     (MAPCAR
			       #'(LAMBDA (CONDITION.TERM) (SETQ PARTNUMBER (1+ PARTNUMBER))
					 (COM=QUANTIFICATION.CLOSURE 'ALL (CAAR CONDITION.TERM)
								     (LIST 'IMPL (CDAR CONDITION.TERM)
									   (LIST 'EQV
										 (LIST '+ P.SYMBOL (COPY-TREE PARAMETER.LIST)
										       (LIST 'KIND (LIST 'DEF PARTNUMBER
													 PREDICATE.SYMBOL)))
										 (CDR CONDITION.TERM)))))
			       PREDICATE.BODY))
			    (T			; PREDICATE.BODY = THEN.QUANTIFICATION
			     (CONS
			       (LIST 'EQV
				     (LIST '+ P.SYMBOL (COPY-TREE PARAMETER.LIST) (LIST 'KIND (LIST 'DEF NIL PREDICATE.SYMBOL)))
				     PREDICATE.BODY)nil))))))))))))))))

(DEFUN COM=2=PREDICATE.BODY (ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED:  2-MAR-82 11:05:40
						;input:  PREDICATE.SYMBOL - A NAME OF A PREDICATE
						;        PARAMETER.LIST  - A LIST OF FORMAL PARAM.EFFECT: IMPLEMENTS -
						;       <PREDICATE BODY> -> <THEN QUANTIFICATION>|  <PREDICATE IF CLAUSE LIST>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E. THE <THEN QUANTIFICATION> RULE OR
						;        BY THE <PREDICATE IF CLAUSE LIST> RULE.
  (COND
    ((NULL COM*ERROR)
     (COND ((COM=1=SYMBOL.IS (IF)) (COM=2=PREDICATE.IF.CLAUSE.LIST ATTRIBUTES)) (T (COM=2=QUANTIFICATION ATTRIBUTES))))))

(DEFUN COM=2=PREDICATE.IF.CLAUSE.LIST (&optional ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED: 11-MAR-82 15:20:02
						;input:  PARAMETER.LIST  - A LIST OF FORMAL PARAM.
						;EFFECT: IMPLEMENTS -   <PREDICATE IF CLAUSE LIST> ->
						;        IF <CONDITION> THEN <THEN.QUANTIFICATION>  <PREDICATE IF CLAUSE TAIL>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E. A LIST WHERE
						;        EACH TOPLEVEL ELEMENT IS A
						;        DOTTED PAIR OF FORM (CONDITION.TERM) ,
						;        WHERE CONDITION IS THE CODE GENERATED BY
						;        THE <CONDITION> RULE AND TERM IS THE CODE
						;        GENERATED BY <THEN.QUANTIFICATION>
						;        RULE.
  (COND
    ((NULL COM*ERROR)
     (PROG (CONDITION THEN.QUANTIFICATION)
	   (COND
	     ((COM=1=SYMBOL.ACCEPTED (IF)) (SETQ CONDITION (COM=2=CONDITION))
	      (COND
		((COM=1=SYMBOL.ACCEPTED (THEN)) (SETQ THEN.QUANTIFICATION (COM=2=QUANTIFICATION ATTRIBUTES))
		 (RETURN (NCONC (LIST (CONS CONDITION THEN.QUANTIFICATION)) (COM=2=PREDICATE.IF.CLAUSE.TAIL)))))))
	   (COM=ERROR T 0)))))

(DEFUN COM=2=PREDICATE.IF.CLAUSE.TAIL NIL
  (DECLARE (special symbol))
						;EDITED:  8-SEP-81 15:11:28
						;input:  PARAMETER.LIST  - A LIST OF FORMAL PARAM.
						;EFFECT: IMPLEMENTS -  <PREDICATE IF CLAUSE TAIL> -> <> |
						;                      <PREDICATE IF CLAUSE LIST>
						;VALUE:  THE CODE GENERATED BY THIS RULE , I.E.
						;        NIL OR THE CODE GENERATED BY THE <PREDICATE IF CLAUSE LIST> RULE
  (COND ((NULL COM*ERROR) (COND ((COM=1=SYMBOL.IS (IF)) (COM=2=PREDICATE.IF.CLAUSE.LIST))))))

(DEFUN COM=2=VARIABLE.DECLARATION (PARAMETER.BOUNDED ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED: 27-JUL-81 15:24:42
						;input:  NONE
						;EFFECT: IMPLEMENTS - <VARIABLE DECLARATION> ->
						;         <IDENTIFIERLIST> <VARIABLE TYPE>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        A LIST X , WHERE (CAR X) IS A SORT SYMBOL ,AND (CDR X) IS A LIST OF
						;        RENAMED IDENTIFIERS
  (unless COM*ERROR
    (let (IDENTIFIER.LIST VARIABLE.TYPE RENAMED.IDENTIFIER.LIST)
      (SETQ IDENTIFIER.LIST (COM=2=IDENTIFIER.LIST))
      (SETQ VARIABLE.TYPE (COND ((COM=2=VARIABLE.TYPE))
				((opt-get.option sort_literals) (dt-constant.omega))
				(T 'ANY)))
      (COM=3=ENTER.SORT VARIABLE.TYPE NIL NIL ATTRIBUTES)
      (SETQ RENAMED.IDENTIFIER.LIST
	    (MAPCAR #'(LAMBDA (IDENTIFIER) (LIST IDENTIFIER (ST-CREATE.VARIABLE VARIABLE.TYPE) PARAMETER.BOUNDED))
		    IDENTIFIER.LIST))
      RENAMED.IDENTIFIER.LIST)))

(DEFUN COM=2=VARIABLE.TYPE NIL
  (DECLARE (special symbol))
						;EDITED:  8-SEP-81 12:46:50
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <VARIABLE TYPE> ->
						;         <> | : <SORT.SYMBOL>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        NIL OR AN ATOM WHICH DENOTES A TYPE SYMBOL
  (unless COM*ERROR
    (if (COM=1=SYMBOL.ACCEPTED (|:|))
	(if (opt-get.option sort_literals)
	    (COM=2=SORT.term)
	    (COM=2=SORT.SYMBOL))
	NIL)))

(DEFUN COM=2=PROPOSITION (&optional ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED:  6-MAR-81 14:14:50
						;input:  NONE
						;EFFECT: IMPLEMENTS - <PROPOSITION> ->
						;                    <IDENTIFIER><ATOM> | <NUMBER><EQUALITY SYMBOL><TERM>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E.,A LIST X WHERE
						;        (CAR X) IS A PREDICATE SYMBOL. (CADR X) TO (CAD...DR X) ARE
						;        TERMLIST,I.E. TERMS IN LIST NOTATION.
  (unless COM*ERROR
    (let (IDENTIFIER ATOM (ARITY 0) NUMBER EQUALITY.SYMBOL TERM)
      (declare (special arity))
      (COND
	((COM=1=SYMBOL.IS (IDENTIFIER NAME))
	 (SETQ IDENTIFIER (COM=2=IDENTIFIER.OR.name))
	 (SETQ ATOM (COM=2=ATOM ATTRIBUTES))
	 (unless com*error
	   (COND ((CDR ATOM)			; EQUALI
		  (SETQ IDENTIFIER
			(COND ((CAR ATOM) (COM=3=ENTER.SYMBOL IDENTIFIER 'FUNCTION ARITY NIL NIL NIL ATTRIBUTES))
			      ((COM=3=VSTACK.NEWNAME IDENTIFIER))
			      (T (COM=3=ENTER.SYMBOL IDENTIFIER 'CONSTANT 0 NIL NIL NIL ATTRIBUTES))))
		  (LIST '+ (CAR (SECOND ATOM))
			(LIST (COND ((CAR ATOM) (CONS IDENTIFIER (CAR ATOM))) (T IDENTIFIER))
			      (THIRD ATOM))
			NIL))
		 (T				; PROPOSITION OR ATOM
		  (LIST '+ (COM=3=ENTER.SYMBOL IDENTIFIER 'PREDICATE ARITY NIL NIL NIL ATTRIBUTES) (CAR ATOM) NIL)))))
	(T (SETQ NUMBER (COM=2=NUMBER))
	   (SETQ EQUALITY.SYMBOL (COM=2=EQUALITY.SYMBOL))
	   (SETQ TERM (COM=2=TERM ATTRIBUTES))
	   (LIST '+
		 (first EQUALITY.SYMBOL)
		 (LIST (COM=3=ENTER.SYMBOL NUMBER 'CONSTANT NIL NIL NIL NIL ATTRIBUTES) TERM)
		 NIL))))))

(DEFUN COM=2=ATOM (ATTRIBUTES)
  (DECLARE (special symbol arity))
						; EDITED: 5-MAR-81 12:08:48
						; INPUT:  NONE
						; EFFECT: IMPLEMENts -    <ATOM> -> <> | <EQUALITY> |
						;               (<TERM><TERMLIST>)<EQUALITY>
						; VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        NIL OR A LIST X , WHERE (CAR X) IS A EMPTY OR  NONEMPTY LIST OF TERMS
						;        WHERE EACH TERM IS IN LISTNOTATION (CDR X) IS THE CODE GENERATED BY THE
						;        <EQUALITY> -> ... RULE
  (unless COM*ERROR
    (prog (TERM TERMLIST EQUALITY)
	  (COND
	    ((COM=1=SYMBOL.ACCEPTED (|(|))
	     (SETQ TERM (COM=2=TERM ATTRIBUTES))
	     (SETQ ARITY (1+ ARITY))
	     (unless com*error
	       (SETQ TERMLIST (COM=2=TERMLIST ATTRIBUTES))
	       (COND
		 ((COM=1=SYMBOL.ACCEPTED (|)|)) (SETQ EQUALITY (COM=2=EQUALITY ATTRIBUTES))
		  (RETURN (CONS (NCONC (LIST TERM) TERMLIST) EQUALITY)))
		 (T (COM=ERROR T 0)))))
	    ((COM=1=SYMBOL.IS (= |:=| |=:| |:=:|))
	     (SETQ EQUALITY (COM=2=EQUALITY))
	     (RETURN (CONS NIL EQUALITY)))
	    (T (RETURN NIL))))))

(DEFUN COM=2=EQUALITY (&optional ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED: 24-FEB-81 16:24:39
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <EQUALITY> -> <> |
						;                  <EQUALITY SYMBOL><TERM>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        NIL OR A LIST X , WHERE  (CAR X) IS THE CODE OF 'EQUALITY
						;        SYMBOL' AND (CADR X) IS THE CODE OF 'TERM'
  (COND
    ((NULL COM*ERROR)
     (PROG (EQUALITY.SYMBOL TERM)
	   (COND
	     ((COM=1=SYMBOL.IS (= |:=| |=:| |:=:|)) (SETQ EQUALITY.SYMBOL (COM=2=EQUALITY.SYMBOL))
	      (SETQ TERM (COM=2=TERM ATTRIBUTES))
	      (RETURN (LIST EQUALITY.SYMBOL TERM)))
	     (T (RETURN NIL)))))))

(DEFUN COM=2=EQUALITY.SYMBOL NIL
  (DECLARE (special symbol))
						;EDITED:  5-MAR-81 12:12:40
						;input:  NONE
						;EFFECT: IMPLEMENTS -                             <EQUALITY SYMBOL> -> ...
						;VALUE:  EQUALITY SYMBOL (AN ATOM)
  (unless COM*ERROR
    (COND ((COM=1=SYMBOL.IS (= |:=| |=:| |:=:|))
	   (PROG1 (CONS (COM=3=ENTER.SYMBOL '= 'PREDICATE 2 NIL NIL (LIST 'DEFINED 'SYMMETRIC 'REFLEXIVE) (CONS 'EQUALITY nil))
			SYMBOL)
		  (COM=1=SYMBOL.ACCEPTED (= |:=| |=:| |:=:|))))
	  (T (COM=ERROR T 0)))))

(DEFUN COM=2=TERM (ATTRIBUTES)
  (DECLARE (special symbol))
						;EDITED:  9-MAR-81 16:28:52
						;input:  NONE
						;EFFECT: IMPLEMENTS - <TERM> -> <IDENTIFIER><TERMTAIL> |
						;                   <NUMBER>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.
						;        IF THE FIRST ALTERNATIVE APPLIES AND THE CODE RETURNED BY THE 'TERMTAIL'
						;        RULE IS NOT NIL, A LIST X WHERE (CAR X) IS THE CODE OF THE
						;        'IDENTIFIER' RULE AND (CDR X) IS THE CODE RETURNED BY THE 'TERMTAIL'
						;        RULE , ELSE THE CODE RETURNED BY THE 'IDENTIFIER' RULE.
						;        FOR THE SECOND ALTERNATIVE THE CODE IS THE CODE RETURNED BY THE 'NUMBER'
						;        RULE.
  (unless COM*ERROR
    (let (IDENTIFIER TERMTAIL (ARITY 0) NUMBER)
      (declare (SPECIAL ARITY)) 
      (COND
	((COM=1=SYMBOL.IS (IDENTIFIER NAME))
	 (SETQ IDENTIFIER (COM=2=IDENTIFIER.OR.NAME))
	 (SETQ TERMTAIL (COM=2=TERMTAIL ATTRIBUTES))
	 (COND (TERMTAIL (CONS (COM=3=ENTER.SYMBOL IDENTIFIER 'FUNCTION ARITY NIL NIL NIL ATTRIBUTES) TERMTAIL))
	       ((COM=3=VSTACK.NEWNAME IDENTIFIER))
	       (T (COM=3=ENTER.SYMBOL IDENTIFIER 'CONSTANT 0 NIL NIL NIL ATTRIBUTES))))
	(T (SETQ NUMBER (COM=2=NUMBER))
	   (COM=3=ENTER.SYMBOL NUMBER 'CONSTANT NIL NIL NIL NIL ATTRIBUTES))))))

(DEFUN COM=2=TERMTAIL (ATTRIBUTES)
  (DECLARE (special symbol arity))
						;EDITED:  6-MAR-81 16:33:55
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <TERMTAIL> -> <>| (<TERM><TERMLIST>)
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E. NIL OR A LIST X WHERE (CAR X) IS THE
						;        CODE GENERATED BY THE 'TERM' RULE  AND (CDR X) IS THE CODE RETURNED BY
						;        'TERMLIST' RULE.
  (unless COM*ERROR
    (let (TERM TERMLIST)
      (COND
	((COM=1=SYMBOL.accepted (|(|))
	 (SETQ TERM (COM=2=TERM ATTRIBUTES))
	 (SETQ ARITY (1+ ARITY))
	 (SETQ TERMLIST (COM=2=TERMLIST ATTRIBUTES))
	 (COND ((COM=1=SYMBOL.ACCEPTED (|)|))
		(CONS TERM TERMLIST)) (T (COM=ERROR T 0))))
	(T NIL)))))

(DEFUN COM=2=TERMLIST (ATTRIBUTES)
  (DECLARE (special symbol arity))
						;EDITED:  6-MAR-81 16:33:12
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <TERMLIST> -> <> | <TERM><TERMLIST>
						;VALUE:  THE CODE GENERATED BY THIS RULE,I.E.  NIL OR A LIST X WHERE (CAR X) IS THE
						;        CODE GENERATED BY THE 'TERM' RULE  AND (CDR X) IS THE CODE RETURNED BY
						;        'TERMLIST' RULE.
  (COND
    ((NULL COM*ERROR)
     (PROG (TERM TERMLIST)
	   (COND ((COM=1=SYMBOL.IS (|)|)) (RETURN NIL))
		 (T (SETQ TERM (COM=2=TERM ATTRIBUTES)) (SETQ ARITY (1+ ARITY)) (SETQ TERMLIST (COM=2=TERMLIST ATTRIBUTES))
		    (RETURN (CONS TERM TERMLIST))))))))

(DEFUN COM=2=IDENTIFIER.LIST NIL
						;EDITED: 24-JUL-81 16:17:28
						;INPUT:  NONE
						;EFFECT: IMPLEMENTS -  <IDENTIFIERLIST> -> <IDENTIFIER>
						;                            <IDENTIFIERTAIL>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E.
						;        A LIST THE CAR OF WHICH IS THE CODE GENERATED BY THE <IDENTIFIER> RULE
						;        AND THE CDR OF WHICH IS THE CODE RETURNED BY THE <IDENTIFIERTAIL> RULE
  (COND ((NULL COM*ERROR) (CONS (COM=2=IDENTIFIER) (COM=2=IDENTIFIER.TAIL)))))

(DEFUN COM=2=IDENTIFIER.TAIL NIL
  (DECLARE (special symbol))
						;EDITED: 24-JUL-81 18:04:56
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <IDENTIFIERTAIL> -> <> |
						;                            , <IDENTIFIERLIST>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E.
						;        NIL OR  THE CODE  RETURNED BY THE <IDENTIFIERLIST> RULE
  (COND ((NULL COM*ERROR)
	 (COND ((COM=1=SYMBOL.ACCEPTED (\,)) (COM=2=IDENTIFIER.LIST)) (T NIL)))))

(DEFUN COM=2=CONSTANT.LIST NIL
  (DECLARE (special symbol))
						;EDITED:  1-OCT-81 15:55:49
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <CONSTANT LIST>  ->
						;                      <NAME> <CONSTANT TAIL> | <NUMBER> <CONSTANT TAIL> |
						;                  <IDENTIFIER> <CONSTANT TAIL>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E.
						;        A LIST THE CAR OF WHICH IS THE CODE GENERATED BY THE <NUMBER>, <NAME> OR
						;        <IDENTIFIER> RULE AND THE CDR OF WHICH IS THE CODE
						;        RETURNED BY THE <CONSTANT TAIL>  RULE
  (COND
    ((NULL COM*ERROR)
     (CONS
       (COND ((COM=1=SYMBOL.IS (NUMBER)) (COM=2=NUMBER)) ((COM=1=SYMBOL.IS (NAME)) (COM=2=NAME)) (T (COM=2=IDENTIFIER)))
       (COM=2=CONSTANT.TAIL)))))

(DEFUN COM=2=CONSTANT.TAIL NIL
  (DECLARE (special symbol))
						;EDITED: 30-SEP-81 16:16:56
						;input:  NONE
						;EFFECT: IMPLEMENTS - <CONSTANT TAIL>     -> <> |
						;                            , <CONSTANT LIST>
  ;VALUE:  THE CODE GENERATED BY THIS RULE, I.E.
						;        NIL OR THE CODE RETURNED BY THE <CONSTANT LIST>  RULE
  (COND ((NULL COM*ERROR) (COND ((COM=1=SYMBOL.ACCEPTED (\,)) (COM=2=CONSTANT.LIST)) (T NIL)))))

(DEFUN COM=2=IDENTIFIER.OR.NAME NIL
  (DECLARE (special symbol))
						;        RENAMING
						;EFFECT: IMPLEMENTS -
						;        <IDENTIFIER OR NAME> ->  <IDENTIFIER> | <NAME>
						;VALUE:  THE CODE GENERATED BY THIS RULE I.E. THE CODE RETURNED BY <NAME>
						;        OR BY <IDENTIFIER>.
  (unless COM*ERROR
    (if (COM=1=SYMBOL.IS (IDENTIFIER))
	(COM=2=IDENTIFIER)
	(COM=2=NAME))))

(DEFUN COM=2=IDENTIFIER ()
  (DECLARE (special symbol))
						;EDITED: 17-JUL-81 11:38:08
						;input:  AN ATOM,WHICH INDICATES VARIABLE
						;        RENAMING
						;EFFECT: IMPLEMENTS -
						;        <IDENTIFIER> -> ...
						;VALUE:  AN ATOM ,WHICH IS THE RENAMED
						;        VARIABLE SYMBOL OF THE IDENTIFIER IF IT IS A VARIABLE AND
						;        'DONT.RENAME' IS NIL , ELSE THE IDENTIFIER SYMBOL ITSELF
  (unless COM*ERROR
    (let ((IDENTIFIER SYMBOL))
      (if (COM=1=SYMBOL.ACCEPTED (IDENTIFIER))
	  (CDR IDENTIFIER)
	  (COM=ERROR T 0 "No identifier")))))

(DEFUN COM=2=NUMBER NIL
  (DECLARE (special symbol))
						;EDITED:  6-MAR-81 11:29:20
						;input:  NONE
						;EFFECT: IMPLEMENTS - <NUMBER> -> ...
						;VALUE:  A NUMBER (I.E. AN ATOM)
  (unless COM*ERROR
    (if (COM=1=SYMBOL.IS (NUMBER))
	(PROG1 (CDR SYMBOL) (COM=1=SYMBOL.ACCEPTED (NUMBER)))
	(COM=ERROR T 0 (format nil "~A no number" symbol)))))

(DEFUN COM=2=NAME NIL
  (DECLARE (special symbol))
						;EDITED:  5-MAR-81 12:11:57
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <NAME> -> ...
						;VALUE:  NAME SYMBOL (AN ATOM)
  (COND
    ((NULL COM*ERROR)
     (COND ((COM=1=SYMBOL.IS (NAME)) (PROG1 (CDR SYMBOL) (COM=1=SYMBOL.ACCEPTED (NAME)))) (T (COM=ERROR T 0 "No name"))))))

(DEFUN COM=2=SORT.SYMBOL NIL
  (DECLARE (special symbol))
						; EDITED: 17-JUL-81 11:38:08
						; INPUT:  NONE
						; EFFECT: IMPLEMENTS - <SORT.SYMBOL> -> ANY |
						;                                           <IDENTIFIER>
						; VALUE:  AN ATOM ,WHICH IS THE IDENTIFIER
						;         SYMBOL ITSELF.
  (unless COM*ERROR
    (let ((SORT SYMBOL))
      (COND ((COM=1=SYMBOL.ACCEPTED (ANY)) 'ANY)
	    ((COM=1=SYMBOL.ACCEPTED (IDENTIFIER)) (CDR SORT))
	    (T (COM=ERROR T 0))))))

(DEFUN COM=2=SORT.term NIL
  (DECLARE (special symbol))
						; EDITED: 17-JUL-81 11:38:08
						; INPUT:  NONE
						; EFFECT: IMPLEMENTS - <SORT.SYMBOL> -> ANY |
						;                                           <IDENTIFIER>
						; VALUE:  AN ATOM ,WHICH IS THE IDENTIFIER
						;         SYMBOL ITSELF.
  (let ((sort symbol))
    (unless COM*ERROR
      (COND ((COM=1=SYMBOL.ACCEPTED (ANY)) (dt-constant.omega))
	    ((com=1=symbol.accepted (|(|))
	     (let ((term (COM=2=term nil)))
	       (if (com=1=symbol.accepted (|)|))
		   term
		   (COM=ERROR T 0))))
	    ((COM=1=SYMBOL.ACCEPTED (IDENTIFIER)) (ST-GET.SYMBOL.CLASSIFICATION (cdr sort) 'address))
	    (T (COM=ERROR T 0))))))

(DEFUN COM=2=SORT.SYMBOLLIST NIL
						;EDITED: 24-JUL-81 16:17:28
						;INPUT:  NONE
						;EFFECT: IMPLEMENTS - <SORT.SYMBOLLIST> -> <SORT.SYMBOL> <SORT.SYMBOL.TAIL>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E.
						;        A LIST THE CAR OF WHICH IS THE CODE GENERATED BY THE <SORT.SYMBOL> RULE
						;        AND THE CDR OF WHICH IS THE CODE RETURNED BY THE <SORT.SYMBOL.TAIL>RULE
  (unless COM*ERROR (CONS (COM=2=SORT.SYMBOL) (COM=2=SORT.SYMBOL.TAIL))))

(DEFUN COM=2=SORT.SYMBOL.TAIL NIL
  (DECLARE (special symbol))
						;EDITED: 30-SEP-81 16:02:00
						;input:  NONE
						;EFFECT: IMPLEMENTS -  <SORT.SYMBOL.TAIL> ->
						;           <SORT.SYMBOL> <SORT.SYMBOL.TAIL>  <TYPELIST>) |
						;                          , <CONSTANT LIST>
						;VALUE: NIL OR A LIST X ,WHERE (CAR X) IS THE
						;       VALUE OF THE 'IDENTIFIER' RULE AND (CDR X) IS THE VALUE OF THE 'TYPELIST
						;       RULE. IF THE 3.RD ALTERNATIVE APPLIES THE VALUE IS A LIST , THE CAR OF
						;       WHICH IS THE CODE RETURNED BY THE <CONSTANT LIST> RULE .
  (COND
    ((NULL COM*ERROR)
     (PROG (SORT.SYMBOL SORT.SYMBOL.TAIL)
	   (COND
	     ((COM=1=SYMBOL.IS (IDENTIFIER ANY)) (SETQ SORT.SYMBOL (COM=2=SORT.SYMBOL))
	      (SETQ SORT.SYMBOL.TAIL (COM=2=SORT.SYMBOL.TAIL)) (RETURN (CONS SORT.SYMBOL SORT.SYMBOL.TAIL)))
	     (T (RETURN NIL)))))))

(DEFUN COM=2=SORT.SYMBOL.SEQUENCE NIL
						;EDITED: 24-JUL-81 16:17:28
						;input:  NONE
						;EFFECT: IMPLEMENTS - <SORT.SYMBOL.SEQUENCE> -> <SORT.SYMBOL>
						;                   <SORT.SYMBOL.SEQUENCE.TAIL>
						;VALUE:  THE CODE GENERATED BY THIS RULE, I.E.
						;        A LIST THE CAR OF WHICH IS THE CODE GENERATED BY THE <SORT.SYMBOL> RULE
						;        AND THE CDR OF WHICH IS THE CODE RETURNED BY<SORT.SYMBOL.SEQUENCE.TAIL>
						;        RULE.
  (COND ((NULL COM*ERROR) (CONS (COM=2=SORT.SYMBOL) (COM=2=SORT.SYMBOL.SEQUENCE.TAIL)))))

(DEFUN COM=2=SORT.SYMBOL.SEQUENCE.TAIL NIL
  (DECLARE (special symbol))
						;EDITED: 30-SEP-81 16:02:00
						;input:  NONE
						;EFFECT: IMPLEMENTS - <SORT.SYMBOL.SEQUENCE.TAIL> ->
						;               <SORT.SYMBOL> <SORT.SYMBOL.SEQUENCE.TAIL> |
						;VALUE: NIL OR A LIST OF VALUES RETURNED BY THE <SORT.SYMBOL> RULE.
  (COND ((NULL COM*ERROR) (COND ((COM=1=SYMBOL.ACCEPTED (\,)) (COM=2=SORT.SYMBOL.SEQUENCE)) (T NIL)))))

(DEFUN COM=QUANTIFICATION.CLOSURE (QUANTOR VARIABLE.LIST FORMULA)
						;EDITED:  3-SEP-81 14:28:45
						;input:  QUANTOR - ONE OF THE LITATOMS ALL OR EX
						;        LIST.OF.VARIABLE.DECLARATIONS
						;        - A LIST OF FORM (VD.1 ... VD.N) WHERE EACH VD.I IS A
						;        LIST OF FORM (SORT VAR.1 ... VAR.M)
						;        FORMULA - A SEXPR REPRESENTING A
						;                   PREDICATELOGIC FORMULA IN LIST NOTATION
						;EFFECT: RETURNS VALUE
						;VALUE:  THE QUANTIFICATION-CLOSURE OF THE GIVEN
						;        FORMULA W.R.T. TO QUANTOR AND LIST.OF.VARIABLE.DECLARATIONS
  (COND
    ((NULL COM*ERROR)
     (PROG ((RESULT FORMULA))
	   (MAPC #'(LAMBDA (VARIABLE) (SETQ RESULT (LIST QUANTOR VARIABLE RESULT))) VARIABLE.LIST) (RETURN RESULT)))))

(DEFUN COM=JUNCTION.CLOSURE (JUNCTOR FORMULAS)
  (unless COM*ERROR
    (let ((CODE (CAR FORMULAS)))
      (MAPC #'(LAMBDA (FORMULA) (SETQ CODE (LIST JUNCTOR FORMULA CODE))) (CDR FORMULAS))
      CODE)))

(DEFUN COM=CREATE.STRUCTURE.SCHEME (CONSTR.DEF)
  (PROG ((VARS (MAPCAR #'(LAMBDA (SORT) (ST-CREATE.VARIABLE SORT)) (CDR CONSTR.DEF))))
	(RETURN (CONS (CONS (ST-GET.SYMBOL.CLASSIFICATION (CAR CONSTR.DEF) 'ADDRESS) VARS) VARS))))

(DEFUN COM=3=ENTER.SYMBOL (&optional SYMBOLNAME SYMBOLKIND SYMBOLARITY SYMBOLDOMAIN SYMBOLRANGE SYMBOLATTRIBUTE SEM.ATTRIBUTES)
						;EDITED: 11-MAR-82 15:30:10
						;input:  SYMBOLNAME - AN ATOM
						;        SYMBOLKIND - ONE OF THE ATOMS:  CONSTANT
						;            VARIABLE FUNCTION
						;            PREDICATE SORT
						;            DENOTING THE KIND OF THE SYMBOL 'SYMBOLNAME'
						;            SYMBOLARITY- A POSITIVE INTEGER DENOTING THE ARITY OF
						;            THE SYMBOL 'SYMBOLNAME' IF 'SYMBOLKIND' IS
						;            FUNCTION OR PREDICATE SYMBOLDOMAIN - A LINEAR LIST WHERE
						;            EACH TOPLEVELATOM IS A SORTSYMBOL DENO-
						;            TING THE DOMAIN OF THE SYMBOL'SYMBOLNAME
						;            IF 'SYMBOLKIND' IS'NT SORT , ELSE A SORT-
						;            SYMBOL DENOTING A SUBSORT OF THE SYMBOL
						;            SYMBOLNAME SYMBOLRANGE - A SORTSYMBOL DENOTING
						;            THE RANGE OF THE SYMBOL 'SYMBOLNAME' IF 'SYMBOL
						;            KIND' IS NOT 'SORT' ELSE DENOTING A SUPER-
						;            SORT OF SORTSYMBOL 'SYMBOLNAME'
						;        SYMBOLATTRIBUTE - ONE OF THE ATOMS NIL
						;            SYMMETRIC DEFINED
						;            STRUCTURE ?STRUCTURE
						;            ANNOUNCED.STRUCTURE ORDER
						;            ORDER*
						;EFFECT: ENTERS SYMBOL 'SYMBOLNAME' IN THE
						;        SYMBOLTABLE TOGETHER WITH ALL ITS ATTRIBUTES (I.E. THE REMAINING PARA-
						;        METERS OF THIS FUNCTION) IF SYMBOL 'SYMBOLNAME' IS NOT ALREADY MENTIONED
						;        ELSE PERFORMS A COMPATIBILITY CHECK BETWEEN THE ARGUMENTS AND THE
						;        DESCRIPTION OF SYMBOL 'SYMBOLNAME' IN THE SYMBOLTABLE.
						;        IN CASE OF INCOMPATIBILITY AN ERROR MESSAGE IS EMITTED AND THE ERROR-
						;        FLAGS ARE SET.
						;VALUE:  UNDEFINED
						;REMARKS: THE SEMANTIC CHECK//S ARE CONTROLLED  BY THE GLOBAL VARIABLES :
						;         RECURSIVE.SYMBOL - CONTAINS A SYMBOL
						;        -NAME WHOSE USAGE IS NOT ALLOWED IN THE CONTEXT UNDER ANALYSYS
						;         CONSTRUCTIVE.SYMBOL - (T//NIL) INDI-
						;        CATES THAT IN THE CONTEXT UNDER ANALYSYS EACH CONSTANT -,FUNCTION -,
						;        AND PREDICATE-SYMBOL HAS TO BE  INTRODUCED BY A STRUCTURE-,
						;        FUNCTION - OR PREDICATE-DEFINITION  AND THAT EACH VARIABLE SYMBOL HAS TO
						;        BE A PARAMETER BOUND VARIABLE.
						;        KNOWN.SYMBOL - (T//NIL) INDICATES THAT EVERY SYMBOL DIFFERNT FROM A
						;        VARIABLE MUST BE KNOWN IN THE CONTEXT UNDER ANALYSYS
						;        NON.CONSTRUCTIVEFLG - (T//NIL)  INDICATES IN THE CONTEXT UNDER
						;        ANALYSYS A PREDICATE-DEFINITION, THIS PREDICATE HAS AN INCONSTRUCTIVE
						;        DEFINITIONPART.
  (unless COM*ERROR
    (PROG
      ((KIND (ST-GET.SYMBOL.CLASSIFICATION SYMBOLNAME 'KIND)) (ARITY (ST-GET.SYMBOL.CLASSIFICATION SYMBOLNAME 'ARITY))
       (DOMAIN (ST-GET.SYMBOL.CLASSIFICATION SYMBOLNAME 'DOMAIN)) (RANGE (ST-GET.SYMBOL.CLASSIFICATION SYMBOLNAME 'RANGE))
       (ATTRIBUTE (ST-GET.SYMBOL.CLASSIFICATION SYMBOLNAME 'ATTRIBUTE))
       (ADDRESS (ST-GET.SYMBOL.CLASSIFICATION SYMBOLNAME 'ADDRESS)))
      (COND ((AND KIND SYMBOLKIND (NEQ KIND SYMBOLKIND)) (COM=ERROR T 2 KIND SYMBOLNAME SYMBOLKIND))
	    ((AND (NULL KIND) (MEMBER 'KNOWN.SYMBOL SEM.ATTRIBUTES)) (COM=ERROR T 4 SYMBOLKIND SYMBOLNAME))
	    ((AND (MEMBER 'CONSTRUCTIVE.SYMBOL SEM.ATTRIBUTES) (NULL (INTERSECTION '(STRUCTURE DEFINED) ATTRIBUTE)))
	     (COM=ERROR T 5 SYMBOLKIND SYMBOLNAME))
	    (T (COND ((AND (MEMBER SYMBOLKIND '(FUNCTION CONSTANT)) (NULL SYMBOLRANGE) (NULL KIND))
		      (SETQ SYMBOLRANGE 'ANY)))
	       (COND ((AND (MEMBER SYMBOLKIND '(FUNCTION PREDICATE)) (NULL DOMAIN) (NULL SYMBOLDOMAIN))
		      (SETQ SYMBOLDOMAIN (let (X) (DODOWN (RPTN SYMBOLARITY) (SETQ X (CONS 'ANY X))) X))))
	       (COND ((NULL KIND)
		      (SETQ ADDRESS
			    (ST-ENTER.SYMBOLENTRY SYMBOLNAME SYMBOLKIND SYMBOLARITY SYMBOLATTRIBUTE SYMBOLDOMAIN SYMBOLRANGE)))
		     (T (COND ((AND (INTERSECTION '(?STRUCTURE STRUCTURE DEFINED) SYMBOLATTRIBUTE)
				    (NOT (MEMBER '?STRUCTURE ATTRIBUTE)))
			       (COND ((NOT (MEMBER 'EQUALITY SEM.ATTRIBUTES)) (COM=ERROR T 3 SYMBOLKIND SYMBOLNAME)))))
			(CASE SYMBOLKIND
			  (CONSTANT (COND
				      ((AND SYMBOLRANGE RANGE (NEQ SYMBOLRANGE RANGE))
				       (COM=ERROR T 14 SYMBOLNAME RANGE SYMBOLRANGE))))
			  (FUNCTION (COND ((EQL (CADR (MEMBER 'REC SEM.ATTRIBUTES :TEST (FUNCTION EQUAL))) SYMBOLNAME)
					   (COM=ERROR T 31 SYMBOLNAME))
					  ((NEQ SYMBOLARITY ARITY) (COM=ERROR T 23 ARITY SYMBOLNAME SYMBOLARITY))
					  ((AND SYMBOLDOMAIN DOMAIN (NOT (EQUAL SYMBOLDOMAIN DOMAIN)))
					   (COM=ERROR T 26 SYMBOLNAME DOMAIN RANGE SYMBOLDOMAIN))
					  ((AND SYMBOLRANGE RANGE (NEQ SYMBOLRANGE RANGE))
					   (COM=ERROR T 27 SYMBOLNAME DOMAIN RANGE SYMBOLRANGE))
					  ((AND SYMBOLATTRIBUTE (NOT (MEMBER SYMBOLATTRIBUTE ATTRIBUTE)))
					   (SETQ ADDRESS
						 (ST-ENTER.SYMBOL.CLASSIFICATION
						   SYMBOLNAME 'ATTRIBUTE (UNION SYMBOLATTRIBUTE ATTRIBUTE))))))
			  (PREDICATE (COND ((EQL (CADR (MEMBER 'REC SEM.ATTRIBUTES :TEST #'EQUAL)) SYMBOLNAME)
					    (COM=ERROR T 40 SYMBOLNAME))
					   ((NEQ SYMBOLARITY ARITY) (COM=ERROR T 34 ARITY SYMBOLNAME SYMBOLARITY))
					   ((AND SYMBOLDOMAIN DOMAIN (NOT (EQUAL SYMBOLDOMAIN DOMAIN)))
					     (COM=ERROR T 36 SYMBOLNAME DOMAIN SYMBOLDOMAIN))
					   (SYMBOLATTRIBUTE
					    (SETQ ADDRESS
						  (ST-ENTER.SYMBOL.CLASSIFICATION
						    SYMBOLNAME 'ATTRIBUTE (UNION SYMBOLATTRIBUTE ATTRIBUTE))))))
			  (OTHERWISE (ERROR "COM=3=ENTER.SYMBOL - INVALID PARAMETER : SYMBOLKIND = ~A" SYMBOLKIND)))))))
      (COND ((AND (NULL COM*ERROR) (NOT (MEMBER SYMBOLNAME COM*USED.SYMBOLS)))
	     (SETQ COM*USED.SYMBOLS (CONS SYMBOLNAME COM*USED.SYMBOLS))))
      (RETURN ADDRESS))))

(DEFUN COM=3=ENTER.SORT (SYMBOLNAME SYMBOLRANGE &optional SYMBOLATTRIBUTE SEM.ATTRIBUTES)
  (when (or (not (opt-get.option sort_literals)) (eq 'any symbolname))
    (let ((KIND (ST-GET.SYMBOL.CLASSIFICATION SYMBOLNAME 'KIND))
	  (RANGE (ST-GET.SYMBOL.CLASSIFICATION SYMBOLNAME 'RANGE))
	  (ATTRIBUTE (ST-GET.SYMBOL.CLASSIFICATION SYMBOLNAME 'ATTRIBUTE)) S.KIND)
      (COND ((MEMBER-IF #'(LAMBDA (SORT)
			    (COND ((NOT (MEMBER (SETQ S.KIND (ST-GET.SYMBOL.CLASSIFICATION SORT 'KIND)) '(NIL SORT)))
				   (COM=ERROR T 2 S.KIND SORT 'SORT))))
			(CONS SYMBOLNAME SYMBOLRANGE)))
	    ((AND (MEMBER 'CONSTRUCTIVE.SYMBOL SEM.ATTRIBUTES) (NULL (INTERSECTION ATTRIBUTE '(STRUCTURE DEFINED))))
	     (COM=ERROR T 5 'SORT SYMBOLNAME))
	    ((MEMBER SYMBOLNAME SYMBOLRANGE) (COM=ERROR T 65 SYMBOLNAME))
	    ((AND (NULL SYMBOLATTRIBUTE) (MEMBER '?STRUCTURE ATTRIBUTE)) (COM=ERROR T 601 SYMBOLNAME))
	    ((MEMBER '?STRUCTURE ATTRIBUTE) (ST-REMOVE.SYMBOL SYMBOLNAME) (SETQ KIND NIL)))
      (COND ((NULL KIND) (ST-ENTER.SYMBOLENTRY SYMBOLNAME 'SORT NIL SYMBOLATTRIBUTE NIL SYMBOLRANGE))
	    (T (ST-ENTER.SYMBOL.CLASSIFICATION SYMBOLNAME 'RANGE (UNION SYMBOLRANGE (DELETE 'ANY RANGE))))))))

(DEFUN COM=3=VSTACK.PUSH (VARIABLE.LIST)
						;EDITED: 11-MAR-81 10:26:08
						;input:  VARIABLESYMBOL - AN ATOM
						;EFFECT: GENERATES A NEW NAME FOR 'VARIABLE - SYMBOL' AND PUSH//S 'VARIABLESYMBOL'
						;        TOGETHER WITH ITS NEW NAME ONTO THE VARIABLE STACK
						;VALUE:  THE NEW NAME OF 'VARIABLESYMBOL'
  (COND ((NULL COM*ERROR) (SETQ COM*VSTACK (CONS VARIABLE.LIST COM*VSTACK)))))

(DEFUN COM=3=VSTACK.POP NIL
						;EDITED: 11-MAR-81 10:16:48
						;input:  NONE
						;EFFECT: UNDOES THE LAST PUSH TO THE VARIABLE STACK.
						;VALUE:  UNDEFINED
  (SETQ COM*VSTACK (CDR COM*VSTACK)))

(DEFUN COM=3=VSTACK.NEWNAME (ANYSYMBOL)
						; EDITED:| "17-JUL-81 11:29:40
						; INPUT:  ANYSYMBOL      - AN ATOM
						; EFFECT: RETURNS VALUE
						; VALUE:  IF 'ANYSYMBOL' IS A VARIABLE SYMBOL
						;        WHICH IS MEMBER OF THE VARIABLE STACK THE NEW NAME OF 'ANYSYMBOL' , ELSE
						;        ANYSYMBOL
  (let (ENTRY)
    (MEMBER-IF #'(LAMBDA (ENTRIES) (SETQ ENTRY (Cdr (ASSOC ANYSYMBOL ENTRIES))))
	       COM*VSTACK)
    (COND (ENTRY (CAR ENTRY)))))

(DEFUN COM=3=VSTACK.OLDNAME (ANYSYMBOL)
						;EDITED: 17-JUL-81 11:36:59
						;input:  ANYSYMBOL - AN ATOM
						;EFFECT: RETURNS VALUE
						;VALUE:  IF 'ANYSYMBOL' IS A RENAMED VARIABLE
						;        THE ORIGINAL VARIABLE NAME , ELSE NIL
  (PROG (ENTRY)
	(MEMBER-IF
	  #'(LAMBDA (ENTRIES)
	      (MEMBER-IF #'(LAMBDA (ENT) (COND ((EQL ANYSYMBOL (SECOND ENT)) (SETQ ENTRY ENT)))) ENTRIES))
	  COM*VSTACK)
	(RETURN (CAR ENTRY))))

(DEFUN COM=3=INSERT.PROPERTY (CODE PROPERTY)
						;EDITED: 09-MAR-83 13:22:12
						;input:  CODE - A SEXPRESSION
						;        PROPERTY - A PROPERTATTRIBUTE
						;EFFECT: INSERTS PROPERTY IN EACH PROPERTYLIST
						;        OF THE ATOMAR FORMULAS IN CODE.
  (SETQ PROPERTY (COPY-TREE PROPERTY))
  (unless COM*ERROR
    (COND
      ((CONSP CODE)
       (CASE (CAR CODE)
	 ((ALL EX)
	  (COM=3=INSERT.PROPERTY (THIRD CODE) PROPERTY))
	 ((EQV |:EQV| |EQV:| |:EQV:| IMPL |:IMPL| |IMPL:| |:IMPL:| OR |:OR| |OR:| |:OR:| AND |:AND| |AND:| |:AND:|)
	  (COM=3=INSERT.PROPERTY (SECOND CODE) PROPERTY) (COM=3=INSERT.PROPERTY (THIRD CODE) PROPERTY))
	 (NOT (COM=3=INSERT.PROPERTY (SECOND CODE) PROPERTY))
	 (+
	   (COND
	     ((CADR (MEMBER (CAR PROPERTY) (FOURTH CODE) :TEST #'EQUAL))
	      (LET ((ENTRY (DO ((ENTRYLIST (FOURTH CODE) (CDDR ENTRYLIST)))
			       ((EQL (FIRST PROPERTY) (FIRST ENTRYLIST)) (REST ENTRYLIST)))))
		(RPLACA ENTRY (NCONC (CAR ENTRY) (SECOND PROPERTY)))))
	     (T (RPLACA (CDDDR CODE) (NCONC PROPERTY (FOURTH CODE))))))
	 (OTHERWISE (ERROR "ILLEGAL FORMAT FOR ATOM IN COM=3=INSERT.PROPERTY~A" NIL))))
      (T (ERROR "ILLEGAL FORMAT FOR ATOM IN COM=3=INSERT.PROPERTY~A" NIL)))))

(DEFUN COM=3=ENTER.PARAMETER.BINDING (NEWVAR.SYMBOL)
  (MEMBER-IF
    #'(LAMBDA (ENTRIES)
        (MEMBER-IF #'(LAMBDA (ENT) (COND ((EQL NEWVAR.SYMBOL (SECOND ENT)) (RPLACA (CDDR ENT) T)))) ENTRIES))
    COM*VSTACK))

(DEFUN COM=3=GET.PARAMETER.BINDING (NEWVAR.SYMBOL)
  (PROG (RESULT)
	(MEMBER-IF
	  #'(LAMBDA (ENTRIES)
	      (MEMBER-IF #'(LAMBDA (ENT) (COND ((EQL NEWVAR.SYMBOL (SECOND ENT)) (SETQ RESULT (THIRD ENT))))) ENTRIES))
	  COM*VSTACK)
	(RETURN RESULT)))

(DEFUN COM=3=IS.PARAMETER.UNBOUND.ATOM (ATOM)
						;EDITED:  1-MAR-82 12:22:39
						;input:  ATOM - A SEXPRESSION DENOTING A ATOM IN
						;        LIST NOTATION
						;EFFECT: RETURNS VALUE
						;VALUE:  NIL,IF EACH VARIABLE OCCURRING IN 'ATOM' IS A PARAMETER BOUND VARIABLE, ELSE ONE
						;        OF THE RENAMED PARAMETER UNBOUND VARIABLES OCCURRING IN 'ATOM'.
  (PROG ((SYMBOLS (FLATTEN ATOM)) RESULT)
	(COND
	  ((SETQ RESULT
		 (MEMBER-IF #'(LAMBDA (SYMBOL) (AND (COM=3=VSTACK.OLDNAME SYMBOL) (NOT (COM=3=GET.PARAMETER.BINDING SYMBOL)))) SYMBOLS))
	   (RETURN (CAR RESULT)))
	  (T (RETURN NIL)))))

(DEFUN COM=3=IS.PARAMETER.BINDING (LEFT.TERM RIGHT.TERM)
						;EDITED:  1-MAR-82 11:52:10
						;input:  LEFT.TERM , RIGHT.TERM - SEXPRESSIONS
						;        DENOTING TERMS IN LIST NOTATION
						;EFFECT: IF VALUE=T THE GLOBAL VARIABLE
						;        'PARAMETER.BOUND.VARIABLES' IS EXTENDED BY
						;         ALL VARIABLES OCURRING IN 'RIGHT.TERM
						;VALUE:  IF 'LEFT.TERM' IS A PARAMETER BOUND  VARIABLE AND
						;        (1) 'RIGHT.TERM' IS A PARAMETER UNBOUND  VARIABLE,
						;            WHOSE SORT IS A SUBSORT
						;            OF 'LEFT.TERM'S SORT BUT DIFFERENT FROM 'LEFT.TERM'S SORT OR
						;        (2) 'RIGHT.TERM' IS A STRUCTURE TERM   SCHEMA
						;       THEN T, ELSE NIL
  (COND
    ((COM=3=GET.PARAMETER.BINDING LEFT.TERM)
     (PROG
       ((LEFT.RANGE (DT-VARIABLE.SORT LEFT.TERM))
	(RIGHT.RANGE
	  (ST-GET.SYMBOL.CLASSIFICATION (INTERN (DT-PNAME (COND ((ATOM RIGHT.TERM) RIGHT.TERM) (T (CAR RIGHT.TERM))))
						(find-package "MKRP")) 'RANGE))
	VARIABLE.SYMBOLS)
       (RETURN
	 (COND
	   ((AND (ATOM RIGHT.TERM) (COM=3=VSTACK.OLDNAME RIGHT.TERM))
	    (COND
	      ((AND (NEQ LEFT.RANGE RIGHT.RANGE) (MEMBER RIGHT.RANGE (ST-GET.TRANSITIVE.CLOSURE LEFT.RANGE)))
	       (COM=3=ENTER.PARAMETER.BINDING RIGHT.TERM) T)))
	   (T (SETQ VARIABLE.SYMBOLS (COM=3=IS.STRUCTURE.TERM.SCHEMA RIGHT.TERM))
              (COND
                ((AND (MEMBER RIGHT.RANGE (ST-GET.TRANSITIVE.CLOSURE LEFT.RANGE)) (NEQ VARIABLE.SYMBOLS 'FAILED))
		 (MAPC #'COM=3=ENTER.PARAMETER.BINDING VARIABLE.SYMBOLS) T)))))))))

(DEFUN COM=3=IS.STRUCTURE.TERM.SCHEMA (TERM)
						;EDITED:  1-MAR-82 12:20:25
						;input:  TERM - A SEXPRESSION DENOTING A TERM
						;               IN LIST NOTATION
						;EFFECT: RETURNS VALUE
						;VALUE:  IF EACH CONSTANT - AND FUNCTION SYMBOL IN 'TERM' HAS THE ATTRIBUTE
						;        'STRUCTURE, A LIST OF ALL VARIABLE SYMBOLS OCCURING IN 'TERM', ELSE THE
						;        ATOM :NIL
  (PROG ((SYMBOLS (FLATTEN TERM)))
	(COND
	  ((MEMBER-IF
	     #'(LAMBDA (SYMBOL)
		 (AND (NOT (COM=3=VSTACK.OLDNAME SYMBOL))
		      (NOT (MEMBER 'STRUCTURE (ST-GET.SYMBOL.CLASSIFICATION (INTERN (DT-PNAME SYMBOL)
										    (find-package "MKRP")) 'ATTRIBUTE)))))
	     SYMBOLS)
	   (RETURN 'FAILED))
	  (T (RETURN (REMOVE-IF-NOT #'(LAMBDA (X) (COM=3=VSTACK.OLDNAME X)) SYMBOLS))))))

(DEFUN COM=4=TYPE.CHECK (CODE VALUE symbol arity)
						; EDITED: 22-FEB-82 13:20:01
						; INPUT:  A SEXPRESSION
						; EFFECT: PERFORMS TYPE CHECKING AND IF NECESSARY IMPLICIT TYPE DEFINITION
						; VALUE:  UNDEFINED
  (unless COM*ERROR
    (if (and (CONSP CODE) (MEMBER (CAR CODE) '(ALL EX EQV IMPL OR AND + - NOT)))
	(case (car code)
	  ((ALL EX) (COM=4=TYPE.CHECK (THIRD CODE) NIL nil nil))
	  ((EQV IMPL OR AND)
	   (COM=4=TYPE.CHECK (SECOND CODE) NIL nil nil)
	   (COM=4=TYPE.CHECK (THIRD CODE) NIL nil nil))
	  (NOT (COM=4=TYPE.CHECK (SECOND CODE) NIL nil nil))
	  ((+ -) (PROG ((counter 0))
		       (COND
			 ((DT-PREDICATE.IS.EQUALITY (SECOND CODE))
			  (COM=4=TYPE.CHECK (CAAR (CDDR CODE)) NIL (first code) 1)
			  (COM=4=TYPE.CHECK (SECOND (THIRD CODE)) NIL (second code) 2))
			 (T (MAPC #'(LAMBDA (CODE1 VALUE)
				      (incf counter)
				      (COM=4=TYPE.CHECK CODE1 VALUE (second code) counter))
				  (THIRD CODE)
				  (DT-PREDICATE.DOMAINSORTS (SECOND CODE))))))))
	(PROG (RANGE fSYMBOL (counter 0))
	      (COND
		((CONSP CODE)
		 (SETQ fSYMBOL (CAR CODE))
		 (SETQ RANGE (DT-FUNCTION.MAX.RANGE.SORT fSYMBOL))
		 (MAPC #'(LAMBDA (CODE VALUE)
			   (incf counter)
			   (COM=4=TYPE.CHECK CODE VALUE fsymbol counter))
		       (CDR CODE)
		       (DT-FUNCTION.DOMAINSORTS FSYMBOL)))
		(T (SETQ FSYMBOL CODE)
		   (SETQ RANGE
			 (CASE (DT-TYPE CODE)
			   (CONSTANT (DT-CONSTANT.SORT CODE))
			   (VARIABLE (DT-VARIABLE.SORT CODE))
			   (OTHERWISE NIL)))))
	      (COND
		((AND VALUE (NEQ VALUE 'ANY)
		      (NOT (MEMBER RANGE (ST-GET.TRANSITIVE.CLOSURE VALUE))))
		 (COM=ERROR T 10 arity (dt-pname symbol) value RANGE)))))))

(DEFUN COM-LAST.ERROR.MESSAGE (FILE)
  (COND
    (COM*ERROR
     (PROG ((NUMBER (CAR COM*ERROR)) (ARGLIST (SECOND COM*ERROR))
	    (SYMBOL.LIST (THIRD COM*ERROR))#| (NULL COM*ERROR)|#)
	   (declare (special symbol.list))
	   (COM=ERROR FILE NUMBER ARGLIST)))))

(DEFUN COM=ERROR (FILE NUMBER &REST ARGLIST)
  (DECLARE (SPECIAL SYMBOL.LIST))
  (terpri file)
  (COND ((ZEROP NUMBER) (format FILE "##### Syntax error: ~A" (or arglist "")))
	((EQL NUMBER 1) (PRINC "##### Symbol error: " FILE))
	(T              (PRINC "##### Semantic error: " FILE)))
  (CASE NUMBER
    (0 NIL)
    (1 (PRINC (CAR ARGLIST) FILE) (PRINC " is no admissible symbol" FILE))
    (2 (format file "~A symbol ~A used as ~A." (CAR ARGLIST) (SECOND ARGLIST) (THIRD ARGLIST)))
    (3 (format file "Attempt to redefine ~A symbol ~A" (CAR ARGLIST) (SECOND ARGLIST)))
    (4 (PRINC "unknown " FILE) (PRINC (CAR ARGLIST) FILE) (PRINC " symbol " FILE) (PRINC (SECOND ARGLIST) FILE))
    (5 (PRINC "non constructive " FILE) (PRINC (CAR ARGLIST) FILE) (PRINC " symbol " FILE) (PRINC (SECOND ARGLIST) FILE))
    (14 (format file "Constant symbol ~A nil -> ~A used with range ~A" (CAR ARGLIST) (SECOND ARGLIST) (THIRD ARGLIST)))
    (23 (PRINC (CAR ARGLIST) FILE) (PRINC "-ary function symbol " FILE) (PRINC (SECOND ARGLIST) FILE) (PRINC " used with " FILE)
	(PRINC (THIRD ARGLIST) FILE) (PRINC " arguments " FILE))
    (26 (PRINC "function symbol " FILE) (PRINC (CAR ARGLIST) FILE) (PRINC  FILE)
	(PRINC (SECOND ARGLIST) FILE) (PRINC " -> " FILE)
	(PRINC (THIRD ARGLIST) FILE) (PRINC " applied to " FILE) (PRINC (FOURTH ARGLIST) FILE))
    (27 (PRINC "function symbol " FILE) (PRINC (CAR ARGLIST) FILE) (PRINC  FILE) (PRINC (SECOND ARGLIST) FILE) (PRINC " -> " FILE)
	(PRINC (THIRD ARGLIST) FILE) (PRINC " used with range " FILE) (PRINC (FOURTH ARGLIST) FILE))
    (31 (PRINC "illegal recursive usage of function symbol " FILE) (PRINC (CAR ARGLIST) FILE))
    (34 (PRINC (CAR ARGLIST) FILE) (PRINC "-ary predicate symbol " FILE) (PRINC (SECOND ARGLIST) FILE) (PRINC " used with " FILE)
	(PRINC (THIRD ARGLIST) FILE) (PRINC " arguments " FILE))
    (36 (PRINC "predicate symbol " FILE) (PRINC (CAR ARGLIST) FILE) (PRINC  FILE)
	(PRINC (SECOND ARGLIST) FILE) (PRINC " applied to " FILE)
	(PRINC (THIRD ARGLIST) FILE))
    (40 (PRINC "Illegal recursive usage of predicate symbol " FILE) (PRINC (CAR ARGLIST) FILE))
    (65 (PRINC "Attempt to establish sort " FILE) (PRINC (CAR ARGLIST) FILE) (PRINC " as a direct subsort of itself " FILE))
    (66 (format file "Sort symbol ~A is no direct subsort of ~A" (CAR ARGLIST) (SECOND ARGLIST)))
    (601 (PRINC "attempt to use the announced sort symbol " FILE) (PRINC (CAR ARGLIST) FILE))
    (603 (PRINC "attempt to define sort " FILE) (PRINC (CAR ARGLIST) FILE) (PRINC " as a supersort of " FILE)
	 (PRINC (SECOND ARGLIST) FILE) (PRINC " which has already the supersort " FILE) (PRINC (THIRD ARGLIST) FILE))
    (70 (PRINC "attempt to use the parameter unbound variable " FILE) (PRINC (CAR ARGLIST) FILE))
    (71 (PRINC "variable symbol " FILE) (PRINC (CAR ARGLIST) FILE) (PRINC " nil -> " FILE) (PRINC (SECOND ARGLIST) FILE)
	(PRINC " used with range " FILE) (PRINC (THIRD ARGLIST) FILE))
    (10 (format file "Argument #~A of ~A has sort ~A" (CAR ARGLIST) (SECOND ARGLIST) (THIRD ARGLIST))
	(format file  " but is used with an incompatible ~A - sort argument" (FOURTH ARGLIST)))
    (OTHERWISE (ERROR "com=error , illegal number: number = ~a" NUMBER)))
  (FORMAT FILE "~%##### Unexamined remainder of the input: ")
  (COM=ERROR.PRINT FILE SYMBOL.LIST)
  (SETQ COM*ERROR (LIST NUMBER ARGLIST SYMBOL.LIST)) NIL)

(DEFUN COM=ERROR.PRINT (FILE SENTENCE)
						; EDITED: 11-MAR-81 10:34:14
						; INPUT:  SENTENCE - A LIST FORMED BY THE
						;         SYMBOL ANALYSYS
						; EFFECT: PRINTS 'SENTENCE' IN READABLE FORM
						;         ON THE TERMINAL
						; VALUE:  UNDEFINED
  (MAPC #'(LAMBDA (X)
	    (COND ((CONSP X) (format file "~A " (rest x)))
		  (T (format file "~A " x))))
	SENTENCE))



