;; -*- package: mkrp; syntax: common-lisp; mode: lisp -*-


(IN-PACKAGE "MKRP" :USE '("CL"))

(defun euni=funcall (term1 store1 term2 store2 app switched)
  (if switched
      (funcall app term1 store1 store2)
      (funcall app term2 store2 store1)))

(defun euni-pop.elem (stack)
  (let ((elem (first stack)))
    (if (and (rest stack) (zerop (rest elem)))
	(euni-pop.elem (rest stack))
	(values (rest stack) (first elem) (rest elem)))))

(defun euni-pop.term (stack)
  (multiple-value-bind (stack tree args) (euni-pop.elem stack)
    (let ((symbol (etree-symbol tree)))
      (values symbol
	      tree
	      (cons (cons (etree-subtrees tree) (1- args)) stack)
	      (if (null stack)
		  (copy-list (etree-store tree))
		  nil)))))

(defun euni-pop.bind (stack)
  (multiple-value-bind (term tree stack store scope) (euni-pop.term stack)
    (while (and (eds-var_p term) (eds-var_binding term))
      (push term scope)
      (push (cons (eds-var_binding term) 1) stack)
      (multiple-value-setq (term tree stack) (euni-pop.term stack)))
    (values term tree stack store scope)))

(defun euni=push (trees args stack)
  (if stack
      (cons (cons trees
		  (+ args (rest (first stack))))
	    (rest stack))
      (cons (cons trees args) nil)))

(defun euni-occur.p (variable scope)
  (some #'(lambda (scope.var)
	    (or (eds-term_equal variable scope.var)
		(euni-occur.p variable (eds-var_scope scope.var))))
	scope))

(defun euni-branches (stack1 stack2 app store1 store2 switched)
  ;(format t "~%Br Stack 2: ~A" stack2)
  ;(format t "~%Br Stack 1: ~A" stack1)
  (if (null stack1)
      (mapc #'(lambda (stor1)
		(mapc #'(lambda (stor2)
			  (euni=funcall (rest stor1) (first stor1) (rest stor2) (first stor2) app switched))
		      store2))
	    store1)
      (multiple-value-bind (newstack1 tree1 args1) (euni-pop.elem stack1)
	(mapc #'(lambda (subtree1)
		    (unwind-protect
			(progn (etree-actual.push subtree1 (etree-supertree subtree1))
			       (multiple-value-bind (newstack2 tree2 args2) (euni-pop.elem stack2)
				 (mapc #'(lambda (subtree2)
					     (unwind-protect
						 (progn (etree-actual.push subtree2 (etree-supertree subtree2))
							(euni-singles (cons (cons subtree1 args1) newstack1)
								      (cons (cons subtree2 args2) newstack2)
								      app store1 store2 switched))
					       (etree-actual.pop (etree-supertree subtree2))))
					 tree2)))
		      (etree-actual.pop (etree-supertree subtree1))))
		tree1))))

(defun euni-singles (stack1 stack2 app store11 store22 switched)
  ;(format t "~%Sing Stack 2: ~A" stack2)
  ;(format t "~%Sing Stack 1: ~A" stack1)
  (multiple-value-bind (term1 tree1 stack1 store1 scope1) (euni-pop.bind stack1)
    (when store11 (setq store1 store11))
    (multiple-value-bind (term2 tree2 stack2 store2 scope2) (euni-pop.bind stack2)
      (when store22 (setq store2 store22))
      (if (eds-term_equal term1 term2)
	  (if (eds-fct_p term1)
	      (euni-branches (euni=push (etree-subtrees tree1) (eds-fct_arity term1) stack1)
			     (euni=push (etree-subtrees tree2) (eds-fct_arity term2) stack2)
			     app store1 store2 switched)
	      (euni-branches stack1 stack2 app store1 store2 switched))
	  (if (and (eds-var_p term1) (not (intersection (eds-var_scope term1) scope2)))
	      (euni-with.bind term1 tree2 stack1 stack2 app store1 store2 switched)
	      (if (and (eds-var_p term2) (not (intersection (eds-var_scope term2) scope1)))
		  (euni-with.bind term2 tree1 stack2 stack1 app store2 store1 (not switched))		  
		  nil))))))

(defun euni-bind (stack1 args stack2 app store1 store2 scope.var switched)
  ;(format t "~%Bind Stack 2: ~A" stack2)
  ;(format t "~%Bind Stack 1: ~A" stack1)
  (if (zerop args)
      (if (and (null (first (first stack1))) (zerop (rest (first stack1))) (null (rest stack1)))
	  (mapc #'(lambda (stor1)
		    (mapc #'(lambda (stor2)
			      (euni=funcall (rest stor1) (first stor1) (rest stor2) (first stor2) app switched))
			  store2))
		store1)
	  (euni-branches stack1 stack2 app store1 store2 switched))
      (mapc #'(lambda (tree)
		(unwind-protect
		    (progn ;(format t "~%>>>>> Enter Bind actual ~A" stack2)
			   (etree-actual.push tree (etree-supertree tree))
			   (let ((symbol (etree-symbol tree)))
			     (cond ((eds-fct_p symbol)
				    (euni-bind stack1 (+ -1 args (eds-fct_arity symbol))
					       (cons (cons (etree-subtrees tree) (rest (first stack2))) (rest stack2))
					       app store1 (or store2 (etree-store tree)) scope.var switched))
				   ((eds-var_p symbol)
				    (unwind-protect
					(progn (eds-var_push.scope scope.var symbol)					  
					       (if (euni-occur.p symbol (eds-var_scope scope.var))
						   nil
						   (euni-bind stack1 (1- args)
							      (cons (cons (etree-subtrees tree) (rest (first stack2))) (rest stack2))
							      app store1 (or store2 (etree-store tree)) scope.var switched)))
				      (eds-var_pop.scope symbol)))
				   ((eds-const_p symbol)
				    (euni-bind stack1 (1- args) (cons (cons (etree-subtrees tree) (rest (first stack2)))
								      (rest stack2))
					       app store1 (or store2 (etree-store tree)) scope.var switched))))
			   ;(format t "~%<<<<< Exit Bind actual ~A" stack2)
			   )
		  (etree-actual.pop (etree-supertree tree))))
	    (first (first stack2)))))

(defun euni-with.bind (variable tree stack1 stack2 app store1 store2 switched)
  ;(format t "~%With Bind Stack 2: ~A ~A" switched stack2)
  ;(format t "~%With Bind Stack 1: ~A ~A" switched stack1)
  (unwind-protect
      (if (and (eds-var_p (etree-symbol tree)) (euni-occur.p (etree-symbol tree) (eds-var_scope variable)))
	  nil
	  (progn (unless (eds-term_equal variable (etree-symbol tree))
		   (eds-var_set.binding variable tree))
		 (unwind-protect
		     (progn (when (eds-var_p (etree-symbol tree))
			      (eds-var_push.scope variable (etree-symbol tree))					  )
			    (euni-bind stack1 (if (eds-fct_p (etree-symbol tree)) (eds-fct_arity (etree-symbol tree)) 0)
				       stack2
				       app store1 (or store2 (etree-store tree)) variable switched))
		   (when (eds-var_p (etree-symbol tree))
		     (eds-var_pop.scope (etree-symbol tree))))))
    (eds-var_set.binding variable nil)))

(defun euni-top (tree1 tree2 app)
  (euni-branches (cons (cons tree1 1) nil)
		 (cons (cons tree2 1) nil)
		 app nil nil nil))
