;;; -*- Package: MKRP; Syntax: Common-lisp; Mode: lisp -*-

(in-package "MKRP" :use '("CL"))

(DEFUN DT-SORT.PRINT.SORTTREE (SORT)
  (PROG (DIFF.COUNT) (COND ((NULL SORT) (SETQ SORT 'ANY)))
    (MAPC
      (FUNCTION
        (LAMBDA (LINE) (TERPRI)
          (MAPC
            (FUNCTION
              (LAMBDA (ELEMENT)
                (COND
                  (ELEMENT
                    (PRINC (INTERN (COERCE (SETQ DIFF.COUNT (FIRSTN (COERCE ELEMENT 'LIST) 7)) 'STRING)
				   (find-package "MKRP")))
                    (DODOWN (RPTN (- 10 (LIST-LENGTH DIFF.COUNT))) (PRINC " "))
                    (DODOWN (RPTN (1- (DT=SORT.PRINT.COUNT ELEMENT))) (PRINC "        ")))
                  (T (PRINC "        ")))))
            LINE)))
      (DT=SORT.PRINTLINES SORT))))

(DEFUN DT=SORT.PRINT.COUNT (SORT)
  (PROG ((SORT.COUNT 0) DIR.SUB)
    (RETURN
      (COND
        ((SETQ DIR.SUB (DT-SORT.DIRECT.SUBSORTS SORT))
          (MAPC (FUNCTION (LAMBDA (SUBSORT) (SETQ SORT.COUNT (+ SORT.COUNT (DT=SORT.PRINT.COUNT SUBSORT))))) DIR.SUB)
          SORT.COUNT)
        (T 1)))))

(DEFUN DT=SORT.PRINTLINES (SORTE)
  (PROG ((LINES (LIST (LIST SORTE))) (CONTINUE T) DIR.SUB)
    (WHILE CONTINUE (SETQ CONTINUE NIL)
      (SETQ LINES
        (CONS
          (MAPCAN
            (FUNCTION
              (LAMBDA (ELEMENT)
                (COND ((SETQ DIR.SUB (DT-SORT.DIRECT.SUBSORTS ELEMENT)) (SETQ CONTINUE T) (COPY-TREE DIR.SUB)) (T (LIST NIL)))))
            (CAR LINES))
          LINES)))
    (RETURN (NREVERSE LINES))))

(defmacro  dt-check (switch)
  `(dt=check ',switch))

(DEFUN DT=CHECK (SWITCH)			; edited:  9-feb-83 17:26:56
						; input:   either  ON  or  OFF
						; value:   message about kind of switch performed.
						; effect:  causes all interface functions to perform
						;          admissibility checks on their arguments.
						;   
						; four common variables are required:
						; DT*CHECK_NONE:       list of functions which shall not be global:advised.
						; DT*CHECK_ARBITRARY:  list of arguments which may be arbitrary s-expressions
						; DT*CHECK_MANUAL:     list with elements (function checkfunction arguments)
						;                      arguments have to be equal to the arguments of function.
						; DT*CHECK_EQUIVALENT: list with elements (arg1 arg2 ...) of names of the same type.
						;                      the first element determines the actual checkfunction.
  (CASE SWITCH
    (ON
      (PROG
        ((ALL.FUNCTIONS (mkrp-FILE.functions "F:>mkrp>prog>dataterm.lisp"))
	 INTERFACE.FUNCTIONS CHECK.FUNCTIONS NOT.ADVISED)
        (SETQ INTERFACE.FUNCTIONS
	      (REMOVE-IF-NOT (FUNCTION (LAMBDA (FUNCTION) (STRING= "-" (SUBSEQ FUNCTION (1- 3) 3)))) ALL.FUNCTIONS))
        (SETQ CHECK.FUNCTIONS
	      (REMOVE-IF-NOT (FUNCTION (LAMBDA (FUNCTION) (STRING= "DT=CHECK_" (SUBSEQ FUNCTION (1- 1) 11)))) ALL.FUNCTIONS))
        (MAPC
          #'(LAMBDA (FUNCTION.CHECK)
              (PROG ((FUNCTION (CAR FUNCTION.CHECK)) (CHECK (CDR FUNCTION.CHECK)) ERROR)
		    (MAPC
		      (FUNCTION
			(LAMBDA (ARG1 ARG2) (COND ((EQL ARG2 'ARBITRARY)) ((NEQ ARG1 ARG2) (SETQ ERROR T)))))
		      (SCL:ARGLIST FUNCTION) (CDR CHECK))
		    (COND (ERROR (SETQ NOT.ADVISED (CONS FUNCTION NOT.ADVISED)))
			  (T (eval `(scl:ADVISE ,FUNCTION BEFORE t 0 (REMOVE 'ARBITRARY CHECK)))))))
          DT*CHECK_MANUAL)
        (COND
          (NOT.ADVISED
	   (PRINC
	     "THE FOLLOWING FUNCTIONS WHICH HAD TO BE MANUALLY GLOBAL:ADVISED HAVE NO COMPATIBLE CHECKFUNCTIONS: ")
	   (TERPRI) (PROGN (PRINC NOT.ADVISED) (TERPRI))))
        (SETQ NOT.ADVISED NIL)
        (MAPC
          (FUNCTION
            (LAMBDA (FUNCTION)
              (COND
                ((AND (SCL:ARGLIST FUNCTION) (NOT (ASSOC FUNCTION DT*CHECK_MANUAL))
		      (NOT (MEMBER FUNCTION DT*CHECK_NONE)))
		 (PROG (ERROR CHECKLIST ARGFCT)
		       (MAPC
			 (FUNCTION
			   (LAMBDA (ARGUMENT)
			     (COND
			       ((NOT (MEMBER ARGUMENT DT*CHECK_ARBITRARY))
				(SETQ ARGFCT
				      (INTERN (CONCATENATE 'STRING "DT=CHECK_" (PRINC-TO-STRING ARGUMENT))
					      (find-package "MKRP")))
				(COND
				  ((MEMBER ARGFCT CHECK.FUNCTIONS)
				   (SETQ CHECKLIST
					 (CONS
					   (LIST ARGFCT
						 argument)
					   CHECKLIST)))
				  ((AND
				     (SETQ ARGFCT
					   (CAR
					     (MEMBER-IF (FUNCTION (LAMBDA (CLASS) (MEMBER ARGUMENT CLASS))) DT*CHECK_EQUIVALENT)))
				     (SETQ ARGFCT
					   (CAR
					     (MEMBER
					       (INTERN
						 (CONCATENATE 'STRING "DT=CHECK_" (PRINC-TO-STRING (CAR ARGFCT)))
						 (find-package "MKRP"))
					       CHECK.FUNCTIONS))))
				   (SETQ CHECKLIST
					 (CONS
					   (LIST ARGFCT
						 (COND (T ARGUMENT)))
					   CHECKLIST)))
				  (T (SETQ ERROR T)))))))
			 (SCL:ARGLIST FUNCTION))
		       (COND (ERROR (SETQ NOT.ADVISED (CONS FUNCTION NOT.ADVISED)))
			     (CHECKLIST (eval `(GLOBAL:ADVISE ,FUNCTION BEFORE dt 0 ,(CONS 'PROGN CHECKLIST))))))))))
          INTERFACE.FUNCTIONS)
        (COND
          (NOT.ADVISED
	   (PRINC
	     "THE FOLLOWING FUNCTIONS WHICH HAD TO BE AUTOMATICALLY ADVISED CANNOT BE ADVISED DUE TO MISSING CHECKFUNCTIONS")
	   (TERPRI) (PROGN (PRINC NOT.ADVISED) (TERPRI)))))
      '(DT-CHECK SWITCHED ON))
    (OFF       (EVAL (CONS 'GLOBAL:unADVISE (mkrp-FILE.functions "F:>mkrp>prog>dataterm.lisp"))) '(DT-CHECK SWITCHED OFF))
    (OTHERWISE '(INVALID ARGUMENT - TRY (DT-CHECK ON) OR (DT-CHECK OFF)))))

(DEFVAR DT*CHECK_NONE
  '(DT-ABBREVIATION.IS DT-CHECK DT-CONSTANT.IS DT-FUNCTION.IS DT-PNAME DT-SAVE DT-TERM.RENAMED
    DT-TERMLIST.MAXDEPTH DT-TERMLIST.VARIABLES DT-TYPE DT-VARIABLE.RENAMING.SUBSTITUTION DT-VARIABLE.IS
    DT-GETPROP DT-PUTPROP DT-GETPROPLIST DT-SETPROPLIST DT-REMPROP DT-REMPROPS DT-ADDPROP
    DT-UPDATE.STRANGE.COMMONS DT-UPDATE.STORAGE.FUNCTIONS))

(DEFVAR DT*CHECK_ARBITRARY
  '(EQ.SEPARATELY INDICATOR INDICATORS VALUE LIST UNIFIER OBJECT RENAMEFLAG LIT.PARENTS ATTRIBUTE ATTRIBUTES
    ARG.ATTRIBUTES COMPLETE.FLAG SKOLEM.FLAG COMPONENT TUPLE1 TUPLE2 ENTRY ENTRY.NAME ADD.SORT SORT.SUBST))

(DEFVAR DT*CHECK_EQUIVALENT
  '((SORT SORT1 SORT2 SUBSORT SUPERSORT DIRECT.SUPERSORT DIRECT.SUBSORT MAX.RANGE.SORT RANGE.SORT)
    (SORTLIST SUPERSORTS DELETED.SORTS DOMAINSORTS MAX.DOMAIN.SORTS COMPLETE.SORT.LIST) (TAF TAF1 TAF2)
    (PREDICATE PREDICATE1 PREDICATE2 DT.PREDICATE) (NUMBER UNIFIERNO STEPS DEPTH STEP)
    (FUNCTION DT.FUNCTION ARG.FUNCTION)))

(DEFVAR DT*CHECK_MANUAL '((DT-SORT.CREATE DT=CHECK_SORT.CREATE SORT DIRECT.SUBSORTS)))

(DEFUN DT=CHECK_SORT (SORT)
  (COND ((MEMBER SORT DT*SORT.ALL)) (T (ERROR "(DT-CHECK) - ILLEGAL SORT SYMBOL: ~A" SORT))))

(DEFUN DT=CHECK_SORTLIST (DOMAINSORTS)
  (COND ((EVERY (FUNCTION (LAMBDA (SORT) (MEMBER SORT DT*SORT.ALL))) DOMAINSORTS))
    (T (ERROR "(DT-CHECK) -  ILLEGAL DOMAINSORTS : ~A" DOMAINSORTS))))

(DEFUN DT=CHECK_SORT.CREATE (SORT DIRECT.SUBSORTS)
  (COND ((AND (ATOM SORT) (EVERY (FUNCTION ATOM) DIRECT.SUBSORTS)))
    (T (ERROR "(DT-CHECK) - ILLEGAL SORT OR DIRECT.SUBSORTS: ~A" (LIST SORT DIRECT.SUBSORTS)))))

(DEFUN DT=CHECK_VARIABLE (VARIABLE)
   ;; EDITED: "22-NOV-79 19:07:51")
  (COND ((DT=VARIABLE.IS VARIABLE)) (T (ERROR "(DT-CHECK) - ILLEGAL VARIABLE SYMBOL: : ~A" VARIABLE))))

(DEFUN DT=CHECK_CONSTANT (CONSTANT)
   ;; EDITED: "22-NOV-79 19:08:25")
  (COND ((DT=CONSTANT.IS CONSTANT)) (T (ERROR "(DT-CHECK) - ILLEGAL CONSTANT SYMBOL: : ~A" CONSTANT))))

(DEFUN DT=CHECK_ABBREVIATION (ABBREVIATION)
  (COND ((DT=ABBREVIATION.IS ABBREVIATION)) (T (ERROR "(DT-CHECK) - ILLEGAL ABBREVIATION: ~A" ABBREVIATION))))

(DEFUN DT=CHECK_SCHEME (SCHEME)
  (COND ((MEMBER SCHEME DT*ABBREVIATIONS)) (T (ERROR "(DT-CHECK) - ILLEGAL ABBREVIATION SCHEME: ~A" SCHEME))))

(DEFUN DT=CHECK_FUNCTION (FUNCTION)
   ;; EDITED: "22-NOV-79 19:08:49")
  (COND ((DT=FUNCTION.IS FUNCTION)) (T (ERROR "(DT-CHECK) - ILLEGAL FUNCTION SYMBOL: : ~A" FUNCTION))))

(DEFUN DT=CHECK_PREDICATE (PREDICATE)
   ;; EDITED: "22-NOV-79 19:09:24")
  (COND ((DT=PREDICATE.IS PREDICATE)) (T (ERROR "(DT-CHECK) - ILLEGAL PREDICATE SYMBOL: : ~A" PREDICATE))))

(DEFUN DT=CHECK_TERMLIST (TERMLIST)
   ;; EDITED: "22-NOV-79 19:37:00")
  (COND ((EVERY (FUNCTION DT=CHECK-TERM) TERMLIST)) (T (ERROR "(DT-CHECK) - ILLEGAL TERMLIST: : ~A" TERMLIST))))

(DEFUN DT=CHECK_TERM (TERM) (COND ((DT=CHECK-TERM TERM)) (T (ERROR "(DT-CHECK) - ILLEGAL TERM: ~A" TERM))))

(DEFUN DT=CHECK_TAF (TAF)
  (COND ((EVERY (FUNCTION (LAMBDA (ELEMENT) (AND (INTEGERP ELEMENT) (NOT (MINUSP ELEMENT))))) TAF))
    (T (ERROR "(DT-CHECK) - ILLEGAL TERM ACCESS FUNCTION: ~A" TAF))))

(DEFUN DT=CHECK_PNAME (PNAME) (COND ((ATOM PNAME)) (T (ERROR "(DT-CHECK) - ILLEGAL PNAME      : ~A" PNAME))))

(DEFUN DT=CHECK_NUMBER (NUMBER)
  (COND ((INTEGERP NUMBER)) (T (ERROR "(DT-CHECK) - ILLEGAL NUMBER : ~A" NUMBER))))

(DEFUN DT=CHECK_NUMBER.OR.NIL (NUMBER.OR.NIL)
  (COND ((OR (NULL NUMBER.OR.NIL) (INTEGERP NUMBER.OR.NIL))) (T (ERROR "DT=CHECK_ ILLEGAL NUMBER: ~A" NUMBER.OR.NIL))))

(DEFUN DT=CHECK-TERM (TERM)
   ;; EDITED: "22-NOV-79 19:36:47")
  (COND ((NULL TERM) NIL) ((ATOM TERM) (OR (DT=VARIABLE.IS TERM) (DT=CONSTANT.IS TERM) (DT=ABBREVIATION.IS TERM)))
    ((CONSP TERM) (AND (DT=FUNCTION.IS (CAR TERM)) (EVERY (FUNCTION DT=CHECK_TERM) (CDR TERM))))))

(DEFUN DT=CHECK_PREDICATES (PREDICATES)
  (COND ((OR (NULL PREDICATES) (AND (CONSP PREDICATES) (EVERY (FUNCTION DT=CHECK_PREDICATE) PREDICATES))))
    (T (ERROR "(DT-CHECK) ILLEGAL PREDICATES: ~A" PREDICATES))))

