(*  Title: 	HOL/fun
    ID:         $Id: fun.ML,v 1.1 1993/09/16 10:21:10 clasohm Exp $
    Author: 	Tobias Nipkow, Cambridge University Computer Laboratory
    Copyright   1993  University of Cambridge

Lemmas about functions.
*)

goal Set.thy "(f = g) = (!x. f(x)=g(x))";
by (rtac iffI 1);
by(asm_simp_tac HOL_ss 1);
by(rtac ext 1 THEN asm_simp_tac HOL_ss 1);
val expand_fun_eq = result();

val prems = goal Set.thy
    "[| f(x)=u;  !!x. P(x) ==> g(f(x)) = x;  P(x) |] ==> x=g(u)";
by (rtac (arg_cong RS box_equals) 1);
by (REPEAT (resolve_tac (prems@[refl]) 1));
val apply_inverse = result();


(*** Range of a function ***)

(*Frequently b does not have the syntactic form of f(x).*)
val [prem] = goalw Set.thy [range_def] "b=f(x) ==> b : range(f)";
by (EVERY1 [rtac CollectI, rtac exI, rtac prem]);
val range_eqI = result();

val rangeI = refl RS range_eqI;

val [major,minor] = goalw Set.thy [range_def]
    "[| b : range(%x.f(x));  !!x. b=f(x) ==> P |] ==> P"; 
by (rtac (major RS CollectD RS exE) 1);
by (etac minor 1);
val rangeE = result();

(*** Image of a set under a function ***)

val prems = goalw Set.thy [image_def] "[| b=f(x);  x:A |] ==> b : f``A";
by (REPEAT (resolve_tac (prems @ [CollectI,bexI,prem]) 1));
val image_eqI = result();

val imageI = refl RS image_eqI;

val major::prems = goalw Set.thy [image_def]
    "[| b : (%x.f(x))``A;  !!x.[| b=f(x);  x:A |] ==> P |] ==> P"; 
by (rtac (major RS CollectD RS bexE) 1);
by (REPEAT (ares_tac prems 1));
val imageE = result();

goal Set.thy "(f o g)``r = f``(g``r)";
by (stac o_def 1);
by (rtac set_ext 1);
by (fast_tac (HOL_cs addIs [imageI] addSEs [imageE]) 1);
val image_compose = result();

goal Set.thy "f``(A Un B) = f``A Un f``B";
by (rtac set_ext 1);
by (fast_tac (HOL_cs addIs [imageI,UnCI] addSEs [imageE,UnE]) 1);
val image_Un = result();

(*** inj(f): f is a one-to-one function ***)

val prems = goalw Set.thy [inj_def]
    "[| !! x y. f(x) = f(y) ==> x=y |] ==> inj(f)";
by (fast_tac (HOL_cs addIs prems) 1);
val injI = result();

val [major] = goal Set.thy "(!!x. g(f(x)) = x) ==> inj(f)";
by (rtac injI 1);
by (etac (arg_cong RS box_equals) 1);
by (rtac major 1);
by (rtac major 1);
val inj_inverseI = result();

val [major,minor] = goalw Set.thy [inj_def]
    "[| inj(f); f(x) = f(y) |] ==> x=y";
by (rtac (major RS spec RS spec RS mp) 1);
by (rtac minor 1);
val injD = result();

(*Useful with the simplifier*)
val [major] = goal Set.thy "inj(f) ==> (f(x) = f(y)) = (x=y)";
by (rtac iffI 1);
by (etac (major RS injD) 1);
by (etac arg_cong 1);
val inj_eq = result();

val [major] = goal Set.thy "inj(f) ==> (@x.f(x)=f(y)) = y";
by (rtac (major RS injD) 1);
by (rtac selectI 1);
by (rtac refl 1);
val inj_select = result();

(*A one-to-one function has an inverse (given using select).*)
val [major] = goal Set.thy "inj(f) ==> Inv(f,f(x)) = x";
by (EVERY1 [stac Inv_def, rtac (major RS inj_select)]);
val Inv_f_f = result();

(* Useful??? *)
val [oneone,minor] = goal Set.thy
    "[| inj(f); !!y. y: range(f) ==> P(Inv(f,y)) |] ==> P(x)";
by (res_inst_tac [("t", "x")] (oneone RS (Inv_f_f RS subst)) 1);
by (rtac (rangeI RS minor) 1);
val inj_transfer = result();


(*** inj_onto(f,A): f is one-to-one over A ***)

val prems = goalw Set.thy [inj_onto_def]
    "(!! x y. [| f(x) = f(y);  x:A;  y:A |] ==> x=y) ==> inj_onto(f,A)";
by (fast_tac (HOL_cs addIs prems addSIs [ballI]) 1);
val inj_ontoI = result();

val [major] = goal Set.thy 
    "(!!x. x:A ==> g(f(x)) = x) ==> inj_onto(f,A)";
by (rtac inj_ontoI 1);
by (etac (apply_inverse RS trans) 1);
by (REPEAT (eresolve_tac [asm_rl,major] 1));
val inj_onto_inverseI = result();

val major::prems = goalw Set.thy [inj_onto_def]
    "[| inj_onto(f,A);  f(x)=f(y);  x:A;  y:A |] ==> x=y";
by (rtac (major RS bspec RS bspec RS mp) 1);
by (REPEAT (resolve_tac prems 1));
val inj_ontoD = result();

val major::prems = goal Set.thy
    "[| inj_onto(f,A);  ~x=y;  x:A;  y:A |] ==> ~ f(x)=f(y)";
by (rtac contrapos 1);
by (etac (major RS inj_ontoD) 2);
by (REPEAT (resolve_tac prems 1));
val inj_onto_contraD = result();


(*** Lemmas about inj ***)

val prems = goal Set.thy
    "[| inj(f);  inj_onto(g,range(f)) |] ==> inj(g o f)";
by (stac o_def 1);
by (cut_facts_tac prems 1);
by (fast_tac (HOL_cs addIs [injI,rangeI]
                     addEs [injD,inj_ontoD]) 1);
val comp_inj = result();

val [prem] = goal Set.thy "inj(f) ==> inj_onto(f,A)";
by (fast_tac (HOL_cs addIs [prem RS injD, inj_ontoI]) 1);
val inj_imp = result();

val [prem] = goal Set.thy "y : range(f) ==> f(Inv(f,y)) = y";
by (EVERY1 [stac Inv_def, rtac (prem RS rangeE), rtac selectI, etac sym]);
val f_Inv_f = result();

val prems = goal Set.thy
    "[| Inv(f,x)=Inv(f,y); x: range(f);  y: range(f) |] ==> x=y";
by (rtac (arg_cong RS box_equals) 1);
by (REPEAT (resolve_tac (prems @ [f_Inv_f]) 1));
val Inv_injective = result();

val prems = goal Set.thy
    "[| inj(f);  A<=range(f) |] ==> inj_onto(Inv(f), A)";
by (cut_facts_tac prems 1);
by (fast_tac (HOL_cs addIs [inj_ontoI] 
		     addEs [Inv_injective,injD,subsetD]) 1);
val inj_onto_Inv = result();


(*** Set reasoning tools ***)

val set_cs = HOL_cs 
    addSIs [ballI, subsetI, InterI, INT_I, INT1_I, CollectI, 
	    ComplI, IntI, DiffI, UnCI, insertCI] 
    addIs  [bexI, UnionI, UN_I, UN1_I, imageI, rangeI] 
    addSEs [bexE, UnionE, UN_E, UN1_E, DiffE,
	    CollectE, ComplE, IntE, UnE, insertE, imageE, rangeE, emptyE] 
    addEs  [ballE, InterD, InterE, INT_D, INT_E, make_elim INT1_D,
	    subsetD, subsetCE];

fun cfast_tac prems = cut_facts_tac prems THEN' fast_tac set_cs;


fun prover s = prove_goal Set.thy s (fn _=>[fast_tac set_cs 1]);

val mem_simps = map prover
 [ "(a : A Un B)   =  (a:A | a:B)",
   "(a : A Int B)  =  (a:A & a:B)",
   "(a : Compl(B)) =  (~a:B)",
   "(a : A-B)      =  (a:A & ~a:B)",
   "(a : {b})      =  (a=b)",
   "(a : {x.P(x)}) =  P(a)" ];

val set_ss = HOL_ss addsimps mem_simps;
