(*  Title: 	HOL/ex/prop-log
    ID:         $Id: pl.thy,v 1.1 1993/09/16 10:21:28 clasohm Exp $
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

Inductive definition of propositional logic.

*)

PL = Finite +
types pl 1
arities pl :: (term)term
consts
    false	:: "'a pl"
    "->"	:: "['a pl,'a pl] => 'a pl"	(infixr 90)
    var		:: "'a => 'a pl"		("#_")
    pl_rec	:: "['a pl,'a => 'b, 'b, ['b,'b] => 'b] => 'b"
    axK,axS,axDN:: "'a pl set"
    ruleMP,thms :: "'a pl set => 'a pl set"
    "|-" 	:: "['a pl set, 'a pl] => bool"	(infixl 50)
    "|="	:: "['a pl set, 'a pl] => bool"	(infixl 50)
    eval	:: "['a set, 'a pl] => bool"	("_[_]" [100,0] 100)
    hyps	:: "['a pl, 'a set] => 'a pl set"
rules

  (** Proof theory for propositional logic **)

    axK_def   "axK ==  {x . ? p q.   x = p->q->p}"
    axS_def   "axS ==  {x . ? p q r. x = (p->q->r) -> (p->q) -> p->r}"
    axDN_def  "axDN == {x . ? p.     x = ((p->false) -> false) -> p}"

    (*the use of subsets simplifies the proof of monotonicity*)
    ruleMP_def  "ruleMP(X) == {q. ? p:X. p->q : X}"

    thms_def
   "thms(H) == lfp(%X. H Un axK Un axS Un axDN Un ruleMP(X))"

    conseq_def  "H |- p == p : thms(H)"

    sat_def "H |= p  ==  (!tt. (!q:H. tt[q]) --> tt[p])"

pl_rec_var   "pl_rec(#v,f,y,z)    = f(v)"
pl_rec_false "pl_rec(false,f,y,z) = y"
pl_rec_imp   "pl_rec(p->q,f,y,g)  = g(pl_rec(p,f,y,g),pl_rec(q,f,y,g))"

eval_def "tt[p] == pl_rec(p, %v.v:tt, False, op -->)"

hyps_def
 "hyps(p,tt) == pl_rec(p, %a. {if(a:tt, #a, #a->false)}, {}, op Un)"

var_inject "(#v = #w) ==> v = w"
imp_inject "[| (p -> q) = (p' -> q'); [| p = p'; q = q' |] ==> R |] ==> R"
var_neq_imp "(#v = (p -> q)) ==> R"
pl_ind "[| P(false); !!v. P(#v); !!p q. P(p)-->P(q)-->P(p->q)|] ==> !t.P(t)"
end
