(*  Title: 	ZF/univ.thy
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

The cumulative hierarchy and a small universe for recursive types

Should change to??   Limit(i) == Ord(i) & 0:i & (ALL y:i. succ(y): i)   

Standard notation for Vset(i) is V(i), but users might want V for a variable
*)

Univ = Arith +
consts
    Limit       ::      "i=>o"
    Vfrom       ::      "[i,i]=>i"
    Vset        ::      "i=>i"
    Vrec        ::      "[i, [i,i]=>i] =>i"
    univ        ::      "i=>i"

rules
    Limit_def   "Limit(i) == 0:i & (ALL y:i. succ(y): i)"

    Vfrom_def   "Vfrom(A,i) == transrec(i, %x f. A Un (UN y:x. Pow(f`y)))"
    Vset_def    "Vset == Vfrom(0)"

    Vrec_def
   	"Vrec(a,H) == transrec(rank(a), %x g. lam z: Vset(succ(x)).      \
\                             H(z, lam w:Vset(x). g`rank(w)`w)) ` a"

    univ_def    "univ(A) == Vfrom(A,nat)"

end
