(*  Title: 	ZF/univ
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

The cumulative hierarchy and a small universe for recursive types
*)

open Univ;

(*NOT SUITABLE FOR REWRITING -- RECURSIVE!*)
goal Univ.thy "Vfrom(A,i) = A Un (UN j:i. Pow(Vfrom(A,j)))";
by (rtac (Vfrom_def RS def_transrec RS ssubst) 1);
by (SIMP_TAC ZF_ss 1);
val Vfrom = result();

(** Monotonicity **)

val [prem] = goal Univ.thy
    "A<=B ==> ALL j. i<=j --> Vfrom(A,i) <= Vfrom(B,j)";
by (eps_ind_tac "i" 1);
by (rtac (impI RS allI) 1);
by (rtac (Vfrom RS ssubst) 1);
by (rtac (Vfrom RS ssubst) 1);
by (rtac (prem RS Un_mono) 1);
by (rtac UN_mono 1);
by (assume_tac 1);
by (rtac Pow_mono 1);
by (etac (bspec RS spec RS mp) 1);
by (assume_tac 1);
by (rtac subset_refl 1);
val Vfrom_mono_lemma = result();

(*  [| A<=B; i<=x |] ==> Vfrom(A,i) <= Vfrom(B,x)  *)
val Vfrom_mono = standard (Vfrom_mono_lemma RS spec RS mp);


(** A fundamental equality: Vfrom does not require ordinals! **)

goal Univ.thy "Vfrom(A,x) <= Vfrom(A,rank(x))";
by (eps_ind_tac "x" 1);
by (rtac (Vfrom RS ssubst) 1);
by (rtac (Vfrom RS ssubst) 1);
by (fast_tac (ZF_cs addSIs [rank_lt]) 1);
val Vfrom_rank_subset1 = result();

goal Univ.thy "Vfrom(A,rank(x)) <= Vfrom(A,x)";
by (eps_ind_tac "x" 1);
by (rtac (Vfrom RS ssubst) 1);
by (rtac (Vfrom RS ssubst) 1);
by (safe_tac ZF_cs);
by (etac (rank_implies_mem RS bexE) 1);
by (swap_res_tac [UN_I]1);
by (assume_tac 1);
by (etac (subset_trans RS PowI) 1);
by (etac (subset_refl RS Vfrom_mono RS subset_trans) 1);
by (etac bspec 1);
by (assume_tac 1);
val Vfrom_rank_subset2 = result();

goal Univ.thy "Vfrom(A,rank(x)) = Vfrom(A,x)";
by (rtac equalityI 1);
by (rtac Vfrom_rank_subset2 1);
by (rtac Vfrom_rank_subset1 1);
val Vfrom_rank_eq = result();


(*** Basic closure properties ***)

val [prem] = goal Univ.thy "y:x ==> 0 : Vfrom(A,x)";
by (rtac (Vfrom RS ssubst) 1);
by (fast_tac (ZF_cs addSIs [prem]) 1);
val zero_in_Vfrom = result();

goal Univ.thy "i <= Vfrom(A,i)";
by (eps_ind_tac "i" 1);
by (rtac (Vfrom RS ssubst) 1);
by (fast_tac ZF_cs 1);
val i_subset_Vfrom = result();

goal Univ.thy "A <= Vfrom(A,i)";
by (rtac (Vfrom RS ssubst) 1);
by (rtac Un_upper1 1);
val A_subset_Vfrom = result();

val prems = goal Univ.thy "a <= Vfrom(A,i) ==> a: Vfrom(A,succ(i))";
by (rtac (Vfrom RS ssubst) 1);
by (cfast_tac prems 1);
val subset_mem_Vfrom = result();

(** Finite sets and ordered pairs **)

(*generates finite sets of arbitrary size*)
val prems = goal Univ.thy
    "[| a: Vfrom(A,i);  b<=Vfrom(A,i) |] ==> cons(a,b) : Vfrom(A,succ(i))";
by (rtac subset_mem_Vfrom 1);
by (cfast_tac prems 1);
val cons_in_Vfrom = result();

val [prem] = goal Univ.thy "a: Vfrom(A,i) ==> {a} : Vfrom(A,succ(i))";
by (rtac (prem RS cons_in_Vfrom) 1);
by (rtac empty_subsetI 1);
val singleton_in_Vfrom = result();

val prems = goal Univ.thy
    "[| a: Vfrom(A,i);  b: Vfrom(A,i) |] ==> {a,b} : Vfrom(A,succ(i))";
by (rtac cons_in_Vfrom 1);
by (REPEAT (resolve_tac (prems@[singleton_subsetI, empty_subsetI]) 1));
val doubleton_in_Vfrom = result();

val prems = goalw Univ.thy [Pair_def]
    "[| a: Vfrom(A,i);  b: Vfrom(A,i) |] ==> \
\    <a,b> : Vfrom(A,succ(succ(i)))";
by (REPEAT (resolve_tac (prems@[doubleton_in_Vfrom]) 1));
val pair_in_Vfrom = result();

val [prem] = goal Univ.thy
    "a<=Vfrom(A,i) ==> succ(a) : Vfrom(A,succ(succ(i)))";
by (REPEAT (resolve_tac [subset_mem_Vfrom, succ_subsetI] 1));
by (rtac (Vfrom_mono RSN (2,subset_trans)) 2);
by (REPEAT (resolve_tac [prem, subset_refl, subset_succI] 1));
val succ_in_Vfrom = result();

(*** 0, successor and limit equations fof Vfrom ***)

goal Univ.thy "Vfrom(A,0) = A";
by (rtac (Vfrom RS ssubst) 1);
by (fast_tac eq_cs 1);
val Vfrom_0 = result();

val [prem] = goal Univ.thy
    "Ord(i) ==> Vfrom(A,succ(i)) = A Un Pow(Vfrom(A,i))";
by (res_inst_tac [("i1","succ(i)")] (Vfrom RS ssubst) 1);
by (resolve_tac ZF_congs 1);
by (rtac refl 1);
by (rtac equalityI 1);
by (rtac UN_least 1);
by (rtac (subset_refl RS Vfrom_mono RS Pow_mono) 1);
by (etac member_succD 1);
by (rtac prem 1);
by (rtac (succI1 RS RepFunI RS Union_upper) 1);
val Vfrom_succ = result();

(*The premise distinguishes this from Vfrom(A,0);  allowing X=0 forces
  the conclusion to be Vfrom(A,Union(X)) = A Un (UN y:X. Vfrom(A,y)) *)
val [prem] = goal Univ.thy
    "y:X ==> Vfrom(A,Union(X)) = (UN y:X. Vfrom(A,y))";
by (rtac (Vfrom RS ssubst) 1);
by (rtac equalityI 1);
by (rtac Un_least 1);
by (rtac (prem RS UN_I RS subsetI) 1);
by (etac (A_subset_Vfrom RS subsetD) 1);
by (safe_tac ZF_cs);
by (rtac UN_I 1);
by (assume_tac 1);
by (rtac (Vfrom RS ssubst) 1);
by (fast_tac ZF_cs 1);
by (etac (Vfrom RS equalityD1 RS subsetD RS UnE) 1);
by (assume_tac 1);
by (fast_tac ZF_cs 1);
val Vfrom_Union = result();


(*** Limit ordinals ***)

val prems = goalw Univ.thy [Limit_def] "Limit(i) ==> i <= Union(i)";
by (cfast_tac prems 1);
val Limit_subset_Union = result();

val [limiti] = goalw Univ.thy [Limit_def] "Limit(i) ==> 0 : i";
by (rtac (limiti RS conjunct1) 1);
val Limit_0I = result();

val [limiti,jprem] = goalw Univ.thy [Limit_def]
    "[| Limit(i);  j:i |] ==> succ(j) : i";
by (rtac (limiti RS conjunct2 RS bspec) 1);
by (rtac jprem 1);
val Limit_succI = result();

goalw Univ.thy [Limit_def] "Limit(nat)";
by (REPEAT (ares_tac [conjI, ballI, nat_0I, nat_succI] 1));
val Limit_nat = result();

(*Because limit ordinals are non-empty, the conclusion is not
    			Vfrom(A,i) <= A Un (UN y:i. Vfrom(A,y)) *)
val [limiti] = goal Univ.thy
    "Limit(i) ==> Vfrom(A,i) <= (UN y:i. Vfrom(A,y))";
by (rtac (subset_refl RS Vfrom_mono RS subset_trans) 1);
by (rtac (limiti RS Limit_subset_Union) 1);
by (rtac (Vfrom_Union RS equalityD1) 1);
by (rtac (limiti RS Limit_0I) 1);
val Limit_Vfrom_subset = result();

val [ordi,limiti] = goal Univ.thy
    "[| Ord(i); Limit(i) |] ==> Vfrom(A,i) = (UN y:i. Vfrom(A,y))";
by (rtac (limiti RS Limit_Vfrom_subset RS equalityI) 1);
by (rtac subset_trans 1);
by (rtac (subset_refl RS Vfrom_mono) 2);
by (rtac (ordi RS Ord_Union_subset) 2);
by (rtac (Vfrom_Union RS equalityD2) 1);
by (rtac (limiti RS Limit_0I) 1);
val Limit_Vfrom_eq = result();

val [major,ordi,limiti] = goal Univ.thy
    "[| a: Vfrom(A,i);  Ord(i);  Limit(i) |] ==> {a} : Vfrom(A,i)";
by (rtac (limiti RS Limit_Vfrom_subset RS subsetD RS UN_E) 1);
by (rtac major 1);
by (rtac (ordi RS Limit_Vfrom_eq RS ssubst) 1);
by (rtac limiti 1);
by (rtac UN_I 1);
by (etac singleton_in_Vfrom 2);
by (etac (limiti RS Limit_succI) 1);
val singleton_in_Vfrom_limit = result();

(*Hard work is finding a single j:i such that {a,b}<=Vfrom(A,j)*)
val [aprem,bprem,ordi,limiti] = goal Univ.thy
    "[| a: Vfrom(A,i);  b: Vfrom(A,i);  Ord(i);  Limit(i) |] ==> \
\    {a,b} : Vfrom(A,i)";
by (rtac (aprem RS (limiti RS Limit_Vfrom_subset RS subsetD RS UN_E)) 1);
by (rtac (bprem RS (limiti RS Limit_Vfrom_subset RS subsetD RS UN_E)) 1);
by (rtac (limiti RS (ordi RS Limit_Vfrom_eq RS ssubst)) 1);
by (rtac UN_I 1);
by (rtac doubleton_in_Vfrom 2);
by (etac (Un_upper1 RS (subset_refl RS Vfrom_mono RS subsetD)) 2);
by (etac (Un_upper2 RS (subset_refl RS Vfrom_mono RS subsetD)) 2);
by (REPEAT (ares_tac [limiti RS Limit_succI, Ord_member_UnI, ordi] 1));
val doubleton_in_Vfrom_limit = result();

val [aprem,bprem,ordi,limiti] = goal Univ.thy
    "[| a: Vfrom(A,i);  b: Vfrom(A,i);  Ord(i);  Limit(i) |] ==> \
\    <a,b> : Vfrom(A,i)";
by (rtac (aprem RS (limiti RS Limit_Vfrom_subset RS subsetD RS UN_E)) 1);
by (rtac (bprem RS (limiti RS Limit_Vfrom_subset RS subsetD RS UN_E)) 1);
by (rtac (limiti RS (ordi RS Limit_Vfrom_eq RS ssubst)) 1);
by (rtac UN_I 1);
by (rtac pair_in_Vfrom 2);
by (etac (Un_upper1 RS (subset_refl RS Vfrom_mono RS subsetD)) 2);
by (etac (Un_upper2 RS (subset_refl RS Vfrom_mono RS subsetD)) 2);
by (REPEAT (ares_tac [limiti RS Limit_succI, Ord_member_UnI, ordi] 1));
val pair_in_Vfrom_limit = result();


(*** The set Vset(i) ***)

goalw Univ.thy [Vset_def] "Vset(i) = (UN j:i. Pow(Vset(j)))";
by (rtac (Vfrom RS ssubst) 1);
by (fast_tac eq_cs 1);
val Vset = result();

goal Univ.thy "Transset(Vset(a))";
by (eps_ind_tac "a" 1);
by (rtac (Vset RS ssubst) 1);
by (fast_tac (ZF_cs addSIs [Transset_Union,Transset_Pow]) 1);
val Transset_Vset = result();

goalw Univ.thy [Vset_def] "Vset(rank(x)) = Vset(x)";
by (rtac Vfrom_rank_eq 1);
val Vset_rank_eq = result();

(** Characterisation of the elements of Vset(i) **)

val [major] = goal Univ.thy "Ord(i) ==> ALL b. b : Vset(i) --> rank(b) : i";
by (rtac (major RS trans_induct) 1);
by (rtac (Vset RS ssubst) 1);
by (safe_tac ZF_cs);
by (rtac (rank RS ssubst) 1);
by (rtac sup_least2 1);
by (assume_tac 1);
by (assume_tac 1);
by (fast_tac ZF_cs 1);
val Vset_rank_imp1 = result();

(*  [| Ord(i); x : Vset(i) |] ==> rank(x) : i  *)
val Vset_D = standard (Vset_rank_imp1 RS spec RS mp);

val [major] = goal Univ.thy "Ord(i) ==> ALL b. rank(b) : i --> b : Vset(i)";
by (rtac (major RS trans_induct) 1);
by (rtac allI 1);
by (rtac (Vset RS ssubst) 1);
by (fast_tac (ZF_cs addSIs [rank_lt]) 1);
val Vset_rank_imp2 = result();

(*  [| Ord(i); rank(x) : i |] ==> x : Vset(i)  *)
val VsetI = standard (Vset_rank_imp2 RS spec RS mp);

(*  rank(x) : rank(a) ==> x : Vset(rank(a))  *)
val Vset_rankI = Ord_rank RS VsetI;

val [major] = goal Univ.thy "Ord(i) ==> b : Vset(i) <-> rank(b) : i";
by (rtac iffI 1);
by (etac (major RS Vset_D) 1);
by (etac (major RS VsetI) 1);
val Vset_Ord_rank_iff = result();

goal Univ.thy "b : Vset(a) <-> rank(b) : rank(a)";
by (rtac (Vset_rank_eq RS subst) 1);
by (rtac (Ord_rank RS Vset_Ord_rank_iff) 1);
val Vset_rank_iff = result();

(** Recursion over Vset levels! **)

(*NOT SUITABLE FOR REWRITING: recursive!*)
goalw Univ.thy [Vrec_def] "Vrec(a,H) = H(a, lam x:Vset(rank(a)). Vrec(x,H))";
by (rtac (transrec RS ssubst) 1);
by (SIMP_TAC (wf_ss addrews [Ord_rank, Ord_succ, Vset_D RS beta, 
			     VsetI RS beta]) 1);
val Vrec = result();

(*This form avoids giant explosions in proofs.  NOTE USE OF == *)
val rew::prems = goal Univ.thy
    "[| !!x. h(x)==Vrec(x,H) |] ==> \
\    h(a) = H(a, lam x: Vset(rank(a)). h(x))";
by (rewtac rew);
by (rtac Vrec 1);
val def_Vrec = result();

val prems = goalw Univ.thy [Vrec_def]
    "[| a=a';  !!x u. H(x,u)=H'(x,u) |]  ==> Vrec(a,H)=Vrec(a',H')";
val Vrec_ss = ZF_ss addcongs ([transrec_cong] @ mk_congs Univ.thy ["rank"])
		      addrews (prems RL [sym]);
by (SIMP_TAC Vrec_ss 1);
val Vrec_cong = result();


(*** univ(A) ***)

val [prem] = goalw Univ.thy [univ_def] "A<=B ==> univ(A) <= univ(B)";
by (rtac (prem RS Vfrom_mono) 1);
by (rtac subset_refl 1);
val univ_mono = result();

(** Closure properties **)

goalw Univ.thy [univ_def] "0 : univ(A)";
by (rtac (nat_0I RS zero_in_Vfrom) 1);
val zero_in_univ = result();

goalw Univ.thy [univ_def] "A <= univ(A)";
by (rtac A_subset_Vfrom 1);
val A_subset_univ = result();

(** Closure under unordered and ordered pairs **)

val prems = goalw Univ.thy [univ_def] "a: univ(A) ==> {a} : univ(A)";
by (rtac singleton_in_Vfrom_limit 1);
by (REPEAT (resolve_tac (prems@[Ord_nat,Limit_nat]) 1));
val singleton_in_univ = result();

val prems = goalw Univ.thy [univ_def] 
    "[| a: univ(A);  b: univ(A) |] ==> {a,b} : univ(A)";
by (rtac doubleton_in_Vfrom_limit 1);
by (REPEAT (resolve_tac (prems@[Ord_nat,Limit_nat]) 1));
val doubleton_in_univ = result();

val prems = goalw Univ.thy [univ_def]
    "[| a: univ(A);  b: univ(A) |] ==> <a,b> : univ(A)";
by (rtac pair_in_Vfrom_limit 1);
by (REPEAT (resolve_tac (prems@[Ord_nat,Limit_nat]) 1));
val pair_in_univ = result();

goal Univ.thy "univ(A)*univ(A) <= univ(A)";
by (REPEAT (ares_tac [subsetI,pair_in_univ] 1
     ORELSE eresolve_tac [SigmaE, ssubst] 1));
val product_univ = result();

val product_subset_univ = standard
    (product_mono RS (product_univ RSN (2,subset_trans)));


(** The natural numbers **)

goalw Univ.thy [univ_def] "nat <= univ(A)";
by (rtac i_subset_Vfrom 1);
val nat_subset_univ = result();

(* n:nat ==> n:univ(A) *)
val nat_into_univ = standard (nat_subset_univ RS subsetD);

(** instances for 1 and 2 **)

goalw Univ.thy [one_def] "1 : univ(A)";
by (REPEAT (ares_tac [nat_into_univ, nat_0I, nat_succI] 1));
val one_in_univ = result();

(*unused!*)
goal Univ.thy "succ(succ(0)) : univ(A)";
by (REPEAT (ares_tac [nat_into_univ, nat_0I, nat_succI] 1));
val two_in_univ = result();

goalw Univ.thy [bool_def] "bool <= univ(A)";
by (fast_tac (ZF_cs addSIs [zero_in_univ,one_in_univ]) 1);
val bool_subset_univ = result();


(** Closure under disjoint union **)

val prems = goalw Univ.thy [Inl_def]
    "a: univ(A) ==> Inl(a) : univ(A)";
by (REPEAT (resolve_tac (prems@[zero_in_univ,pair_in_univ]) 1));
val Inl_in_univ = result();

val prems = goalw Univ.thy [Inr_def]
    "b: univ(A) ==> Inr(b) : univ(A)";
by (REPEAT (resolve_tac (prems@[one_in_univ, pair_in_univ]) 1));
val Inr_in_univ = result();

val prems = goal Univ.thy "[| B<=univ(A);  C<=univ(A) |] ==> B+C <= univ(A)";
by (rtac (sum_mono RS subset_trans) 1);
by (REPEAT (ares_tac (prems@[subsetI,Inl_in_univ,Inr_in_univ]) 1
     ORELSE eresolve_tac [sumE, ssubst] 1));
val sum_subset_univ = result();

(** Closure under binary union -- use Un_least **)
(** Closure under Collect -- use  (Collect_subset RS subset_trans)  **)
(** Closure under RepFun -- use   RepFun_subset  **)


