(*  Title: 	ZF/sum.thy
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Disjoint sums in Zermelo-Fraenkel Set Theory 
*)

Sum = Bool +
consts
    "+"    	::      "[i,i]=>i"      	(infixr 65)
    Inl,Inr     ::      "i=>i"
    case        ::      "[i,i=>i,i=>i]=>i"

rules
    sum_def     "A+B == {0}*A Un {1}*B"
    Inl_def     "Inl(a) == <0,a>"
    Inr_def     "Inr(b) == <1,b>"
    case_def    "case(u,c,d) == split(u, %y z. cond(y, d(z), c(z)))"
end
