(*  Title: 	ZF/sum
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Disjoint sums in Zermelo-Fraenkel Set Theory 
*)

open Sum;

val sum_defs = [sum_def,Inl_def,Inr_def,case_def];

(** constructors **)

val prems = goalw Sum.thy sum_defs "a : A ==> Inl(a) : A+B";
by (REPEAT (resolve_tac (prems @ [UnI1,SigmaI,singletonI]) 1));
val sum_InlI = result();

val prems = goalw Sum.thy sum_defs "b : B ==> Inr(b) : A+B";
by (REPEAT (resolve_tac (prems @ [UnI2,SigmaI,singletonI]) 1));
val sum_InrI = result();

(* Injection rules *)

val [major] = goalw Sum.thy sum_defs "Inl(a)=Inl(b) ==> a=b";
by (EVERY1 [rtac (major RS Pair_inject), atac]);
val Inl_inject = result();

val [major] = goalw Sum.thy sum_defs "Inr(a)=Inr(b) ==> a=b";
by (EVERY1 [rtac (major RS Pair_inject), atac]);
val Inr_inject = result();

val [major] = goalw Sum.thy sum_defs "Inl(a)=Inr(b) ==> P";
by (rtac (major RS Pair_inject) 1);
by (etac (sym RS one_neq_0) 1);
val Inl_neq_Inr = result();

val major::prems = goalw Sum.thy sum_defs
    "[| u: A+B;  \
\       !!x. [| x:A;  u=Inl(x) |] ==> P; \
\       !!y. [| y:B;  u=Inr(y) |] ==> P \
\    |] ==> P";
by (rtac (major RS UnE) 1);
by (REPEAT (rtac refl 1
     ORELSE eresolve_tac (prems@[SigmaE,singletonE,ssubst]) 1));
val sumE = result();

val [major] = goal Sum.thy
    "u: A+B ==> (EX x. x:A & u=Inl(x)) | (EX y. y:B & u=Inr(y))";
by (rtac (major RS sumE) 1);
by (fast_tac ZF_cs 1);
by (fast_tac ZF_cs 1);
val sumE2 = result();


(*** Eliminator -- case ***)

goalw Sum.thy sum_defs "case(Inl(a),c,d) = c(a)";
by (rtac (split RS trans) 1);
by (rtac cond_0 1);
val case_Inl = result();

goalw Sum.thy sum_defs "case(Inr(b),c,d) = d(b)";
by (rtac (split RS trans) 1);
by (rtac cond_1 1);
val case_Inr = result();

val prems = goalw Sum.thy [case_def]
    "[| u=u'; !!x. c(x)=c'(x);  !!y. d(y)=d'(y) |] ==>    \
\    case(u,c,d)=case(u',c',d')";
by (REPEAT (resolve_tac ([refl,split_cong,cond_cong] @ prems) 1));
val case_cong = result();

val major::prems = goal Sum.thy
    "[| u: A+B; \
\       !!x. x: A ==> c(x): C(Inl(x));   \
\       !!y. y: B ==> d(y): C(Inr(y)) \
\    |] ==> case(u,c,d) : C(u)";
by (rtac (major RS sumE) 1);
by (ALLGOALS (etac ssubst));
by (ALLGOALS (ASM_SIMP_TAC (ZF_ss addrews
			    (prems@[case_Inl,case_Inr]))));
val case_type = result();

