(*  Title: 	ZF/mono
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Monotonicity of various operations (for lattice properties, see subset.ML)
*)

val [sub,PQimp] = goal ZF.thy
    "[| A<=B;  !!x. [| x:A; P(x) |] ==> Q(x) |] \
\    ==> Collect(A,P) <= Collect(B,Q)";
by (fast_tac (ZF_cs addIs [sub RS subsetD, PQimp]) 1);
val Collect_mono = result();

(** Replacement, in its various formulations **)

(*Not easy to express monotonicity in P, since any "bigger" predicate
  would have to be single-valued*)
val prems = goal ZF.thy "A<=B ==> Replace(A,P) <= Replace(B,P)";
by (cfast_tac prems 1);
val Replace_mono = result();

val prems = goal ZF.thy "A<=B ==> {f(x). x:A} <= {f(x). x:B}";
by (cfast_tac prems 1);
val RepFun_mono = result();

val prems = goal ZF.thy "A<=B ==> Pow(A) <= Pow(B)";
by (cfast_tac prems 1);
val Pow_mono = result();

val prems = goal ZF.thy "A<=B ==> Union(A) <= Union(B)";
by (cfast_tac prems 1);
val Union_mono = result();

val prems = goal ZF.thy
    "[| A<=C;  !!x. x:A ==> B(x)<=D(x) \
\    |] ==> (UN x:A. B(x)) <= (UN x:C. D(x))";
by (fast_tac (ZF_cs addIs (prems RL [subsetD])) 1);
val UN_mono = result();

(*Intersection is ANTI-monotonic.  There are TWO premises! *)
val prems = goal ZF.thy "[| A<=B;  a:A |] ==> Inter(B) <= Inter(A)";
by (cfast_tac prems 1);
val Inter_anti_mono = result();

val prems = goal ZF.thy "[| C<=D |] ==> cons(a,C) <= cons(a,D)";
by (fast_tac (ZF_cs addIs (prems RL [subsetD])) 1);
val cons_mono = result();

val prems = goal ZF.thy "[| A<=C;  B<=D |] ==> A Un B <= C Un D";
by (cfast_tac prems 1);
val Un_mono = result();

val prems = goal ZF.thy "[| A<=C;  B<=D |] ==> A Int B <= C Int D";
by (cfast_tac prems 1);
val Int_mono = result();

val prems = goal ZF.thy "[| A<=C;  D<=B |] ==> A-B <= C-D";
by (cfast_tac prems 1);
val Diff_mono = result();

(*Generalize to Sigma_mono??*)
val prems = goal ZF.thy "[| A<=C;  B<=D |] ==> A*B <= C*D";
by (cfast_tac prems 1);
val product_mono = result();

(*Note that B->A and C->A are typically disjoint!*)
val prems = goal ZF.thy "[| B<=C |] ==> A->B <= A->C";
by (fast_tac (ZF_cs addIs ([lam_type] @ (prems RL [subsetD]))
     		    addEs [Pi_lamE]) 1);
val Pi_mono = result();

val [prem] = goalw ZF.thy [lam_def] "A<=B ==> Lambda(A,c) <= Lambda(B,c)";
by (rtac (prem RS RepFun_mono) 1);
val lam_mono = result();

(** Converse, domain, range, field **)

val prems = goal ZF.thy "r<=s ==> converse(r) <= converse(s)";
by (cut_facts_tac prems 1);
by (fast_tac ZF_cs 1);
val converse_mono = result();

val prems = goal ZF.thy "[| r<=s |] ==> domain(r)<=domain(s)";
by (cfast_tac prems 1);
val domain_mono = result();

val [prem] = goal ZF.thy "r <= Sigma(A,B) ==> domain(r) <= A";
by (rtac (domain_subset RS (prem RS domain_mono RS subset_trans)) 1);
val domain_rel_subset = result();

val prems = goal ZF.thy "[| r<=s |] ==> range(r)<=range(s)";
by (cfast_tac prems 1);
val range_mono = result();

val [prem] = goal ZF.thy "r <= A*B ==> range(r) <= B";
by (rtac (range_subset RS (prem RS range_mono RS subset_trans)) 1);
val range_rel_subset = result();

val prems = goal ZF.thy "[| r<=s |] ==> field(r)<=field(s)";
by (cfast_tac prems 1);
val field_mono = result();

val [prem] = goal ZF.thy "r <= A*A ==> field(r) <= A";
by (rtac (field_subset RS (prem RS field_mono RS subset_trans)) 1);
val field_rel_subset = result();


(** Images **)

val [prem1,prem2] = goal ZF.thy
    "[| !! x y. <x,y>:r ==> <x,y>:s;  A<=B |] ==> r``A <= s``B";
by (fast_tac (ZF_cs addIs [prem1, prem2 RS subsetD]) 1);
val image_pair_mono = result();

val [prem1,prem2] = goal ZF.thy
    "[| !! x y. <x,y>:r ==> <x,y>:s;  A<=B |] ==> r-``A <= s-``B";
by (fast_tac (ZF_cs addIs [prem1, prem2 RS subsetD]) 1);
val vimage_pair_mono = result();

val prems = goal ZF.thy "[| r<=s;  A<=B |] ==> r``A <= s``B";
by (cfast_tac prems 1);
val image_mono = result();

val prems = goal ZF.thy "[| r<=s;  A<=B |] ==> r-``A <= s-``B";
by (cfast_tac prems 1);
val vimage_mono = result();

(** Disjoint sums **)

val prems = goalw Sum.thy sum_defs "[| A<=C;  B<=D |] ==> A+B <= C+D";
by (REPEAT (resolve_tac (prems@[subset_refl,Un_mono,product_mono]) 1));
val sum_mono = result();
