(*  Title: 	ZF/list
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Lists in Zermelo-Fraenkel Set Theory 

map is a binding operator -- it applies to meta-level functions, not 
object-level functions.  This simplifies the final form of term_rec_conv,
although complicating its derivation.
*)

List = Univ +
consts
    "@"		::      "[i,i]=>i"      (infixr 60)
    list        ::      "i=>i"
    list_case   ::      "[i, i, [i,i]=>i] => i"
    list_rec    ::      "[i, i, [i,i,i]=>i] => i"
    map 	::      "[i=>i, i] => i"
    length,rev	::      "i=>i"
    flat    	::      "i=>i"
    list_add    ::      "i=>i"

rules
  list_def    "list(A) == lfp(univ(A), %X. {0} Un A*X)"

  list_case_def
      "list_case(l,c,h) == THE z. l=0 & z=c | (EX x y. l = <x,y> & z=h(x,y))"

  list_rec_def
      "list_rec(l,c,h) == Vrec(l, %l g.list_case(l, c, %x xs. h(x, xs, g`xs)))"

  map_def     "map(f,l)  == list_rec(l,  0,  %x xs r. <f(x), r>)"
  length_def  "length(l) == list_rec(l,  0,  %x xs r. succ(r))"
  app_def     "xs@ys     == list_rec(xs, ys, %x xs r. <x,r>)"
  rev_def     "rev(l)    == list_rec(l,  0,  %x xs r. r @ <x,0>)"
  flat_def    "flat(ls)  == list_rec(ls, 0,  %l ls r. l @ r)"
  list_add_def        "list_add(l)  == list_rec(l, 0,  %x xs r. x#+r)"

end
