(*  Title: 	ZF/lfp.ML
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

For lfp.thy.  The Knaster-Tarski Theorem and the Schroeder-Bernstein Theorem

Proved in the lattice of subsets of D, namely Pow(D), with Inter as glb
*)

open Lfp;

(*** Monotone operators ***)

val prems = goalw Lfp.thy [bnd_mono_def]
    "[| h(D)<=D;  \
\       !!W X. [| W<=D;  X<=D;  W<=X |] ==> h(W) <= h(X)  \
\    |] ==> bnd_mono(D,h)";  
by (REPEAT (ares_tac (prems@[conjI,allI,impI]) 1
     ORELSE etac subset_trans 1));
val bnd_monoI = result();

val [major] = goalw Lfp.thy [bnd_mono_def] "bnd_mono(D,h) ==> h(D) <= D";
by (rtac (major RS conjunct1) 1);
val bnd_monoD1 = result();

val major::prems = goalw Lfp.thy [bnd_mono_def]
    "[| bnd_mono(D,h);  W<=X;  X<=D |] ==> h(W) <= h(X)";
by (rtac (major RS conjunct2 RS spec RS spec RS mp RS mp) 1);
by (REPEAT (resolve_tac prems 1));
val bnd_monoD2 = result();

val [major,minor] = goal Lfp.thy "[| bnd_mono(D,h);  X<=D |] ==> h(X) <= D";
by (rtac (major RS bnd_monoD2 RS subset_trans) 1);
by (rtac (major RS bnd_monoD1) 3);
by (rtac minor 1);
by (rtac subset_refl 1);
val bnd_mono_subset = result();


(*** Proof of Knaster-Tarski Theorem ***)

(*lfp is contained in each pre-fixedpoint*)
val prems = goalw Lfp.thy [lfp_def] "[| h(A) <= A;  A<=D |] ==> lfp(D,h) <= A";
by (rtac (PowI RS CollectI RS Inter_lower) 1);
by (REPEAT (resolve_tac prems 1));
val lfp_lowerbound = result();

val [major] = goal Lfp.thy "bnd_mono(D,h) ==> lfp(D,h) <= D";
by (rtac (subset_refl RSN (2,lfp_lowerbound)) 1);
by (rtac (major RS bnd_monoD1) 1);
val lfp_subset = result();

(*This version is useful when "A" is not a subset of D;
  second premise could simply be h(D Int A) <= D or !!X. X<=D ==> h(X)<=D *)
val [hsub,hmono] = goal Lfp.thy
    "[| h(D Int A) <= A;  bnd_mono(D,h) |] ==> lfp(D,h) <= A";
by (rtac (lfp_lowerbound RS subset_trans) 1);
by (rtac (hmono RS bnd_mono_subset RS Int_greatest) 1);
by (REPEAT (resolve_tac [hsub,Int_lower1,Int_lower2] 1));
val lfp_Int_lowerbound = result();

val subset0_cs = FOL_cs
  addSIs [ballI, InterI, CollectI, PowI, empty_subsetI]
  addIs [bexI, UnionI, ReplaceI, RepFunI]
  addSEs [bexE, make_elim PowD, UnionE, ReplaceE, RepFunE,
	  CollectE, emptyE]
  addEs [ballE', InterD, make_elim InterD, subsetD];

val subset_cs = subset0_cs 
  addSIs [subset_refl,cons_subsetI,subset_consI,Union_least,UN_least,Un_least,
	  Inter_greatest,Int_greatest,RepFun_subset]
  addIs  [Union_upper,Inter_lower,Un_upper1,Un_upper2,Int_lower1,Int_lower2]
  addSEs [cons_subsetE];

(*This is useful to prove lfp_lemma2 but then is obsolete!*)
val hmono::prems = goalw Lfp.thy [lfp_def]
    "[| bnd_mono(D,h);  !!X. [| h(X) <= X;  X<=D |] ==> A<=X |] ==> \
\    A <= lfp(D,h)";
by (fast_tac (subset_cs addIs ((hmono RS bnd_monoD1)::prems)) 1);
val lfp_greatest = result();

val hmono::prems = goal Lfp.thy
    "[| bnd_mono(D,h);  h(A)<=A;  A<=D |] ==> h(lfp(D,h)) <= A";
by (rtac (hmono RS bnd_monoD2 RS subset_trans) 1);
by (rtac lfp_lowerbound 1);
by (REPEAT (resolve_tac prems 1));
val lfp_lemma1 = result();

val [hmono] = goal Lfp.thy
    "bnd_mono(D,h) ==> h(lfp(D,h)) <= lfp(D,h)";
by (rtac lfp_greatest 1);
by (rtac lfp_lemma1 2);
by (REPEAT (ares_tac [hmono] 1));
val lfp_lemma2 = result();

val [hmono] = goal Lfp.thy
    "bnd_mono(D,h) ==> lfp(D,h) <= h(lfp(D,h))";
by (rtac lfp_lowerbound 1);
by (rtac (hmono RS bnd_monoD2) 1);
by (rtac (hmono RS lfp_lemma2) 1);
by (rtac (hmono RS bnd_mono_subset) 2);
by (REPEAT (rtac (hmono RS lfp_subset) 1));
val lfp_lemma3 = result();

val prems = goal Lfp.thy
    "bnd_mono(D,h) ==> lfp(D,h) = h(lfp(D,h))";
by (REPEAT (resolve_tac (prems@[equalityI,lfp_lemma2,lfp_lemma3]) 1));
val Tarski = result();


(*** General induction rule for least fixedpoints ***)

val [hmono,indstep] = goal Lfp.thy
    "[| bnd_mono(D,h);  !!x. x : h(Collect(lfp(D,h),P)) ==> P(x) \
\    |] ==> h(Collect(lfp(D,h),P)) <= Collect(lfp(D,h),P)";
by (rtac subsetI 1);
by (rtac CollectI 1);
by (etac indstep 2);
by (rtac (hmono RS lfp_lemma2 RS subsetD) 1);
by (rtac (hmono RS bnd_monoD2 RS subsetD) 1);
by (REPEAT (ares_tac [Collect_subset, hmono RS lfp_subset] 1));
val Collect_is_pre_fixedpt = result();

(*This rule yields an induction hypothesis in which the components of a
  data structure may be assumed to be elements of lfp(D,h)*)
val prems = goal Lfp.thy
    "[| a : lfp(D,h);  bnd_mono(D,h);   		\
\       !!x. x : h(Collect(lfp(D,h),P)) ==> P(x) 	\
\    |] ==> P(a)";
by (rtac (Collect_is_pre_fixedpt RS lfp_lowerbound RS subsetD RS CollectD2) 1);
by (rtac (lfp_subset RS (Collect_subset RS subset_trans)) 3);
by (REPEAT (ares_tac prems 1));
val induct = result();

(** Definition forms of Tarski and induct, to control unfolding **)

val [rew,mono] = goal Lfp.thy
    "[| A==lfp(D,h);  bnd_mono(D,h) |] ==> A = h(A)";
by (rewtac rew);
by (rtac (mono RS Tarski) 1);
val def_Tarski = result();

val rew::prems = goal Lfp.thy
    "[| A == lfp(D,h);  a:A;  bnd_mono(D,h);   \
\       !!x. x : h(Collect(A,P)) ==> P(x) \
\    |] ==> P(a)";
by (rtac induct 1);
by (REPEAT (ares_tac (map (rewrite_rule [rew]) prems) 1));
val def_induct = result();

(*Monotonicity of lfp, where h precedes i under a domain-like partial order
  monotonicity of h is not strictly necessary; h must be bounded by D*)
val [hmono,imono,subhi] = goal Lfp.thy
    "[| bnd_mono(D,h);  bnd_mono(E,i); 		\
\       !!X. X<=D ==> h(X) <= i(X)  |] ==> lfp(D,h) <= lfp(E,i)";
by (rtac lfp_Int_lowerbound 1);
by (rtac (Int_lower1 RS subhi RS subset_trans) 1);
by (rtac hmono 2);
by (rtac (imono RS bnd_monoD2 RS subset_trans) 1);
by (rtac Int_lower2 1);
by (rtac (imono RS lfp_subset) 1);
by (rtac (imono RS lfp_lemma2) 1);
val lfp_mono = result();


(*** The Schroeder-Bernstein Theorem ***)

goal Lfp.thy "bnd_mono(X, %W. X - g``(Y - f``W))";
by (rtac bnd_monoI 1);
by (REPEAT (ares_tac [Diff_subset, subset_refl, Diff_mono, image_mono] 1));
val decomp_bnd_mono = result();

val decomp_subset = standard (decomp_bnd_mono RS lfp_subset);

(*Banach's Decomposition Theorem -- see Davey & Priestly, page 106*)
val prems = goal Lfp.thy
    "[| f: X->Y;  g: Y->X |] ==>   \
\    EX XA XB YA YB. (XA Int XB = 0) & (XA Un XB = X) &    \
\                    (YA Int YB = 0) & (YA Un YB = Y) &    \
\                    f``XA=YA & g``YB=XB";
by (res_inst_tac [("x", "lfp(X, %W. X - g``(Y - f``W))")] exI 1);
by (rtac exI 1);
by (res_inst_tac [("x", "f``?XA")] exI 1);
by (rtac exI 1);
by (REPEAT (resolve_tac (prems@[refl,decomp_subset,Diff_disjoint,
                  Diff_partition,fun_is_rel,image_subset,conjI]) 1));
by (rtac (trans RS sym) 1);
by (rtac (decomp_bnd_mono RS Tarski RS ssubst) 1);
by (rtac double_complement 1);
by (REPEAT (resolve_tac (prems@[refl,subset_refl,fun_is_rel,
				image_subset,Diff_subset]) 1));
val decomposition = result();

val prems = goal Lfp.thy
    "[| f: inj(X,Y);  g: inj(Y,X) |] ==> EX h. h: bij(X,Y)";
by (cut_facts_tac prems 1);
by (res_inst_tac [("f","f"), ("g","g")] (make_elim decomposition) 1);
by (REPEAT (ares_tac [inj_is_fun] 1
     ORELSE eresolve_tac [restrict_bij,exE,conjE] 1
     ORELSE hyp_subst_tac 1
     ORELSE resolve_tac [Un_upper1,Un_upper2,bij_disjoint_Un,
			 bij_converse_bij,exI] 1));
(* The instantiation of exI to "restrict(f,XA) Un converse(restrict(g,YB))"
   is forced by the context!! *)
val schroeder_bernstein = result();
