(*  Title: 	ZF/ex/term,thy
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Terms over a given alphabet -- function applications; illustrates list functor
  (essentially the same type as in Trees & Forests)
*)

Term = List +
consts
    term        ::      "i=>i"
    term_rec    ::      "[i, [i,i,i]=>i] => i"
    term_map    ::      "[i=>i, i] => i"
    term_size,reflect,preorder  ::      "i=>i"

rules
  term_def	"term(A) == lfp(univ(A), %X. A * list(X))"

  term_rec_def
   "term_rec(t,d) == Vrec(t, %t g. split(t, %x zs. d(x, zs, map(%z.g`z, zs))))"

  term_map_def	"term_map(f,t) == term_rec(t, %x zs rs. <f(x), rs>)"

  term_size_def	"term_size(t) == term_rec(t, %x zs rs. succ(list_add(rs)))"

  reflect_def	"reflect(t) == term_rec(t, %x zs rs. <x, rev(rs)>)"

  preorder_def	"preorder(t) == term_rec(t, %x zs rs. <x, flat(rs)>)"

end
