(*  Title: 	ZF/ex/simult.thy
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Primitives for simultaneous recursive type definitions
  includes worked example of trees & forests
*)

Simult = List +
consts
  Part        	 ::      "[i,i=>i] => i"
  tree,forest,TF ::      "i=>i"
  Tcons,Fcons 	 ::      "[i,i]=>i"
  Fnil        	 ::      "i"

  TF_rec	 ::	"[i, [i,i,i]=>i, i, [i,i,i,i]=>i] => i"
  TF_map      	 ::      "[i=>i, i] => i"
  TF_size 	 ::      "i=>i"
  TF_preorder 	 ::      "i=>i"
  list_of_TF 	 ::      "i=>i"
  TF_of_list 	 ::      "i=>i"

rules
  (*operator for selecting out the various types*)
  Part_def	"Part(A,h) == {x: A. EX z. x = h(z)}"

  TF_def	"TF(A) == lfp(univ(A), %X.  A * Part(X,Inr) \
\                            + ({0} Un Part(X,Inl)*Part(X,Inr)))"

  tree_def	"tree(A)   == Part(TF(A),Inl)"
  forest_def	"forest(A) == Part(TF(A),Inr)"

  Tcons_def 	"Tcons(a,tf) == Inl(<a,tf>)"
  Fnil_def  	"Fnil        == Inr(0)"
  Fcons_def 	"Fcons(t,tf) == Inr(<t,tf>)"

  TF_rec_def
    "TF_rec(z,b,c,d) == Vrec(z,  \
\      %z r. case(z, %xtf. split(xtf, %x tf. b(x, tf, r`tf)), \
\                      %l. list_case(l, c, \
\                             %t tf. d(t, tf, r`t, r`tf))))"

  list_of_TF_def
    "list_of_TF(z) == TF_rec(z, %x tf r.<Tcons(x,tf),0>, 0, \
\		             %t tf r1 r2. <t, r2>)"

  TF_of_list_def
    "TF_of_list(tf) == list_rec(tf, Fnil,  %t tf r. Fcons(t,r))"

  TF_map_def
    "TF_map(h,z) == TF_rec(z, %x tf r.Tcons(h(x),r), Fnil, \
\                           %t tf r1 r2. Fcons(r1,r2))"

  TF_size_def
    "TF_size(z) == TF_rec(z, %x tf r.succ(r), 0, %t tf r1 r2. r1#+r2)"

  TF_preorder_def
    "TF_preorder(z) == TF_rec(z, %x tf r.<x,r>, 0, %t tf r1 r2. r1@r2)"

end
