(*  Title: 	ZF/ex/simult
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Primitives for simultaneous recursive type definitions
  includes worked example of trees & forests

Still needs

"TF_reflect == (%z. TF_rec(z, %x ts r. Tcons(x,r), 0, 
               %t ts r1 r2. TF_of_list(list_of_TF(r2) @ <r1,0>)))"
*)

open Simult;

(*** General rules for Part ***)

val prems = goalw Simult.thy [Part_def]
    "[| a : A;  a=h(b) |] ==> a : Part(A,h)";
by (REPEAT (resolve_tac (prems@[refl,exI,CollectI]) 1));
val PartI = result();

val major::prems = goalw Simult.thy [Part_def]
    "[| a : Part(A,h);  !!z. [| a : A;  a=h(z) |] ==> P  \
\    |] ==> P";
by (rtac (major RS CollectE) 1);
by (etac exE 1);
by (REPEAT (ares_tac prems 1));
val PartE = result();

goalw Simult.thy [Part_def] "Part(A,h) <= A";
by (rtac Collect_subset 1);
val Part_subset = result();

val [prem] = goalw Simult.thy [Part_def] "A<=B ==> Part(A,h)<=Part(B,h)";
by (rtac (prem RS Collect_mono) 1);
by (assume_tac 1);
val Part_mono = result();

goal Simult.thy "Part(A+B,Inl) = {Inl(x). x: A}";
by (fast_tac (ZF_cs addIs [PartI,sum_InlI,equalityI]
	            addSEs [PartE,sumE,Inl_neq_Inr]
	            addSDs [Inl_inject]) 1);
val Part_Inl = result();

goal Simult.thy "Part(A+B,Inr) = {Inr(y). y: B}";
by (fast_tac (ZF_cs addIs [PartI,sum_InrI,equalityI]
	            addSEs [PartE,sumE, sym RS Inl_neq_Inr]
	            addSDs [Inr_inject]) 1);
val Part_Inr = result();


(*** Monotonicity and unfolding of the function ***)

goal Simult.thy 
    "bnd_mono(univ(A), %X. A*Part(X,Inr) + ({0} Un Part(X,Inl)*Part(X,Inr)))";
by (rtac bnd_monoI 1);
by (REPEAT (ares_tac [subset_refl,
                      Un_mono, sum_mono, product_mono, Part_mono] 2));
by (REPEAT (ares_tac [subset_refl,
                      zero_in_univ, singleton_subsetI, A_subset_univ,
		      Un_least, Part_subset RS subset_trans,
		      sum_subset_univ, product_subset_univ] 1));
val TF_bnd_mono = result();

(* TF(A) = A*Part(TF(A),Inr) + ({0} Un Part(TF(A),Inl)*Part(TF(A),Inr)) *)
val TF_unfold = TF_bnd_mono RS (TF_def RS def_Tarski);

val TF_defs = [tree_def,forest_def,Tcons_def,Fnil_def,Fcons_def];

(** Isomorphisms involving tree(A) and forest(A) -- interesting but unused **)

goalw Simult.thy TF_defs "tree(A) = {Inl(x). x: A*forest(A)}";
by (res_inst_tac [("P", "%x.?t(x) = ?u::i")] (TF_unfold RS ssubst) 1);
by (rtac Part_Inl 1);
val tree_unfold = result();

goalw Simult.thy TF_defs "forest(A) = {Inr(x). x: {0} Un tree(A)*forest(A)}";
by (res_inst_tac [("P", "%x.?t(x) = ?u::i")] (TF_unfold RS ssubst) 1);
by (rtac Part_Inr 1);
val forest_unfold = result();

(** Introduction rule for "tree" **)

val prems = goalw Simult.thy TF_defs
    "[| a:A;  tf: forest(A) |] ==> Tcons(a,tf) : tree(A)";
by (rtac (TF_unfold RS ssubst) 1);
by (rtac (SigmaI RS sum_InlI RS PartI) 1);
by (REPEAT (ares_tac ([refl]@prems) 1));
val treeI = result();

(** Introduction rules for "forest" **)

goalw Simult.thy TF_defs "Fnil : forest(A)";
by (rtac (TF_unfold RS ssubst) 1);
by (rtac (sum_InrI RS PartI) 1);
by (rtac (singletonI RS UnI1) 1);
by (rtac refl 1);
val forest_FnilI = result();

val prems = goalw Simult.thy TF_defs
    "[| t: tree(A);  tf: forest(A) |] ==> Fcons(t,tf) : forest(A)";
by (rtac (TF_unfold RS ssubst) 1);
by (rtac (sum_InrI RS PartI) 1);
by (rtac (SigmaI RS UnI2) 1);
by (REPEAT (ares_tac ([refl]@prems) 1));
val forest_FconsI = result();

(** Elimination -- structural induction on TF **)

val major::prems = goalw Simult.thy TF_defs
    "[| z: TF(A);  \
\       !!x tf. [| x: A;  tf: forest(A);  R(tf) |] ==> R(Tcons(x,tf)); \
\       R(Fnil);        \
\       !!t tf. [| t: tree(A);  tf: forest(A);  R(t);  R(tf) \
\               |] ==> R(Fcons(t,tf))    \
\    |] ==> R(z)";
by (rtac (major RS (TF_def RS def_induct)) 1);
by (rtac TF_bnd_mono 1);
by (fast_tac (ZF_cs addIs (prems@[PartI]) addSEs [PartE,sumE]) 1);
val TF_induct = result();


(*** Disjointness of tree(A) and forest(A) ***)

val TF_rep_cs = ZF_cs addIs [PartI]
		      addSDs [Inl_inject, Inr_inject]
		      addSEs [Inl_neq_Inr, sym RS Inl_neq_Inr, PartE];

(*unused!*)
val prems = goalw Simult.thy TF_defs "[| c:tree(A); c:forest(A) |] ==> R";
by (cut_facts_tac prems 1);
by (fast_tac TF_rep_cs 1);
val TF_disjoint = result();

goalw Simult.thy TF_defs "~ Tcons(a,tf) : forest(A)";
by (fast_tac TF_rep_cs 1);
val Tcons_not_forest = result();

goalw Simult.thy TF_defs "~ Fnil : tree(A)";
by (fast_tac TF_rep_cs 1);
val Fnil_not_tree = result();

goalw Simult.thy TF_defs "~ Fcons(t,tf) : tree(A)";
by (fast_tac TF_rep_cs 1);
val Fcons_not_tree = result();

(*This lemma replaces a use of subgoal_tac to prove tree_forest_induct*)
val prems = goalw Simult.thy (Part_def::TF_defs)
    "ALL z: TF(A). (z:tree(A) --> P(z)) & (z:forest(A) --> Q(z))    \
\    ==> (ALL z:tree(A). P(z)) & (ALL z:forest(A). Q(z))";
by (cfast_tac prems 1);
val TF_induct_lemma = result();

val prems = goal Simult.thy
    "[| !!x tf. [| x: A;  tf: forest(A);  Q(tf) |] ==> P(Tcons(x,tf));     \
\	Q(Fnil);        \
\       !!t tf. [| t: tree(A);  tf: forest(A);  P(t);  Q(tf) \
\               |] ==> Q(Fcons(t,tf))    \
\    |] ==> (ALL t:tree(A). P(t)) & (ALL tf: forest(A). Q(tf))";
by (rtac (ballI RS TF_induct_lemma) 1);
by (etac TF_induct 1);
by (ALLGOALS 
    (ASM_SIMP_TAC 
     (ZF_ss addrews (prems@[Tcons_not_forest,Fnil_not_tree,Fcons_not_tree]))));
val tree_forest_induct = result();


(*** TF_rec -- by Vset recursion ***)

(*Used only to verify TF_rec*)
val TF_rec_ss = ZF_ss 
    addcongs (mk_typed_congs Simult.thy 
		   [("b", "[i,i,i]=>i"), ("d", "[i,i,i,i]=>i")])
    addrews [case_Inl, case_Inr, 
	     list_case_0, list_case_Pair,
	     rank_Inl RSN (2,rank_trans), rank_Inr RSN (2,rank_trans),
	     Vset_rankI, rank_pair1, rank_pair2];

(** conversion rules **)

goalw Simult.thy TF_defs
    "TF_rec(Tcons(a,tf), b, c, d) = b(a, tf, TF_rec(tf,b,c,d))";
by (rtac (TF_rec_def RS def_Vrec RS trans) 1);
by (SIMP_TAC TF_rec_ss 1);
val TF_rec_Tcons = result();

goalw Simult.thy TF_defs
    "TF_rec(Fnil, b, c, d) = c";
by (rtac (TF_rec_def RS def_Vrec RS trans) 1);
by (SIMP_TAC TF_rec_ss 1);
val TF_rec_Fnil = result();

goalw Simult.thy TF_defs
    "TF_rec(Fcons(t,tf), b, c, d) = \
\      d(t, tf, TF_rec(t, b, c, d), TF_rec(tf, b, c, d))";
by (rtac (TF_rec_def RS def_Vrec RS trans) 1);
by (SIMP_TAC TF_rec_ss 1);
val TF_rec_Fcons = result();

(*list_ss includes list operations as well as arith_ss*)
val TF_ss = list_ss addrews
  [TF_rec_Tcons, TF_rec_Fnil, TF_rec_Fcons,
   treeI, forest_FnilI, forest_FconsI];

(** Type checking **)

val major::prems = goal Simult.thy
    "[| z: TF(A);  \
\       !!x tf r. [| x: A;  tf: forest(A);  r: C(tf) 		\
\                 |] ==> b(x,tf,r): C(Tcons(x,tf));     	\
\	c : C(Fnil);        					\
\       !!t tf r1 r2. [| t: tree(A);  tf: forest(A);  r1: C(t); r2: C(tf) \
\                     |] ==> d(t,tf,r1,r2): C(Fcons(t,tf))    	\
\    |] ==> TF_rec(z,b,c,d) : C(z)";
by (rtac (major RS TF_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC (TF_ss addrews prems)));
val TF_rec_type = result();

val prems = goal Simult.thy
    "[| !!x tf r. [| x: A;  tf: forest(A);  r: D(tf) 		\
\                 |] ==> b(x,tf,r): C(Tcons(x,tf));     	\
\	c : D(Fnil);        					\
\       !!t tf r1 r2. [| t: tree(A);  tf: forest(A);  r1: C(t); r2: D(tf) \
\                     |] ==> d(t,tf,r1,r2): D(Fcons(t,tf))    	\
\    |] ==> (ALL t:tree(A).    TF_rec(t,b,c,d)  : C(t)) &  	\
\           (ALL tf: forest(A). TF_rec(tf,b,c,d) : D(tf))";
by (rtac tree_forest_induct 1);
by (ALLGOALS (ASM_SIMP_TAC (TF_ss addrews prems)));
val tree_forest_rec_type = result();


(** Versions for use with definitions **)

val [rew] = goal Simult.thy
    "[| !!z. j(z)==TF_rec(z,b,c,d) |] ==> j(Tcons(a,tf)) = b(a,tf,j(tf))";
by (rewtac rew);
by (rtac TF_rec_Tcons 1);
val def_TF_rec_Tcons = result();

val [rew] = goal Simult.thy
    "[| !!z. j(z)==TF_rec(z,b,c,d) |] ==> j(Fnil) = c";
by (rewtac rew);
by (rtac TF_rec_Fnil 1);
val def_TF_rec_Fnil = result();

val [rew] = goal Simult.thy
    "[| !!z. j(z)==TF_rec(z,b,c,d) |] ==> j(Fcons(t,tf)) = d(t,tf,j(t),j(tf))";
by (rewtac rew);
by (rtac TF_rec_Fcons 1);
val def_TF_rec_Fcons = result();

fun TF_recs def = 
      (standard (def RS def_TF_rec_Tcons),
       standard (def RS def_TF_rec_Fnil),
       standard (def RS def_TF_rec_Fcons));


(** list_of_TF and TF_of_list **)

val (list_of_TF_Tcons, list_of_TF_Fnil, list_of_TF_Fcons) =
	TF_recs list_of_TF_def;

val prems = goalw Simult.thy [list_of_TF_def]
    "z: TF(A) ==> list_of_TF(z) : list(tree(A))";
by (REPEAT (ares_tac ([TF_rec_type,treeI] @ prems @ list_typechecks) 1));
val list_of_TF_type = result();

val (TF_of_list_0,TF_of_list_Pair) = list_recs TF_of_list_def;

val prems = goalw Simult.thy [TF_of_list_def] 
    "l: list(tree(A)) ==> TF_of_list(l) : forest(A)";
by (REPEAT (ares_tac (prems@[list_rec_type, forest_FnilI, forest_FconsI]) 1));
val TF_of_list_type = result();


(** TF_map **)

val (TF_map_Tcons, TF_map_Fnil, TF_map_Fcons) =
	TF_recs TF_map_def;

val prems = goalw Simult.thy [TF_map_def]
    "[| !!x. x: A ==> h(x): B |] ==> \
\      (ALL t:tree(A). TF_map(h,t) : tree(B)) &  \
\      (ALL tf: forest(A). TF_map(h,tf) : forest(B))";
by (REPEAT
    (ares_tac
     ([tree_forest_rec_type, treeI, forest_FnilI, forest_FconsI] @ prems) 1));
val TF_map_type = result();


(** TF_size **)

val (TF_size_Tcons, TF_size_Fnil, TF_size_Fcons) =
	TF_recs TF_size_def;

val prems = goalw Simult.thy [TF_size_def]
    "z: TF(A) ==> TF_size(z) : nat";
by (REPEAT (ares_tac ([TF_rec_type, add_type, nat_0I, nat_succI] @ prems) 1));
val TF_size_type = result();


(** TF_preorder **)

val (TF_preorder_Tcons, TF_preorder_Fnil, TF_preorder_Fcons) =
	TF_recs TF_preorder_def;

val prems = goalw Simult.thy [TF_preorder_def]
    "z: TF(A) ==> TF_preorder(z) : list(A)";
by (REPEAT (ares_tac ([TF_rec_type, app_type,list_0I, list_PairI] @ prems) 1));
val TF_preorder_type = result();


(** TF(A) as the union of tree(A) and forest(A) **)

goalw Simult.thy TF_defs "tree(A) <= TF(A)";
by (fast_tac TF_rep_cs 1);
val tree_subset_TF = result();

goalw Simult.thy TF_defs "forest(A) <= TF(A)";
by (fast_tac TF_rep_cs 1);
val forest_subset_TF = result();

val tree_TF_I = tree_subset_TF RS subsetD
and forest_TF_I = forest_subset_TF RS subsetD;

goal Simult.thy "TF(A) = tree(A) Un forest(A)";
by (rtac equalityI 1);
by (rtac Un_least 2);
by (rtac tree_subset_TF 2);
by (rtac forest_subset_TF 2);
by (rtac subsetI 1);
by (etac TF_induct 1);
by (ALLGOALS (fast_tac (ZF_cs addIs [treeI, forest_FnilI, forest_FconsI])));
val TF_equals_Un = result();

(** Term simplification **)

val TF_typechecks =
    [treeI, forest_FnilI, forest_FconsI, tree_TF_I, forest_TF_I,
     list_of_TF_type, TF_map_type, TF_size_type, TF_preorder_type];

val TF_not_typechecks =
    [Tcons_not_forest,Fnil_not_tree,Fcons_not_tree];

val TF_congs = mk_congs Simult.thy
    ["Tcons","Fnil","Fcons","TF_rec","list_of_TF","TF_of_list","TF_map",
     "TF_size","TF_preorder"];

val TF_rewrites =
   [TF_rec_Tcons, TF_rec_Fnil, TF_rec_Fcons,
    list_of_TF_Tcons, list_of_TF_Fnil, list_of_TF_Fcons,
    TF_of_list_0,TF_of_list_Pair,
    TF_map_Tcons, TF_map_Fnil, TF_map_Fcons,
    TF_size_Tcons, TF_size_Fnil, TF_size_Fcons,
    TF_preorder_Tcons, TF_preorder_Fnil, TF_preorder_Fcons];

val TF_ss = list_ss addcongs TF_congs 
		    addrews (TF_rewrites@TF_typechecks@TF_not_typechecks);

(** theorems about list_of_TF and TF_of_list **)

(*essentially the same as list induction*)
val major::prems = goal Simult.thy 
    "[| tf: forest(A);  \
\       R(Fnil);        \
\       !!t tf. [| t: tree(A);  tf: forest(A);  R(tf) |] ==> R(Fcons(t,tf))  \
\    |] ==> R(tf)";
by (rtac (major RS rev_mp) 1);
by (rtac (major RS (forest_subset_TF RS subsetD) RS TF_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC (TF_ss addrews prems)));
val forest_induct = result();

val [major] = goal Simult.thy
    "tf: forest(A) ==> TF_of_list(list_of_TF(tf)) = tf";
by (rtac (major RS forest_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC TF_ss));
val forest_iso = result();

val [major] = goal Simult.thy
    "ts: list(tree(A)) ==> list_of_TF(TF_of_list(ts)) = ts";
by (rtac (major RS list_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC TF_ss));
val tree_list_iso = result();

(** theorems about TF_map **)

val [major] = goal Simult.thy
    "z: TF(A) ==> TF_map(%u.u, z) = z";
by (rtac (major RS TF_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC TF_ss));
val TF_map_ident = result();

val [major] = goal Simult.thy
    "z: TF(A) ==> TF_map(h, TF_map(j,z)) = TF_map(%u.h(j(u)), z)";
by (rtac (major RS TF_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC TF_ss));
val TF_map_compose = result();

(** theorems about TF_size **)

val [major] = goal Simult.thy
    "z: TF(A) ==> TF_size(TF_map(h,z)) = TF_size(z)";
by (rtac (major RS TF_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC TF_ss));
val TF_size_TF_map = result();

val [major] = goal Simult.thy
    "z: TF(A) ==> TF_size(z) = length(TF_preorder(z))";
by (rtac (major RS TF_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC (TF_ss addrews [length_app])));
val TF_size_length = result();

(** theorems about TF_preorder **)

val [major] = goal Simult.thy
    "z: TF(A) ==> TF_preorder(TF_map(h,z)) = map(h, TF_preorder(z))";
by (rtac (major RS TF_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC (TF_ss addrews [map_app_distrib])));
val TF_preorder_TF_map = result();
