(*  Title: 	ZF/ex/sexp.thy
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

S-expressions, i.e. general binary trees
*)

Sexp = Univ +
consts
    sexp,Atom   ::      "i=>i"
    sexp_case   ::      "[i, i=>i, [i,i]=>i] => i"
    sexp_rec    ::      "[i, i=>i, [i,i,i,i]=>i] => i"

rules
    sexp_def    "sexp(A) == lfp(univ(A), %X. RepFun(A,Atom) Un X*X)"

    Atom_def    "Atom(a) == {0,a}"

    sexp_case_def
   	"sexp_case(M,c,d) == THE z. (EX x.   M=Atom(x) & z=c(x))  \
\                            | (EX N1 N2. M = <N1,N2>  & z=d(N1,N2))"

    sexp_rec_def
   	"sexp_rec(M,c,d) ==   \
\       Vrec(M, %M g. sexp_case(M, c, %N1 N2. d(N1, N2, g`N1, g`N2)))"

end
