(*  Title: 	ZF/ex/prop-log.thy
    Author: 	Tobias Nipkow & Lawrence C Paulson
    Copyright   1992  University of Cambridge

Inductive definition of propositional logic.
*)

PL = Sexp + Finite +
consts
    pl,false    ::      "i"
    var         ::      "i => i"        ("#_" [100] 100)
    "=>"        ::      "[i,i] => i"    (infixr 90)

    is_true     ::      "[i,i] => o"
    "|="        ::      "[i,i] => o"    (infixl 50)

    axK,axS,axDN        ::      "i"
    ruleMP,thms,conseq  ::      "i => i"
    "|-"        ::      "[i,i] => o"    (infixl 50)

    hyps        ::      "[i,i] => i"

rules
  (** pl and its constructors **)
    pl_def      "pl     == sexp(nat)"
    false_def   "false  == Atom(0)"
    var_def     "#v     == Atom(succ(v))"
    imp_def     "p=>q   == <p,q>"

  (** Semantics of propositional logic **)
    is_true_def
   "is_true(p,t) == sexp_rec(p, %x. rec(x, 0, %v w. if(v:t, 1, 0)), \
\                       %p q tp tq. if(tp=1,tq,1))         =  1"

    (*For every valuation, if all elements of H are true then so is p*)
    sat_def     "H |= p == ALL t. (ALL q:H. is_true(q,t)) --> is_true(p,t)"

  (** Proof theory for propositional logic **)

    axK_def   "axK == UN p:pl. UN q:pl. {p=>q=>p}"
    axS_def   "axS == UN p:pl. UN q:pl. UN r:pl. {(p=>q=>r) => (p=>q) => p=>r}"
    axDN_def  "axDN == UN p:pl. {((p=>false) => false) => p}"

    (*the use of subsets simplifies the proof of monotonicity*)
    ruleMP_def  "ruleMP(X) == UN p:pl. {q:pl. {p=>q, p} <= X}"

    thms_def
   "thms(H) == lfp(pl, %X. (H Int pl) Un axK Un axS Un axDN Un ruleMP(X))"

    conseq_def  "H |- p == p : thms(H)"

  (** A finite set of hypotheses from t and the vars in p **)
    hyps_def
     "hyps(p,t) == sexp_rec(p, %x. rec(x, 0, \
\                                       %v w. {if(v:t, #v, #v=>false)}), \
\                               %p q Hp Hq. Hp Un Hq)"

end
