(*  Title: 	ZF/ex/misc
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Miscellaneous examples Zermelo-Fraenkel Set Theory 
*)

writeln"ZF/ex/misc";


(*** Cantor's Theorem: There is no surjection from a set to its powerset. ***)

val cantor_cs = FOL_cs   (*precisely the rules needed for the proof*)
  addSIs [ballI, CollectI, PowI, subsetI] addIs [bexI]
  addSEs [CollectE, equalityCE];

(*The search is undirected and similar proof attempts fail*)
goal ZF.thy "ALL f: A->Pow(A). EX S: Pow(A). ALL x:A. ~ f`x = S";
by (best_tac cantor_cs 1);
result();

(*This form displays the diagonal term, {x: A . ~ x: f`x} *)
val [prem] = goal ZF.thy
    "f: A->Pow(A) ==> (ALL x:A. ~ f`x = ?S) & ?S: Pow(A)";
by (best_tac cantor_cs 1);
result();

(*yet another version...*)
goalw Perm.thy [surj_def] "~ f : surj(A,Pow(A))";
by (safe_tac ZF_cs);
by (etac ballE 1);
by (best_tac (cantor_cs addSEs [bexE]) 1);
by (fast_tac ZF_cs 1);
result();


(*** Composition of homomorphisms is a homomorphism ***)

(*Given as a challenge problem in
  R. Boyer et al.,
  Set Theory in First-Order Logic: Clauses for G\"odel's Axioms,
  JAR 2 (1986), 287-327 
*)

val hom_ss =   (*collecting the relevant lemmas*)
  ZF_ss addrews [comp_func,comp_func_apply,SigmaI,apply_type]
   	addcongs (mk_congs Perm.thy ["op O"]);

(*This version uses a super application of SIMP_TAC;  it is SLOW
  Expressing the goal by --> instead of ==> would make it slower still*)
val [hom_eq] = goal Perm.thy
    "(ALL A f B g. hom(A,f,B,g) = \
\          {H: A->B. f:A*A->A & g:B*B->B & \
\                    (ALL x:A. ALL y:A. H`(f`<x,y>) = g`<H`x,H`y>)}) ==> \
\    J : hom(A,f,B,g) & K : hom(B,g,C,h) -->  \
\    (K O J) : hom(A,f,C,h)";
by (SIMP_TAC (hom_ss setauto fast_tac prop_cs addrews [hom_eq]) 1);
val comp_homs = result();

(*This version uses meta-level rewriting, safe_tac and ASM_SIMP_TAC*)
val [hom_def] = goal Perm.thy
    "(!! A f B g. hom(A,f,B,g) == \
\          {H: A->B. f:A*A->A & g:B*B->B & \
\                    (ALL x:A. ALL y:A. H`(f`<x,y>) = g`<H`x,H`y>)}) ==> \
\    J : hom(A,f,B,g) & K : hom(B,g,C,h) -->  \
\    (K O J) : hom(A,f,C,h)";
by (rewtac hom_def);
by (safe_tac ZF_cs);
by (ASM_SIMP_TAC hom_ss 1);
by (ASM_SIMP_TAC hom_ss 1);
val comp_homs = result();


(** A characterization of functions, suggested by Tobias Nipkow **)

goalw ZF.thy [Pi_def]
    "r: domain(r)->B  <->  r <= domain(r)*B & (ALL X. r `` (r -`` X) <= X)";
by (safe_tac ZF_cs);
by (fast_tac (ZF_cs addSDs [bspec RS ex1_equalsE]) 1);
by (eres_inst_tac [("x", "{y}")] allE 1);
by (fast_tac ZF_cs 1);
result();

writeln"Reached end of file.";
