(*  Title: 	ZF/ex/finite.ML
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

For finite.thy.  Finite sets; could define cardinality?

prove X:Fin(A) ==> EX n:nat. EX f. f:bij(X,n)
	card(0)=0
	[| ~ a:b; b: Fin(A) |] ==> card(cons(a,b)) = succ(card(b))

b: Fin(A) ==> inj(b,b)<=surj(b,b)

Limit(i) ==> Fin(Vfrom(A,i)) <= Un j:i. Fin(Vfrom(A,j))
Fin(univ(A)) <= univ(A)
*)

open Finite;

(** Monotonicity and unfolding of the function **)

goal Finite.thy "bnd_mono(Pow(A), %Z. {0} Un (UN y:Z. UN x:A. {cons(x,y)}))";
by (rtac bnd_monoI 1);
by (REPEAT (ares_tac [subset_refl, Un_mono, UN_mono] 2));
by (fast_tac ZF_cs 1);
val Fin_bnd_mono = result();

val [prem] = goalw Finite.thy [Fin_def] "A<=B ==> Fin(A) <= Fin(B)";
by (rtac lfp_mono 1);
by (REPEAT (resolve_tac [Fin_bnd_mono, prem, 
			 subset_refl, Un_mono, UN_mono, RepFun_mono] 1));
val Fin_mono = result();

goalw Finite.thy [Fin_def] "Fin(A) <= Pow(A)";
by (fast_tac (subset_cs addIs [lfp_lowerbound]) 1);
val Fin_subset_Pow = result();

(* A : Fin(B) ==> A <= B *)
val FinD = Fin_subset_Pow RS subsetD RS PowD;

(** Type checking of 0 (as nil) and <-,-> (as cons) **)

val Fin_unfold = Fin_bnd_mono RS (Fin_def RS def_Tarski);

goal Finite.thy "0 : Fin(A)";
by (rtac (Fin_unfold RS ssubst) 1);
by (rtac (singletonI RS UnI1) 1);
val Fin_0I = result();

val prems = goal Finite.thy "[| a: A;  b: Fin(A) |] ==> cons(a,b) : Fin(A)";
by (rtac (Fin_unfold RS ssubst) 1);
by (REPEAT (resolve_tac (prems @ [UN_I, UnI2, singletonI]) 1));
val Fin_consI = result();

(** Induction on finite sets **)

(*Discharging ~ x:y entails extra work*)
val major::prems = goal Finite.thy 
    "[| b: Fin(A);  \
\       P(0);        \
\       !!x y. [| x: A;  y: Fin(A);  ~ x:y;  P(y) |] ==> P(cons(x,y)) \
\    |] ==> P(b)";
by (rtac (major RS (Fin_def RS def_induct)) 1);
by (rtac Fin_bnd_mono 1);
by (safe_tac ZF_cs);
(*Excluded middle on x:y would be more straightforward;
  actual proof is inspired by Dov Gabbay's Restart Rule*)
by (rtac classical 2);
by (REPEAT (ares_tac prems 1));
by (etac contrapos 1);
by (rtac (cons_absorb RS ssubst) 1);
by (REPEAT (assume_tac 1));
val Fin_induct = result();

(** Simplification for Fin **)
val Fin_ss = arith_ss 
    addcongs mk_congs Finite.thy ["Fin"]
    addrews [Fin_0I, Fin_consI];

(*The union of two finite sets is finite*)
val major::prems = goal Finite.thy
    "[| b: Fin(A);  c: Fin(A) |] ==> b Un c : Fin(A)";
by (rtac (major RS Fin_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC (Fin_ss addrews (prems@[Un_0, Un_cons]))));
val Fin_UnI = result();

(*The union of a set of finite sets is finite*)
val [major] = goal Finite.thy "C : Fin(Fin(A)) ==> Union(C) : Fin(A)";
by (rtac (major RS Fin_induct) 1);
by (ALLGOALS (ASM_SIMP_TAC (Fin_ss addrews [Union_0, Union_cons, Fin_UnI])));
val Fin_UnionI = result();

(*Every subset of a finite set is finite*)
val [subs,fin] = goal Finite.thy "[| c<=b;  b: Fin(A) |] ==> c: Fin(A)";
by (EVERY1 [subgoal_tac "(ALL z. z<=b --> z: Fin(A))",
	    etac (spec RS mp),
	    rtac subs]);
by (rtac (fin RS Fin_induct) 1);
by (SIMP_TAC (Fin_ss addrews [subset_empty_iff]) 1);
by (safe_tac (ZF_cs addSDs [subset_cons_iff RS iffD1]));
by (eres_inst_tac [("b","z")] (cons_Diff RS subst) 2);
by (ALLGOALS (ASM_SIMP_TAC Fin_ss));
val Fin_subset = result();

val major::prems = goal Finite.thy 
    "[| c: Fin(A);  b: Fin(A);  				\
\       P(b);       						\
\       !!x y. [| x: A;  y: Fin(A);  x:y;  P(y) |] ==> P(y-{x}) \
\    |] ==> c<=b --> P(b-c)";
by (rtac (major RS Fin_induct) 1);
by (rtac (Diff_cons RS ssubst) 2);
by (ALLGOALS (ASM_SIMP_TAC (Fin_ss addrews (prems@[Diff_0, cons_subset_iff, 
				Diff_subset RS Fin_subset]))));
val Fin_0_induct_lemma = result();

val prems = goal Finite.thy 
    "[| b: Fin(A);  						\
\       P(b);        						\
\       !!x y. [| x: A;  y: Fin(A);  x:y;  P(y) |] ==> P(y-{x}) \
\    |] ==> P(0)";
by (rtac (Diff_cancel RS subst) 1);
by (rtac (Fin_0_induct_lemma RS mp) 1);
by (REPEAT (ares_tac (subset_refl::prems) 1));
val Fin_0_induct = result();
