(*  Title: 	ZF/bt.thy
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Binary trees
*)

BT = List +
consts
    bt        	:: "i=>i"
    bt_case   	:: "[i, i, [i,i,i]=>i] => i"
    bt_rec    	:: "[i, i, [i,i,i,i,i]=>i] => i"
    n_nodes	:: "i=>i"
    n_leaves   	:: "i=>i"
    bt_reflect 	:: "i=>i"

rules
  bt_def    	"bt(A) == lfp(univ(A), %X. {0} Un A*X*X)"

  bt_case_def
    "bt_case(t,c,h) == THE u. t=0 & u=c | (EX x y z. t = <x,y,z> & u=h(x,y,z))"

  bt_rec_def
    "bt_rec(t,c,h) == Vrec(t, %t g.bt_case(t, c, %x y z. h(x,y,z,g`y,g`z)))"

  n_nodes_def	"n_nodes(t) == bt_rec(t,  0,  %x y z r s. succ(r#+s))"
  n_leaves_def	"n_leaves(t) == bt_rec(t,  succ(0),  %x y z r s. r#+s)"
  bt_reflect_def "bt_reflect(t) == bt_rec(t,  0,  %x y z r s. <x,s,r>)"

end
