(*  Title: 	ZF/arith.thy
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Arithmetic operators and their definitions
*)

Arith = Epsilon +
consts
    rec		::	"[i, i, [i,i]=>i]=>i"
    "#*"        ::      "[i,i]=>i"      (infixl 70)
    "#'/"       ::      "[i,i]=>i"      (infixl 70) 
    "#'/'/"     ::      "[i,i]=>i"      (infixl 70)
    "#+"	::      "[i,i]=>i"      (infixl 65)
    "#-"        ::      "[i,i]=>i"      (infixl 65)

rules
    rec_def  "rec(k,a,b) ==  transrec(k, %n f. nat_case(n, a, %m. b(m, f`m)))"

    add_def     "m#+n == rec(m, n, %u v.succ(v))"
    diff_def    "m#-n == rec(n, m, %u v. rec(v, 0, %x y.x))"
    mult_def    "m#*n == rec(m, 0, %u v. n #+ v)"
    mod_def     "m#//n == transrec(m, %j f. if(j:n, j, f`(j#-n)))"
    quo_def     "m#/n == transrec(m, %j f. if(j:n, 0, succ(f`(j#-n))))"
end
