(*  Title: 	ZF/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Adds Zermelo-Fraenkel Set Theory to a database containing First-Order Logic.

This theory is the work of Martin Coen, Philippe Noel and Lawrence Paulson.
*)

val banner = "ZF Set Theory (in FOL)";
writeln banner;

print_depth 1;
use_thy "zf";

use "upair.ML";
use "subset.ML";
use "pair.ML";
use "domrange.ML";
use "func.ML";
use "simpdata.ML";  

(*further development*)
use_thy "bool";
use_thy "sum";
use "mono.ML";
use "equalities.ML";
use_thy "perm";
use_thy "lfp";
use_thy "trancl";
use_thy "wf";
use_thy "ordinal";
use_thy "nat";
use_thy "epsilon";
use_thy "arith";
use_thy "univ";
use_thy "list";

(* Set up automatic printing -- works in Poly/ML only *)
install_pp (K print_thm);   				(*theorems*)
install_pp (K prin);        				(*terms*)
install_pp (K (writeln o Sign.string_of_cterm));	(*cterms*)
print_depth 8;
