(*  Title: 	ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1993  University of Cambridge

Root file for pure Isabelle: all modules in proper order for loading
Loads pure Isabelle into an empty database.

To build system, use Makefile (Poly/ML) or Makefile.NJ (New Jersey ML)

TO DO: 
instantiation of theorems can lead to inconsistent sorting of type vars if
'a::S is already present and 'a::T is introduced. 
*)

val banner = "Pure Isabelle";
val version = "February 93";

print_depth 1;

use "library.ML";
use "term.ML";
use "symtab.ML";

(*Used for building the parser generator*)
structure Symtab = SymtabFun();
cd "Syntax";
use "ROOT.ML";
cd "..";

(* Theory parser *)
cd "Thy";
use "ROOT.ML";
cd "..";

print_depth 1;
use "type.ML";
use "sign.ML";
use "sequence.ML";
use "envir.ML";
use "unify.ML";
use "logic.ML";
use "thm.ML";
use "stringtree.ML";
use "tctical.ML";
use "tactic.ML";
use "goals.ML";

(*Will be visible to all object-logics.*)
structure Type = TypeFun(structure Symtab=Symtab and Syntax=Syntax);
structure Sign = SignFun(structure Type=Type and Syntax=Syntax);
structure Sequence = SequenceFun();
structure Envir = EnvirFun();
structure Unify = UnifyFun(structure Sign=Sign and Envir=Envir
			      and Sequence=Sequence);
structure Logic = LogicFun(Unify);
structure Thm = ThmFun(structure Logic=Logic and Unify=Unify); 
structure Stringtree = StringtreeFun();
structure Tactical = TacticalFun(structure Logic=Logic and Thm=Thm);
structure Tactic = TacticFun(structure Logic=Logic and Tactical=Tactical
			     and Stringtree=Stringtree);
structure Goals = GoalsFun(structure Logic=Logic and Tactic=Tactic);
open Basic_Syntax Thm Tactical Tactic Goals;

structure Pure = struct val thy = pure_thy end;

