(*  Title: 	LCF/simpdata
    Author: 	Tobias Nipkow, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Simplification data for LCF
*)


fun mk_rew_rules r =
let fun basify thm =
	let val _$(_$t$_) = concl_of thm
	in case fastype_of([],t) of
	     Type("fun",_) => basify(thm RS ap_thm)
	   | _ => thm
	end
in map (basify o mk_eq) (atomize r) end;

structure LCF_SimpData : SIMP_DATA =
  struct
  val refl_thms		= [refl, iff_refl]
  val trans_thms	= [trans, iff_trans]
  val red1		= iffD1
  val red2		= iffD2
  val mk_rew_rules	= mk_rew_rules
  val case_splits	= [(COND_cases_iff,"COND")]
  val norm_thms		= norm_thms
  val subst_thms	= [subst];
  val dest_red		= dest_red
  end;

structure LCF_Simp = SimpFun(LCF_SimpData);
open LCF_Simp;

val LCF_congs = FOL_congs @ [ext,adm_cong] @ mk_congs thy
	["op <<","FIX","PAIR","FST","SND","COND"];

val LCF_rews = FOL_rews @
	[minimal,
	 UU_app, UU_app RS ap_thm, UU_app RS ap_thm RS ap_thm,
	 not_TT_less_FF,not_FF_less_TT,not_TT_less_UU,not_FF_less_UU,
	 not_UU_eq_TT,not_UU_eq_FF,not_TT_eq_UU,not_TT_eq_FF,
	 not_FF_eq_UU,not_FF_eq_TT,
	 COND_UU,COND_TT,COND_FF,
	 surj_pairing,FST,SND,void_cases];

val LCF_ss = empty_ss addcongs LCF_congs 
		      addrews  LCF_rews 
		      setauto  ares_tac [TrueI];
