(*  Title: 	HOL/univ
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Defines "Cartesian Product" and "Disjoint Sum" as set operations
within sexp.  Could <*> be generalized to a general summation?

Should define   'a univ == ('a+nat)sexp ??
Should declare eliminators to reduce reliance on descriptions:
    Split	:: "['a sexp, ['a sexp,'a sexp]=>'b] => 'b"
    Case  :: "[('a+nat)sexp, [('a+nat)sexp]=>'b, [('a+nat)sexp]=>'b] => 'b"
    
    Split(M,b) == @u. ? x y. M = x.y & u = b(x,y)
    Case(M,c,d) == @u.  (? x . M = IN0(x) & u = c(x))
		      | (? y . M = IN1(y) & u = d(y))

   "List_rec(M,c,d) == wfrec(trancl(pred_sexp), M, \
\                    %z g. Case(z, %x.c, %u. Split(u, %x y. d(x,y,g(y)))))"

*)

Univ = Sexp +
consts
    ATOM	:: "'a => ('a + 'b)sexp"
    NUMB	:: "nat => ('a+nat)sexp"
    IN0,IN1	:: "('a+nat)sexp => ('a+nat)sexp"
    "<*>"	:: "[('a sexp)set, ('a sexp)set]=> ('a sexp)set" (infixr 80)
    "<+>"	::
     "[(('a+nat)sexp)set, (('a+nat)sexp)set] => (('a+nat)sexp)set" (infixr 70)

rules
  uprod_def 	"A<*>B == UN x:A. UN y:B. { (x.y) }"
  usum_def 	"A<+>B == (UN x:A. {IN0(x)}) Un (UN y:B. {IN1(y)})"
  ATOM_def 	"ATOM == (%a. Atom(Inl(a)))"
  NUMB_def 	"NUMB == (%k. Atom(Inr(k)))"
  IN0_def 	"IN0(M) == Atom(Inr(0)) . M"
  IN1_def 	"IN1(M) == Atom(Inr(Suc(0))) . M"
end
