(*  Title: 	HOL/univ
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

For univ.thy
*)

open Univ;

(*** Cartesian Product ***)

val prems = goalw Univ.thy [uprod_def]
    "[| a:A;  b:B |] ==> (a.b) : A<*>B";
by (REPEAT (resolve_tac(prems@[singletonI,UN_I]) 1));
val uprodI = result();

(*The general elimination rule*)
val major::prems = goalw Univ.thy [uprod_def]
    "[| c : A<*>B;  \
\       !!x y.[| x:A;  y:B;  c=x.y |] ==> P \
\    |] ==> P";
by (cut_facts_tac [major] 1);
by (REPEAT (eresolve_tac [asm_rl,singletonE,UN_E] 1
     ORELSE resolve_tac prems 1));
val uprodE = result();

(*Elimination of <a,b>:A*B -- introduces no eigenvariables*)
val prems = goal Univ.thy
    "[| (a.b) : A<*>B;    \
\       [| a:A;  b:B |] ==> P   \
\    |] ==> P";
by (rtac uprodE 1);
by (REPEAT (ares_tac prems 1 ORELSE eresolve_tac [Scons_inject,ssubst] 1));
val uprodE2 = result();

val prems = goalw Univ.thy [uprod_def] "[| A<=C;  B<=D |] ==> A<*>B <= C<*>D";
by (cfast_tac prems 1);
val uprod_mono = result();


(*** Atoms ***)

goalw Univ.thy [ATOM_def] "inj(ATOM)";
by (rtac injI 1);
by (etac (Atom_inject RS Inl_inject) 1);
val inj_ATOM = result();

val ATOM_inject = inj_ATOM RS injD;

goalw Univ.thy [NUMB_def] "inj(NUMB)";
by (rtac injI 1);
by (etac (Atom_inject RS Inr_inject) 1);
val inj_NUMB = result();

val NUMB_inject = inj_NUMB RS injD;


(*** Disjoint Sum ***)

(** introduction **)

val prems = goalw Univ.thy [usum_def] "a:A ==> IN0(a) : A<+>B";
by (fast_tac (set_cs addIs prems) 1);
val usum_IN0I = result();

val prems = goalw Univ.thy [usum_def] "b:B ==> IN1(b) : A<+>B";
by (fast_tac (set_cs addIs prems) 1);
val usum_IN1I = result();

(** elimination **)

val major::prems = goalw Univ.thy [usum_def]
    "[| u : A<+>B;  \
\       !!x. x:A ==> P(IN0(x)); \
\       !!y. y:B ==> P(IN1(y)) \
\    |] ==> P(u)";
by (rtac (major RS UnE) 1);
by (REPEAT (eresolve_tac (prems@[UN_E,singletonE,ssubst]) 1));
val usumE = result();


(*** Injection rules ***)

goalw Univ.thy [IN0_def,IN1_def] "~ (IN0(a) = IN1(b))";
by (rtac notI 1);
by (etac Scons_inject 1);
by (etac (Atom_inject RS Inr_inject RS Zero_neq_Suc) 1);
val IN0_not_IN1 = result();

val IN1_not_IN0 = standard (IN0_not_IN1 RS not_sym);

val IN0_neq_IN1 = standard (IN0_not_IN1 RS notE);
val IN1_neq_IN0 = sym RS IN0_neq_IN1;

val [major] = goalw Univ.thy [IN0_def] "IN0(a) = IN0(b) ==>  a=b";
by (rtac (major RS Scons_inject) 1);
by (assume_tac 1);
val IN0_inject = result();

val [major] = goalw Univ.thy [IN1_def] "IN1(a) = IN1(b) ==>  a=b";
by (rtac (major RS Scons_inject) 1);
by (assume_tac 1);
val IN1_inject = result();

val prems = goalw Univ.thy [usum_def] "[| A<=C;  B<=D |] ==> A<+>B <= C<+>D";
by (cfast_tac prems 1);
val usum_mono = result();

