(*  Title: 	HOL/simpdata
    Author: 	Tobias Nipkow
    Copyright   1990  University of Cambridge

Invoking the simplifier
*)


fun prover s = prove_goal HOL.thy s (fn _=>[fast_tac HOL_cs 1]);

(* Conversion into rewrite rules *)

fun basify thm =
    let val _$(_$t$_) = concl_of thm
    in  case fastype_of([],t) of
	   Type("fun",_) => basify(thm RS fun_cong)
         | _ => thm
    end;

val not_P_imp_P_iff_F = prover "~P --> (P = False)" RS mp;

fun mk_eq r = case concl_of r of
	_$(Const("op =",_)$_$_) => r
    |	_$(Const("not",_)$_) => r RS not_P_imp_P_iff_F
    |   _ => r RS eqTrueI;

fun atomize r = case concl_of r of
	_$(Const("op -->",_)$_$_) => atomize(r RS mp)
    |   _$(Const("op &",_)$_$_) => atomize(r RS conjunct1) @
				atomize(r RS conjunct2)
    |	_$(Const("All",_)$_) => atomize(r RS spec)
    |	_$(Const("True",_)) => []
    |	_$(Const("False",_)) => []
    |   _ => [r];


val if_True = prove_goal HOL.thy "if(True,x,y) = x"
 (fn _=>[stac if_def 1,  fast_tac (HOL_cs addIs [select_equality]) 1]);

val if_False = prove_goal HOL.thy "if(False,x,y) = y"
 (fn _=>[stac if_def 1,  fast_tac (HOL_cs addIs [select_equality]) 1]);

val if_P = prove_goal HOL.thy "P ==> if(P,x,y) = x"
 (fn [prem] => [ stac (prem RS eqTrueI) 1, rtac if_True 1 ]);

val if_not_P = prove_goal HOL.thy "~P ==> if(P,x,y) = y"
 (fn [prem] => [ stac (prem RS not_P_imp_P_iff_F) 1, rtac if_False 1 ]);

val expand_if = prove_goal HOL.thy
    "P(if(Q,x,y)) = ((Q --> P(x)) & (~Q --> P(y)))"
 (fn _=> [ (res_inst_tac [("Q","Q")] (excluded_middle RS disjE) 1),
	 rtac (if_P RS ssubst) 2,
	 rtac(if_not_P RS ssubst) 1,
	 REPEAT(fast_tac HOL_cs 1) ]);

val o_apply = prove_goal HOL.thy "(f o g)(x) = f(g(x))"
 (fn _ => [ (stac o_def 1), (rtac refl 1) ]);


structure HOL_SimpData =
  struct
  val refl_thms = [refl]
  val trans_thms = [trans]
  val red1	= iffD1
  val red2	= iffD2
  fun mk_rew_rules r = map (basify o mk_eq) (atomize r)
  val case_splits = [(expand_if,"if")]
  val norm_thms = []
  val subst_thms = [subst]
  fun dest_red(_ $ (red$lhs$rhs)) = (red,lhs,rhs)
    | dest_red _ = error("dest_red")
  end;

structure HOL_Simp = SimpFun(HOL_SimpData);
open HOL_Simp;

val simp_thms = [if_True, if_False, o_apply] @ map prover
 [ "(x=x) = True",
   "(~True) = False", "(~False) = True", "(~ ~ P) = P",
   "(True=P) = P", "(P=True) = P",
   "(True --> P) = P", "(False --> P) = True", 
   "(P --> True) = True", "(P --> P) = True",
   "(P & True) = P", "(True & P) = P", 
   "(P & False) = False", "(False & P) = False", "(P & P) = P",
   "(P | True) = True", "(True | P) = True", 
   "(P | False) = P", "(False | P) = P", "(P | P) = P",
   "(!x.P) = P",
   "(P|Q --> R) = ((P-->R)&(Q-->R))" ];

val imp_cong = impI RSN
    (2, prove_goal HOL.thy "(P=P')--> (P'--> (Q=Q'))--> ((P-->Q) = (P'-->Q'))"
	(fn _=> [fast_tac HOL_cs 1]) RS mp RS mp);

val congs = imp_cong :: ext ::
	mk_congs HOL.thy ["op =","not","op &","op |","op o","if"] @
	map (apl(ext,op RS)) (mk_congs HOL.thy ["Eps","All","Ex","Ex1"]);

val HOL_ss = empty_ss addcongs congs 
	              addrews simp_thms 
                      setauto ares_tac[TrueI];
