(*  Title: 	HOL/sexp
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

S-expressions, general binary trees for defining recursive data structures

Type ('a)sexp is defined as a set Sexp over (nat=>nat) * 'a => bool

Each s-expression is represented by a set {<l0,x0>,...,<lk,xk>} where
   each lk is a list of integers -- 1 for left and 2 for right --
   giving the access path to each Atom.

Here, lists are represented by functions.  The list [x0,...,xk] with
elements of type 'a is represented by a function f: nat=>'a such that
f(i)=xi for i from 0 to k; otherwise f(i) can be anything.  Above we use
lists of 1s and 2s, distinguishing the "empty list" as a constant 0
function.
*)

Sexp = Nat +
types sexp 1
arities sexp :: (term)term
consts
  apfst        :: "['a=>'c, 'a*'b] => 'c*'b"
  Push         :: "['a, nat=>'a] => (nat=>'a)"
  Atom_Rep     :: "'a => ((nat=>nat) * 'a)set"
  Scons_Rep    ::
   "[((nat=>nat)*'a)set, ((nat=>nat)*'a)set] => ((nat=>nat)*'a)set"
  Sexp         :: "(((nat=>nat) * 'a)set)set"
  Rep_Sexp     :: "'a sexp => ((nat=>nat) * 'a)set"
  Abs_Sexp     :: "((nat=>nat) * 'a)set => 'a sexp"
  Atom         :: "'a => 'a sexp"
  sexp_case    :: "['a sexp, 'a=>'b, ['a sexp,'a sexp]=>'b] => 'b"
  pred_sexp    :: "('a sexp * 'a sexp)set"
  sexp_rec     :: "['a sexp, 'a=>'b, ['a sexp,'a sexp,'b,'b]=>'b] => 'b"
  "."          :: "['a sexp, 'a sexp]=> 'a sexp" 	(infixr 60)

rules
  apfst_def 	"apfst == (%f p.<f(fst(p)),snd(p)>)"
  Push_def 	"Push == (%b h n. nat_case(n,b,h))"
  Atom_Rep_def 	"Atom_Rep(a) == {<%k.0, a>}"
  Scons_Rep_def	
   "Scons_Rep(i,j) == (apfst(Push(Suc(0))) `` i) \
\                  Un (apfst(Push(Suc(Suc(0)))) `` j)"
  Sexp_def 
   "Sexp == lfp(%Z. range(Atom_Rep) Un (UN i:Z. UN j:Z. {Scons_Rep(i,j)}))"
    (*faking a type definition...*)
  Rep_Sexp 		"Rep_Sexp(xs) : Sexp"
  Rep_Sexp_inverse 	"Abs_Sexp(Rep_Sexp(xs)) = xs"
  Abs_Sexp_inverse 	"i: Sexp ==> Rep_Sexp(Abs_Sexp(i)) = i"
     (*defining the abstract constants*)
  Atom_def  	"Atom == (%a. Abs_Sexp(Atom_Rep(a)))"
  Scons_def 	"M . N == Abs_Sexp(Scons_Rep(Rep_Sexp(M), Rep_Sexp(N)))"

  sexp_case_def	
   "sexp_case(M,c,d) == @ z. (? x.   M=Atom(x) & z=c(x))  \
\                          | (? N1 N2. M = N1 . N2  & z=d(N1,N2))"

  pred_sexp_def "pred_sexp == {p. ? M N. p = <M, M . N> | p = <N, M . N>}"

  sexp_rec_def
   "sexp_rec(M,c,d) == wfrec(pred_sexp, M,  \
\             %M g. sexp_case(M, c, %N1 N2. d(N1, N2, g(N1), g(N2))))"
end

