Set = HOL +
types set 1
arities set :: (term)term
        set :: (term)ord
consts
  Collect	:: "['a=>bool] => 'a set"          	(*comprehension*)
  Compl		:: "('a set) => 'a set"            	(*complement*)
  Int		:: "['a set,'a set]=> 'a set" 		(infixl 70)
  Un		:: "['a set,'a set]=> 'a set" 		(infixl 65)
  Union, Inter	:: "(('a set)set) => 'a set"       	(*of a set*)
  UNION, INTER	:: "['a set, 'a => 'b set] => 'b set" 	(*general*)
  range		:: "('a => 'b) => 'b set"  		(*of function*)
  Ball,Bex	:: "['a set, 'a=>bool]=>bool"      	(*bounded quantifiers*)
  mono		:: "['a set => 'b set] => bool"    	(*monotonicity*)
  inj,surj	:: "('a => 'b) => bool"             (*injective/surjective*)
  inj_onto	:: "['a => 'b, 'a set] => bool"
  "``"		:: "['a=>'b,'a set] => ('b set)"   	(infixl 90)
  ":"		:: "['a,'a set]=>bool" (infixl 50) 	(*membership*)
  singleton	:: "'a=> 'a set"                   	("{_}")
  "@Coll"	:: "[id,bool]=>'a set" ("(1{_./ _})") 	(*collection*)
    (*Big intersection/union*)
  "@INTER"	:: "[id,'a set,'b set]=> 'b set" 	("(3INT _:_./ _)" 10)
  "@UNION"	:: "[id,'a set,'b set]=> 'b set" 	("(3UN _:_./ _)" 10)
    (*Bounded quantifiers*)
  "@Ball"	:: "[id,'a set,bool]=>bool"      	("(3! _:_./ _)" 10)
  "@Bex"	:: "[id,'a set,bool]=>bool"      	("(3? _:_./ _)" 10)
  "*Ball"	:: "[id,'a set,bool]=>bool"      	("(3ALL _:_./ _)" 10)
  "*Bex"	:: "[id,'a set,bool]=>bool"      	("(3EX _:_./ _)" 10)

rules
  mem_Collect_eq	"(a : {x.P(x)}) = P(a)"
  Collect_mem_eq	"{x.x:A} = A"

  Ball_def	"Ball(A,P)  == ! x. x:A --> P(x)"
  Bex_def	"Bex(A,P)   == ? x. x:A & P(x)"
  subset_def 	"A <= B     == ! x:A. x:B"
  singleton_def "{a}        == {x.x=a}"
  Un_def	"A Un B     == {x.x:A | x:B}"
  Int_def	"A Int B    == {x.x:A & x:B}"
  Compl_def	"Compl(A)   == {x. ~x:A}"
  INTER_def	"INTER(A,B) == {y. ! x:A. y: B(x)}"
  UNION_def	"UNION(A,B) == {y. ? x:A. y: B(x)}"
  Inter_def	"Inter(S)   == (INT x:S. x)"
  Union_def	"Union(S)   ==  (UN x:S. x)"
  image_def  	"f``A       == {y. ? x:A. y=f(x)}"
  range_def	"range(f)   == {y. ? x. y=f(x)}"
  mono_def	"mono(f)    == (!A B. A <= B --> f(A) <= f(B))"
  inj_def	"inj(f)     == ! x y. f(x)=f(y) --> x=y"
  inj_onto_def	"inj_onto(f,A) == ! x:A. ! y:A. f(x)=f(y) --> x=y"
  surj_def	"surj(f)    == ! y. ? x. y=f(x)"
end

ML

(** Bounded quantifiers have the form %x:A.P(x) **)
fun qnt_tr q [Free(x,T), A, P] = Const(q,dummyT) $ A $ absfree(x,T,P);

fun qnt_tr' q [A, Abs(x,T,P)] =
    let val (x',P') = variant_abs(x,T,P)
    in Const(q,dummyT) $ Free(x',T) $ A $ P' end;

val parse_translation=
    [mk_binder_tr("@Coll","Collect"),
     ("@INTER", qnt_tr "INTER"),
     ("@UNION", qnt_tr "UNION"),
     ("@Ball",  qnt_tr "Ball"),
     ("*Ball",  qnt_tr "Ball"),
     ("@Bex",   qnt_tr "Bex"),
     ("*Bex",   qnt_tr "Bex") ];
val print_translation=
    [mk_binder_tr'("Collect","@Coll"),
     ("INTER",  qnt_tr' "@INTER"),
     ("UNION",  qnt_tr' "@UNION"),
     ("Ball",   alt_tr' (qnt_tr' "@Ball", qnt_tr' "*Ball")),
     ("Bex",    alt_tr' (qnt_tr' "@Bex",  qnt_tr' "*Bex")) ];
