(*  Title: 	HOL/prod
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

For prod.thy.  Ordered Pairs, the Cartesian product type, the unit type
*)

open Prod;

(*This counts as a non-emptiness result for admitting 'a * 'b as a type*)
goalw Prod.thy [Prod_def] "Pair_Rep(a,b) : Prod";
by (EVERY1 [rtac CollectI, rtac exI, rtac exI, rtac refl]);
val ProdI = result();

val [major] = goalw Prod.thy [Pair_Rep_def]
    "Pair_Rep(a, b) = Pair_Rep(a',b') ==> a=a' & b=b'";
by (EVERY1 [rtac (major RS fun_cong RS fun_cong RS subst), 
	    rtac conjI, rtac refl, rtac refl]);
val Pair_Rep_inject = result();

goal Prod.thy "inj_onto(Abs_Prod,Prod)";
by (rtac inj_onto_inverseI 1);
by (etac Abs_Prod_inverse 1);
val inj_onto_Abs_Prod = result();

val prems = goalw Prod.thy [Pair_def]
    "[| <a, b> = <a',b'>;  [| a=a';  b=b' |] ==> R |] ==> R";
by (rtac (inj_onto_Abs_Prod RS inj_ontoD RS Pair_Rep_inject RS conjE) 1);
by (REPEAT (ares_tac (prems@[ProdI]) 1));
val Pair_inject = result();

goal Prod.thy "(<a,b> = <a',b'>) = (a=a' & b=b')";
by (fast_tac (set_cs addIs [Pair_inject]) 1);
val Prod_eq = result();

goalw Prod.thy [fst_def] "fst(<a,b>) = a";
by (fast_tac (set_cs addIs [select_equality] addEs [Pair_inject]) 1);
val fst = result();

goalw Prod.thy [snd_def] "snd(<a,b>) = b";
by (fast_tac (set_cs addIs [select_equality] addEs [Pair_inject]) 1);
val snd = result();

goalw Prod.thy [Pair_def] "? x y. p = <x,y>";
by (rtac (rewrite_rule [Prod_def] Rep_Prod RS CollectE) 1);
by (EVERY1[etac exE, etac exE, rtac exI, rtac exI,
	   rtac (Rep_Prod_inverse RS sym RS trans),  etac arg_cong]);
val PairE_lemma = result();

val [prem] = goal Prod.thy "[| !!x y. p = <x,y> ==> Q |] ==> Q";
by (rtac (PairE_lemma RS exE) 1);
by (REPEAT (eresolve_tac [prem,exE] 1));
val PairE = result();

goalw Prod.thy [split_def] "split(<a,b>, c) = c(a,b)";
by (sstac [fst, snd] 1);
by (rtac refl 1);
val split = result();

val Pair_ss = 
    set_ss addcongs (mk_congs Prod.thy ["Pair","fst","snd","split"])
           addrews [fst, snd, split];

goal Prod.thy "p = <fst(p),snd(p)>";
by (res_inst_tac [("p","p")] PairE 1);
by (ASM_SIMP_TAC Pair_ss 1);
val surjective_pairing = result();

goal Prod.thy "p = split(p, %x y.<x,y>)";
by (res_inst_tac [("p","p")] PairE 1);
by (ASM_SIMP_TAC Pair_ss 1);
val surjective_pairing2 = result();

(** split used as a logical connective, with result type bool **)

val prems = goal Prod.thy "c(a,b) ==> split(<a,b>, c)";
by (stac split 1);
by (resolve_tac prems 1);
val splitI = result();

val prems = goalw Prod.thy [split_def]
    "[| split(p,c);  !!x y. [| p = <x,y>;  c(x,y) |] ==> Q |] ==> Q";
by (REPEAT (resolve_tac (prems@[surjective_pairing]) 1));
val splitE = result();

(** Exhaustion rule for unit -- a degenerate form of induction **)

goalw Prod.thy [Unity_def]
    "u = ()";
by (stac (rewrite_rule [Unit_def] Rep_Unit RS CollectD RS sym) 1);
br (Rep_Unit_inverse RS sym) 1;
val unit_eq = result();
