(*  Title: 	HOL/mono
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Monotonicity of various operations
*)

val [prem] = goal Set.thy
    "[| !!x. P(x) ==> Q(x) |] ==> Collect(P) <= Collect(Q)";
by (fast_tac (set_cs addIs [prem]) 1);
val Collect_mono = result();

val prems = goal Set.thy "A<=B ==> f``A <= f``B";
by (cfast_tac prems 1);
val image_mono = result();

val prems = goal Set.thy "A<=B ==> Union(A) <= Union(B)";
by (cfast_tac prems 1);
val Union_mono = result();

val [prem] = goal Set.thy
    "[| !!x. f(x)<=g(x) |] ==> Union(range(f)) <= Union(range(g))";
by (fast_tac (set_cs addIs [prem RS subsetD]) 1);
val Union_range_mono = result();

val prems = goal Set.thy "B<=A ==> Inter(A) <= Inter(B)";
by (cfast_tac prems 1);
val Inter_anti_mono = result();

val prems = goal Set.thy
    "[| A<=B;  !!x. x:A ==> f(x)<=g(x) |] ==> \
\    (UN x:A. f(x)) <= (UN x:B. g(x))";
by (fast_tac (set_cs addIs (prems RL [subsetD])) 1);
val UN_mono = result();

val prems = goal Set.thy
    "[| B<=A;  !!x. x:A ==> f(x)<=g(x) |] ==> \
\    (INT x:A. f(x)) <= (INT x:A. g(x))";
by (fast_tac (set_cs addIs (prems RL [subsetD])) 1);
val INT_anti_mono = result();

val prems = goal Set.thy "[| A<=C;  B<=D |] ==> A Un B <= C Un D";
by (cfast_tac prems 1);
val Un_mono = result();

val prems = goal Set.thy "[| A<=C;  B<=D |] ==> A Int B <= C Int D";
by (cfast_tac prems 1);
val Int_mono = result();

val prems = goal Set.thy "A<=B ==> Compl(B) <= Compl(A)";
by (cfast_tac prems 1);
val Compl_anti_mono = result();
