(*  Title: 	HOL/list
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Definition of type 'a list by a least fixed point

Could list_rec be defined directly, with no List_rec?? e.g.
   "list_rec(l,c,d) == wfrec(trancl(pred_sexp), Rep_List(l), \
\                    %z g. @u. z=NIL & u=c | \
\                     (? x y. z=CONS(ATOM(x),Rep_List(y)) & u = d(x,y,g(y))))"
But -- do we ever want to perform recursion on List(A)??

We use  	List(A) == lfp(%Z. {NUMB(0)} <+> A <*> Z)
and not		List    == lfp(%Z. {NUMB(0)} <+> range(ATOM) <*> Z)
so that List can serve as a "functor" for defining other recursive types
*)

List = Univ +
types list 1
arities list :: (term)term
consts
  List		:: "(('a + nat)sexp)set => (('a + nat)sexp)set"
  Rep_List	:: "'a list => ('a + nat)sexp"
  Abs_List 	:: "('a + nat)sexp => 'a list"
  NIL      	:: "('a + nat)sexp"
  CONS     	:: "[('a + nat)sexp, ('a + nat)sexp] => ('a + nat)sexp"
  Nil      	:: "'a list"
  Cons     	:: "['a, 'a list] => 'a list"
  List_rec	::
    "[('a+nat)sexp, 'b, [('a+nat)sexp , ('a+nat)sexp, 'b]=>'b] => 'b"
  list_rec	:: "['a list, 'b, ['a, 'a list, 'b]=>'b] => 'b"
  Rep_map	:: "('b => ('a+nat)sexp) => ('b list => ('a+nat)sexp)"
  Abs_map	:: "(('a+nat)sexp => 'b) => ('a+nat)sexp => 'b list"
  list_all      :: "('a => bool) => ('a list => bool)"
  map		:: "('a=>'b) => ('a list => 'b list)"
rules
  List_def	"List(A) == lfp(%Z. {NUMB(0)} <+> A <*> Z)"
    (*faking a type definition...*)
  Rep_List 		"Rep_List(xs): List(range(ATOM))"
  Rep_List_inverse 	"Abs_List(Rep_List(xs)) = xs"
  Abs_List_inverse 	"M: List(range(ATOM)) ==> Rep_List(Abs_List(M)) = M"
     (*defining the concrete constructors*)
  NIL_def  	"NIL == IN0(NUMB(0))"
  CONS_def 	"CONS(M,N) == IN1(M . N)"
     (*defining the abstract constructors*)
  Nil_def  		"Nil == Abs_List(NIL)"
  Cons_def 	 "Cons(x,xs) == Abs_List(CONS(ATOM(x), Rep_List(xs)))"

     (*list recursion*)
  List_rec_def	
   "List_rec(M,c,d) == wfrec(trancl(pred_sexp), M, \
\                    %z g. @u. z=NIL & u=c | \
\                             (? x y. z=CONS(x,y) & u = d(x,y,g(y))))"

  list_rec_def
   "list_rec(l,c,d) == \
\   List_rec(Rep_List(l), c, %x y r. d(Inv(ATOM,x), Abs_List(y), r))"

     (*Generalized map functionals*)
  Rep_map_def 
   "Rep_map(f,xs) == list_rec(xs, NIL, %x l r. CONS(f(x), r))"
  Abs_map_def 
   "Abs_map(g,M) == List_rec(M, Nil, %N L r. Cons(g(N), r))"

  list_all_def "list_all(P,xs) == list_rec(xs, True, %x l r. P(x) & r)"
  map_def 	"map(f,xs) == list_rec(xs, Nil, %x l r. Cons(f(x), r))"
end
