(*  Title: 	HOL/hol.thy
    Author: 	Tobias Nipkow
    Copyright   1993  University of Cambridge

Higher-Order Logic
*)

HOL = Pure +

classes term < logic
        ord < term

default term

types bool 0

arities fun  :: (term,term) term
        bool :: term

consts  Trueprop   ::   "bool => prop"          ("(_)" [0] 5)
        All,Ex,Ex1 ::   "['a=>bool]=>bool"      (*quantifiers*)
        True,False ::   "bool"
        if         ::   "[bool,'a,'a] => 'a"
        Inv        ::   "('a => 'b)  =>  ('b => 'a)"
        "="        ::   "['a,'a] => bool"       (infixl 50)
        "-->"      ::   "[bool,bool] => bool"   (infixr 25)
        "Eps"      ::   "('a => bool) => 'a"    (binder "@" 10)
        "o"        ::   "['b=>'c, 'a=>'b, 'a] => 'c"    (infixr 50)
        not        ::   "bool => bool"          ("~ _" [40] 40)
        "&"        ::   "[bool,bool] => bool"   (infixr 35)
        "|"        ::   "[bool,bool] => bool"   (infixr 30)
(* Effect is similar to the following, but allows both syntaxes 
        All        ::   "('a => bool) => bool"  (binder "! " 10)
        Ex         ::   "('a => bool) => bool"  (binder "? " 10)
        Ex1        ::   "('a => bool) => bool"  (binder "?! " 10)
*)
        "@All"     ::   "[idts, bool] => bool"  ("(3! _./ _)" [0,0] 10)
        "*All"     ::   "[idts, bool] => bool"  ("(3ALL _./ _)" [0,0] 10)
        "@Ex"      ::   "[idts, bool] => bool"  ("(3? _./ _)" [0,0] 10)
        "*Ex"      ::   "[idts, bool] => bool"  ("(3EX _./ _)" [0,0] 10)
        "@Ex1"     ::   "[idts, bool] => bool"  ("(3?! _./ _)" [0,0] 10)
        "*Ex1"     ::   "[idts, bool] => bool"  ("(3EX! _./ _)" [0,0] 10)
(* overloaded constants *)
	"<","<="   ::	"['a::ord,'a] => bool"  (infixl 50)

rules

  (*Basic Rules*)

refl	"t = t::'a"
subst	"[| s = t; P(s) |] ==> P(t::'a)"
ext	"(!!x::'a. f(x)::'b = g(x)) ==> (%x.f(x)) = (%x.g(x))"
selectI	"P(x::'a) ==> P(@x.P(x))"

impI	"(P ==> Q) ==> P-->Q"
mp	"[| P-->Q;  P |] ==> Q"

  (* Definitions *)

True_def	"True = ((%x.x)=(%x.x))"
All_def		"All  = (%P. P = (%x.True))"
Ex_def		"Ex   = (%P. P(@x.P(x)))"
False_def	"False = (!P.P)"
not_def		"not  = (%P. P-->False)"
and_def		"op & = (%P Q. !R. (P-->Q-->R) --> R)"
or_def		"op | = (%P Q. !R. (P-->R) --> (Q-->R) --> R)"
Ex1_def		"Ex1  = (%P. ? x. P(x) & (! y. P(y) --> y=x))"

  (* Axioms*)

iff		"(P-->Q) --> (Q-->P) --> (P=Q)"
True_or_False	"(P=True) | (P=False)"

  (*Misc Definitions*)

Inv_def		"Inv = (%(f::'a=>'b) y. @x. f(x)=y)"
o_def		"op o = (%(f::'b=>'c) g (x::'a). f(g(x)))"

if_def		"if = (%P x y.@z::'a. (P=True --> z=x) & (P=False --> z=y))"

end

ML

(** Choice between the HOL and Isabelle style of quantifiers **)

val HOL_quantifiers = ref true;

fun alt_tr' (tr1',tr2') ts = if !HOL_quantifiers then tr1' ts else tr2' ts;

fun mk_bindopt_tr' name =
  let val (_, tr1') = mk_binder_tr' (name, "@"^name)
      and (_, tr2') = mk_binder_tr' (name, "*"^name)
  in  (name, alt_tr' (tr1',tr2'))  end;

val parse_translation = map mk_binder_tr
	[("@All","All"), ("@Ex","Ex"), ("@Ex1","Ex1"),
	 ("*All","All"), ("*Ex","Ex"), ("*Ex1","Ex1")];

val print_translation = map mk_bindopt_tr' ["All", "Ex", "Ex1"];
