(*  Title: 	HOL/ex/term
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

For term.thy.  illustrates List functor
  (essentially the same type as in Trees & Forests)
*)

open Term;

(*** Monotonicity and unfolding of the function ***)

goal Term.thy "mono(%Z.  A <*> List(Z))";
by (REPEAT (ares_tac [monoI, subset_refl, List_mono, uprod_mono] 1));
val Term_fun_mono = result();

val Term_unfold = Term_fun_mono RS (Term_def RS def_Tarski);

(*This justifies using Term in other recursive type definitions*)
val prems = goalw Term.thy [Term_def] "[| A<=B |] ==> Term(A) <= Term(B)";
by (REPEAT (ares_tac (prems@[monoI, subset_refl, lfp_mono, 
			     List_mono, uprod_mono]) 1));
val Term_mono = result();


(** Elimination -- structural induction on the set Term(A) **)

(*Induction for the set Term(A) *)
val [major,minor] = goal Term.thy 
    "[| M: Term(A);  \
\       !!x zs. [| x: A;  zs: List(Term(A));  zs: List({x.R(x)}) \
\               |] ==> R(x.zs)  \
\    |] ==> R(M)";
by (rtac (major RS (Term_def RS def_induct)) 1);
by (rtac Term_fun_mono 1);
by (REPEAT (eresolve_tac ([uprodE, ssubst, minor] @
 		([Int_lower1,Int_lower2] RL [List_mono RS subsetD])) 1));
val Term_induct = result();

(*Induction on Term(A) followed by induction on List *)
val major::prems = goal Term.thy
    "[| M: Term(A);  \
\       !!x.      [| x: A |] ==> R(x.NIL);  \
\       !!x z zs. [| x: A;  z: Term(A);  zs: List(Term(A));  R(x.zs)  \
\                 |] ==> R(x . CONS(z,zs))  \
\    |] ==> R(M)";
by (rtac (major RS Term_induct) 1);
by (etac List_induct 1);
by (REPEAT (ares_tac prems 1));
val Term_induct2 = result();

(*** Structural Induction on the abstract type 'a term ***)

(*Induction for the abstract type 'a term*)
val prems = goalw Term.thy [App_def,Rep_TList_def,Abs_TList_def]
    "[| !!x ts. [| list_all(R,ts) |] ==> R(App(x,ts))  \
\    |] ==> R(t)";
by (rtac (Rep_Term_inverse RS subst) 1);   (*types force good instantiation*)
by (rtac (Rep_Term RS Term_induct) 1);
by (eres_inst_tac [("A1","Term(?u)"), ("f1","Rep_Term"), ("g1","Abs_Term")]
    	(Abs_map_inverse RS subst) 1);
by (etac Abs_Term_inverse 1);
by (etac rangeE 1);
by (hyp_subst_tac 1);
by (resolve_tac prems 1);
by (etac List_induct 1);
by (etac CollectE 2);
by (ALLGOALS (ASM_SIMP_TAC list_ss));
val term_induct = result();


(*Induction for the abstract type 'a term*)
val prems = goal Term.thy 
    "[| !!x. R(App(x,Nil));  \
\       !!x t ts. R(App(x,ts)) ==> R(App(x, Cons(t,ts)))  \
\    |] ==> R(t)";
by (rtac term_induct 1);  (*types force good instantiation*)
by (etac rev_mp 1);
by (rtac list_induct 1);  (*types force good instantiation*)
by (ALLGOALS (ASM_SIMP_TAC (list_ss addrews prems)));
val term_induct2 = result();

(*Perform induction on xs. *)
fun term_ind2_tac a i = 
    EVERY [res_inst_tac [("t",a)] term_induct2 i,
	   rename_last_tac a ["1","s"] (i+1)];


(** Introduction rule for Term **)

(* ?c : ?Ga5 <*> List(Term(?Ga5)) ==> ?c : Term(?Ga5) *)
val TermI = Term_unfold RS equalityD2 RS subsetD;

(*The constant APP is not declared; it is simply . *)
val prems = goal Term.thy "[| M: A;  N : List(Term(A)) |] ==> M.N : Term(A)";
by (REPEAT (resolve_tac (prems@[TermI, ListI, uprodI]) 1));
val APP_I = result();


(*** Term_rec -- by wf recursion on pred_sexp ***)

val Term_rec_unfold =
    wf_pred_sexp RS wf_trancl RS (Term_rec_def RS def_wfrec);

(** conversion rules **)

val [prem] = goal Term.thy
    "N: List(Term(A)) ==>  \
\    !M. <N,M>: pred_sexp^+ --> \
\        Abs_map(cut(h, pred_sexp^+, M), N) = \
\        Abs_map(h,N)";
by (rtac (prem RS List_induct) 1);
by (SIMP_TAC list_ss 1);
by (strip_tac 1);
by (forward_tac [pred_sexp_CONS1 RS (trans_trancl RS transD)] 1);
by (dtac (pred_sexp_CONS2 RS (trans_trancl RS transD)) 1);
by (ASM_SIMP_TAC (list_ss addrews [cut_apply]) 1);
val Abs_map_lemma = result();

val [prem] = goal Term.thy
    "N: List(Term(A)) ==> \
\    Term_rec(M.N, d) = d(M, N, Abs_map(%Z. Term_rec(Z,d), N))";
by (rtac (Term_rec_unfold RS trans) 1);
by (rtac (select_equality RS trans) 1);
by (fast_tac HOL_cs 1);
by (fast_tac (HOL_cs addEs [Scons_inject]) 1);
by (REPEAT (resolve_tac (refl :: 
		mk_typed_congs Term.thy [("d", "[?'a,?'b,?'c]=>?'d")]) 1));
by (rtac (prem RS Abs_map_lemma RS spec RS mp) 1);
by (rtac (pred_sexpI2 RS r_into_trancl) 1);
val Term_rec = result();


(*** term_rec -- by Term_rec ***)

val Rep_TList = Rep_Term RS Rep_map_type;

(*Now avoids conditional rewriting with the premise N: List(Term(A)),
  since A will be uninstantiated and will cause rewriting to fail. *)
val term_rec_ss = HOL_ss 
    addcongs (mk_congs Term.thy ["map","Term_rec"] @ 
	      mk_typed_congs Term.thy [("d", "[?'a, ?'b, ?'c]=>?'d")])
    addrews [Rep_TList RS (rangeI RS APP_I RS Abs_Term_inverse),  
	     Rep_TList RS Term_rec,
	     Rep_Term_inverse, inj_ATOM, Inv_f_f,
	     Abs_Rep_map, map_ident];

goalw Term.thy [term_rec_def, App_def, Rep_TList_def, Abs_TList_def]
    "term_rec(App(f,ts), d) = d(f, ts, map (%t. term_rec(t,d), ts))";
by (SIMP_TAC term_rec_ss 1);
val term_rec = result();

