(*  Title: 	HOL/ex/simult
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Primitives for simultaneous recursive type definitions
  includes worked example of trees & forests

This is essentially the same data structure that on ex/term.ML, which is
simpler because it uses List as a new type former.  The approach in this
file may be superior for other simultaneous recursions.

TF_rec cannot be defined as in ZF because HOL has no Split or List_case
*)

Simult = Univ +
types tree,forest 1
arities tree,forest :: (term)term
consts
  Part		:: "['a set, 'a=>'a] => 'a set"
  TF		:: "(('a + nat)sexp)set => (('a+nat)sexp)set"
  FNIL      	:: "('a + nat)sexp"
  TCONS,FCONS	:: "[('a + nat)sexp, ('a + nat)sexp] => ('a + nat)sexp"
  Rep_Tree	:: "'a tree => ('a+nat)sexp"
  Abs_Tree	:: "('a+nat)sexp => 'a tree"
  Rep_Forest	:: "'a forest => ('a+nat)sexp"
  Abs_Forest	:: "('a+nat)sexp => 'a forest"
  Tcons		:: "['a, 'a forest] => 'a tree"
  Fcons		:: "['a tree, 'a forest] => 'a forest"
  Fnil		:: "'a forest"
  TF_rec	::
    "[('a+nat)sexp, [('a+nat)sexp , ('a+nat)sexp, 'b]=>'b, 	\
\     'b, [('a+nat)sexp , ('a+nat)sexp, 'b, 'b]=>'b] => 'b"
  tree_rec	:: "['a tree, ['a, 'a forest, 'b]=>'b, 		\
\     'b, ['a tree, 'a forest, 'b, 'b]=>'b] => 'b"
  forest_rec	:: "['a forest, ['a, 'a forest, 'b]=>'b, 	\
\     'b, ['a tree, 'a forest, 'b, 'b]=>'b] => 'b"

rules
    (*operator for selecting out the various types*)
  Part_def	"Part(A,h) == {x. x:A & (? z. x = h(z))}"

  TF_def	"TF(A) == lfp(%Z. A <*> Part(Z,IN1) \
\                           <+> ({NUMB(0)} <+> Part(Z,IN0) <*> Part(Z,IN1)))"
    (*faking a type definition for tree...*)
  Rep_Tree 	   "Rep_Tree(n): Part(TF(range(ATOM)),IN0)"
  Rep_Tree_inverse "Abs_Tree(Rep_Tree(t)) = t"
  Abs_Tree_inverse "z: Part(TF(range(ATOM)),IN0) ==> Rep_Tree(Abs_Tree(z)) = z"
    (*faking a type definition for forest...*)
  Rep_Forest 	     "Rep_Forest(n): Part(TF(range(ATOM)),IN1)"
  Rep_Forest_inverse "Abs_Forest(Rep_Forest(ts)) = ts"
  Abs_Forest_inverse 
	"z: Part(TF(range(ATOM)),IN1) ==> Rep_Forest(Abs_Forest(z)) = z"

     (*the concrete constants*)
  TCONS_def 	"TCONS(M,N) == IN0(M . N)"
  FNIL_def	"FNIL       == IN1(IN0(NUMB(0)))"
  FCONS_def	"FCONS(M,N) == IN1(IN1(M . N))"
     (*the abstract constants*)
  Tcons_def 	"Tcons(a,ts) == Abs_Tree(TCONS(ATOM(a), Rep_Forest(ts)))"
  Fnil_def  	"Fnil        == Abs_Forest(FNIL)"
  Fcons_def 	"Fcons(t,ts) == Abs_Forest(FCONS(Rep_Tree(t), Rep_Forest(ts)))"

     (*recursion*)
  TF_rec_def	
   "TF_rec(M,b,c,d) == wfrec(trancl(pred_sexp), M, \
\                    %z g. @u. (? x y. z=TCONS(x,y) & u = b(x,y,g(y)))	\
\			     | z=FNIL & u=c 				\
\                            | (? x y. z=FCONS(x,y) & u = d(x,y,g(x),g(y))))"

  tree_rec_def
   "tree_rec(t,b,c,d) == \
\   TF_rec(Rep_Tree(t), %x y r. b(Inv(ATOM,x), Abs_Forest(y), r), \
\          c, %x y rt rf. d(Abs_Tree(x), Abs_Forest(y), rt, rf))"

  forest_rec_def
   "forest_rec(tf,b,c,d) == \
\   TF_rec(Rep_Forest(tf), %x y r. b(Inv(ATOM,x), Abs_Forest(y), r), \
\          c, %x y rt rf. d(Abs_Tree(x), Abs_Forest(y), rt, rf))"
end
