(*  Title: 	HOL/ex/prop-log
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

Inductive (impredicative) definition of propositional logic.

CHANGE t[p] notation:   t\[\([^]]*\)\]		is_true(\1,t)
SWAP hyps args:		hyps(\([^,]*\),\([^)]*\))	hyps(\2,\1)
*)

PL = Arith +
types pl 0
arities pl :: term
consts
    false	:: "pl"
    pl_imp	:: "[pl,pl] => pl"	("_ -> _" [20,10] 10)
    var		:: "nat => pl"		("#_")
    pl_der	:: "[pl => bool, pl] => bool"	("_ |- _")
    pl_val	:: "[pl => bool, pl] => bool"	("_ |= _")
    eval	:: "[nat => bool, pl] => bool"	("_[_]" [100,0] 100)
    max		:: "pl => nat"
    tt_asms	:: "[nat => bool, nat, pl] => bool"
rules
pl_der
	"H |- p = (!D. (!H p. H(p) --> D(H,p)) --> \
\		       (!H p q. D(H,false->p)) --> \
\		       (!H p q. D(H,p->q->p)) --> \
\		       (!H p q r. D(H,(p->q->r) -> (p->q) -> p -> r)) --> \
\		       (!H p q r. D(H,((p->false) -> p) -> p)) --> \
\		       (!H p q. D(H,p -> q) --> D(H,p) --> D(H,q)) \
\		       --> D(H,p))"

pl_val "H |= p  =  (!t. (!q. H(q) --> t[q]) --> t[p])"

eval_false "t[false] = False"
eval_var "t[#v] = t(v)"
eval_imp "t[p->q] = (t[p]-->t[q])"

max_false "max(false) = 0"
max_var "max(#x) = Suc(x)"
max_imp "max(p->q) = if(max(p) < max(q), max(q), max(p))"

tt_asms_def
 "tt_asms(t,k) == nat_rec(k, %p.False, \
\	                  %n H p. H(p) | (p = if(t(n), #n, #n->false)))"

term_ind "[| P(false); !!v. P(#v); !!p q. P(p)-->P(q)-->P(p->q)|] ==> !t.P(t)"
end
