(*  Title: 	HOL/arith
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1993  University of Cambridge

Arithmetic operators and their definitions
*)

Arith = Nat +
consts
  "+","-"	   :: "[nat,nat]=>nat"	(infixl 65)
  "*","'/'/","'/"  :: "[nat,nat]=>nat"	(infixl 70)
rules
  add_def   "m+n == nat_rec(m, n, %u v.Suc(v))"  
  diff_def  "m-n == nat_rec(n, m, %u v. nat_rec(v, 0, %x y.x))"  
  mult_def  "m*n == nat_rec(m, 0, %u v. n + v)"  
  mod_def   "m//n == wfrec(trancl(pred_nat), m, %j f. if(j<n, j, f(j-n)))"  
  quo_def   "m/n == wfrec(trancl(pred_nat), m, %j f. if(j<n, 0, Suc(f(j-n))))"
end

(*"Difference" is subtraction of natural numbers.
  There are no negative numbers; we have
     m - n = 0  iff  m<=n   and     m - n = Suc(k) iff m>n.
  Also, nat_rec(m, 0, %z w.z) is pred(m).   *)
