(*  Title: 	HOL/ROOT
    Author: 	Tobias Nipkow
    Copyright   1990  University of Cambridge

Adds Classical Higher-order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory HOL.

Reorder parameters in wf.ML?
ex/prop-log: construct the type of propositions and define logic using lfp?
*)

val banner = "Higher-Order Logic";
writeln banner;

print_depth 1;  
use_thy "hol";
use "../Provers/hypsubst.ML";
use "../Provers/classical.ML";
use "../Provers/simp.ML";
use "../Provers/ind.ML";

(** Applying HypsubstFun to generate hyp_subst_tac **)

structure Hypsubst_Data =
  struct
  (*Take apart an equality judgement; otherwise raise Match!*)
  fun dest_eq (Const("Trueprop",_) $ (Const("op =",_)  $ t $ u)) = (t,u);

  val imp_intr = impI

  (*etac rev_cut_eq moves an equality to be the last premise. *)
  val rev_cut_eq = prove_goal HOL.thy "[| a=b;  a=b ==> R |] ==> R"
   (fn prems => [ REPEAT(resolve_tac prems 1) ]);

  val rev_mp = rev_mp
  val subst = subst 
  val sym = sym
  end;

structure Hypsubst = HypsubstFun(Hypsubst_Data);
open Hypsubst;

(** Applying ClassicalFun to create a classical prover **)
structure Classical_Data = 
  struct
  val sizef = size_of_thm
  val mp = mp
  val not_elim = notE
  val swap = swap
  val hyp_subst_tacs=[hyp_subst_tac]
  end;

structure Classical = ClassicalFun(Classical_Data);
open Classical;

(*Propositional rules*)
val prop_cs = empty_cs addSIs [refl,TrueI,conjI,disjCI,impI,notI,iffI]
                       addSEs [conjE,disjE,impCE,FalseE,iffE];

(*Quantifier rules*)
val HOL_cs = prop_cs addSIs [allI] addIs [exI,ex1I] 
                     addSEs [exE,ex1E] addEs [allE];

val HOL_dup_cs = prop_cs addSIs [allI] addIs [exCI,ex1I] 
                         addSEs [exE,ex1E] addEs [all_dupE];

structure HOL_Induction = InductionFun(struct val spec=spec end);
open HOL_Induction;

use"simpdata.ML";
use_thy"set";
use"fun.ML";
use"subset.ML";
use"equalities.ML";
use_thy"prod";
use_thy"sum";
use"mono.ML";
use_thy"lfp";
use_thy"trancl";
use_thy"wf";
use_thy"nat";
use_thy"arith";
use_thy"sexp";
use_thy"univ";
use_thy"list";

(* Set up automatic printing -- works in Poly/ML only *)
install_pp (K print_thm);   				(*theorems*)
install_pp (K prin);        				(*terms*)
install_pp (K (writeln o Sign.string_of_cterm));	(*cterms*)
print_depth 8;  

