(*  Title: 	FOL/ex/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Executes all examples for First-Order Logic. 
*)

writeln"Root file for FOL examples";

proof_timing := true;
cd "ex";

time_use "intro.ML";
time_use_thy "nat";
time_use "foundn.ML";
time_use_thy "prolog";

writeln"\n** Intuitionistic examples **\n";
time_use "int.ML";

val thy = IFOL.thy  and  tac = Int.fast_tac 1;
time_use "prop.ML";
time_use "quant.ML";

writeln"\n** Classical examples **\n";
time_use "cla.ML";
time_use_thy "if";

val thy = FOL.thy  and  tac = Cla.fast_tac FOL_cs 1;
time_use "prop.ML";
time_use "quant.ML";

writeln"\n** Simplification examples **\n";
time_use_thy"nat2";
time_use_thy"list";

cd "..";
maketest"END: Root file for FOL examples";
