(*  Title: 	CUBE/cube
    Author: 	Tobias Nipkow
    Copyright   1993  University of Cambridge

Barendregt's Lambda-Cube
*)

Cube = Pure +

types term,context,necontext,typing 0

arities term :: logic

consts
  Abs,Prod   :: "[term, term=>term] => term"
  Trueprop   :: "[context,typing] => prop"     ("(_/|- _)")
  Trueprop1  :: "typing => prop"               ("(_)")
  MT_context :: "context"                      ("")
  ""         :: "id  => context"               ("_ ")
  ""         :: "var => context"               ("_ ")
  Context    :: "[typing,context] => context"  ("_ _")
  star       :: "term"                         ("*")
  box        :: "term"                         ("[]")
  "^"        :: "[term,term] => term"          (infixl 20)
  Lam        :: "[id,term,term] => term"       ("(2Lam _:_./ _)" [0,0,0] 10)
  Pi         :: "[id,term,term] => term"       ("(2Pi _:_./ _)" [0,0] 10)
  "->"       :: "[term,term] => term"          (infixr 10)
  Has_type   :: "[term,term] => typing"        ("(_:/ _)" [0,0] 5)

rules
  s_b        "*: []"

  strip_s    "[| A:*;  a:A ==> G |- x:X |] ==> a:A G |- x:X"
  strip_b    "[| A:[]; a:A ==> G |- x:X |] ==> a:A G |- x:X"

  app        "[| F:Prod(A,B); C:A |] ==> F^C: B(C)"

  pi_ss      "[| A:*; !!x. x:A ==> B(x):* |] ==> Prod(A,B):*"

  lam_ss     "[| A:*; !!x. x:A ==> f(x):B(x); !!x. x:A ==> B(x):* |] \
\                ==> Abs(A,f) : Prod(A,B)"

  beta       "Abs(A,f)^a == f(a)"
end

ML

local

fun qnt_tr q [Free(a,T),A,B] = Const(q,dummyT) $ A $ absfree(a,T,B);

fun qnt_tr' q [t1,Abs(a,T,t2')] =
let val (a',t2) = variant_abs(a,T,t2')
in Const(q,dummyT) $ Free(a',T) $ t1 $ t2 end;

fun fun_tr[A,B] =
	Const("Prod",dummyT) $ A $ Abs("x",dummyT,incr_boundvars 1 B);

fun fun_tr'[A,Abs(id,T,B)] =
    if 0 mem (loose_bnos B)
    then 
      let val (id',B') = variant_abs(id,T,B)
      in Const("Pi",dummyT) $ Free(id',T) $ A $ B' end
    else Const("op ->",dummyT) $ A $ B;

fun no_asms_tr[t] = Const("Trueprop",dummyT)$Const("MT_context",dummyT)$t;
fun no_asms_tr'[Const("MT_context",_),t] = Const("Trueprop1",dummyT)$t;

in 

val parse_translation = [("Lam", qnt_tr "Abs"), ("Pi", qnt_tr "Prod"),
	("op ->", fun_tr), ("Trueprop1",no_asms_tr)];
val print_translation = [("Abs", qnt_tr' "Lam"), ("Prod", fun_tr'),
	("Trueprop",no_asms_tr')];

end
