(*  Title: 	CTT/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Adds Constructive Type Theory to a database containing pure Isabelle. 
Should be executed in the subdirectory CTT.
*)

val banner = "Constructive Type Theory";
writeln banner;

print_depth 1;  

use_thy"ctt";
use "../Provers/typedsimp.ML";
use "rew.ML";
use_thy "arith";
use_thy "bool";

(* Set up automatic printing of theorems -- works in Poly/ML only *)
install_pp (K print_thm);                               (*theorems*)
install_pp (K prin);                                    (*terms*)
install_pp (K (writeln o Sign.string_of_cterm));        (*cterms*)
print_depth 8;

