;;; isa-site.el - Site specifics for Isabelle mode, initial autoloads.
;;;
;;; Author:  David Aspinall <da@dcs.ed.ac.uk>
;;;
;;; $Id: isa-site.el,v 1.8 1994/02/28 20:24:05 da Exp $
;;;

;;; See INSTALL.txt.


;;; Installation method choices:  
;;;
;;; "LONG"  - each user adds several lines to his/her .emacs
;;; "SHORT" - you edit this file & each user adds a single line to .emacs 
;;; "NOTHING" - you edit a site default file (eg. default.el, site-run.el, 
;;;             site-init.el) and nothing needs to be done per-user.
;;;


;;;
;;; For LONG and SHORT, each user will add to .emacs
;;;
;;;       (load-file "<path>/isa-site")
;;;
;;; where <path> is replaced by path to this file.
;;; This is only edit to .emacs for SHORT.
;;;


;;;
;;; Site-specific variables...
;;;
;;; For: LONG.    use appropriate setq's in .emacs  (see INSTALL.txt)
;;;      SHORT.   edit settings below
;;;      NOTHING. copy to site default file and change.
;;;

(defvar isa-install-dir 
  "/usr/local/share/isabelle/emacs"
; "home/da/lib/emacs/isa-mode"
  "Directory where the lisp files for Isabelle mode are located")


(defvar isa-ml-compiler 
  'poly
; 'NJ
  "ML compiler that Isabelle is built under (see isa-ml-comp.el).")


(defvar isa-builtin-logic-path
  "/usr/local/lib/isabelle/dbases/"	; for Poly/ML at dcs.ed.ac.uk
; "/usr/local/bin/isabelle/bin/"	; for NJ-ML at dcs.ed.ac.uk
  "Path to built-in Isabelle logics")

(defvar isa-user-logic-path
  "./"
  "*Path to user-defined Isabelle logics (tried after current directory)")

(defvar isa-manual-path 
  "/home/isabelle/doc/"			; at dcs.ed.ac.uk
  "Path to Isabelle manuals.")


(defvar isa-view-man-command "xdvi"
  "Command to use for previewing Isabelle manuals.")


(defvar isa-manual-path "/home/isabelle/doc/"
  "Path to Isabelle manuals.")


(defvar isa-view-man-command "xdvi"
  "Command to use for previewing Isabelle manuals.")

  

;;;
;;; Load path and initial autoloads...
;;;
;;;  For: NOTHING. copy these into site default, and
;;;                comment out here, or include:
;;;		       (provide 'isa-site) 
;;;		   in site default also.
;;;

(setq load-path (cons isa-install-dir load-path))

(setq auto-mode-alist 
      (cons '("\\.thy$" . isa-thy-mode) auto-mode-alist))

(autoload 'isa-thy-mode "isa-thy-mode" 
	  "Major mode for Isabelle theory files" t nil)

(autoload 'isabelle   "isa-mode" 
	  "Start an Isabelle session" t nil)

(autoload 'isa-menus  "isa-menus"
          "Show Isabelle menus." t nil)




(provide 'isa-site)

;;; end of isa-site.el
