;;; isa-ml-comp.el - ML compiler specifics for isa-mode.
;;;
;;; Author:  David Aspinall <da@dcs.ed.ac.uk>
;;;
;;; $Id: isa-ml-comp.el,v 1.5 1994/02/23 19:01:48 da Exp $
;;;

(require 'isa-site)
(require 'isa-proc)			; NB: isa-proc refers to 
					; variables here too.

;;; To add support for another ML compiler:
;;;
;;; 1. Write versions of per-compiler functions 
;;;    by analogy with those below.
;;; 2. Change the prompt pattern if necessary
;;; 3. Add a case for the new compiler in the 
;;;    final cond expression.
;;; 4. Send the details to me so that 
;;;    I can include it by default!
;;;


;;; ========== Per-compiler functions ==========

;;; SML of New Jersey

(defun isa-run-NJ (logic-filename)
  "Value for isa-run-command-function for SML of New Jersey."
  (list logic-filename))

(defun isa-quit-NJ ()
  "Value of isa-quit-command suitable for SML of New Jersey"
  (interrupt-process)
  (comint-send-eof))


;;; poly/ML

(defun isa-run-poly (logic-filename)
  "Value for isa-run-command-function for Poly/ML.
Include any poly options here."
  (list "poly" logic-filename))

(defun isa-quit-poly ()
  "Value of isa-quit-command suitable for Poly/ML"
  (cond ((y-or-n-p "Save database? ")
	 (comint-send-eof))
	(t 
	 (isa-insert-ret "PolyML.quit();"))))


;;; ========== Prompt pattern ==========

(defvar isa-prompt-pattern  "^2?[---=#>]>? *\\|^\\*\\* .*"    
  "*Regexp to recognise prompts from the Isabelle interpreter.
Must include all forms of prompt; the default:
 ^2?[---=#>]>? *\\|^\\*\\* .*
splits into a two parts:
 ^2?[---=#>] *
matches all forms of prompt from Poly/ML and New Jersey ML, and:
 ^\\*\\* .*
matches Isabelle tracing prompts.")



;;; ========== Compiler specific variables ==========

(defvar isa-run-command-function
  nil
  "Function that makes command for running Isabelle with built-in logics.
The function is called with the filename of the logic as an argument,
and it must build a list of the form:
     (PROGRAM ARG ... ARG)
consisting of the Unix program name and arguments to run Isabelle.")

(defvar isa-quit-command 
  nil
  "*Name of function to quit Isabelle session.")



;;; ========== Setting compiler specifics ==========


(cond 
 ((eq isa-ml-compiler 'NJ)
  (setq isa-run-command-function 'isa-run-NJ)
  (setq isa-quit-command         'isa-quit-NJ))

 ((eq isa-ml-compiler 'poly)
  (setq isa-run-command-function 'isa-run-poly)
  (setq isa-quit-command         'isa-quit-poly))
)


(provide 'isa-ml-comp)

;;; End of isa-ml-comp.el
