(* -------------------------------------------------------------*)
(*								*)
(*		ValBind.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature VALBIND =
  sig
   structure Dec: DEC
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor ValBindFun 
 (structure Dec : DEC) : VALBIND =  
struct
structure Dec = Dec;
local open Syntax 
in

val spec =
    [("ValBind1",					(* Rule 135a *)
	"(EX v. E |- exp ~> v in1Val' & \
	\  E, v ||- pat ~> VE  in1VarEnv'  [Pat] ) <->  \
	\   E ||- pat = exp ~> VE in1VarEnv' [ValBind]"),
     ("ValBind2",					(* Rule 135b *)
	"(EX v VE VE'. E |- exp ~> v in1Val' & \
	\ E, v ||- pat ~> VE in1VarEnv'  [Pat] & \
	\   E ||- valbind ~> VE' in1VarEnv' [ValBind] & \
	\    combine (VE,VE',VE'') ) <->  \
	\   E ||- pat = exp and valbind ~> VE'' in1VarEnv'  [ValBind]"),
						 (* Rule 136 omitted *)
     ("Rec",					(* Rule 137 *)
	"(EX VE. E ||- valbind ~> VE in1VarEnv' [ValBind] \
	\    & unfold (VE,VE,VE')) \
        \   <-> E ||- rec valbind ~> VE' in1VarEnv' [ValBind]")];
				           (* Rules 138-139 omitted *)


val thy = extend_theory Dec.thy "VALBIND"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
