(* -------------------------------------------------------------------- *)
(*									*)
(*		Test5.ml						*)
(*									*)
(* -------------------------------------------------------------------- *)

print "\n\n Test5.ml\n\n";
print "\n\n Recursion and List Functions\n\n";

(* -------------------------------------------------------------------- *)
(*	Recursion							*)
(* -------------------------------------------------------------------- *)


dec_eval E "val rec var fac = fn var x => \
  \ (- if zero var x then scon suc 0 else \
  \ (- var x * (- var fac ` (- var x - scon suc 0 -)-)-)-)";

exp_eval E "let val rec var fac = fn var x => \
 \  (- if zero var x then scon suc 0 else \
 \  (- var x * (- var fac ` (- var x - scon suc 0 -)-)-)-) in \
 \  var fac ` (- scon 0 -) end";

(* this one needs arithmetic !! 

exp_eval E "let val rec var fac = fn var x => \
 \  (- if zero var x then scon suc 0 else \
 \  (- var x * (- var fac ` (- var x - scon suc 0 -)-)-)-) in \
 \ var fac ` (- scon suc 0 -) end";

exp_eval E "let val rec var fac = fn var x => \
 \  (- if zero var x then scon suc 0 else \
 \  (- var x * (- var fac ` (- var x - scon suc 0 -)-)-)-) in \
 \  var fac ` (- scon (suc suc 0) -) end";

 *)

(* -------------------------------------------------------------------- *)
(*	Lists and Polymorphism						*)
(* -------------------------------------------------------------------- *)

exp_eval E "var L ";

exp_eval E "head (- var L -)";

exp_eval E "tail (-var L-)";

exp_eval E "head (-tail (-var L-)-)";

exp_eval E "[]";

exp_eval E "var x::var L";

exp_eval E "null (-var L-)";

dec_eval E "val var f = fn var x => head (-var x-)";

exp_eval E "scon d :: []";

exp_eval E "[]::[]";

dec_eval E "val rec var append = fn var x => (- fn var y => \
  \  (- if null var x then var y else \
  \  (- head var x :: (-(var append)`(-tail var x-)`(-var y-)-)-)-)-)";

exp_eval E "let val rec var append = fn var x => (- fn var y => \
  \  (- if null var x then var y else \
  \  (- head var x :: (-(var append)`(-tail var x-)`(-var y-)-)-)-)-) in  \
  \  (-(-var append ` (-var L-)-) ` (-var L-)-) end";


exp_eval E "let  val rec var reverse = \
\ fn var l => (-fn var ac => (-if null var l then var ac  \
 \ else  (-(- var reverse ` (-tail var l-)-) ` \
 \ (- head var l :: var ac -)-)-)-) in \  
 \ (-(-var reverse ` (-var L-)-) ` []-) end";




 





